/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.color;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.themes.ColorScheme;
import bibliothek.gui.dock.themes.color.AbstractColorScheme;
import bibliothek.gui.dock.util.UIProperties;
import bibliothek.gui.dock.util.UIScheme;
import bibliothek.gui.dock.util.UISchemeEvent;
import bibliothek.gui.dock.util.UISchemeListener;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.DockColor;
import bibliothek.gui.dock.util.extension.ExtensionName;
import bibliothek.util.Path;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ExtendingColorScheme
extends AbstractColorScheme {
    private ColorScheme scheme;
    private ColorScheme[] extensions;
    private UISchemeListener<Color, DockColor, ColorBridge> delegateListener = new UISchemeListener<Color, DockColor, ColorBridge>(){

        @Override
        public void changed(final UISchemeEvent<Color, DockColor, ColorBridge> event) {
            UISchemeEvent<Color, DockColor, ColorBridge> forward = new UISchemeEvent<Color, DockColor, ColorBridge>(){

                @Override
                public UIScheme<Color, DockColor, ColorBridge> getScheme() {
                    return ExtendingColorScheme.this;
                }

                @Override
                public Collection<String> changedResources(Set<String> names) {
                    return event.changedResources(names);
                }

                @Override
                public Collection<Path> changedBridges(Set<Path> names) {
                    return event.changedBridges(names);
                }
            };
            ExtendingColorScheme.this.fire(forward);
        }
    };

    public ExtendingColorScheme(ColorScheme scheme, DockController controller) {
        ExtensionName<ColorScheme> name = new ExtensionName<ColorScheme>(ColorScheme.EXTENSION_NAME, ColorScheme.class, "scheme", scheme);
        List<ColorScheme> extensions = controller.getExtensions().load(name);
        this.scheme = scheme;
        this.extensions = extensions.toArray(new ColorScheme[extensions.size()]);
    }

    @Override
    public void addListener(UISchemeListener<Color, DockColor, ColorBridge> listener) {
        boolean has = this.hasListeners();
        super.addListener(listener);
        if (!has) {
            this.scheme.addListener(this.delegateListener);
            ColorScheme[] colorSchemeArray = this.extensions;
            int n = this.extensions.length;
            int n2 = 0;
            while (n2 < n) {
                ColorScheme extension = colorSchemeArray[n2];
                extension.addListener(this.delegateListener);
                ++n2;
            }
        }
    }

    @Override
    public void removeListener(UISchemeListener<Color, DockColor, ColorBridge> listener) {
        super.removeListener(listener);
        if (!this.hasListeners()) {
            this.scheme.removeListener(this.delegateListener);
            ColorScheme[] colorSchemeArray = this.extensions;
            int n = this.extensions.length;
            int n2 = 0;
            while (n2 < n) {
                ColorScheme extension = colorSchemeArray[n2];
                extension.removeListener(this.delegateListener);
                ++n2;
            }
        }
    }

    @Override
    public void install(UIProperties<Color, DockColor, ColorBridge> properties) {
        super.install(properties);
        this.scheme.install(properties);
        ColorScheme[] colorSchemeArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            ColorScheme extension = colorSchemeArray[n2];
            extension.install(properties);
            ++n2;
        }
    }

    @Override
    public void uninstall(UIProperties<Color, DockColor, ColorBridge> properties) {
        super.uninstall(properties);
        this.scheme.uninstall(properties);
        ColorScheme[] colorSchemeArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            ColorScheme extension = colorSchemeArray[n2];
            extension.uninstall(properties);
            ++n2;
        }
    }

    @Override
    protected void updateUI() {
    }

    @Override
    public ColorBridge getBridge(Path name, UIProperties<Color, DockColor, ColorBridge> properties) {
        int i = this.extensions.length - 1;
        while (i >= 0) {
            ColorBridge result = this.extensions[i].getBridge(name, properties);
            if (result != null) {
                return result;
            }
            --i;
        }
        return this.scheme.getBridge(name, properties);
    }

    @Override
    public Color getResource(String name, UIProperties<Color, DockColor, ColorBridge> properties) {
        int i = this.extensions.length - 1;
        while (i >= 0) {
            Color result = this.extensions[i].getResource(name, properties);
            if (result != null) {
                return result;
            }
            --i;
        }
        return this.scheme.getResource(name, properties);
    }
}

