/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util.icon;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.UIProperties;
import bibliothek.gui.dock.util.UIScheme;
import bibliothek.gui.dock.util.UISchemeEvent;
import bibliothek.gui.dock.util.icon.AbstractIconScheme;
import bibliothek.gui.dock.util.icon.DockIcon;
import bibliothek.gui.dock.util.icon.DockIconBridge;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;

public class DefaultIconScheme
extends AbstractIconScheme {
    private Map<String, Icon> icons = new HashMap<String, Icon>();

    public DefaultIconScheme(String file, DockController controller) {
        this(file, DefaultIconScheme.class.getClassLoader(), controller);
    }

    public DefaultIconScheme(String file, ClassLoader loader, DockController controller) {
        this(controller, new IconResource(file, null, loader));
    }

    public DefaultIconScheme(DockController controller, IconResource ... resources) {
        super(controller);
        int i = resources.length - 1;
        while (i >= 0) {
            this.icons.putAll(DockUtilities.loadIcons(resources[i].getFileName(), resources[i].getPath(), this.icons.keySet(), resources[i].getLoader()));
            --i;
        }
        this.icons.put("overflow.menu", new Icon(){

            @Override
            public int getIconHeight() {
                return 7;
            }

            @Override
            public int getIconWidth() {
                return 9;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                g = g.create();
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(c.getForeground());
                g.fillPolygon(new int[]{x + 1, x + 8, x + 4}, new int[]{y + 1, y + 1, y + 6}, 3);
                g.dispose();
            }
        });
    }

    @Override
    public DockIconBridge getBridge(Path name, UIProperties<Icon, DockIcon, DockIconBridge> properties) {
        return null;
    }

    @Override
    public Icon getResource(String name, UIProperties<Icon, DockIcon, DockIconBridge> properties) {
        return this.icons.get(name);
    }

    @Override
    protected void changed(final String id, Icon icon) {
        if (icon == null) {
            this.icons.remove(id);
        } else {
            this.icons.put(id, icon);
        }
        this.fire(new UISchemeEvent<Icon, DockIcon, DockIconBridge>(){

            @Override
            public UIScheme<Icon, DockIcon, DockIconBridge> getScheme() {
                return DefaultIconScheme.this;
            }

            @Override
            public Collection<String> changedResources(Set<String> names) {
                ArrayList<String> list = new ArrayList<String>(1);
                if (names.contains(id)) {
                    list.add(id);
                }
                return list;
            }

            @Override
            public Collection<Path> changedBridges(Set<Path> names) {
                return Collections.emptySet();
            }
        });
    }

    public static class IconResource {
        private String fileName;
        private String path;
        private ClassLoader loader;

        public IconResource(String fileName, String path, ClassLoader loader) {
            if (fileName == null) {
                throw new IllegalArgumentException("fileName must not be null");
            }
            this.fileName = fileName;
            this.path = path;
            if (loader == null) {
                loader = DefaultIconScheme.class.getClassLoader();
            }
            this.loader = loader;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getPath() {
            return this.path;
        }

        public ClassLoader getLoader() {
            return this.loader;
        }
    }
}

