/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.interniprenos.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.db.PZDBF;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikalinterniracun;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.interniprenos.PzExtensionLoader;
import rs.pezar.interniprenos.gui.PzDialogPrimopredajnicaIzrada;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogDokumentiPrimopredajnica
extends PzDialog {
    private static final long serialVersionUID = 1L;
    protected static Interniracun selected;
    private JToolBar toolbar;
    private PzToolBarIcon icnBrisanjePrimopredajnicee;
    private PzToolBarIcon icnIzmenaPrimopredajnice;
    private PzToolBarIcon icnDodavanjePrimopredajnice;
    private JScrollPane scrollPane;
    private PzTable table;
    private PzPanel mainPanel;
    private PzComponentGroup kIcnGroup;
    private PzComponentGroup fIcnGroup;
    private Interniracun primopredajnicaBrisanje;
    private Stanje stanje;
    private String parameter;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public PzDialogDokumentiPrimopredajnica(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogDokumentiPrimopredajnica(JFrame frame, String parameter) {
        super(frame);
        this.parameter = parameter;
        this.initGUI();
        this.postInit();
    }

    public PzDialogDokumentiPrimopredajnica(PzDialog dialog, String parameter) {
        super(dialog);
        this.parameter = parameter;
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        if (this.parameter.equalsIgnoreCase("Interniracun")) {
            this.fIcnGroup.hideAll();
        } else {
            this.parameter.equalsIgnoreCase("");
        }
        this.table = new PzTable((List)PZDBF.getDokumenti((Pzuser)PzExtensionLoader.getLoggedUser(), (String)this.parameter, (int)0, (int)0, (String)"PRIMO_PREDAJNICA"), Interniracun.class);
        this.table.setEnterAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PzDialogDokumentiPrimopredajnica.this.table.getSelectedRow() == -1) {
                    return;
                }
                PzDialogDokumentiPrimopredajnica.this.showDialog(PzDialogPrimopredajnicaIzrada.class, true, PzDialogDokumentiPrimopredajnica.this.table, PzDialogDokumentiPrimopredajnica.this.table.getSelectedEntity());
            }
        });
        this.scrollPane.setViewportView((Component)this.table);
        this.refresh();
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogDokumentiPrimopredajnica.this.brDok.setText(String.valueOf(PzDialogDokumentiPrimopredajnica.this.table.getRowCount()));
            }
        });
    }

    private void initGUI() {
        try {
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{96, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.kIcnGroup = new PzComponentGroup();
            this.fIcnGroup = new PzComponentGroup();
            this.toolbar.setOpaque(false);
            this.icnDodavanjePrimopredajnice = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnDodavanjePrimopredajnice);
            this.toolbar.add((Component)this.icnDodavanjePrimopredajnice);
            this.icnDodavanjePrimopredajnice.setText("Nova|primopredajnica|(Insert)");
            this.icnDodavanjePrimopredajnice.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/document_add.png")));
            this.icnDodavanjePrimopredajnice.addActionListener((ActionListener)((Object)this));
            this.icnDodavanjePrimopredajnice.setActionCommand("insert_primopredajnica");
            this.icnDodavanjePrimopredajnice.setShortcut("insert");
            this.icnIzmenaPrimopredajnice = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnIzmenaPrimopredajnice);
            this.toolbar.add((Component)this.icnIzmenaPrimopredajnice);
            this.icnIzmenaPrimopredajnice.setText("Izmena|primopredajnice|(F3)");
            this.icnIzmenaPrimopredajnice.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/document_edit.png")));
            this.icnIzmenaPrimopredajnice.setActionCommand("update_primopredajnica");
            this.icnIzmenaPrimopredajnice.addActionListener((ActionListener)((Object)this));
            this.icnIzmenaPrimopredajnice.setShortcut("f3");
            this.icnBrisanjePrimopredajnicee = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnBrisanjePrimopredajnicee);
            this.toolbar.add((Component)this.icnBrisanjePrimopredajnicee);
            this.icnBrisanjePrimopredajnicee.setText("Brisanje|primopredajnice|(Delete)");
            this.icnBrisanjePrimopredajnicee.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/interniprenos/resource/img/document_delete.png")));
            this.icnBrisanjePrimopredajnicee.addActionListener((ActionListener)((Object)this));
            this.icnBrisanjePrimopredajnicee.setActionCommand("delete_primopredajnica");
            this.icnBrisanjePrimopredajnicee.setShortcut("delete");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj stavki");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setMinimumSize(new Dimension(1006, 600));
            this.setTitle("Primopredajnice u pripremi");
            this.pack();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = ((PzToolBarIcon)e.getSource()).getActionCommand();
        boolean izmena = false;
        if (!actionCommand.equals("insert_primopredajnica")) {
            if (actionCommand.equals("update_primopredajnica")) {
                if (this.table.getSelectedRow() == -1) {
                    return;
                }
                izmena = true;
            } else if (actionCommand.equals("delete_primopredajnica")) {
                EntityManager em = PzEntityManager.getEm();
                this.primopredajnicaBrisanje = (Interniracun)this.table.getSelectedEntity();
                if (this.primopredajnicaBrisanje == null) {
                    return;
                }
                int rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Da li ste sigurni?", (String)"Brisanje", null, (boolean)false);
                if (rez != 0) {
                    return;
                }
                try {
                    em.getTransaction().begin();
                    for (Artikalinterniracun aintrac : this.primopredajnicaBrisanje.getArtikalinterniracuns()) {
                        this.stanje = (Stanje)em.find(Stanje.class, (Object)new StanjePK(aintrac.getId().getSfrProizvod(), this.primopredajnicaBrisanje.getIzlaznaRJ()));
                        if (PzParameter.getParameterValue((String)"INT_NAL_FORM_ALOC").equals("true")) {
                            this.stanje.setAlocKolicina(this.stanje.getAlocKolicina() - aintrac.getKolicina());
                        }
                        em.merge((Object)this.stanje);
                    }
                    em.remove(em.find(Interniracun.class, (Object)this.primopredajnicaBrisanje.getIdDok()));
                    em.getTransaction().commit();
                    this.table.removeSelectedEntity(false, false);
                    this.refresh();
                    return;
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                }
                finally {
                    em.close();
                }
            }
        }
        this.showDialog(PzDialogPrimopredajnicaIzrada.class, izmena, this.table, null);
        this.table.refreshData();
        this.refresh();
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogDokumentiPrimopredajnica(Boolean.FALSE);
    }

    public PzDialogDokumentiPrimopredajnica(Boolean initGUI) {
    }

    public void finish() {
        this.table.removeSelectedEntity(false, false);
    }

    public static Interniracun getInterniRacunUPripermi(PzDialog parent, String parameter) {
        PzDialogDokumentiPrimopredajnica dlg = new PzDialogDokumentiPrimopredajnica(parent, parameter);
        if (!dlg.shouldBeShown()) {
            return null;
        }
        dlg.table.setEnterAction(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                selected = (Interniracun)PzDialogDokumentiPrimopredajnica.this.table.getSelectedEntity();
                PzDialogDokumentiPrimopredajnica.this.dispose();
            }
        });
        dlg.restoreSize();
        dlg.setModal(true);
        dlg.setVisible(true);
        Interniracun res = selected;
        selected = null;
        return res;
    }

    public boolean shouldBeShown() {
        this.mainPanel.setPaintGradient(true);
        return true;
    }
}

