/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.interniprenos.transformation;

import java.awt.Component;
import java.util.HashMap;
import javax.persistence.EntityManager;
import rs.pezar.core.transformation.DefaultDokumentTransformer;
import rs.pezar.core.transformation.DokumentTransformer;
import rs.pezar.core.transformation.TransformationException;
import rs.pezar.db.PzDokument;
import rs.pezar.db.entity.Artikalinterniracun;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.interniprenos.gui.PzDialogDokumentiPovratnica;
import rs.pezar.interniprenos.gui.PzDialogIzradaPovratnicePregled;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.swing.util.PzSwingUtility;
import util.PzInterniNalogUtil;

public class PovratnicaTransformer
extends DokumentTransformer {
    public static final String PARAMETER_RJ_IZLAZ = "IZLAZNA_RJ";
    public static final String PARAMETER_RJ_ULAZ = "ULAZNA_RJ";
    public static final String PARAMETER_TIP = "TIP_DOKUMENTA";
    private boolean priprema = false;

    public HashMap<String, Object> getDokumentParameters(PzDialog parent, Lista l) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        try {
            this.setParametars(parent, parameters);
        }
        catch (TransformationException e) {
            PzSwingUtility.showErrorMessage((Component)parent, (String)e.getMessage());
        }
        parameters.put(PARAMETER_TIP, "POVRATNICA");
        if (parameters.get(PARAMETER_RJ_ULAZ) == null) {
            return null;
        }
        return parameters;
    }

    private void setParametars(PzDialog parent, HashMap<String, Object> parameters) throws TransformationException {
        Radnajedinica izlaznaRJ = PzDialogRJ.getRJ((PzDialog)parent, (String[])new String[]{"EL", "EV", "ET", "ELK", "EP", "EW", "ELR"});
        Radnajedinica ulaznaRJ = PzDialogRJ.getRJ((PzDialog)parent, (String[])new String[]{"V", "VR", "VS", "T", "G"});
        if (izlaznaRJ != null && ulaznaRJ != null) {
            if ((izlaznaRJ.getpTip().equals("V") || izlaznaRJ.getpTip().equals("L")) && !ulaznaRJ.getgTip().equals("V")) {
                throw new TransformationException("Gre\u0161ka! Magacin ulaza nije magacin TRGOVACKE ROBE");
            }
            if ((izlaznaRJ.getpTip().equals("P") || izlaznaRJ.getpTip().equals("W")) && !ulaznaRJ.getgTip().equals("G")) {
                throw new TransformationException("Gre\u0161ka! Magacin ulaza nije magacin GOTOVIH PROIZVODA");
            }
            if (izlaznaRJ.getpTip().equals("T") && !ulaznaRJ.getgTip().equals("T")) {
                throw new TransformationException("Gre\u0161ka! Magain ulaza nije KONSIGNACIJA TUDJE ROBE");
            }
        }
        parameters.put(PARAMETER_RJ_IZLAZ, izlaznaRJ);
        parameters.put(PARAMETER_RJ_ULAZ, ulaznaRJ);
    }

    public PzDokument getDokumentToTransform(PzDialog parent) {
        PzChoice[] choices = new PzChoice[]{new PzChoice("Povratnica iz arhive", (Object)"ARHIVA"), new PzChoice("Povratnica u pripremi", (Object)"U_PRIPREMI")};
        String choice = (String)PzDialogChoice.showPzDialogChoice((PzDialog)parent, (PzChoice[])choices, (String)"Izabor povratnice");
        if (choice == null) {
            return null;
        }
        if (choice.equals("ARHIVA")) {
            return PzDialogIzradaPovratnicePregled.getInterniRacunIzArhive(parent);
        }
        this.priprema = true;
        return PzDialogDokumentiPovratnica.getInterniRacunUPripermi(parent, "Interniracun");
    }

    public PzDokument toDokument(Lista l, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        return PzInterniNalogUtil.toInterniRacun(l, parameters, em);
    }

    public Lista toLista(PzDokument dokument, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        Lista l = new DefaultDokumentTransformer(Interniracun.class, Artikalinterniracun.class).toLista(dokument, parameters, em);
        if (this.priprema) {
            l.setNaslov("POVRATNICA  " + dokument.getRbrDok());
        }
        return l;
    }

    public String getName() {
        return "Transformator povratnice";
    }

    public String getDescription() {
        return null;
    }
}

