/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.service.msg.chat.textComponent.notification;

import java.awt.Color;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.commons.lang.StringUtils;
import rs.pezar.service.msg.chat.textComponent.hyperlink.HyperlinkTextWorker;

public class NotificationText {
    public static String NOTIFICATION_MAIN_BEGIN = "<pznotify>";
    public static String NOTIFICATION_MAIN_END = "</pznotify>";
    public static Color COLOR = new Color(27, 168, 19);
    private static Integer initialFontSize = 13;

    public static boolean hasNotification(String text) {
        return StringUtils.substringsBetween((String)text, (String)NOTIFICATION_MAIN_BEGIN, (String)NOTIFICATION_MAIN_END) != null;
    }

    public static void addNotoficationText(StyledDocument document, String notificationText, SimpleAttributeSet hyperAttributeSet, AttributeSet textAttributeSet) {
        String[] temp = NotificationText.getNotificationText(notificationText);
        if (temp != null) {
            int i = 0;
            while (i < temp.length) {
                HyperlinkTextWorker hlComp = new HyperlinkTextWorker();
                hlComp.addHyperlinkedText(document, " >>" + temp[i] + "\n", hyperAttributeSet, textAttributeSet);
                ++i;
            }
        }
    }

    private static String[] getNotificationText(String text) {
        return StringUtils.substringsBetween((String)text, (String)NOTIFICATION_MAIN_BEGIN, (String)NOTIFICATION_MAIN_END);
    }

    public static String decodeNotification(String text) {
        return StringUtils.substringBetween((String)text, (String)NOTIFICATION_MAIN_BEGIN, (String)NOTIFICATION_MAIN_END);
    }

    public static String codeNotification(String notification) {
        return String.valueOf(NOTIFICATION_MAIN_BEGIN) + notification + NOTIFICATION_MAIN_END;
    }

    public static SimpleAttributeSet getTextAttributes() {
        SimpleAttributeSet notificationAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(notificationAttributeSet, COLOR);
        StyleConstants.setBold(notificationAttributeSet, true);
        StyleConstants.setFontSize(notificationAttributeSet, initialFontSize);
        StyleConstants.setBold(notificationAttributeSet, true);
        return notificationAttributeSet;
    }
}

