/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.service.msg.chat.textComponent.userText;

import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class UserText {
    public static Color COLOR = new Color(83, 172, 128);
    private static Integer initialFontSize = 13;
    private static HashMap<String, Color> userColors = new HashMap();

    private static Color getUserTextColor(String user) {
        Color userColor = userColors.get(user);
        Integer col = user.hashCode();
        if (userColor == null) {
            userColor = new Color(col);
            userColors.put(user, userColor);
        }
        return userColor;
    }

    public static void addUserText(StyledDocument doc, String userText, SimpleAttributeSet userTextAttributeSet) {
        AttributeSet attr = doc.getDefaultRootElement().getAttributes().copyAttributes();
        String from1 = String.valueOf(userText) + "<" + UserText.now() + ">" + " : ";
        StyleConstants.setForeground(userTextAttributeSet, UserText.getUserTextColor(userText));
        try {
            doc.insertString(doc.getLength(), from1, attr);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        doc.setCharacterAttributes(doc.getLength() - from1.length(), from1.length(), userTextAttributeSet, false);
    }

    private static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        return sdf.format(cal.getTime());
    }

    public static SimpleAttributeSet getTextAttributes() {
        SimpleAttributeSet userAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(userAttributeSet, new Color(83, 172, 128));
        StyleConstants.setBold(userAttributeSet, true);
        StyleConstants.setFontSize(userAttributeSet, initialFontSize);
        return userAttributeSet;
    }
}

