/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.magacin.gui;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporterParameter;
import org.apache.commons.beanutils.BeanUtils;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.jdesktop.swingx.JXMonthView;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikalnalog;
import rs.pezar.db.entity.Nalogmagacinu;
import rs.pezar.magacin.PzExtensionLoader;
import rs.pezar.magacin.gui.PzSadrzajMag;
import rs.pezar.reports.engine.standard.PzBeanDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.AudioUtility;
import rs.pezar.util.PzFileUtility;

public class PrintMagDialog
extends PzDialog {
    private static final long serialVersionUID = -5601872572651129530L;
    private JPanel mainPanel;
    private JLabel jLabel1;
    private JXMonthView kalendar;
    private JToolBar toolbar;
    private PzToolBarIcon icnVidiSadrzaj;
    private PzToolBarIcon icnStampa;
    private PzToolBarIcon icnOsveziTabelu;
    private JScrollPane jScrollPane1;
    private JLabel jLabel2;
    private JLabel lblBrojNeodstampanih;
    private PzTable table;
    private PzPanel dataPanel;
    private PzBusyPainterUI layerui;
    private JXLayer<JScrollPane> jxLayer;
    private EntityManager em;
    private static PrintMagDialog instance = null;
    private List<Nalogmagacinu> oldData;
    private PzPanel pnlContent;
    private PrintService service;
    private JRPrintServiceExporter exporter;
    private String glavniMagacin;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PrintMagDialog inst = new PrintMagDialog(new JFrame());
                inst.setLocation(0, 0);
                inst.setVisible(true);
            }
        });
    }

    public PrintMagDialog(JFrame parent) {
        super(parent);
        this.initGUI();
        try {
            this.glavniMagacin = PzParameter.getParameterValue((String)"GLAVNI_MAGACIN").trim();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        this.addTable();
        this.refreshTable();
        instance = this;
    }

    public PrintMagDialog() {
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.pnlContent = new PzPanel();
            this.pnlContent.setPaintGradient(true);
            this.pnlContent.setLayout((LayoutManager)new BorderLayout());
            this.getContentPane().add((Component)this.pnlContent, "Center");
            this.setTitle("\u0160tampanje naloga iz magacina");
            this.setMinimumSize(new Dimension(0, 350));
            this.mainPanel = new JPanel();
            this.mainPanel.setBorder(new EmptyBorder(0, 15, 0, 15));
            this.pnlContent.add((Component)this.mainPanel, (Object)"Center");
            AnchorLayout jPanel1Layout = new AnchorLayout();
            this.mainPanel.setLayout(jPanel1Layout);
            this.mainPanel.setBackground(new Color(255, 255, 255));
            this.mainPanel.setLocale(new Locale("sr", "RS"));
            this.dataPanel = new PzPanel();
            this.dataPanel.setOpaque(false);
            this.pnlContent.add((Component)this.dataPanel, (Object)"South");
            LayoutManager toolbarLayout = new GridBagLayout();
            ((GridBagLayout)toolbarLayout).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
            ((GridBagLayout)toolbarLayout).rowHeights = new int[]{35, 31, 28, 32, 39};
            ((GridBagLayout)toolbarLayout).columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            ((GridBagLayout)toolbarLayout).columnWidths = new int[]{249, 203, 54, 113, 7};
            this.dataPanel.setLayout(toolbarLayout);
            this.kalendar = new JXMonthView();
            this.dataPanel.add((Component)this.kalendar, (Object)new GridBagConstraints(0, 0, 1, 5, 0.0, 0.0, 17, 3, new Insets(10, 10, 10, 0), 0, 0));
            this.kalendar.setDaysOfTheWeek(new String[]{"Ned", "Pon", "Uto", "Sre", "Cet", "Pet", "Sub"});
            this.kalendar.setTraversable(true);
            this.kalendar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    try {
                        PrintMagDialog.this.refreshTable();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            this.kalendar.setVisible(false);
            this.jLabel1 = new JLabel();
            this.dataPanel.add((Component)this.jLabel1, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel1.setPreferredSize(new Dimension(161, 38));
            this.jLabel1.setBackground(new Color(255, 255, 255));
            this.jLabel1.setText("NEOD\u0160TAMPANO");
            this.jLabel1.setLayout(null);
            this.jLabel1.setForeground(new Color(255, 255, 255));
            this.jLabel1.setFont(new Font("Tahoma", 1, 16));
            this.jLabel1.setHorizontalAlignment(4);
            this.lblBrojNeodstampanih = new JLabel();
            this.dataPanel.add((Component)this.lblBrojNeodstampanih, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.lblBrojNeodstampanih.setText("0");
            this.lblBrojNeodstampanih.setPreferredSize(new Dimension(44, 21));
            this.lblBrojNeodstampanih.setForeground(new Color(255, 255, 255));
            this.lblBrojNeodstampanih.setFont(new Font("Tahoma", 1, 24));
            this.lblBrojNeodstampanih.setHorizontalAlignment(0);
            this.jLabel2 = new JLabel();
            this.dataPanel.add((Component)this.jLabel2, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel2.setPreferredSize(new Dimension(93, 38));
            this.jLabel2.setText("NALOGA");
            this.jLabel2.setForeground(new Color(255, 255, 255));
            this.jLabel2.setFont(new Font("Tahoma", 1, 16));
            this.toolbar = new JToolBar();
            this.pnlContent.add((Component)this.toolbar, (Object)"North");
            toolbarLayout = new FlowLayout();
            ((FlowLayout)toolbarLayout).setAlignment(0);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnOsveziTabelu = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnOsveziTabelu);
            this.icnOsveziTabelu.setText("Osve\u017ei tabelu|(F10)");
            this.icnOsveziTabelu.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/document.png")));
            this.icnOsveziTabelu.setActionCommand("osvezitabelu");
            this.icnOsveziTabelu.addActionListener((ActionListener)((Object)this));
            this.icnOsveziTabelu.setShortcut("F10");
            this.icnVidiSadrzaj = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnVidiSadrzaj);
            this.icnVidiSadrzaj.setText("Vidi sadr\u017eaj|(F4)");
            this.icnVidiSadrzaj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/document.png")));
            this.icnVidiSadrzaj.setActionCommand("vidi");
            this.icnVidiSadrzaj.addActionListener((ActionListener)((Object)this));
            this.icnVidiSadrzaj.setShortcut("F4");
            this.icnStampa = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnStampa);
            this.icnStampa.setText("\u0160tampaj|(ALT+S)");
            this.icnStampa.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/printer_preferences.png")));
            this.icnStampa.setActionCommand("stampa");
            this.icnStampa.addActionListener((ActionListener)((Object)this));
            this.icnStampa.setShortcut("ALT+S");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("Broj stavki");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(800, 700);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addTable() {
        this.jScrollPane1 = new JScrollPane();
        this.layerui = new PzBusyPainterUI();
        this.jxLayer = new JXLayer((Component)this.jScrollPane1, (LayerUI)this.layerui);
        this.mainPanel.add((Component)this.jxLayer, new AnchorConstraint(37, 986, 965, 15, 1, 1, 1, 1));
        this.table = new PzTable();
        this.jScrollPane1.setViewportView((Component)this.table);
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equalsIgnoreCase("osvezitabelu")) {
            this.refreshTable();
        } else if (actionCommand.equalsIgnoreCase("vidi")) {
            if (this.table.getSelectedEntity() == null) {
                JOptionPane.showMessageDialog(null, "Izaberite nalog magacina \u010diji sadr\u017eaj \u017eelite da vidite!", "Informacija ", 1);
            } else {
                Nalogmagacinu n = (Nalogmagacinu)this.table.getSelectedEntity();
                this.getSession().putParameter("nalog", (Object)n);
                this.showDialog(PzSadrzajMag.class);
            }
        } else if (actionCommand.equals("stampa")) {
            if (this.table.getDataSize() == 0) {
                JOptionPane.showMessageDialog(null, "Tabela je prazna!", "Informacija ", 1);
            } else if (this.table.getSelectedEntity() == null) {
                JOptionPane.showMessageDialog(null, "Izaberite nalog magacina \u010diji sadr\u017eaj \u017eelite da \u0161tampate!", "Informacija ", 1);
            } else {
                Nalogmagacinu mag = (Nalogmagacinu)this.table.getSelectedEntity();
                EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                try {
                    try {
                        em.getTransaction().begin();
                        mag.getPzusers().add(PzExtensionLoader.getLoggedUser());
                        PzEntityManager.update((Object)mag, (EntityManager)em);
                        em.getTransaction().commit();
                        try {
                            this.printReport(mag);
                        }
                        catch (Exception e1) {
                            this.handlePrintingException(em, mag, e1);
                        }
                        this.table.removeSelectedEntity(false, false);
                        this.repaintBackground();
                        this.lblBrojNeodstampanih.setText(String.valueOf(this.table.getDataSize()));
                    }
                    catch (Exception e1) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                        em.close();
                    }
                }
                finally {
                    em.close();
                }
            }
        }
    }

    private void handlePrintingException(EntityManager em, Nalogmagacinu mag, Exception e1) {
        try {
            try {
                em.getTransaction().begin();
                mag.getPzusers().remove(PzExtensionLoader.getLoggedUser());
                PzEntityManager.update((Object)mag, (EntityManager)em);
                em.getTransaction().commit();
            }
            catch (Exception exception) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)("Do\u0161lo je do gre\u0161ke prilikom \u0161tampanja naloga. Nalog je obele\u017een kao od\u0161tampan, ali nije stvarno od\u0161tampan.\n Oznaka naloga je " + mag.getOznNalogMagacinu() + ". Zapi\u0161ite oznaku i nazovite nadle\u017enog da re\u0161i problem."));
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
        }
        finally {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    public void refreshTable() {
        if (PzExtensionLoader.getLoggedUser().getOznMagacin() == null) {
            return;
        }
        this.layerui.setLocked(true);
        this.em = PzEntityManager.getEm();
        SwingWorker<Vector<Nalogmagacinu>, Integer> worker = new SwingWorker<Vector<Nalogmagacinu>, Integer>(){

            @Override
            protected Vector<Nalogmagacinu> doInBackground() throws Exception {
                Query q = null;
                String[] magacini = PzExtensionLoader.getLoggedUser().getOznMagacin().split(",");
                String krit = "";
                int i = 0;
                while (i < magacini.length) {
                    krit = String.valueOf(krit) + (i == 0 ? "" : " OR ") + "a.stalaza LIKE '" + magacini[i].trim() + "%'";
                    ++i;
                }
                krit = krit.contains(PrintMagDialog.this.glavniMagacin) || PzExtensionLoader.getLoggedUser().getOznMagacin().equals("%") ? "" : "(" + krit + ") AND ";
                q = PrintMagDialog.this.em.createQuery("SELECT distinct n FROM Nalogmagacinu n JOIN n.artikalnalogs a where " + krit + " ( :user not member of n.pzusers and not exists (select u from n.pzusers u where u.oznMagacin = :oznMagacin ) ) order by n.redniBroj");
                q.setParameter("user", (Object)PzExtensionLoader.getLoggedUser());
                q.setParameter("oznMagacin", (Object)PzExtensionLoader.getLoggedUser().getOznMagacin());
                Vector data = (Vector)q.getResultList();
                return data;
            }

            @Override
            protected void done() {
                try {
                    try {
                        Vector data = (Vector)this.get();
                        if (data.size() != 0) {
                            PrintMagDialog.this.table.setData((List)data, Nalogmagacinu.class);
                            PrintMagDialog.this.lblBrojNeodstampanih.setText(String.valueOf(data.size()));
                            PrintMagDialog.this.brDok.setText(Integer.toString(data.size()));
                        }
                        if (PrintMagDialog.this.oldData != null) {
                            if (!PrintMagDialog.this.sameData(PrintMagDialog.this.oldData, data)) {
                                PrintMagDialog.this.notifyUser();
                            }
                            PrintMagDialog.this.oldData = data;
                        } else {
                            PrintMagDialog.this.oldData = data;
                        }
                        PrintMagDialog.this.repaintBackground();
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)PrintMagDialog.this), (Throwable)e);
                        PrintMagDialog.this.layerui.setLocked(false);
                        PrintMagDialog.this.em.close();
                    }
                }
                finally {
                    PrintMagDialog.this.layerui.setLocked(false);
                    PrintMagDialog.this.em.close();
                }
            }
        };
        worker.execute();
    }

    private boolean sameData(List<Nalogmagacinu> stari, List<Nalogmagacinu> novi) {
        if (stari.size() == 0 && novi.size() == 0) {
            return true;
        }
        boolean found = false;
        for (Nalogmagacinu nnovi : novi) {
            found = false;
            for (Nalogmagacinu nstari : stari) {
                if (nnovi.getOznNalogMagacinu() != nstari.getOznNalogMagacinu()) continue;
                found |= true;
            }
            if (!found) break;
        }
        return found;
    }

    private void notifyUser() {
        this.playAlarm();
    }

    private void paintBackground(Color color) {
        this.pnlContent.setPaintGradient(true);
        this.pnlContent.setGradient(Color.WHITE, color, PzPanel.GRADIENT_WEST_EAST);
        this.pnlContent.repaint();
    }

    private void repaintBackground() {
        if (this.table.getRowCount() == 0) {
            this.paintBackground(Color.BLUE);
        } else {
            this.paintBackground(Color.RED);
        }
    }

    private void playAlarm() {
        try {
            AudioInputStream as = AudioSystem.getAudioInputStream(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/wav/alarme.wav"));
            AudioUtility.playAudioStream((AudioInputStream)as);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void printReport(Nalogmagacinu n) throws Exception {
        Vector<Object> data = new Vector<Object>();
        n.getArtikalnalogs().iterator();
        Vector<Artikalnalog> l = new Vector<Artikalnalog>();
        for (Artikalnalog artikalnalog : n.getArtikalnalogs()) {
            l.add(artikalnalog);
        }
        if (PzParameter.getParameterValue((String)"SORT_NALOG") != null) {
            String fields = PzParameter.getParameterValue((String)"SORT_NALOG");
            final String[] fieldArr = fields.split("\\s+|,");
            Comparator<Artikalnalog> c = new Comparator<Artikalnalog>(){

                @Override
                public int compare(Artikalnalog arg0, Artikalnalog arg1) {
                    try {
                        String p1 = "";
                        String p2 = "";
                        int i = 0;
                        while (i < fieldArr.length) {
                            p1 = String.valueOf(p1) + BeanUtils.getProperty((Object)arg0, (String)fieldArr[i]);
                            p2 = String.valueOf(p2) + BeanUtils.getProperty((Object)arg1, (String)fieldArr[i]);
                            ++i;
                        }
                        int res = p1.compareTo(p2);
                        return res;
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Throwable)e);
                        return 0;
                    }
                }
            };
            n.setArtikalnalogs(l);
            Collections.sort(n.getArtikalnalogs(), c);
        } else {
            Collections.sort(n.getArtikalnalogs());
        }
        data.add(n);
        data.add(n.getDokument().getRadnajedinica());
        try {
            data.add(PzFirma.getFirma());
        }
        catch (Exception exception) {}
        data.add(n.getDokument().getKomitent());
        data.add(n);
        if (n.getKoplacas().size() > 0) {
            data.add(n.getKoplacas().get(0));
        }
        data.add(PzExtensionLoader.getLoggedUser());
        Vector<List> ll = new Vector<List>();
        ll.addElement(n.getArtikalnalogs());
        PzDataSourceExtended ds = new PzDataSourceExtended(data, n.getArtikalnalogs());
        ds.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
        HashMap<String, Object> params = new HashMap<String, Object>();
        String title = "NALOG MAGACINU DA IZDA ROBU BROJ: " + n.getOznNalogMagacinu();
        params.put("title", title);
        String fname = null;
        fname = "rs/pezar/magacin/resource/reports/compiled/magacin_stampa.jasper";
        String magacini = "";
        Hashtable<Character, Character> magTable = new Hashtable<Character, Character>();
        for (Artikalnalog an : n.getArtikalnalogs()) {
            magTable.put(Character.valueOf(an.getStalaza().charAt(0)), Character.valueOf(an.getStalaza().charAt(0)));
        }
        Object[] magArray = magTable.keySet().toArray();
        int i = magArray.length - 1;
        while (i >= 0) {
            magacini = String.valueOf(magacini) + (i == magArray.length - 1 ? "" : ", ") + magArray[i].toString();
            --i;
        }
        params.put("magacini", magacini);
        params.put("interniRacun", "FAKTURA_INTERNI_RACUN".equals(n.getDokument().getTip()));
        JasperPrint jp = JasperFillManager.fillReport((InputStream)PzFileUtility.getReportFileAsInputStream((String)fname, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()), params, (JRDataSource)ds);
        if (PzExtensionLoader.getLoggedUser().getOznMagacin().contains(this.glavniMagacin)) {
            Vector staticContentVodeca = new Vector();
            if (n.getKoplacas().size() > 0) {
                staticContentVodeca.add(n.getKoplacas().get(0));
            }
            staticContentVodeca.add(n);
            PzDataSourceExtended dsVodeca = new PzDataSourceExtended(staticContentVodeca, n.getArtikalnalogs());
            dsVodeca.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
            JasperPrint jpVodeca = JasperFillManager.fillReport((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/magacin/resource/reports/compiled/nalog.magacinu.vodeca.jasper", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()), params, (JRDataSource)dsVodeca);
            if (this.shouldPrint(n.getArtikalnalogs())) {
                for (Object p : jpVodeca.getPages()) {
                    JRPrintPage page = (JRPrintPage)p;
                    jp.addPage(page);
                }
            } else {
                jp = jpVodeca;
            }
        }
        this.print(jp);
    }

    private boolean shouldPrint(List<Artikalnalog> nalozi) {
        boolean found = false;
        for (Artikalnalog a : nalozi) {
            if (!PzExtensionLoader.getLoggedUser().getOznMagacin().contains(String.valueOf(a.getStalaza().charAt(0)))) continue;
            found = true;
            break;
        }
        return found;
    }

    private void print(JasperPrint jp) throws JRException {
        if (this.service == null) {
            this.service = PrintServiceLookup.lookupDefaultPrintService();
        }
        if (this.service == null) {
            throw new JRException("Printer ne postoji.");
        }
        if (this.exporter == null) {
            this.exporter = new JRPrintServiceExporter();
            this.exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.PRINT_SERVICE_ATTRIBUTE_SET, (Object)this.service.getAttributes());
            this.exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.DISPLAY_PAGE_DIALOG, (Object)Boolean.FALSE);
            this.exporter.setParameter((JRExporterParameter)JRPrintServiceExporterParameter.DISPLAY_PRINT_DIALOG, (Object)Boolean.FALSE);
            this.exporter.setParameter(JRPrintServiceExporterParameter.IGNORE_PAGE_MARGINS, (Object)Boolean.TRUE);
        }
        this.exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jp);
        this.exporter.exportReport();
    }

    public static Object getGUIBuilderInstance() {
        return new PrintMagDialog(Boolean.FALSE);
    }

    public PrintMagDialog(Boolean initGUI) {
        instance = this;
    }

    public static PrintMagDialog getInstance() {
        return instance;
    }
}

