/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.magacin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Nalogmagacinu;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.magacin.PzExtensionLoader;
import rs.pezar.magacin.gui.IzborKorisnika;
import rs.pezar.magacin.gui.PzSadrzajMag;
import rs.pezar.sifarnici.util.UpitUPodatke;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzCheckbox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PrintMagDialogArhiva
extends PzDialog {
    public static final String PRODAVAC = "PRODAVAC";
    public static final String KUPAC = "KUPAC";
    public static final String BRZA_POSTA = "BRZA_POSTA";
    public static final String TRANZIT = "TRANZIT";
    public static final String VOZI_PRODAVAC = "Vozi prodavac";
    public static final String VOZI_KUPAC = "Vozi kupac";
    public static final String VOZI_BRZA_POSTA = "Brza po\u0161ta";
    public static final String VOZI_TRANZIT = "Tranzit";
    private PzPanel mainPanel;
    private JToolBar toolbar;
    private PzPanel pnlPretraga;
    private PzTable tblNalog;
    private JScrollPane scrollPane;
    private PzToolBarIcon icnVrati;
    private String glavniMagacin;
    private final PrintMagDialogArhiva instance;
    private JButton btnTrazi;
    private PzDateField dfKrajnji;
    private JPanel pnlVozi;
    private JLabel lblKrajnjiDatum;
    private PzDateField dfPocetni;
    private JLabel lblDatumOd;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    protected Vector<Nalogmagacinu> data;
    private PzCheckbox cbTranzit;
    private PzCheckbox cbBrzaPosta;
    private PzCheckbox cbKupac;
    private PzCheckbox cbProdavac;
    private PzToolBarIcon icnVidiSadrzaj;
    private PzToolBarIcon icnUpitUPodatke;

    public PrintMagDialogArhiva(JFrame parent) {
        super(parent);
        this.initGUI();
        try {
            this.glavniMagacin = PzParameter.getParameterValue((String)"GLAVNI_MAGACIN").trim();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        this.instance = this;
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Pregled naloga");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanleLayout1 = new GridBagLayout();
            GridBagLayout mainPanleLayout = new GridBagLayout();
            mainPanleLayout.columnWidths = new int[]{7, 7, 7, 7};
            mainPanleLayout.rowHeights = new int[]{7, 7, 7, 7};
            mainPanleLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanleLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanleLayout1.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            mainPanleLayout1.rowHeights = new int[]{96, 130, 7, 7};
            mainPanleLayout1.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanleLayout1.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanleLayout1);
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnVrati = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnVrati);
            this.icnVrati.setText("Vrati na stampu|(ALT+S)");
            this.icnVrati.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/printer_preferences.png")));
            this.icnVrati.setActionCommand("vrati_na_stampu");
            this.icnVrati.addActionListener((ActionListener)((Object)this));
            this.icnVrati.setShortcut("ALT+S");
            this.icnVidiSadrzaj = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnVidiSadrzaj);
            this.icnVidiSadrzaj.setText("Vidi sadr\u017eaj|(F4)");
            this.icnVidiSadrzaj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/document.png")));
            this.icnVidiSadrzaj.setActionCommand("vidi");
            this.icnVidiSadrzaj.addActionListener((ActionListener)((Object)this));
            this.icnVidiSadrzaj.setShortcut("F4");
            this.icnUpitUPodatke = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnUpitUPodatke);
            this.icnUpitUPodatke.setText("Upit u podatke|komitenta(F2)");
            this.icnUpitUPodatke.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/message_edit.png")));
            this.icnUpitUPodatke.addActionListener((ActionListener)((Object)this));
            this.icnUpitUPodatke.setShortcut("F2");
            this.icnUpitUPodatke.setActionCommand("upitUPodatke");
            this.pnlPretraga = new PzPanel();
            GridBagLayout pnlPretragaLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlPretraga, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlPretraga.setBorder((Border)BorderFactory.createTitledBorder("Pretraga"));
            this.pnlPretraga.setOpaque(false);
            pnlPretragaLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
            pnlPretragaLayout.rowHeights = new int[]{7, 7, 7, 7, 7};
            pnlPretragaLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlPretragaLayout.columnWidths = new int[]{20, 98, 128, 135, 7};
            this.pnlPretraga.setLayout((LayoutManager)pnlPretragaLayout);
            this.lblDatumOd = new JLabel();
            this.pnlPretraga.add((Component)this.lblDatumOd, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 3, 0), 0, 0));
            this.lblDatumOd.setName("lblDatumOd");
            this.dfPocetni = new PzDateField();
            this.pnlPretraga.add((Component)this.dfPocetni, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.dfPocetni.setVal((Object)PzDateUtility.getFirstDayOfCurrentYear());
            this.lblKrajnjiDatum = new JLabel();
            this.pnlPretraga.add((Component)this.lblKrajnjiDatum, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 3, 0), 0, 0));
            this.lblKrajnjiDatum.setName("lblKrajnjiDatum");
            this.dfKrajnji = new PzDateField();
            this.pnlPretraga.add((Component)this.dfKrajnji, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.btnTrazi = new PzButton();
            this.pnlPretraga.add((Component)this.btnTrazi, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnTrazi.setName("btnTrazi");
            this.btnTrazi.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/check.png")));
            this.btnTrazi.setText("Tra\u017ei");
            this.btnTrazi.addActionListener((ActionListener)((Object)this));
            this.btnTrazi.setActionCommand("trazi");
            this.pnlVozi = new JPanel();
            GridBagLayout pnlVoziLayout = new GridBagLayout();
            this.pnlPretraga.add((Component)this.pnlVozi, (Object)new GridBagConstraints(0, 0, 1, 5, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlVozi.setBorder(BorderFactory.createTitledBorder("Na\u010din otpreme"));
            pnlVoziLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            pnlVoziLayout.rowHeights = new int[]{7, 7, 7, 7};
            pnlVoziLayout.columnWeights = new double[]{0.1, 0.1, 0.1};
            pnlVoziLayout.columnWidths = new int[]{7, 7, 7};
            this.pnlVozi.setLayout(pnlVoziLayout);
            this.pnlVozi.setOpaque(false);
            this.cbProdavac = new PzCheckbox();
            this.pnlVozi.add((Component)this.cbProdavac, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.cbProdavac.setName("cbProdavac");
            this.cbProdavac.setSelected(true);
            this.cbProdavac.setText(VOZI_PRODAVAC);
            this.cbProdavac.setOpaque(false);
            this.cbKupac = new PzCheckbox();
            this.pnlVozi.add((Component)this.cbKupac, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.cbKupac.setName("cbKupac");
            this.cbKupac.setSelected(true);
            this.cbKupac.setText(VOZI_KUPAC);
            this.cbKupac.setOpaque(false);
            this.cbBrzaPosta = new PzCheckbox();
            this.pnlVozi.add((Component)this.cbBrzaPosta, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.cbBrzaPosta.setName("cbBrzaPosta");
            this.cbBrzaPosta.setSelected(true);
            this.cbBrzaPosta.setText(VOZI_BRZA_POSTA);
            this.cbBrzaPosta.setOpaque(false);
            this.cbTranzit = new PzCheckbox();
            this.pnlVozi.add((Component)this.cbTranzit, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.cbTranzit.setName("cbTranzit");
            this.cbTranzit.setSelected(true);
            this.cbTranzit.setText(VOZI_TRANZIT);
            this.cbTranzit.setOpaque(false);
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 2, 4, 2, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.tblNalog = new PzTable();
            this.scrollPane.setViewportView((Component)this.tblNalog);
            this.tblNalog.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Nalogmagacinu dok = (Nalogmagacinu)entity;
                    String odstampan = dok.getPzusers().size() == 0 ? "NE" : "DA";
                    return new Object[]{dok.getOznNalogMagacinu(), dok.getDatum(), dok.getBrTure(), dok.getDokument().getRadnajedinica().getId().getOznRj(), dok.getDokument().getKomitent().getSfrKomitent(), dok.getDokument().getKomitent().getNaziv(), odstampan, dok.getVremePreuzimanja()};
                }

                public String[] getColumnNames() {
                    return new String[]{"Broj naloga", "Datum", "Tura(*)", "Rj", "\u0160ifra kupca(*)", "Naziv kupca", "Od\u0161tampan", "Vreme"};
                }
            });
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText(" Broj naloga");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(775, 468);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("trazi")) {
            if (!(this.cbProdavac.isSelected() || this.cbKupac.isSelected() || this.cbBrzaPosta.isSelected() || this.cbTranzit.isSelected())) {
                PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Niste izabrali nacin otpreme!");
                return;
            }
            this.refreshTable();
            return;
        }
        if (actionCommand.equals("upitUPodatke")) {
            if (this.tblNalog.getSelectedEntity() != null) {
                Nalogmagacinu n = (Nalogmagacinu)this.tblNalog.getSelectedEntity();
                this.getSession().putParameter("komitent", (Object)n.getDokument().getKomitent());
                this.showDialog(UpitUPodatke.class);
            }
            return;
        }
        if (actionCommand.equalsIgnoreCase("vidi")) {
            if (this.tblNalog.getSelectedEntity() == null) {
                JOptionPane.showMessageDialog(null, "Izaberite nalog magacina \u010diji sadr\u017eaj \u017eelite da vidite!", "Informacija ", 1);
            } else {
                Nalogmagacinu n = (Nalogmagacinu)this.tblNalog.getSelectedEntity();
                this.getSession().putParameter("nalog", (Object)n);
                this.showDialog(PzSadrzajMag.class);
            }
        } else if (actionCommand.equals("vrati_na_stampu")) {
            if (this.tblNalog.getRowCount() == 0) {
                return;
            }
            Nalogmagacinu mag = (Nalogmagacinu)this.tblNalog.getSelectedEntity();
            if (this.tblNalog.getRowCount() == 0) {
                return;
            }
            EntityManager em = PzEntityManagerFactory.getInstance().createEm();
            Pzuser user = null;
            if (mag.getPzusers().size() == 0) {
                PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Nalog nije od\u0161tampan");
                return;
            }
            if (mag.getPzusers().size() == 1) {
                user = (Pzuser)mag.getPzusers().get(0);
            } else {
                this.getSession().putParameter("users", (Object)mag.getPzusers());
                this.showDialog(IzborKorisnika.class);
                user = (Pzuser)this.getSession().getParameter("user");
                if (user == null) {
                    return;
                }
            }
            try {
                em.getTransaction().begin();
                mag.getPzusers().remove(user);
                PzEntityManager.update((Object)mag, (EntityManager)em);
                em.getTransaction().commit();
                PzSwingUtility.showInformationMessage((Component)((Object)this), (String)("Nalog " + mag.getOznNalogMagacinu() + " je vra\u0107en na \u0161tampanje korisniku " + user.getFullName()));
                return;
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
            finally {
                em.close();
            }
        }
    }

    public void refreshTable() {
        if (PzExtensionLoader.getLoggedUser().getOznMagacin() == null) {
            return;
        }
        final EntityManager em = PzEntityManager.getEm();
        PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                Query q = null;
                String[] magacini = PzExtensionLoader.getLoggedUser().getOznMagacin().split(",");
                String krit = "";
                int i = 0;
                while (i < magacini.length) {
                    krit = String.valueOf(krit) + (i == 0 ? "" : " OR ") + "a.stalaza LIKE '" + magacini[i].trim() + "%'";
                    ++i;
                }
                krit = krit.contains(PrintMagDialogArhiva.this.glavniMagacin) || PzExtensionLoader.getLoggedUser().getOznMagacin().equals("%") ? "" : "(" + krit + ") AND ";
                String vozi = "";
                int j = 0;
                int i2 = 0;
                while (i2 < PrintMagDialogArhiva.this.pnlVozi.getComponents().length) {
                    JCheckBox cbox = (JCheckBox)PrintMagDialogArhiva.this.pnlVozi.getComponents()[i2];
                    if (cbox.isSelected()) {
                        if (cbox.getText().equals(PrintMagDialogArhiva.VOZI_PRODAVAC)) {
                            vozi = String.valueOf(vozi) + (j == 0 ? " 'PRODAVAC' " : ", 'PRODAVAC'");
                            ++j;
                        } else if (cbox.getText().equals(PrintMagDialogArhiva.VOZI_KUPAC)) {
                            vozi = String.valueOf(vozi) + (j == 0 ? " 'KUPAC'" : ", 'KUPAC'");
                            ++j;
                        } else if (cbox.getText().equals(PrintMagDialogArhiva.VOZI_BRZA_POSTA)) {
                            vozi = String.valueOf(vozi) + (j == 0 ? " 'BRZA_POSTA'" : ", 'BRZA_POSTA'");
                            ++j;
                        } else if (cbox.getText().equals(PrintMagDialogArhiva.VOZI_TRANZIT)) {
                            vozi = String.valueOf(vozi) + (j == 0 ? " 'TRANZIT'" : ", 'TRANZIT'");
                            ++j;
                        }
                    }
                    ++i2;
                }
                q = em.createQuery("SELECT distinct n FROM Nalogmagacinu n JOIN n.artikalnalogs a where " + krit + " n.koVozi in (" + vozi + ") and n.datum>=:datumOD and n.datum<=:datumDO order by n.redniBroj");
                q.setParameter("datumOD", (Object)PrintMagDialogArhiva.this.dfPocetni.getVal());
                q.setParameter("datumDO", (Object)PrintMagDialogArhiva.this.dfKrajnji.getVal());
                PrintMagDialogArhiva.this.data = (Vector)q.getResultList();
                PrintMagDialogArhiva.this.brDok.setText(String.valueOf(PrintMagDialogArhiva.this.data.size()));
                return null;
            }

            @Override
            protected void done() {
                try {
                    try {
                        this.get();
                        if (PrintMagDialogArhiva.this.data.size() != 0) {
                            PrintMagDialogArhiva.this.tblNalog.setData(PrintMagDialogArhiva.this.data, Nalogmagacinu.class);
                            PrintMagDialogArhiva.this.brDok.setText(String.valueOf(PrintMagDialogArhiva.this.data.size()));
                            PzWorkerDialog.hideStatus();
                        }
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)PrintMagDialogArhiva.this), (Throwable)e);
                        PzWorkerDialog.hideStatus();
                        em.close();
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    em.close();
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        worker.execute();
    }
}

