/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.magacin.gui.brzaposta;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.FiskalniIzvestaj;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.magacin.gui.brzaposta.PzDialogStampaNalogaZaBrzuPostu;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzGradient;

public class UzmiDokument
extends PzDialog {
    private static final long serialVersionUID = 5284942039737355206L;
    private JToolBar toolbar;
    private PzToolBarIcon btnSlikaProfakture;
    private PzToolBarIcon btnNeplacene;
    private PzPanel plGlavni;
    private Faktura f;
    private PzTable tblTabela;
    private JScrollPane scTabela;
    private PzPanel plTabela;
    private JPanel jPanel1;
    private String tipDokumenta;
    private Radnajedinica radnaJedinica;
    private Faktura selektovanaFaktura;
    private FiskalniIzvestaj selektovaniIzvestaj;
    private String tableID = "";
    private Komitent komitent;
    private boolean vracanjeFakture = false;
    private boolean vracanjeOtpremnice = false;
    private boolean izmenaDatuma = false;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public UzmiDokument(PzDialog dialog) {
        super(dialog);
        this.preInit();
        this.initGUI();
    }

    private void preInit() {
        this.komitent = (Komitent)this.getSession().getParameter("komitent");
    }

    private void paintPanel() {
        this.plGlavni.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.plGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.plGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            this.plGlavni = new PzPanel();
            this.paintPanel();
            GridBagLayout plGlavniLayout = new GridBagLayout();
            plGlavniLayout.rowWeights = new double[]{0.0, 0.1};
            plGlavniLayout.rowHeights = new int[]{84, 7};
            plGlavniLayout.columnWeights = new double[]{0.1};
            plGlavniLayout.columnWidths = new int[]{7};
            this.plGlavni.setLayout((LayoutManager)plGlavniLayout);
            this.getContentPane().add((Component)this.plGlavni, "Center");
            this.toolbar = new JToolBar();
            this.plGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.btnSlikaProfakture = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnSlikaProfakture);
            this.btnSlikaProfakture.setText("Slika|dokumenta|(F2)");
            this.btnSlikaProfakture.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/presentation_chart.png")));
            this.btnSlikaProfakture.setActionCommand("slika");
            this.btnSlikaProfakture.addActionListener((ActionListener)((Object)this));
            this.btnSlikaProfakture.setShortcut("F2");
            this.btnNeplacene = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnNeplacene);
            this.btnNeplacene.setText("Samo|neplacene|(F4)");
            this.btnNeplacene.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/presentation.png")));
            this.btnNeplacene.setActionCommand("neplacene");
            this.btnNeplacene.addActionListener((ActionListener)((Object)this));
            this.btnNeplacene.setShortcut("F4");
            this.btnNeplacene.setVisible(false);
            this.jPanel1 = new JPanel();
            this.plGlavni.add((Component)this.jPanel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            BorderLayout jPanel1Layout1 = new BorderLayout();
            this.jPanel1.setLayout(jPanel1Layout1);
            this.jPanel1.setOpaque(false);
            this.plTabela = new PzPanel();
            BorderLayout jPanel1Layout = new BorderLayout();
            this.jPanel1.add((Component)this.plTabela, "Center");
            this.plTabela.setLayout((LayoutManager)jPanel1Layout);
            this.plTabela.setOpaque(false);
            this.scTabela = new JScrollPane();
            this.plTabela.add((Component)this.scTabela, (Object)"Center");
            this.scTabela.setBackground(new Color(211, 242, 210));
            this.tblTabela = new PzTable();
            this.tblTabela.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Faktura dok = (Faktura)entity;
                    return new Object[]{dok.getTip(), dok.getDatum(), dok.getOznDokumenta(), dok.getIznos()};
                }

                public String[] getColumnNames() {
                    return new String[]{"Tip dokumenta", "Datum dokumenta", "Oznaka", "Iznos"};
                }
            });
            EntityManager em = PzEntityManager.getEm();
            Query q = null;
            q = em.createQuery("SELECT f FROM Faktura f where f.arhiviran = 1 and f.storno = 0 and f.komitent=:komitent ORDER BY f.datum DESC");
            q.setParameter("komitent", (Object)this.komitent);
            Vector data = (Vector)q.getResultList();
            this.brDok.setText(String.valueOf(data.size()));
            this.tblTabela.setData(data, Faktura.class);
            em.close();
            this.tblTabela.setId(this.tableID);
            this.scTabela.setViewportView((Component)this.tblTabela);
            this.tblTabela.getTableHeader().setFocusable(false);
            this.tblTabela.requestFocusInWindow();
            if (this.tblTabela.getDataSize() > 0) {
                this.tblTabela.setRowSelectionInterval(0, 0);
            }
            this.tblTabela.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (UzmiDokument.this.tblTabela.getDataSize() > 0) {
                        PzEntityManager.getEm();
                        UzmiDokument.this.selektovanaFaktura = (Faktura)UzmiDokument.this.tblTabela.getSelectedEntity();
                        ((PzDialogStampaNalogaZaBrzuPostu)((Object)UzmiDokument.this.getParent())).refreshField(UzmiDokument.this.selektovanaFaktura);
                        UzmiDokument.this.dispose();
                    }
                }
            });
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("Broj stavki");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setSize(800, 450);
            this.setMinimumSize(new Dimension(800, 450));
            this.pack();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(null, (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("slika")) {
            this.showReport();
        }
    }

    public void showReport() {
        try {
            if (this.tblTabela.getSelectedEntity() != null) {
                Faktura faktura = (Faktura)this.tblTabela.getSelectedEntity();
                PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)faktura);
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new UzmiDokument(Boolean.FALSE);
    }

    public UzmiDokument(Boolean initGUI) {
    }
}

