/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.magacin.gui.util;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalnalogprijem;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Nalepnica;
import rs.pezar.db.entity.Nalogprijem;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzBeanDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.util.PzDateUtility;

public class PzMagacinUtil {
    public static Boolean postojiMagacin(String magacin, Character ch) {
        Boolean res = false;
        String[] magacini = magacin.split(",");
        int i = 0;
        while (i < magacini.length) {
            System.out.println(magacini[i]);
            if (magacini[i].equals(ch.toString())) {
                res = true;
            }
            ++i;
        }
        return res;
    }

    public static Boolean azurirajStanje(Nalogprijem nalog, Boolean alociranje, EntityManager em) {
        try {
            for (Artikalnalogprijem anp : nalog.getArtikalnalogprijems()) {
                StanjePK spk = new StanjePK(anp.getSfrProizvod(), nalog.getDokument().getRadnajedinica().getId().getOznOgranak(), nalog.getDokument().getRadnajedinica().getId().getOznRj());
                Stanje s = (Stanje)em.find(Stanje.class, (Object)spk);
                if (alociranje.booleanValue()) {
                    s.setAlocKolicina(s.getAlocKolicina() + anp.getKolicina());
                    s.setDatZadIzlaza(new Date(nalog.getDatNaloga().getTime()));
                    s.setKumIzlaza(s.getKumIzlaza() + anp.getKolicina());
                } else {
                    s.setAlocKolicina(s.getAlocKolicina() - anp.getKolicina());
                    s.setDatZadIzlaza(new Date(nalog.getDatNaloga().getTime()));
                    s.setKumIzlaza(s.getKumIzlaza() + anp.getKolicina());
                }
                PzEntityManager.update((Object)s, (EntityManager)em);
            }
            return true;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
            return false;
        }
    }

    public static void showReports(PzDialog parent, Nalogprijem nalog) throws Exception {
        System.out.println("NALOG IMA STAVKI:" + nalog.getArtikalnalogprijems().size());
        Vector<Object> data = new Vector<Object>();
        data.add(PzFirma.getFirma());
        data.add(nalog);
        data.add(nalog.getDokument());
        PzDataSourceExtended ds = new PzDataSourceExtended(data, nalog.getArtikalnalogprijems());
        ds.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("title", "NALOG MAGACINU DA PRIMI ROBU");
        params.put("reklama", "");
        PzReportManager.createAndShowReport((PzDialog)parent, (JRDataSource)ds, (URL)parent.getClass().getClassLoader().getResource("rs/pezar/magacin/resource/reports/compiled/nalogprijem.jasper"), params, null, (int)PzReportManager.REPORT_TYPE_JASPER);
    }

    public static void showReports(PzDialog parent, Vector<PzEntity> dataArtikli, String fname, String subtitle) throws Exception {
        Vector<Firma> data = new Vector<Firma>();
        data.add(PzFirma.getFirma());
        PzDataSourceExtended ds = new PzDataSourceExtended(data, dataArtikli);
        ds.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", "PREGLED NESPAKOVANIH ARTIKALA");
        params.put("reklama", "");
        params.put("subtitle", subtitle);
        params.put("datum", PzDateUtility.getCurrentDate());
        PzReportManager.createAndShowReport((PzDialog)parent, (JRDataSource)ds, (URL)parent.getClass().getClassLoader().getResource(fname), params, null, (int)PzReportManager.REPORT_TYPE_JASPER);
    }

    public static void cistiTabelu(PzTable tabela, EntityManager em) {
        List data = tabela.getAllEntities();
        Iterator i = data.iterator();
        System.out.println("naloga ima " + data.size());
        while (i.hasNext()) {
            Nalogprijem nalog = (Nalogprijem)i.next();
            if (nalog.getStatus() != 2) continue;
            nalog.setSpakovano(1);
            em.merge((Object)nalog);
        }
    }

    public static Boolean postojiArtikal(PzTable tabela, String sifra, int kolicina, EntityManager em) {
        Boolean res = false;
        int i = 0;
        while (i < tabela.getRowCount()) {
            Nalepnica n = (Nalepnica)tabela.getEntity(i);
            if (n.getSfrProizvod().equals(sifra)) {
                n.setBrNalepnica(n.getBrNalepnica() + kolicina);
                em.merge((Object)n);
                res = true;
                break;
            }
            ++i;
        }
        return res;
    }

    public static void createNalepnice(PzTable tabela, Artikal art, BigDecimal cena, int brojNalepnica, String firma, EntityManager em) {
        try {
            Nalepnica n = new Nalepnica();
            n.setSfrProizvod(art.getSfrProizvod());
            n.setNaziv(art.getNaziv());
            n.setBliziOpis(art.getBliziOpis());
            n.setBarKod(art.getBarKod());
            n.setStandPak(new BigDecimal(art.getStandPak()));
            n.setBrNalepnica(brojNalepnica);
            n.setDistributer(firma);
            n.setJedMere(art.getJedMere());
            n.setUvoznik(firma);
            n.setDobSifra(art.getDobSifra());
            if (cena != null && cena.compareTo(BigDecimal.ZERO) != 0) {
                n.setCena(cena);
            }
            n.setPzuser(PzApplication.getApplication().getSession().getLoggedUser());
            if (art.getProizvodjac() == null) {
                n.setProizvodjac("");
                n.setZemlja("");
            } else {
                n.setProizvodjac(art.getProizvodjac().getSfrKomitent());
                n.setZemlja(art.getProizvodjac().getZemljaKomitenta());
            }
            tabela.insert((PzEntity)n, em);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }

    public static void azurirajCene(PzTable tabela, Radnajedinica rj1, Radnajedinica rj2, EntityManager em) {
        try {
            new IndirectList();
            for (PzEntity entity : tabela.getAllEntities()) {
                Nalepnica nal = (Nalepnica)entity;
                Stanje stanjeArt1 = (Stanje)PzEntityManager.getEm().find(Stanje.class, (Object)new StanjePK(nal.getSfrProizvod(), rj1));
                if (nal.getCena() == null || nal.getCena().compareTo(BigDecimal.ZERO) == 0) {
                    nal.setCena(BDConverter.getProdCena((double)(stanjeArt1 == null ? 0.0 : stanjeArt1.getProdCena())));
                }
                if (rj2 != null) {
                    Stanje stanjeArt2 = (Stanje)PzEntityManager.getEm().find(Stanje.class, (Object)new StanjePK(nal.getSfrProizvod(), rj2));
                    nal.setPomCena(BDConverter.getProdCena((double)(stanjeArt2 == null ? 0.0 : stanjeArt2.getProdCena())));
                }
                em.merge((Object)nal);
            }
            tabela.commitUpdate();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }
}

