/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jdesktop.application.Application;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturaparameter;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.db.entity.StanjeartikalPK;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.prodaja.PzExtensionLoader;
import rs.pezar.prodaja.gui.faktureZaProdajuRobe.ArhivaStampa;
import rs.pezar.sifarnici.gui.PzDialogArtikliExtended;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextAreaPanel;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogFakturaAutomobila
extends PzDialog {
    private final String MARKA_VOZILA = "MARKA_VOZILA";
    private final String TIP_VOZILA = "TIP_VOZILA";
    private final String TRGOVACKI_NAZIV = "TRGOVACKI_NAZIV";
    private final String MODEL_VOZILA = "MODEL_VOZILA";
    private final String VRSTA_VOZILA = "VRSTA_VOZILA";
    private final String FABRICKI_BROJ = "FABRICKI_BROJ";
    private final String STANDARD = "STANDARD";
    private final String OBLIK_KAROSERIJE = "OBLIK_KAROSERIJE";
    private final String BROJ_SEDISTA = "BROJ_SEDISTA";
    private final String BROJ_VRATA = "BROJ_VRATA";
    private final String BOJA_KAROSERIJE = "BOJA_KAROSERIJE";
    private final String BROJ_SASIJE = "BROJ_SASIJE";
    private final String GODINA_PROIZVODNJE = "GODINA_PROIZVODNJE";
    private final String PROIZVODJAC = "PROIZVODJAC";
    private final String DRZAVA_PROIZVODNJE = "DRZAVA_PROIZVODNJE";
    private final String SERVISNA_KNJIZICA = "SERVISNA_KNJIZICA";
    private final String DUZINA_VOZILA = "DUZINA_VOZILA";
    private final String SIRINA_VOZILA = "SIRINA_VOZILA";
    private final String VISINA_VOZILA = "VISINA_VOZILA";
    private final String TEZINA_VOZILA = "TEZINA_VOZILA";
    private final String NOSIVOST = "NOSIVOST";
    private final String BROJ_MOTORA = "BROJ_MOTORA";
    private final String VRSTA_MOTORA = "VRSTA_MOTORA";
    private final String ZAPREMINA_MOTORA = "ZAPREMINA_MOTORA";
    private final String SNAGA_MOTORA = "SNAGA_MOTORA";
    private final String OPIS = "OPIS";
    private PzPanel mainPanel;
    private JToolBar toolbar;
    private PzPanel pnlPodaci;
    private PzDoubleField dfIznosSaPdv;
    private JLabel lblIznosSaPdv;
    private PzDoubleField dfIznosBezPdv;
    private JLabel lblIznosBezPdv;
    private PzToolBarIcon icnArhiviranje;
    private PzToolBarIcon icnBrisanje;
    private JLabel lblCenaBezPDV;
    private PzDoubleField tfPopust;
    private JLabel lblPopust;
    private PzDoubleField tfCenaBezPdv;
    private PzTextField tfNaziv;
    private JLabel lblTipVozila;
    private JLabel lblDuzina;
    private PzTextAreaPanel areaOpis;
    private PzPanel pnlOpis;
    private PzTextField tfSnaga;
    private JLabel lblSnaga;
    private PzTextField tfZapremina;
    private JLabel lblZapremina;
    private PzTextField tfVrstaMotora;
    private JLabel lblVrstaMotora;
    private PzTextField tfBrojMotora;
    private JLabel lblBrojMotora;
    private PzPanel pnlMotor;
    private PzTextField tfNosivost;
    private JLabel lblNosivost;
    private PzTextField tfTezina;
    private JLabel lblTezina;
    private PzTextField tfVisina;
    private PzTextField tfVrstaVozila;
    private JLabel lblVrstaVozila;
    private JLabel lblVisina;
    private PzTextField tfSirina;
    private JLabel lblSirina;
    private PzTextField tfDuzina;
    private PzPanel pnlDimenzije;
    private PzTextField tfServisnaKnjizica;
    private JLabel lblServisnaKnjizica;
    private PzTextField tfDrzavaProizvodnje;
    private JLabel lblDrzavaProizvodnje;
    private PzTextField tfProizvodjac;
    private JLabel lblProiyvodjac;
    private PzTextField tfGodProizvodnje;
    private JLabel lblGodinaProizvodnje;
    private PzTextField tfBrojSasije;
    private JLabel lblBrojSasije;
    private PzTextField tfBojaKaroserije;
    private JLabel lblBojaKaroserije;
    private PzTextField tfBrojVrata;
    private JLabel lblBrojVrata;
    private PzTextField tfBrojSedista;
    private JLabel lblBrojSedista;
    private PzTextField tfKaroserija;
    private JLabel lblKaroserija;
    private PzTextField tfStandard;
    private JLabel lblStandard;
    private PzTextField tfFabrickiBroj;
    private JLabel lblFabrickiBroj;
    private PzTextField tfModelVozila;
    private JLabel lblModelVozila;
    private PzTextField tfTrgovackiNaziv;
    private JLabel lblTrgovackiNaziv;
    private PzTextField tfTipVozila;
    private PzTextField tfMarkaVozila;
    private JLabel lblMarkaVozila;
    private PzFieldIndikator indSifra;
    private PzTextField tfSifra;
    private JLabel lblSifra;
    private PzPanel panel1;
    private Radnajedinica rj;
    private Artikal art = null;
    private boolean update;
    private Faktura faktura;
    private boolean arhiviran = false;

    public PzDialogFakturaAutomobila(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout bLayout = new BorderLayout();
            this.setLayout(bLayout);
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel);
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.rowHeights = new int[]{86, 97, 162, 134, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{347, 99, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.mainPanel.setPreferredSize(new Dimension(937, 668));
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setOpaque(false);
            this.icnArhiviranje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnArhiviranje);
            this.icnArhiviranje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/printer_preferences.png")));
            this.icnArhiviranje.setText("Arhiviranje|(Ctrl+W)");
            this.icnArhiviranje.setActionCommand("Arhiviranje");
            this.icnArhiviranje.addActionListener((ActionListener)((Object)this));
            this.icnArhiviranje.setShortcut("CTRL+W");
            this.icnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/document_delete.png")));
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setActionCommand("Brisanje");
            this.icnBrisanje.setText("Brisanje|(DEL)");
            this.icnBrisanje.setShortcut("DELETE");
            this.panel1 = new PzPanel();
            GridBagLayout panel1Layout = new GridBagLayout();
            this.mainPanel.add((Component)this.panel1, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel1Layout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            panel1Layout.rowHeights = new int[]{7, 7, 7, 7};
            panel1Layout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            panel1Layout.columnWidths = new int[]{114, 108, 25, 90, 108, 91, 20};
            this.panel1.setLayout((LayoutManager)panel1Layout);
            this.lblSifra = new JLabel();
            this.panel1.add((Component)this.lblSifra, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblSifra.setText("\u0160ifra automobila");
            this.tfSifra = new PzTextField();
            this.panel1.add((Component)this.tfSifra, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tfSifra.setFKField(Artikal.class, PzDialogArtikliExtended.class, true, null);
            this.tfSifra.setCustomInputVerifier(new InputVerifier(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public boolean verify(JComponent arg0) {
                    PzField field = (PzField)arg0;
                    if (PzDialogFakturaAutomobila.this.art == null) {
                        return false;
                    }
                    Stanjeartikal stanje = (Stanjeartikal)PzEntityManager.getEm().find(Stanjeartikal.class, (Object)new StanjeartikalPK(PzDialogFakturaAutomobila.this.art.getSfrProizvod(), PzDialogFakturaAutomobila.this.rj));
                    if (stanje == null) {
                        PzSwingUtility.showInformationMessage((Component)((Object)PzDialogFakturaAutomobila.this), (String)"Artikal nema stanje u izabranoj radnoj jedinici");
                        return false;
                    }
                    if (!(stanje.getKolicina() > 0.0)) {
                        PzSwingUtility.showErrorMessage(null, (String)"Artikal u izabranoj radnoj jedinici nema dovoljno kolicine!");
                        PzDialogFakturaAutomobila.this.tfSifra.setVal((Object)"");
                        PzDialogFakturaAutomobila.this.tfNaziv.setVal((Object)"");
                        field.setState(PzFieldIndikator.STATE_INVALID);
                        PzDialogFakturaAutomobila.this.art = null;
                        return false;
                    }
                    if (PzDialogFakturaAutomobila.this.rj.getgTip().equals("E")) {
                        PzDialogFakturaAutomobila.this.tfCenaBezPdv.setVal((Object)(stanje.getProdCena() * 100.0 / (PzDialogFakturaAutomobila.this.art.getTarifnaGrupa("PDV").getStopa() + 100.0)));
                    } else {
                        PzDialogFakturaAutomobila.this.tfCenaBezPdv.setVal((Object)stanje.getProdCena());
                    }
                    PzDialogFakturaAutomobila.this.tfSifra.setEnabled(false);
                    return true;
                }
            });
            this.indSifra = new PzFieldIndikator();
            this.panel1.add((Component)this.indSifra, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.tfNaziv = new PzTextField();
            this.panel1.add((Component)this.tfNaziv, (Object)new GridBagConstraints(3, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tfNaziv.setEnabled(false);
            this.tfNaziv.setFocusable(false);
            this.lblCenaBezPDV = new JLabel();
            this.panel1.add((Component)this.lblCenaBezPDV, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblCenaBezPDV.setName("lblCenaBezPDV");
            this.tfCenaBezPdv = new PzDoubleField();
            this.panel1.add((Component)this.tfCenaBezPdv, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tfCenaBezPdv.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogFakturaAutomobila.this.tfCenaBezPdv.getVal() == 0.0) {
                        PzDialogFakturaAutomobila.this.dfIznosBezPdv.setVal((Object)0.0);
                        PzDialogFakturaAutomobila.this.dfIznosSaPdv.setVal((Object)0.0);
                    } else {
                        BigDecimal cenaBezPdv = new BigDecimal(PzDialogFakturaAutomobila.this.tfCenaBezPdv.getVal());
                        BigDecimal popust100 = BDConverter.getIznos((BigDecimal)new BigDecimal(PzDialogFakturaAutomobila.this.tfPopust.getVal()).divide(new BigDecimal(100)));
                        BigDecimal iznosBezPdv = PzDialogFakturaAutomobila.this.tfPopust.getVal() == 0.0 ? cenaBezPdv : BDConverter.getIznos((BigDecimal)cenaBezPdv.multiply(BDConverter.getIznos((BigDecimal)new BigDecimal(1).subtract(popust100))));
                        PzDialogFakturaAutomobila.this.dfIznosBezPdv.setVal((Object)iznosBezPdv);
                        BigDecimal stopa100 = BDConverter.getIznos((BigDecimal)new BigDecimal(PzDialogFakturaAutomobila.this.art.getTarifnaGrupa("PDV").getStopa()).divide(new BigDecimal(100)));
                        BigDecimal iznosSaPDV = BDConverter.getIznos((BigDecimal)iznosBezPdv.multiply(BDConverter.getIznos((BigDecimal)new BigDecimal(1)).add(stopa100)));
                        PzDialogFakturaAutomobila.this.dfIznosSaPdv.setVal((Object)iznosSaPDV);
                        PzDialogFakturaAutomobila.this.snimiDokument();
                    }
                    return true;
                }
            });
            this.lblPopust = new JLabel();
            this.panel1.add((Component)this.lblPopust, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblPopust.setName("lblPopust");
            this.tfPopust = new PzDoubleField();
            this.panel1.add((Component)this.tfPopust, (Object)new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tfPopust.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    if (PzDialogFakturaAutomobila.this.tfPopust.getVal() != 0.0) {
                        BigDecimal iznosBezPdv = PzDialogFakturaAutomobila.this.dfIznosBezPdv.getBigDecimal();
                        BigDecimal iznosSaPdv = PzDialogFakturaAutomobila.this.dfIznosSaPdv.getBigDecimal();
                        BigDecimal popust100 = BDConverter.getIznos((BigDecimal)new BigDecimal(PzDialogFakturaAutomobila.this.tfPopust.getVal()).divide(new BigDecimal(100)));
                        PzDialogFakturaAutomobila.this.dfIznosBezPdv.setVal((Object)BDConverter.getIznos((BigDecimal)iznosBezPdv.multiply(BDConverter.getIznos((BigDecimal)new BigDecimal(1).subtract(popust100)))));
                        PzDialogFakturaAutomobila.this.dfIznosSaPdv.setVal((Object)BDConverter.getIznos((BigDecimal)iznosSaPdv.multiply(BDConverter.getIznos((BigDecimal)new BigDecimal(1).subtract(popust100)))));
                    }
                    return true;
                }
            });
            this.lblIznosBezPdv = new JLabel();
            this.panel1.add((Component)this.lblIznosBezPdv, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 5, 0), 0, 0));
            this.lblIznosBezPdv.setName("lblIznosBezPdv");
            this.dfIznosBezPdv = new PzDoubleField();
            this.panel1.add((Component)this.dfIznosBezPdv, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblIznosSaPdv = new JLabel();
            this.panel1.add((Component)this.lblIznosSaPdv, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblIznosSaPdv.setName("lblIznosSaPdv");
            this.dfIznosSaPdv = new PzDoubleField();
            this.panel1.add((Component)this.dfIznosSaPdv, (Object)new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.pnlPodaci = new PzPanel();
            GridBagLayout pnlPodaciLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlPodaci, (Object)new GridBagConstraints(0, 2, 2, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            pnlPodaciLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            pnlPodaciLayout.rowHeights = new int[]{7, 7, 7, 20, 20, 20, 7, 20, 20, 20, 20, 20, 20, 20, 20, 20};
            pnlPodaciLayout.columnWeights = new double[]{0.0, 0.1, 0.0};
            pnlPodaciLayout.columnWidths = new int[]{108, 7, 193};
            this.pnlPodaci.setLayout((LayoutManager)pnlPodaciLayout);
            this.pnlPodaci.setBorder((Border)BorderFactory.createTitledBorder("Podaci o vozilu"));
            this.lblMarkaVozila = new JLabel();
            this.pnlPodaci.add((Component)this.lblMarkaVozila, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblMarkaVozila.setName("lblMarkaVozila");
            this.tfMarkaVozila = new PzTextField();
            this.pnlPodaci.add((Component)this.tfMarkaVozila, (Object)new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblTipVozila = new JLabel();
            this.pnlPodaci.add((Component)this.lblTipVozila, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblTipVozila.setName("lblTipVozila");
            this.tfTipVozila = new PzTextField();
            this.pnlPodaci.add((Component)this.tfTipVozila, (Object)new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblTrgovackiNaziv = new JLabel();
            this.pnlPodaci.add((Component)this.lblTrgovackiNaziv, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblTrgovackiNaziv.setName("lblTrgovackiNaziv");
            this.tfTrgovackiNaziv = new PzTextField();
            this.pnlPodaci.add((Component)this.tfTrgovackiNaziv, (Object)new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblModelVozila = new JLabel();
            this.pnlPodaci.add((Component)this.lblModelVozila, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblModelVozila.setName("lblModelVozila");
            this.tfModelVozila = new PzTextField();
            this.pnlPodaci.add((Component)this.tfModelVozila, (Object)new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblFabrickiBroj = new JLabel();
            this.pnlPodaci.add((Component)this.lblFabrickiBroj, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblFabrickiBroj.setName("lblFabrickiBroj");
            this.tfFabrickiBroj = new PzTextField();
            this.pnlPodaci.add((Component)this.tfFabrickiBroj, (Object)new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblStandard = new JLabel();
            this.pnlPodaci.add((Component)this.lblStandard, (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblStandard.setName("lblStandard");
            this.tfStandard = new PzTextField();
            this.pnlPodaci.add((Component)this.tfStandard, (Object)new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblKaroserija = new JLabel();
            this.pnlPodaci.add((Component)this.lblKaroserija, (Object)new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblKaroserija.setName("lblKaroserija");
            this.tfKaroserija = new PzTextField();
            this.pnlPodaci.add((Component)this.tfKaroserija, (Object)new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblBrojSedista = new JLabel();
            this.pnlPodaci.add((Component)this.lblBrojSedista, (Object)new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblBrojSedista.setName("lblBrojSedista");
            this.tfBrojSedista = new PzTextField();
            this.pnlPodaci.add((Component)this.tfBrojSedista, (Object)new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblBrojVrata = new JLabel();
            this.pnlPodaci.add((Component)this.lblBrojVrata, (Object)new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblBrojVrata.setName("lblBrojVrata");
            this.tfBrojVrata = new PzTextField();
            this.pnlPodaci.add((Component)this.tfBrojVrata, (Object)new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblBojaKaroserije = new JLabel();
            this.pnlPodaci.add((Component)this.lblBojaKaroserije, (Object)new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblBojaKaroserije.setName("lblBojaKaroserije");
            this.tfBojaKaroserije = new PzTextField();
            this.pnlPodaci.add((Component)this.tfBojaKaroserije, (Object)new GridBagConstraints(1, 10, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblBrojSasije = new JLabel();
            this.pnlPodaci.add((Component)this.lblBrojSasije, (Object)new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblBrojSasije.setName("lblBrojSasije");
            this.tfBrojSasije = new PzTextField();
            this.pnlPodaci.add((Component)this.tfBrojSasije, (Object)new GridBagConstraints(1, 11, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblGodinaProizvodnje = new JLabel();
            this.pnlPodaci.add((Component)this.lblGodinaProizvodnje, (Object)new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblGodinaProizvodnje.setName("lblGodinaProizvodnje");
            this.tfGodProizvodnje = new PzTextField();
            this.pnlPodaci.add((Component)this.tfGodProizvodnje, (Object)new GridBagConstraints(1, 12, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblProiyvodjac = new JLabel();
            this.pnlPodaci.add((Component)this.lblProiyvodjac, (Object)new GridBagConstraints(0, 13, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblProiyvodjac.setName("lblProiyvodjac");
            this.tfProizvodjac = new PzTextField();
            this.pnlPodaci.add((Component)this.tfProizvodjac, (Object)new GridBagConstraints(1, 13, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblDrzavaProizvodnje = new JLabel();
            this.pnlPodaci.add((Component)this.lblDrzavaProizvodnje, (Object)new GridBagConstraints(0, 14, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblDrzavaProizvodnje.setName("lblDrzavaProizvodnje");
            this.tfDrzavaProizvodnje = new PzTextField();
            this.pnlPodaci.add((Component)this.tfDrzavaProizvodnje, (Object)new GridBagConstraints(1, 14, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblServisnaKnjizica = new JLabel();
            this.pnlPodaci.add((Component)this.lblServisnaKnjizica, (Object)new GridBagConstraints(0, 15, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblServisnaKnjizica.setName("lblServisnaKnjizica");
            this.tfServisnaKnjizica = new PzTextField();
            this.pnlPodaci.add((Component)this.tfServisnaKnjizica, (Object)new GridBagConstraints(1, 15, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblVrstaVozila = new JLabel();
            this.pnlPodaci.add((Component)this.lblVrstaVozila, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblVrstaVozila.setName("lblVrstaVozila");
            this.tfVrstaVozila = new PzTextField();
            this.pnlPodaci.add((Component)this.tfVrstaVozila, (Object)new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.pnlDimenzije = new PzPanel();
            GridBagLayout pnlDimenzijeLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlDimenzije, (Object)new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlDimenzije.setBorder((Border)BorderFactory.createTitledBorder("Dimenzije"));
            pnlDimenzijeLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
            pnlDimenzijeLayout.rowHeights = new int[]{7, 7, 7, 7, 20};
            pnlDimenzijeLayout.columnWeights = new double[]{0.0, 0.1, 0.1};
            pnlDimenzijeLayout.columnWidths = new int[]{126, 7, 7};
            this.pnlDimenzije.setLayout((LayoutManager)pnlDimenzijeLayout);
            this.lblDuzina = new JLabel();
            this.pnlDimenzije.add((Component)this.lblDuzina, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblDuzina.setName("lblDuzina");
            this.tfDuzina = new PzTextField();
            this.pnlDimenzije.add((Component)this.tfDuzina, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblSirina = new JLabel();
            this.pnlDimenzije.add((Component)this.lblSirina, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblSirina.setName("lblSirina");
            this.tfSirina = new PzTextField();
            this.pnlDimenzije.add((Component)this.tfSirina, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblVisina = new JLabel();
            this.pnlDimenzije.add((Component)this.lblVisina, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblVisina.setName("lblVisina");
            this.tfVisina = new PzTextField();
            this.pnlDimenzije.add((Component)this.tfVisina, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblTezina = new JLabel();
            this.pnlDimenzije.add((Component)this.lblTezina, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblTezina.setName("lblTezina");
            this.tfTezina = new PzTextField();
            this.pnlDimenzije.add((Component)this.tfTezina, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblNosivost = new JLabel();
            this.pnlDimenzije.add((Component)this.lblNosivost, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblNosivost.setName("lblNosivost");
            this.tfNosivost = new PzTextField();
            this.pnlDimenzije.add((Component)this.tfNosivost, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.pnlMotor = new PzPanel();
            GridBagLayout pnlMotorLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlMotor, (Object)new GridBagConstraints(2, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlMotor.setBorder((Border)BorderFactory.createTitledBorder("Podaci o motoru"));
            pnlMotorLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            pnlMotorLayout.rowHeights = new int[]{7, 7, 7, 7};
            pnlMotorLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            pnlMotorLayout.columnWidths = new int[]{128, 165, 7};
            this.pnlMotor.setLayout((LayoutManager)pnlMotorLayout);
            this.lblBrojMotora = new JLabel();
            this.pnlMotor.add((Component)this.lblBrojMotora, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblBrojMotora.setName("lblBrojMotora");
            this.tfBrojMotora = new PzTextField();
            this.pnlMotor.add((Component)this.tfBrojMotora, (Object)new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblVrstaMotora = new JLabel();
            this.pnlMotor.add((Component)this.lblVrstaMotora, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblVrstaMotora.setName("lblVrstaMotora");
            this.tfVrstaMotora = new PzTextField();
            this.pnlMotor.add((Component)this.tfVrstaMotora, (Object)new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblZapremina = new JLabel();
            this.pnlMotor.add((Component)this.lblZapremina, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblZapremina.setName("lblZapremina");
            this.tfZapremina = new PzTextField();
            this.pnlMotor.add((Component)this.tfZapremina, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblSnaga = new JLabel();
            this.pnlMotor.add((Component)this.lblSnaga, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblSnaga.setName("lblSnaga");
            this.tfSnaga = new PzTextField();
            this.pnlMotor.add((Component)this.tfSnaga, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.pnlOpis = new PzPanel();
            BorderLayout pnlOpisLayout = new BorderLayout();
            this.pnlOpis.setLayout((LayoutManager)pnlOpisLayout);
            this.mainPanel.add((Component)this.pnlOpis, (Object)new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            this.pnlOpis.setBorder((Border)BorderFactory.createTitledBorder("Opis"));
            this.areaOpis = new PzTextAreaPanel();
            this.pnlOpis.add((Component)this.areaOpis, (Object)"Center");
            this.areaOpis.setPreferredSize(new Dimension(10, 53));
            this.tfSifra.setStateIndikator(this.indSifra);
            this.pack();
            this.setSize(931, 693);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                int rez;
                if (actionCommand.equals("Brisanje") && (rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Da li ste sigurni?!", (String)"Brisanje", null, (boolean)false)) == 0) {
                    em.getTransaction().begin();
                    Artikalfaktura artf = (Artikalfaktura)this.faktura.getArtikalfakturas().get(0);
                    this.faktura.setArhiviran((short)-1);
                    this.faktura.getDokument().setArhiviran((short)-1);
                    Stanje stanje = (Stanje)em.find(Stanje.class, (Object)new StanjePK(artf.getId().getSfrProizvod(), this.rj));
                    stanje.setAlocKolicina(stanje.getAlocKolicina() - 1.0);
                    this.dispose();
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().commit();
                    }
                }
                if (actionCommand.equals("Arhiviranje")) {
                    this.save();
                    this.getSession().putParameter("faktura", (Object)this.faktura);
                    this.showDialog(ArhivaStampa.class);
                    if (this.getSession().getParameter("arhiviran") != null && ((Boolean)this.getSession().getParameter("arhiviran")).booleanValue()) {
                        this.arhiviran = true;
                        this.dispose();
                    }
                }
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    public boolean shouldBeShown() {
        this.rj = PzDialogRJ.getRJ((PzDialog)this, (Character[])new Character[]{Character.valueOf('E'), Character.valueOf('V')});
        if (this.rj == null) {
            return false;
        }
        this.faktura = this.getFaktura();
        if (this.update) {
            this.updateForm();
        }
        this.setTitle("Faktura automobila iz " + this.rj.getPunNaziv());
        return true;
    }

    private void snimiDokument() {
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                em.getTransaction().begin();
                PzDokumentManager.getInstance().snimiDokument((PzDokument)this.faktura, true, null);
                Artikalfaktura artFak = new Artikalfaktura();
                Stanje stanje = (Stanje)em.find(Stanje.class, (Object)new StanjePK(this.art.getSfrProizvod(), this.rj));
                artFak.init(this.art, (PzDokument)this.faktura);
                if (this.rj.getgTip().equals("E")) {
                    artFak.setProdCena(this.dfIznosSaPdv.getBigDecimal());
                    artFak.setCena(this.dfIznosSaPdv.getVal().doubleValue());
                } else {
                    artFak.setProdCena(this.tfCenaBezPdv.getBigDecimal());
                    artFak.setCena(this.tfCenaBezPdv.getVal().doubleValue());
                    artFak.setProcRabata(this.tfPopust.getVal().doubleValue());
                }
                artFak.setProsNabCena(stanje.getProsNabCena() == null ? new BigDecimal(0.0) : stanje.getProsNabCena());
                artFak.setKolicina(1.0);
                em.persist((Object)artFak);
                this.faktura.getArtikalfakturas().add(artFak);
                stanje.setAlocKolicina(stanje.getAlocKolicina() + 1.0);
                em.merge((Object)stanje);
                em.getTransaction().commit();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private Faktura getFaktura() {
        Faktura fak = null;
        EntityManager em = PzEntityManager.getEm();
        List f = em.createQuery("Select f From Faktura f Where f.arhiviran = 0 and f.podTip='FAKTURA_AUTOMOBILA' and f.radnajedinica.id.oznRj='" + this.rj.getId().getOznRj() + "'").getResultList();
        if (f.size() != 0) {
            fak = (Faktura)f.get(0);
            this.update = true;
        } else {
            fak = new Faktura();
            fak.setTip(TipDokumentConfig.get().FAKTURA);
            fak.setPodTip(TipDokumentConfig.get().PODTIP_FAKTURA_AUTOMOBILA);
            fak.setRadnajedinica(this.rj);
            fak.setArhiviran((short)0);
            fak.setStorno(0);
            fak.setArtikalfakturas(new ArrayList());
            fak.setDatum(PzDateUtility.getCurrentDate());
            fak.setUserKraj(PzExtensionLoader.getLoggedUser());
            fak.setUserPoc(PzExtensionLoader.getLoggedUser());
            this.update = false;
        }
        return fak;
    }

    private void updateForm() {
        this.tfSifra.setVal((Object)((Artikalfaktura)this.faktura.getArtikalfakturas().get(0)).getArtikal().getSfrProizvod());
        this.tfSifra.setEnabled(false);
        this.tfSifra.setFocusable(false);
        this.tfCenaBezPdv.setVal((Object)((Artikalfaktura)this.faktura.getArtikalfakturas().get(0)).getProdCena().doubleValue());
        this.tfPopust.setVal((Object)((Artikalfaktura)this.faktura.getArtikalfakturas().get(0)).getProcRabata());
        this.dfIznosBezPdv.setVal((Object)this.faktura.getIznosBezPoreza());
        this.dfIznosSaPdv.setVal((Object)this.faktura.getIznos());
        this.art = ((Artikalfaktura)this.faktura.getArtikalfakturas().get(0)).getArtikal();
        if (this.faktura.getFakturaparameters() != null && this.faktura.getFakturaparameters().size() != 0) {
            this.tfMarkaVozila.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "MARKA_VOZILA").getValue());
            this.tfTipVozila.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "TIP_VOZILA").getValue());
            this.tfTrgovackiNaziv.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "TRGOVACKI_NAZIV").getValue());
            this.tfModelVozila.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "MODEL_VOZILA").getValue());
            this.tfVrstaVozila.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "VRSTA_VOZILA").getValue());
            this.tfFabrickiBroj.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "FABRICKI_BROJ").getValue());
            this.tfStandard.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "STANDARD").getValue());
            this.tfKaroserija.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "OBLIK_KAROSERIJE").getValue());
            this.tfBrojSedista.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "BROJ_SEDISTA").getValue());
            this.tfBrojVrata.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "BROJ_VRATA").getValue());
            this.tfBojaKaroserije.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "BOJA_KAROSERIJE").getValue());
            this.tfBrojSasije.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "BROJ_SASIJE").getValue());
            this.tfGodProizvodnje.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "GODINA_PROIZVODNJE").getValue());
            this.tfProizvodjac.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "PROIZVODJAC").getValue());
            this.tfDrzavaProizvodnje.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "DRZAVA_PROIZVODNJE").getValue());
            this.tfServisnaKnjizica.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "SERVISNA_KNJIZICA").getValue());
            this.tfDuzina.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "DUZINA_VOZILA").getValue());
            this.tfSirina.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "SIRINA_VOZILA").getValue());
            this.tfVisina.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "VISINA_VOZILA").getValue());
            this.tfTezina.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "TEZINA_VOZILA").getValue());
            this.tfNosivost.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "NOSIVOST").getValue());
            this.tfBrojMotora.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "BROJ_MOTORA").getValue());
            this.tfVrstaMotora.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "VRSTA_MOTORA").getValue());
            this.tfZapremina.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "ZAPREMINA_MOTORA").getValue());
            this.tfSnaga.setVal((Object)this.faktura.getFakturaparameter(this.faktura.getIdDok(), "SNAGA_MOTORA").getValue());
            this.areaOpis.setVal((Object)this.faktura.getPotvrda());
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        try {
            if (entity == null) {
                return;
            }
            this.art = (Artikal)entity;
            this.tfSifra.setVal((Object)this.art.getSfrProizvod());
            this.tfNaziv.setVal((Object)this.art.getNaziv());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void save() {
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                em.getTransaction().begin();
                Fakturaparameter fp = new Fakturaparameter(this.faktura.getIdDok(), "MARKA_VOZILA", this.tfMarkaVozila.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "TIP_VOZILA", this.tfTipVozila.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "TRGOVACKI_NAZIV", this.tfTrgovackiNaziv.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "MODEL_VOZILA", this.tfModelVozila.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "VRSTA_VOZILA", this.tfVrstaVozila.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "FABRICKI_BROJ", this.tfFabrickiBroj.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "STANDARD", this.tfStandard.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "OBLIK_KAROSERIJE", this.tfKaroserija.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "BROJ_SEDISTA", this.tfBrojSedista.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "BROJ_VRATA", this.tfBrojVrata.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "BOJA_KAROSERIJE", this.tfBojaKaroserije.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "BROJ_SASIJE", this.tfBrojSasije.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "GODINA_PROIZVODNJE", this.tfGodProizvodnje.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "PROIZVODJAC", this.tfProizvodjac.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "DRZAVA_PROIZVODNJE", this.tfDrzavaProizvodnje.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "SERVISNA_KNJIZICA", this.tfServisnaKnjizica.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "DUZINA_VOZILA", this.tfDuzina.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "SIRINA_VOZILA", this.tfSirina.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "VISINA_VOZILA", this.tfVisina.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "TEZINA_VOZILA", this.tfTezina.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "NOSIVOST", this.tfNosivost.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "BROJ_MOTORA", this.tfBrojMotora.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "VRSTA_MOTORA", this.tfVrstaMotora.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "ZAPREMINA_MOTORA", this.tfZapremina.getVal(), "");
                this.faktura.addFakturaparameter(fp);
                fp = new Fakturaparameter(this.faktura.getIdDok(), "SNAGA_MOTORA", this.tfSnaga.getVal().toString(), "");
                this.faktura.addFakturaparameter(fp);
                this.faktura.setPotvrda(this.areaOpis.getArea().getText());
                em.merge((Object)this.faktura);
                em.getTransaction().commit();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
        if (this.art != null && !this.arhiviran) {
            this.save();
        }
    }
}

