/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jdesktop.application.Application;
import rs.pezar.core.PzApplication;
import rs.pezar.core.PzGenericService;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fizickolice;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.management.PzPorukeManager;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.prodaja.gui.PzDialogFaktureArhiva;
import rs.pezar.prodaja.gui.storniranje.IzborStampe;
import rs.pezar.prodaja.gui.storniranje.Kolicina;
import rs.pezar.prodaja.util.PzProdajaUtil;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzButtonPanel;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.event.PzTableCheckboxListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzTextAreaPanel;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogStornoFakture
extends PzDialog {
    private static final long serialVersionUID = -7745443644331406254L;
    private PzTextAreaPanel razlog;
    private JLabel jLabel6;
    private PzPanel panelRazlog;
    private PzToolBarIcon icnArhiva;
    private PzPanel pnlGlavni;
    private JToolBar toolbar;
    private PzButton icnInverznaSelekcija;
    private PzButton icnDeselektujSve;
    private PzButton icnSelektujSve;
    private PzButton icnSelektuj;
    private JPanel pnlSelect;
    private Faktura f;
    private PzPanel pzPanel1;
    private JLabel jLabel3;
    private PzDoubleField dfSaPorezom;
    private JLabel jLabel13;
    private PzDoubleField dfBezPoreza;
    private PzButton btnOK;
    private JRadioButton rbBezNivelacije;
    private JRadioButton rbSaNivelacijom;
    private PzButtonPanel panelNivelacija;
    private PzDateField datIzrade;
    private JLabel jLabel1;
    private PzToolBarIcon icnIzmena;
    private PzTable table;
    private JScrollPane scpArtikli;
    private ButtonGroup buttonGroupNiv;
    private HashMap<String, Double> mapaKolicina = null;
    private String tableID = "";

    public PzDialogStornoFakture(PzDialog parent) {
        super(parent);
        try {
            this.f = (Faktura)this.getSession().getParameter("stornoFaktura");
            this.mapaKolicina = this.setMapaKolicina(this.f);
            if (this.f.getTip().equals("FAKTURA")) {
                if (this.f.izMaloprodaje()) {
                    this.tableID = "TABLE_FAKTURA_MALPRODAJA";
                    this.setId("FAKTURA_MALOPRODAJA");
                } else {
                    this.tableID = "TABLE_FAKTURA_VELIKOPRODAJA";
                    this.setId("FAKTURA_VELIKOPRODAJA");
                }
            } else if (this.f.getTip().equals("OTPREMNICA")) {
                this.tableID = "TABLE_OTPREMNICA";
                this.setId("OTPREMNICA");
            } else if (this.f.getTip().equals("FAKTURA_INTERNI_RACUN")) {
                this.tableID = "TABLE_INTERNI_RACUN";
                this.setId("INTERNI_RACUN");
            }
            this.initGUI();
            if (this.f.getTip().equals("FAKTURA")) {
                this.setTitle("Storno fakture");
            } else if (this.f.getTip().equals("FAKTURA_INTERNI_RACUN")) {
                this.setTitle("Storno internog ra\u010duna (kupi za sebe)");
            } else if (this.f.getTip().equals("OTPREMNICA")) {
                this.setTitle("Storno otpremnice");
                this.rbBezNivelacije.setEnabled(false);
                this.rbSaNivelacijom.setEnabled(false);
            }
            this.setVrednostPorez(this.f.getArtikalfakturas());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            e.printStackTrace();
        }
        this.paintPanel();
    }

    private HashMap<String, Double> setMapaKolicina(Faktura f) {
        HashMap<String, Double> rez = new HashMap<String, Double>();
        for (Artikalfaktura a : f.getArtikalfakturas()) {
            rez.put(String.valueOf(a.getId().getSfrProizvod()) + "/" + a.getId().getrBroj(), a.getKolicina());
        }
        return rez;
    }

    public double getKolicinaFor(Artikalfaktura af) {
        return this.mapaKolicina.get(String.valueOf(af.getId().getSfrProizvod()) + "/" + af.getId().getrBroj());
    }

    public void setVrednostPorez(List<Artikalfaktura> artikli) {
        this.dfSaPorezom.setVal((Object)this.f.getIznosSaPorezomVeleprodaja(artikli));
        this.dfBezPoreza.setVal((Object)this.f.getIznosBezPorezaVeleprodaja(artikli));
    }

    public List<Artikalfaktura> prebaciUListuArtikalFaktura(List<PzEntity> lista) {
        Vector<Artikalfaktura> rez = null;
        if (lista != null) {
            rez = new Vector<Artikalfaktura>();
            for (PzEntity entitet : lista) {
                rez.add((Artikalfaktura)entitet);
            }
        }
        return rez;
    }

    private void paintPanel() {
        this.pnlGlavni.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.pnlGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.pnlGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            this.pnlGlavni = new PzPanel();
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            this.pnlGlavni.setPreferredSize(new Dimension(943, 367));
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{115, 142, 159, 7};
            this.pnlGlavni.setOpaque(false);
            this.scpArtikli = new JScrollPane();
            this.pnlGlavni.add((Component)this.scpArtikli, (Object)new GridBagConstraints(0, 1, 4, 2, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            this.table = new PzTable(this.f.getArtikalfakturas(), Artikalfaktura.class);
            this.table.setCheckboxColumn(0, KeyStroke.getKeyStroke(113, 0), KeyStroke.getKeyStroke(113, 512), KeyStroke.getKeyStroke(113, 128), KeyStroke.getKeyStroke(113, 640));
            this.table.checkAll();
            this.table.addCheckboxListener(new PzTableCheckboxListener(){

                public void valueChanged(int rowIndex, PzEntity entity, boolean newValue) {
                    PzDialogStornoFakture.this.setVrednostPorez(PzDialogStornoFakture.this.prebaciUListuArtikalFaktura(PzDialogStornoFakture.this.table.getCheckedEntities()));
                }
            });
            this.table.setId(this.tableID);
            this.scpArtikli.setViewportView((Component)this.table);
            this.table.getTableHeader().setFocusable(false);
            this.table.requestFocusInWindow();
            this.table.setRowSelectionInterval(0, 0);
            if (this.f.getTip().equals("FAKTURA") && !this.f.getRadnajedinica().getgTip().equals("E")) {
                this.table.setEnabled(false);
            }
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setOpaque(false);
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("A\u017euriranje|koli\u010dine|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/product_edit_small.png")));
            this.icnIzmena.setActionCommand("Kolicina");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("F3");
            this.icnArhiva = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnArhiva);
            this.icnArhiva.setText("Arhiva|i \u0161tampa|(CTRL+W)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/printer_preferences.png")));
            this.icnArhiva.setActionCommand("arhiva");
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setShortcut("ctrl+w");
            this.pnlSelect = new JPanel();
            FlowLayout pnlSelectLayout = new FlowLayout();
            pnlSelectLayout.setAlignment(0);
            pnlSelectLayout.setVgap(2);
            this.pnlSelect.setLayout(pnlSelectLayout);
            this.toolbar.add(this.pnlSelect);
            this.pnlSelect.setPreferredSize(new Dimension(221, 113));
            this.pnlSelect.setOpaque(false);
            this.icnSelektuj = new PzButton();
            this.pnlSelect.add((Component)this.icnSelektuj);
            this.icnSelektuj.setText("Selektuj trenutni (f2)");
            this.icnSelektuj.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnSelektuj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/selektuj.png")));
            this.icnSelektuj.setPreferredSize(new Dimension(207, 24));
            this.icnSelektuj.setHorizontalAlignment(10);
            this.icnSelektuj.setFocusable(false);
            this.icnSelektuj.setOpaque(false);
            this.icnSelektuj.addActionListener((ActionListener)((Object)this));
            this.icnSelektujSve = new PzButton();
            this.pnlSelect.add((Component)this.icnSelektujSve);
            this.icnSelektujSve.setText("Selektuj sve (alt+f2)");
            this.icnSelektujSve.setOpaque(false);
            this.icnSelektujSve.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnSelektujSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/selection_sve.png")));
            this.icnSelektujSve.setPreferredSize(new Dimension(207, 24));
            this.icnSelektujSve.setHorizontalAlignment(10);
            this.icnSelektujSve.setFocusable(false);
            this.icnSelektujSve.addActionListener((ActionListener)((Object)this));
            this.icnDeselektujSve = new PzButton();
            this.pnlSelect.add((Component)this.icnDeselektujSve);
            this.icnDeselektujSve.setText("Deselektuj sve (ctrl+f2)");
            this.icnDeselektujSve.setOpaque(false);
            this.icnDeselektujSve.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnDeselektujSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/deselektuj_sve.png")));
            this.icnDeselektujSve.setPreferredSize(new Dimension(207, 24));
            this.icnDeselektujSve.setHorizontalAlignment(10);
            this.icnDeselektujSve.setFocusable(false);
            this.icnDeselektujSve.addActionListener((ActionListener)((Object)this));
            this.icnInverznaSelekcija = new PzButton();
            this.pnlSelect.add((Component)this.icnInverznaSelekcija);
            this.icnInverznaSelekcija.setText("Inverzna selekcija (ctrl+alt+f2)");
            this.icnInverznaSelekcija.setOpaque(false);
            this.icnInverznaSelekcija.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnInverznaSelekcija.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/selektuj inverzno.png")));
            this.icnInverznaSelekcija.setPreferredSize(new Dimension(208, 24));
            this.icnInverznaSelekcija.setHorizontalAlignment(10);
            this.icnInverznaSelekcija.setFocusable(false);
            this.icnInverznaSelekcija.addActionListener((ActionListener)((Object)this));
            this.pnlSelect.setVisible(false);
            this.panelRazlog = new PzPanel();
            this.pnlGlavni.add((Component)this.panelRazlog, (Object)new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout panelRazlogLayout = new GridBagLayout();
            panelRazlogLayout.rowWeights = new double[]{0.0, 0.1, 0.1};
            panelRazlogLayout.rowHeights = new int[]{28, 7, 20};
            panelRazlogLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            panelRazlogLayout.columnWidths = new int[]{300, 85, 110, 20};
            this.panelRazlog.setLayout((LayoutManager)panelRazlogLayout);
            this.panelRazlog.setPreferredSize(new Dimension(1295, 163));
            this.panelRazlog.setOpaque(false);
            this.jLabel6 = new JLabel();
            this.panelRazlog.add((Component)this.jLabel6, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.jLabel6.setText("Razlog storniranja:");
            this.razlog = new PzTextAreaPanel();
            this.panelRazlog.add((Component)this.razlog, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 8, 10), 0, 0));
            this.razlog.setPreferredSize(new Dimension(762, 96));
            this.razlog.setTransferFocusOnEnter(true);
            this.jLabel1 = new JLabel();
            this.panelRazlog.add((Component)this.jLabel1, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.jLabel1.setText("Datum izrade:");
            this.jLabel1.setHorizontalAlignment(4);
            this.datIzrade = new PzDateField();
            this.panelRazlog.add((Component)this.datIzrade, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
            this.datIzrade.setFont(new Font("Tahoma", 0, 14));
            this.panelNivelacija = new PzButtonPanel();
            GridBagLayout panelNivelacijaLayout1 = new GridBagLayout();
            this.panelRazlog.add((Component)this.panelNivelacija, (Object)new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
            GridBagLayout panelNivelacijaLayout = new GridBagLayout();
            panelNivelacijaLayout.columnWidths = new int[]{7, 7, 7, 7};
            panelNivelacijaLayout.rowHeights = new int[]{7, 7, 7};
            panelNivelacijaLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            panelNivelacijaLayout.rowWeights = new double[]{0.1, 0.1, 0.1};
            this.panelNivelacija.setBorder((Border)BorderFactory.createTitledBorder("Nivelacija"));
            panelNivelacijaLayout1.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            panelNivelacijaLayout1.rowHeights = new int[]{7, 7, 7, 7};
            panelNivelacijaLayout1.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            panelNivelacijaLayout1.columnWidths = new int[]{7, 7, 7, 7};
            this.panelNivelacija.setLayout((LayoutManager)panelNivelacijaLayout1);
            this.panelNivelacija.setOpaque(false);
            this.rbSaNivelacijom = new JRadioButton();
            this.panelNivelacija.add((Component)this.rbSaNivelacijom, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.rbSaNivelacijom.setText("Sa nivelacijom");
            this.rbSaNivelacijom.setActionCommand("SaNivelacijom");
            this.rbSaNivelacijom.addActionListener((ActionListener)((Object)this));
            this.rbSaNivelacijom.setOpaque(false);
            this.rbBezNivelacije = new JRadioButton();
            this.panelNivelacija.add((Component)this.rbBezNivelacije, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.rbBezNivelacije.setText("Bez nivelacije");
            this.rbBezNivelacije.setActionCommand("BezNivelacije");
            this.rbBezNivelacije.addActionListener((ActionListener)((Object)this));
            this.rbBezNivelacije.setOpaque(false);
            this.buttonGroupNiv = new ButtonGroup();
            this.buttonGroupNiv.add(this.rbSaNivelacijom);
            this.buttonGroupNiv.add(this.rbBezNivelacije);
            this.rbSaNivelacijom.setSelected(true);
            this.btnOK = new PzButton();
            this.btnOK.setEnabled(false);
            this.panelRazlog.add((Component)this.btnOK, (Object)new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 4, 0), 0, 0));
            this.btnOK.setText("Dalje");
            this.btnOK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
            this.btnOK.setPreferredSize(new Dimension(100, 30));
            this.btnOK.setActionCommand("dalje");
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.btnOK.setShortcut("ctrl+w");
            this.pzPanel1 = new PzPanel();
            this.panelRazlog.add((Component)this.pzPanel1, (Object)new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 11, 1, new Insets(0, 10, 5, 0), 0, 0));
            GridBagLayout pzPanel1Layout = new GridBagLayout();
            pzPanel1Layout.columnWidths = new int[]{160, 7};
            pzPanel1Layout.rowHeights = new int[]{7, 7};
            pzPanel1Layout.columnWeights = new double[]{0.0, 0.1};
            pzPanel1Layout.rowWeights = new double[]{0.1, 0.1};
            this.pzPanel1.setBorder((Border)BorderFactory.createTitledBorder("Storno"));
            this.pzPanel1.setLayout((LayoutManager)pzPanel1Layout);
            this.pzPanel1.setOpaque(false);
            this.jLabel13 = new JLabel();
            this.pzPanel1.add((Component)this.jLabel13, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel13.setText("Iznos bez poreza:");
            this.jLabel13.setFont(new Font("Tahoma", 1, 16));
            this.dfBezPoreza = new PzDoubleField();
            this.pzPanel1.add((Component)this.dfBezPoreza, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.dfBezPoreza.setFont(new Font("Tahoma", 1, 14));
            this.dfBezPoreza.setEditable(false);
            this.dfBezPoreza.setForeground(new Color(0, 0, 255));
            this.dfBezPoreza.setPreferredSize(new Dimension(150, 25));
            this.dfBezPoreza.setSize(150, 25);
            this.dfBezPoreza.setFocusable(false);
            this.jLabel3 = new JLabel();
            this.pzPanel1.add((Component)this.jLabel3, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel3.setText("Iznos sa porezom:");
            this.jLabel3.setFont(new Font("Tahoma", 1, 16));
            this.dfSaPorezom = new PzDoubleField();
            this.pzPanel1.add((Component)this.dfSaPorezom, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.dfSaPorezom.setFont(new Font("Tahoma", 1, 14));
            this.dfSaPorezom.setEditable(false);
            this.dfSaPorezom.setForeground(new Color(0, 0, 255));
            this.dfSaPorezom.setPreferredSize(new Dimension(150, 25));
            this.dfSaPorezom.setSize(150, 25);
            this.dfSaPorezom.setFocusable(false);
            this.setLocationRelativeTo(null);
            this.pack();
            this.setSize(1300, 645);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.icnSelektujSve) {
            this.table.checkAll();
        } else if (arg0.getSource() == this.icnDeselektujSve) {
            this.table.unCheckAll();
        } else if (arg0.getSource() == this.icnInverznaSelekcija) {
            this.table.inverseCheck();
        } else if (arg0.getSource() == this.icnSelektuj) {
            this.table.switchIt();
        } else {
            String actionCommand = ((AbstractButton)arg0.getSource()).getActionCommand();
            if (actionCommand.equalsIgnoreCase("kolicina")) {
                this.getSession().putParameter("tabela", (Object)this.table);
                this.getSession().putParameter("artikal", (Object)this.table.getSelectedEntity());
                this.showDialog(Kolicina.class);
            } else if (actionCommand.equals("arhiva")) {
                this.btnOK.setEnabled(true);
                this.icnArhiva.setActionCommand("dalje");
                this.razlog.getArea().requestFocusInWindow();
            } else if (actionCommand.equals("dalje")) {
                if (this.table.getCheckedEntities().size() == 0) {
                    JOptionPane.showMessageDialog(this.getParent(), "Mora biti selektovan barem jedan artikal!", "Informacija", 1);
                    return;
                }
                if (this.razlog.getVal().trim().length() == 0) {
                    JOptionPane.showMessageDialog(this.getParent(), "Morate uneti razlog storniranja!", "Informacija", 1);
                    this.razlog.requestFocusInWindow();
                    return;
                }
                this.getSession().putParameter("saPotvrdom", null);
                this.showDialog(IzborStampe.class);
                Boolean saPotvrdom = (Boolean)this.getSession().getParameter("saPotvrdom");
                if (saPotvrdom != null) {
                    if (saPotvrdom.booleanValue()) {
                        this.arhiviraj(true);
                    } else {
                        this.arhiviraj(false);
                    }
                } else {
                    this.btnOK.setEnabled(false);
                    this.table.requestFocusInWindow();
                    this.table.setRowSelectionInterval(0, 0);
                    this.icnArhiva.setActionCommand("arhiva");
                }
            }
        }
    }

    private void arhivirajNivelaciju(Nivelacija nivel, EntityManager em) throws Exception {
        if (nivel == null || nivel.getArtikalnivelacijas() == null || nivel.getArtikalnivelacijas().size() == 0) {
            PzSwingUtility.showInformationMessage((Component)SwingUtilities.getRoot((Component)((Object)this)), (String)"Nivelacija ne mo\u017ee da se napravi jer cena nije promenjena!");
            nivel = null;
        } else {
            PzDokumentManager.getInstance().arhivirajDokument((PzDokument)nivel, true, null, em);
        }
    }

    private void arhiviraj(Boolean saPotvrdom) {
        block18: {
            EntityManager em = PzEntityManager.getEm();
            try {
                try {
                    em.getTransaction().begin();
                    this.f.removeFakturaparameter(this.f.getIdDok(), "LPFR_BROJ");
                    this.f.setArtikalfakturas(this.prebaciUListuArtikalFaktura(this.table.getCheckedEntities()));
                    this.f.setDatum(this.datIzrade.getVal());
                    this.f.setDatPrometa(this.datIzrade.getVal());
                    this.f.setPoruka(this.razlog.getVal());
                    this.f.setStorno(1);
                    if (saPotvrdom.booleanValue()) {
                        this.f.setPotvrda(PzPorukeManager.getStandardnaPoruka((PzDokument)this.f));
                    } else {
                        this.f.setPotvrda("");
                    }
                    Nivelacija nivelacija = null;
                    if (this.rbSaNivelacijom.isSelected() && !this.f.getTip().equals("OTPREMNICA")) {
                        nivelacija = PzEntityUtil.createNivelacija((PzDokument)this.f, (boolean)false, (boolean)false, (EntityManager)em);
                        this.arhivirajNivelaciju(nivelacija, em);
                    }
                    if (PzProdajaUtil.updateStanjeStorniranje(this.f)) {
                        if (!this.f.getTip().equals("OTPREMNICA")) {
                            PzDokumentManager.getInstance().arhivirajStorno((PzDokument)this.f, PzEntityManager.KOLICINE_UVECANJE, PzEntityManager.KOLICINA_UKUPNA, true, null, em);
                        } else {
                            PzDokumentManager.getInstance().arhivirajStorno((PzDokument)this.f, PzEntityManager.KOLICINE_UVECANJE, PzEntityManager.KOLICINA_ALOCIRANA, true, null, em);
                        }
                    }
                    Fizickolice fizLice = null;
                    if (this.f.getFizickolice() != null) {
                        fizLice = this.f.getFizickolice();
                        this.f.setFizickolice(null);
                    }
                    if (fizLice != null) {
                        fizLice.setFaktura(this.f);
                        fizLice.setIdDok(Integer.valueOf(this.f.getIdDok()));
                        this.f.setFizickolice(fizLice);
                    }
                    this.stampajFiskalni(this.f, em);
                    if (this.f.getOriginal().getZaOtpremnice() == 1) {
                        List otpremnice = this.f.getOriginal().getFakturas();
                        for (Faktura o : otpremnice) {
                            if (o.getFakturaBean() == null) continue;
                            o.setFakturaBean(null);
                        }
                        for (Artikalfaktura af : this.f.getArtikalfakturas()) {
                            Stanje s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(af.getId().getSfrProizvod(), this.f.getRadnajedinica()));
                            s.setAlocKolicina(s.getAlocKolicina() + af.getKolicina());
                        }
                    }
                    em.getTransaction().commit();
                    this.f.setStorno(1);
                    PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.f);
                    if (nivelacija != null) {
                        PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)nivelacija);
                    }
                    ((PzDialogFaktureArhiva)((Object)this.getParent())).refreshData();
                }
                catch (Exception e) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                    PzSwingUtility.showErrorMessage((Component)this.scpArtikli, (String)"Gre\u0161ka prilikom storniranja fakture. Poku\u0161ajte ponovo.");
                    em.close();
                    break block18;
                }
            }
            catch (Throwable throwable) {
                em.close();
                throw throwable;
            }
            em.close();
        }
        this.dispose();
    }

    private void stampajFiskalni(Faktura f, EntityManager em) throws Exception {
        PzGenericService kasa;
        if ((f.getTip().equals(TipDokumentConfig.get().FAKTURA) || f.getTip().equals(TipDokumentConfig.get().FAKTURA_INTERNI_RACUN)) && f.getRadnajedinica() != null && f.izMaloprodaje() && (kasa = PzApplication.getApplication().getGenericServiceRegistry().getService("KASA_SERVICE")) != null && PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Da li \u017eelite da izdate fiskalni ra\u010dun - refundaciju uz fakturu?", (String)"Izdavanje fiskalnog ra\u010duna", null, (boolean)false) == 0) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("DOKUMENT", f);
            params.put("EntityManager", em);
            kasa.run(params);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogStornoFakture(Boolean.FALSE);
    }

    public PzDialogStornoFakture(Boolean initGUI) {
    }
}

