/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.prodaja.gui.PzDialogIzradaFaktureZaProdajuRobe;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.util.PzDateUtility;

public class PzDialogUnosInternogRacuna
extends PzDialogInsert {
    private PzDateField dfDatumIzrade;
    private JLabel lblDatumIzrade;
    private PzPanel pnlGlavni;
    private PzButton btnPotvrdi;
    private PzPanel pnlFields;
    private Radnajedinica rj;
    private PzPanelHeader header;
    private final boolean izmena = Boolean.parseBoolean(this.getSession().getParameter("update").toString());
    private Faktura f;
    private PzTable table;

    public PzDialogUnosInternogRacuna(PzDialog dialog) {
        super(dialog);
        this.paintPanel();
    }

    private void paintPanel() {
        this.pnlGlavni.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.pnlGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.pnlGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    protected void initGUI() {
        try {
            this.pnlGlavni = new PzPanel();
            BorderLayout pnlGlavniLayout = new BorderLayout();
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            this.header = new PzPanelHeader();
            this.pnlGlavni.add((Component)this.header, (Object)"North");
            this.header.setIcon(this.getHeaderIcon());
            this.header.setTitle(this.getHeaderTitle());
            this.header.setOpaque(false);
            this.pnlFields = new PzPanel();
            GridBagLayout plGlavniLayout = new GridBagLayout();
            this.pnlFields.setLayout((LayoutManager)plGlavniLayout);
            this.pnlGlavni.add((Component)this.pnlFields, (Object)"Center");
            plGlavniLayout.rowWeights = new double[]{0.0, 0.0};
            plGlavniLayout.rowHeights = new int[]{25, 40};
            plGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            plGlavniLayout.columnWidths = new int[]{20, 110, 110, 20};
            this.pnlFields.setOpaque(false);
            this.lblDatumIzrade = new JLabel();
            this.pnlFields.add((Component)this.lblDatumIzrade, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 1, 0), 0, 0));
            this.lblDatumIzrade.setText("Datum izrade");
            this.dfDatumIzrade = new PzDateField();
            this.pnlFields.add((Component)this.dfDatumIzrade, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.dfDatumIzrade.setFont(new Font("Tahoma", 0, 14));
            this.dfDatumIzrade.setDefaultDate(PzDateUtility.getCurrentDate());
            this.btnPotvrdi = new PzButton();
            this.pnlFields.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pack();
            this.setResizable(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.pnlFields.validateForm(true)) {
            return;
        }
        try {
            String actionCommand = ((PzButton)e.getSource()).getActionCommand();
            if (actionCommand.equals("insert")) {
                Faktura f = new Faktura();
                f.setTip("FAKTURA_INTERNI_RACUN");
                f.setRadnajedinica(this.rj);
                f.setDatum(this.dfDatumIzrade.getVal());
                this.table.insert((PzEntity)f, true);
            } else if (actionCommand.equals("update")) {
                this.f.setDatum(this.dfDatumIzrade.getVal());
                this.table.updateSelectedEntity((PzEntity)this.f, true);
                ((PzDialogIzradaFaktureZaProdajuRobe)((Object)this.getParent())).initializeTable(false);
            }
            this.dispose();
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    protected void onInsert() {
        this.table = (PzTable)this.getSession().getParameter("tabela");
        this.btnPotvrdi.setActionCommand("insert");
    }

    protected void onUpdate() {
        this.table = (PzTable)this.getSession().getParameter("tabela");
        this.btnPotvrdi.setActionCommand("update");
        this.f = (Faktura)this.table.getSelectedEntity();
        this.dfDatumIzrade.setVal((Object)this.f.getDatum());
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Unos novog dokumenta");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/document_new.png")));
    }

    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Izmena dokumenta");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/document_edit.png")));
    }

    public boolean shouldBeShown() {
        boolean result = true;
        if (this.izmena) {
            this.rj = this.f.getRadnajedinica();
            this.setTitle("Izmena dokumenta iz [ " + this.rj.getId().getOznRj() + " ] " + this.rj.getNaziv());
        } else {
            this.rj = PzDialogRJ.getRJ((PzDialog)this, (Character[])new Character[]{Character.valueOf("V".charAt(0)), Character.valueOf("E".charAt(0)), Character.valueOf("T".charAt(0))});
            if (this.rj != null) {
                this.setTitle("Otvaranje novog dokumenta u " + this.rj.getOgranak().getNaziv() + "-" + this.rj.getNaziv());
            } else {
                result = false;
            }
        }
        return result;
    }

    public void setEntity(PzEntity entity, Component component) {
    }
}

