/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.faktureServisa;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.border.Border;
import org.jdesktop.application.Application;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturaservisa;
import rs.pezar.db.management.PzPorukeManager;
import rs.pezar.prodaja.gui.PzDialogFaktureArhiva;
import rs.pezar.prodaja.util.PzProdajaUtil;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzTextAreaPanel;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class StornoFaktureServisa
extends PzDialog {
    private static final long serialVersionUID = -8829428819843026528L;
    private PzDateField dfDatumIzrade;
    private PzButton btnPotvrdi;
    private PzTextAreaPanel taRazlog;
    private JLabel jLabel1;
    private Fakturaservisa fakturaServisa;
    private PzPanel mainPanel;

    public StornoFaktureServisa(PzDialog dialog) {
        super(dialog);
        this.fakturaServisa = (Fakturaservisa)this.getSession().getParameter("fakturaServisa");
        this.initGUI();
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        this.mainPanel = new PzPanel();
        this.mainPanel.setLayout((LayoutManager)new BorderLayout());
        try {
            this.setContentPane((Container)this.mainPanel);
            this.setTitle("Storno fakture servisa " + this.fakturaServisa.getOznDokumenta());
            GridBagLayout thisLayout = new GridBagLayout();
            thisLayout.columnWidths = new int[]{105, 100, 7};
            thisLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            thisLayout.rowWeights = new double[]{0.0, 0.1, 0.0};
            thisLayout.rowHeights = new int[]{25, 7, 43};
            this.mainPanel.setLayout((LayoutManager)thisLayout);
            this.jLabel1 = new JLabel();
            this.getContentPane().add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 3), 0, 0));
            this.jLabel1.setName("jLabel1");
            this.dfDatumIzrade = new PzDateField();
            this.getContentPane().add((Component)this.dfDatumIzrade, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 1, 0), 0, 0));
            this.dfDatumIzrade.setDefaultDate(PzDateUtility.getCurrentDate());
            this.btnPotvrdi = new PzButton();
            this.mainPanel.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 0, 3, 0), 0, 0));
            this.btnPotvrdi.setName("btnPotvrdi");
            this.btnPotvrdi.setPreferredSize(new Dimension(80, 30));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setShortcut("ctrl+w");
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
            this.taRazlog = new PzTextAreaPanel();
            this.getContentPane().add((Component)this.taRazlog, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 30), 0, 0));
            this.taRazlog.setBorder((Border)BorderFactory.createTitledBorder("Razlog izrade"));
            this.taRazlog.setName("taRazlog");
            this.pack();
            this.setSize(400, 250);
            this.setResizable(false);
            this.paintPanel();
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        block9: {
            EntityManager em = PzEntityManager.getEm();
            if (this.taRazlog.getVal().trim().length() == 0) {
                JOptionPane.showMessageDialog((Component)this.taRazlog, "Morate uneti razlog storniranja!", "Informacija", 1);
                this.taRazlog.getArea().requestFocusInWindow();
                return;
            }
            try {
                try {
                    em.getTransaction().begin();
                    this.fakturaServisa.setDatum(this.dfDatumIzrade.getVal());
                    this.fakturaServisa.setDatPrometa(this.dfDatumIzrade.getVal());
                    if (PzProdajaUtil.updateStanjeStorniranje((Faktura)this.fakturaServisa)) {
                        PzDokumentManager.getInstance().arhivirajStorno((PzDokument)this.fakturaServisa, PzEntityManager.KOLICINE_UVECANJE, PzEntityManager.KOLICINA_UKUPNA, true, null, em);
                    } else {
                        PzDokumentManager.getInstance().arhivirajStorno((PzDokument)this.fakturaServisa, PzEntityManager.KOLICINE_NEPROMENJENE, PzEntityManager.KOLICINA_UKUPNA, true, null, em);
                    }
                    this.fakturaServisa.setStorno(1);
                    this.fakturaServisa.setPoruka(String.valueOf(this.taRazlog.getVal()) + "\r\n\r\n" + PzPorukeManager.getStandardnaPoruka((PzDokument)this.fakturaServisa));
                    em.getTransaction().commit();
                    PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.fakturaServisa);
                    ((PzDialogFaktureArhiva)((Object)this.getParent())).refreshData();
                }
                catch (Exception ex) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
                    PzSwingUtility.showErrorMessage((Component)this.mainPanel, (String)"Gre\u0161ka prilikom storniranja fakture servisa. Poku\u0161ajte ponovo.");
                    em.close();
                    break block9;
                }
            }
            catch (Throwable throwable) {
                em.close();
                throw throwable;
            }
            em.close();
        }
        this.dispose();
    }

    public static Object getGUIBuilderInstance() {
        return new StornoFaktureServisa(Boolean.FALSE);
    }

    public StornoFaktureServisa(Boolean initGUI) {
    }
}

