/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.faktureUsluga;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Fakturausluga;
import rs.pezar.db.entity.Stavkafaktureusl;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.Usluga;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.prodaja.gui.PzDialogIzradaFaktureSpedicije;
import rs.pezar.sifarnici.gui.PzDialogUsluge;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;

public class DodavanjeStavke
extends PzDialogInsert {
    private static final long serialVersionUID = -5445527818341329119L;
    private PzPanelHeader phDodavanjeFaktureSpedicije;
    private JLabel lblSifraUsluge;
    private PzTextField tfTarifnaGrupa;
    private PzTextField tfOpis;
    private PzPanel pnlGlavni;
    private PzTextField tfProcenat;
    private PzButton btnPotvrdi;
    private PzDoubleField dfCenaUsluge;
    private PzTextField tfSifraUsluge;
    private JLabel lblTarifnaGrupa;
    private JLabel lblCenaUsluge;
    private PzPanel pnlFields;
    private Usluga odabranaUsluga;
    private PzTable table;
    private Fakturausluga fakU;
    private Stavkafaktureusl stavka;
    private double maxCena;

    public DodavanjeStavke(JFrame frame) {
        super(frame);
        this.initGUI();
        this.paintPanel();
    }

    public DodavanjeStavke(PzDialog dialog) {
        super(dialog);
        this.paintPanel();
    }

    public DodavanjeStavke(PzDialog dialog, boolean izmena, Object data1, Object data2) {
        super(dialog, izmena, (PzTable)data1, data2);
        this.paintPanel();
    }

    private void paintPanel() {
        this.pnlGlavni.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.pnlGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.pnlGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    protected void initGUI() {
        try {
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setLayout(null);
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            this.phDodavanjeFaktureSpedicije = new PzPanelHeader();
            this.pnlGlavni.add((Component)this.phDodavanjeFaktureSpedicije, (Object)"Center");
            this.phDodavanjeFaktureSpedicije.setBounds(-6, -2, 522, 72);
            this.phDodavanjeFaktureSpedicije.setIcon(this.getHeaderIcon());
            this.phDodavanjeFaktureSpedicije.setTitle(this.getHeaderTitle());
            this.phDodavanjeFaktureSpedicije.setOpaque(false);
            this.pnlFields = new PzPanel();
            this.pnlGlavni.add((Component)this.pnlFields, (Object)"North");
            GridBagLayout plGlavniLayout = new GridBagLayout();
            plGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            plGlavniLayout.rowHeights = new int[]{25, 25, 25, 25};
            plGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            plGlavniLayout.columnWidths = new int[]{50, 66, 45, 50, 50, 214, 50};
            this.pnlFields.setLayout((LayoutManager)plGlavniLayout);
            this.pnlFields.setBounds(0, 82, 522, 129);
            this.pnlFields.setOpaque(false);
            this.lblSifraUsluge = new JLabel();
            this.pnlFields.add((Component)this.lblSifraUsluge, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
            this.lblSifraUsluge.setText("\u0160ifra usluge");
            this.lblCenaUsluge = new JLabel();
            this.pnlFields.add((Component)this.lblCenaUsluge, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
            this.lblCenaUsluge.setText("Cena usluge");
            this.lblTarifnaGrupa = new JLabel();
            this.pnlFields.add((Component)this.lblTarifnaGrupa, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
            this.lblTarifnaGrupa.setText("Tarifna grupa");
            this.tfTarifnaGrupa = new PzTextField();
            this.pnlFields.add((Component)this.tfTarifnaGrupa, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.tfTarifnaGrupa.setFont(new Font("Tahoma", 0, 14));
            this.tfTarifnaGrupa.setMaxLength(3);
            this.tfTarifnaGrupa.setEditable(false);
            this.tfTarifnaGrupa.setFocusable(false);
            this.tfSifraUsluge = new PzTextField();
            this.pnlFields.add((Component)this.tfSifraUsluge, (Object)new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.tfSifraUsluge.setFont(new Font("Tahoma", 0, 14));
            this.tfSifraUsluge.setToUpperCase(true);
            this.tfSifraUsluge.setFKField(Usluga.class, PzDialogUsluge.class, true, "Ne postoji usluga sa unetom \u0161ifrom!");
            this.tfOpis = new PzTextField();
            this.pnlFields.add((Component)this.tfOpis, (Object)new GridBagConstraints(4, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 2, 1, 0), 0, 0));
            this.tfOpis.setFont(new Font("Tahoma", 0, 14));
            this.tfOpis.setEditable(false);
            this.tfOpis.setFocusable(false);
            this.dfCenaUsluge = new PzDoubleField();
            this.pnlFields.add((Component)this.dfCenaUsluge, (Object)new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.dfCenaUsluge.setFont(new Font("Tahoma", 0, 14));
            this.dfCenaUsluge.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (DodavanjeStavke.this.dfCenaUsluge.getVal() <= 0.0) {
                        JOptionPane.showMessageDialog(null, "Cena usluge mora biti ve\u0107a od 0!", "Informacija", 1);
                        return false;
                    }
                    return true;
                }
            });
            this.btnPotvrdi = new PzButton();
            this.pnlFields.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(0, 3, 7, 1, 0.0, 0.0, 10, 3, new Insets(15, 0, 5, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setShortcut("Insert");
            this.tfProcenat = new PzTextField();
            this.pnlFields.add((Component)this.tfProcenat, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 2, 1, 0), 0, 0));
            this.tfProcenat.setFont(new Font("Tahoma", 0, 14));
            this.tfProcenat.setEditable(false);
            this.tfProcenat.setFocusable(false);
            this.setPreferredSize(new Dimension(579, 260));
            this.setResizable(false);
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Stavkafaktureusl getInsertData() {
        Stavkafaktureusl stavka = new Stavkafaktureusl();
        if (!this.fakU.getPodTip().equalsIgnoreCase(TipDokumentConfig.get().PODTIP_FAKTURA_SPEDICIJE)) {
            stavka.init(this.odabranaUsluga, (PzDokument)this.fakU);
        } else {
            stavka.setId(this.fakU.getIdDok(), this.fakU.getNextRBrojUsluge());
            stavka.setNaziv(this.odabranaUsluga.getNaziv());
            stavka.setCena(this.dfCenaUsluge.getVal().doubleValue());
            stavka.setUsluga(this.odabranaUsluga);
            for (Tarifnagrupa tgr : this.odabranaUsluga.getTarifnagrupas()) {
                stavka.addTaksa(tgr);
            }
        }
        stavka.setKolicina(1.0);
        stavka.setFakturausluga(this.fakU);
        return stavka;
    }

    public Stavkafaktureusl getUpdateData() {
        this.stavka.setCena(this.dfCenaUsluge.getVal().doubleValue());
        return this.stavka;
    }

    public void actionPerformed(ActionEvent e) {
        block15: {
            EntityManager em = PzEntityManager.getEm();
            try {
                if (this.getParent() instanceof PzDialogIzradaFaktureSpedicije) {
                    em.getTransaction().begin();
                    String actionCommand = e.getActionCommand();
                    if (actionCommand.equals("insert")) {
                        if (this.fakU.artikalExists(this.tfSifraUsluge.getVal())) {
                            this.stavka = this.fakU.getStavka(this.tfSifraUsluge.getVal());
                            int rez = JOptionPane.showConfirmDialog(SwingUtilities.getRoot(null), "Na fakturi ve\u0107 postoji izabrana usluga!Da li \u017eelite da dodate odabranu uslugu kao novu stavku?", "Informacija", 0);
                            if (rez != 0) {
                                this.tfSifraUsluge.requestFocus();
                                return;
                            }
                        }
                        this.stavka = this.getInsertData();
                        this.table.insert((PzEntity)this.stavka, em);
                        em.getTransaction().commit();
                        this.table.commitInsert();
                        this.getSession().putParameter("stavka", (Object)this.stavka);
                    } else if (actionCommand.equals("update")) {
                        this.table.updateSelectedEntity((PzEntity)this.getUpdateData(), em);
                        em.getTransaction().commit();
                        this.table.commitUpdate();
                    }
                    ((PzDialogIzradaFaktureSpedicije)((Object)this.getParent())).setUkupanIznos();
                    this.dispose();
                    break block15;
                }
                if (this.maxCena < this.dfCenaUsluge.getVal()) {
                    JOptionPane.showMessageDialog(this.getParent(), "Nova cena ne mo\u017ee biti ve\u0107a od:" + this.maxCena + "!", "Informacija", 1);
                    this.dfCenaUsluge.requestFocus();
                    return;
                }
                try {
                    this.table.updateSelectedEntity((PzEntity)this.getUpdateData(), false);
                    this.dispose();
                }
                catch (Exception e1) {
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                }
            }
            finally {
                em.close();
            }
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Usluga) {
            this.odabranaUsluga = (Usluga)entity;
            this.tfSifraUsluge.setVal((Object)this.odabranaUsluga.getSfrProizvod());
            this.tfOpis.setVal((Object)this.odabranaUsluga.getNaziv());
            this.dfCenaUsluge.setVal((Object)this.odabranaUsluga.getCena());
            this.tfTarifnaGrupa.setVal((Object)this.odabranaUsluga.getTarifnaGrupa("PDV").getOznTarGr());
            this.tfProcenat.setVal((Object)(String.valueOf(this.odabranaUsluga.getStopa("PDV")) + "%"));
            this.dfCenaUsluge.requestFocus();
        }
    }

    protected void onInsert() {
        this.btnPotvrdi.setActionCommand("insert");
        this.table = (PzTable)this.getSession().getParameter("tabela");
        this.fakU = (Fakturausluga)this.getSession().getParameter("fakturaU");
    }

    protected void onUpdate() {
        this.btnPotvrdi.setActionCommand("update");
        this.tfSifraUsluge.setEnabled(false);
        this.table = (PzTable)this.getSession().getParameter("tabela");
        this.fakU = (Fakturausluga)this.getSession().getParameter("fakturaU");
        this.stavka = (Stavkafaktureusl)this.table.getSelectedEntity();
        this.tfSifraUsluge.setVal((Object)this.stavka.getUsluga().getSfrProizvod());
        this.dfCenaUsluge.setVal((Object)this.stavka.getCena());
        this.tfTarifnaGrupa.setVal((Object)this.stavka.getUsluga().getTarifnaGrupa("PDV").getOznTarGr());
        this.tfProcenat.setVal((Object)(String.valueOf(this.stavka.getUsluga().getStopa("PDV")) + "%"));
        Object cena = this.getSession().getParameter("cena");
        this.maxCena = cena != null ? Double.parseDouble(cena.toString()) : 0.0;
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Dodavanje stavke usluga");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/product_new.png")));
    }

    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Izmena stavke usluga");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/product_edit.png")));
    }

    public static Object getGUIBuilderInstance() {
        return new DodavanjeStavke(Boolean.FALSE);
    }

    public DodavanjeStavke(Boolean initGUI) {
    }
}

