/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.faktureUsluga;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.prodaja.gui.PzDialogStornoFaktureZaUsluge;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.custom.PzTablePorez;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.util.PzMathUtility;

public class PzDialogTaksa
extends PzDialog {
    private static final long serialVersionUID = 1L;
    private PzPanelHeader header;
    private PzTaksaDokument taksa;
    private PzPanel panel;
    private PzButton btnOK;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzDoubleField iznos;
    private PzDoubleField osnovica;
    private PzTablePorez table;
    private int index;
    private double maxOsnovica;
    private PzPanel mainPanel;

    public PzDialogTaksa(PzDialog dialog) {
        super(dialog);
        this.taksa = (PzTaksaDokument)this.getSession().getParameter("taksa");
        this.maxOsnovica = Double.parseDouble(this.getSession().getParameter("osnovica").toString());
        this.table = (PzTablePorez)this.getSession().getParameter("table");
        this.initGUI();
        this.header.setTitle("Izmena takse");
        this.iznos.setVal((Object)this.taksa.getIznos());
        this.osnovica.setVal((Object)this.taksa.getOsnovica());
        if (this.osnovica.getVal() == 0.0) {
            this.btnOK.setActionCommand("insert");
        } else {
            this.btnOK.setActionCommand("update");
        }
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    protected void initGUI() {
        this.mainPanel = new PzPanel();
        this.mainPanel.setLayout((LayoutManager)new BorderLayout());
        try {
            this.setContentPane((Container)this.mainPanel);
            this.header = new PzPanelHeader();
            this.header.setOpaque(false);
            this.header.setTitle("Unos poreza");
            this.getContentPane().add((Component)this.header, "North");
            this.panel = new PzPanel();
            this.panel.setOpaque(false);
            GridBagLayout panelLayout = new GridBagLayout();
            panelLayout.rowWeights = new double[]{0.0, 0.0, 0.1};
            panelLayout.rowHeights = new int[]{25, 25, 7};
            panelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            panelLayout.columnWidths = new int[]{85, 95, 128, 7};
            this.panel.setLayout((LayoutManager)panelLayout);
            this.getContentPane().add((Component)this.panel, "Center");
            this.panel.setPreferredSize(new Dimension(359, 122));
            this.btnOK = new PzButton();
            this.panel.add((Component)this.btnOK, (Object)new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOK.setText("Potvrdi");
            this.btnOK.setPreferredSize(new Dimension(130, 30));
            this.btnOK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.jLabel2 = new JLabel();
            this.panel.add((Component)this.jLabel2, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 1, 5), 0, 0));
            this.jLabel2.setText("Iznos:");
            this.jLabel1 = new JLabel();
            this.panel.add((Component)this.jLabel1, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 1, 5), 0, 0));
            this.jLabel1.setText("Osnovica:");
            this.iznos = new PzDoubleField();
            this.panel.add((Component)this.iznos, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.iznos.setPreferredSize(new Dimension(108, 25));
            this.iznos.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent evt) {
                    PzDialogTaksa.this.iznosFocusGained(evt);
                }
            });
            this.iznos.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogTaksa.this.iznos.getVal() <= 0.0) {
                        JOptionPane.showMessageDialog(null, "Iznos mora biti ve\u0107i od 0!", "Informacija", 1);
                        return false;
                    }
                    return true;
                }
            });
            this.osnovica = new PzDoubleField();
            this.panel.add((Component)this.osnovica, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.osnovica.setPreferredSize(new Dimension(108, 25));
            this.osnovica.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogTaksa.this.osnovica.getVal() <= 0.0) {
                        JOptionPane.showMessageDialog(null, "Osnovica mora biti ve\u0107a od 0!", "Informacija", 1);
                        return false;
                    }
                    if (PzDialogTaksa.this.osnovica.getVal() > PzDialogTaksa.this.maxOsnovica) {
                        JOptionPane.showMessageDialog(null, "Osnovica ne mo\u017ee biti ve\u0107a od " + PzDialogTaksa.this.maxOsnovica + "!", "Informacija", 1);
                        return false;
                    }
                    return true;
                }
            });
            this.pack();
            this.setSize(440, 200);
            this.setResizable(false);
            this.paintPanel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String actionCommand = ((PzButton)e.getSource()).getActionCommand();
            if (this.getParent() instanceof PzDialogStornoFaktureZaUsluge) {
                this.taksa.setOsnovica(PzMathUtility.roundToBigDecimal((double)this.osnovica.getVal()));
                this.taksa.setIznos(PzMathUtility.roundToBigDecimal((double)this.iznos.getVal()));
                PzTable tab = (PzTable)this.getSession().getParameter("tabela");
                tab.updateSelectedEntity((PzEntity)this.taksa, false);
                BigDecimal noviIznosFakture = new BigDecimal(0);
                noviIznosFakture = noviIznosFakture.add(this.taksa.getOsnovica()).add(this.taksa.getIznos());
                this.getSession().putParameter("noviIznosFakture", (Object)noviIznosFakture);
            } else if (actionCommand.equalsIgnoreCase("insert")) {
                this.taksa.setOsnovica(PzMathUtility.roundToBigDecimal((double)this.osnovica.getVal()));
                this.taksa.setIznos(PzMathUtility.roundToBigDecimal((double)this.iznos.getVal()));
                this.table.refreshData();
            } else {
                this.taksa.setOsnovica(PzMathUtility.roundToBigDecimal((double)this.osnovica.getVal()));
                this.taksa.setIznos(PzMathUtility.roundToBigDecimal((double)this.iznos.getVal()));
                this.table.refreshData();
                this.table.setRowSelectionInterval(this.index, this.index);
            }
            this.dispose();
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogTaksa(Boolean.FALSE);
    }

    public PzDialogTaksa(Boolean initGUI) {
    }

    private void iznosFocusGained(FocusEvent evt) {
        this.iznos.setVal((Object)(this.osnovica.getVal() * Double.valueOf(this.taksa.getTarifnagrupa().getStopa()) / 100.0));
    }
}

