/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.faktureZaProdajuRobe;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.db.filter.PzStanjeArtikalFilter;
import rs.pezar.prodaja.gui.faktureZaProdajuRobe.UnosPodataka;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class PreuzimanjeKolSaKons
extends PzDialog {
    private static final long serialVersionUID = -8698467128101998602L;
    private PzPanel pnlGlavni;
    private PzPanel panelKol;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private PzTable tblTabela;
    private JScrollPane scTabela;
    private PzPanel plTabela;
    private PzTextField tfArtikal;
    private PzDoubleField dfRaspoloziva;
    private PzDoubleField dfAlocirana;
    private PzDoubleField dfUkupnaKol;
    private Vector<PzEntity> podaci = null;
    private static String kons = null;
    private boolean dajStaDasKons = false;

    public PreuzimanjeKolSaKons(PzDialog dialog) {
        super(dialog);
        this.initGUI();
        this.postInit(this.getSession().getParameter("artikal").toString(), Double.parseDouble(this.getSession().getParameter("ukAloc").toString()), Double.parseDouble(this.getSession().getParameter("ukKol").toString()));
        if (this.getSession().getParameter("dajStaDasKons") != null && new Boolean(this.getSession().getParameter("dajStaDasKons").toString()).booleanValue()) {
            this.dajStaDasKons = true;
        }
        this.paintPanel();
    }

    public PreuzimanjeKolSaKons(PzDialog parent, Vector<PzEntity> data, String artikal, double ukAlocirana, double ukKolicina) {
        this.podaci = data;
        this.initGUI();
        this.postInit(artikal, ukAlocirana, ukKolicina);
        this.paintPanel();
    }

    private void postInit(String artikal, double ukAlocirana, double ukKolicina) {
        this.tfArtikal.setVal((Object)artikal);
        this.dfRaspoloziva.setVal((Object)this.getUkupan(2, "+"));
        this.dfAlocirana.setVal((Object)ukAlocirana);
        this.dfUkupnaKol.setVal((Object)ukKolicina);
    }

    private void paintPanel() {
        this.pnlGlavni.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.pnlGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.pnlGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private double getUkupan(int column, String op) {
        double rez = 0.0;
        int i = 0;
        while (i < this.tblTabela.getDataSize()) {
            double iznos = Double.valueOf(this.tblTabela.getValueAt(i, column).toString());
            if (op.equals("-")) {
                if (iznos < 0.0) {
                    rez += iznos;
                }
            } else {
                rez += iznos;
            }
            ++i;
        }
        return rez;
    }

    private void initGUI() {
        try {
            this.setTitle("Preuzimanje koli\u010dine sa konsignacije");
            this.pnlGlavni = new PzPanel();
            BorderLayout pnlGlavniLayout = new BorderLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.panelKol = new PzPanel();
            this.panelKol.setOpaque(false);
            this.pnlGlavni.add((Component)this.panelKol, (Object)"Center");
            GridBagLayout panelTopLayout = new GridBagLayout();
            panelTopLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 1.0};
            panelTopLayout.rowHeights = new int[]{30, 25, 25, 25, 200};
            panelTopLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            panelTopLayout.columnWidths = new int[]{110, 118, 195, 7};
            this.panelKol.setLayout((LayoutManager)panelTopLayout);
            this.jLabel1 = new JLabel();
            this.panelKol.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 6, 0, 2), 0, 0));
            this.jLabel1.setText("Artikal");
            this.jLabel2 = new JLabel();
            this.panelKol.add((Component)this.jLabel2, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 2), 0, 0));
            this.jLabel2.setText("Ukupna koli\u010dina");
            this.jLabel3 = new JLabel();
            this.panelKol.add((Component)this.jLabel3, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 2), 0, 0));
            this.jLabel3.setText("Ukupna alocirana");
            this.jLabel4 = new JLabel();
            this.panelKol.add((Component)this.jLabel4, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 2), 0, 0));
            this.jLabel4.setText("Ukupna raspolo\u017eiva");
            this.tfArtikal = new PzTextField();
            this.panelKol.add((Component)this.tfArtikal, (Object)new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 1, 10), 0, 0));
            this.tfArtikal.setEditable(false);
            this.tfArtikal.setFocusable(false);
            this.dfUkupnaKol = new PzDoubleField();
            this.panelKol.add((Component)this.dfUkupnaKol, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 1, 0), 0, 0));
            this.dfUkupnaKol.setEditable(false);
            this.dfUkupnaKol.setFocusable(false);
            this.dfAlocirana = new PzDoubleField();
            this.panelKol.add((Component)this.dfAlocirana, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 1, 0), 0, 0));
            this.dfAlocirana.setEditable(false);
            this.dfAlocirana.setFocusable(false);
            this.dfRaspoloziva = new PzDoubleField();
            this.panelKol.add((Component)this.dfRaspoloziva, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 1, 0), 0, 0));
            this.dfRaspoloziva.setEditable(false);
            this.dfRaspoloziva.setFocusable(false);
            this.plTabela = new PzPanel();
            this.panelKol.add((Component)this.plTabela, (Object)new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
            BorderLayout jPanel1Layout = new BorderLayout();
            this.plTabela.setLayout((LayoutManager)jPanel1Layout);
            this.plTabela.setOpaque(false);
            this.scTabela = new JScrollPane();
            this.scTabela.setOpaque(false);
            this.plTabela.add((Component)this.scTabela, (Object)"Center");
            this.scTabela.setBackground(new Color(211, 242, 210));
            this.tblTabela = new PzTable();
            Vector tableData = null;
            tableData = this.podaci == null ? (Vector)this.getSession().getParameter("data") : this.podaci;
            this.tblTabela.setFilter((PzEntityFilter)new PzStanjeArtikalFilter(PzStanjeArtikalFilter.OPTION_KOLICINA_SA_KONS));
            this.tblTabela.setData(tableData, Stanjeartikal.class);
            this.tblTabela.getTableHeader().setFocusable(false);
            this.scTabela.setViewportView((Component)this.tblTabela);
            this.tblTabela.setRowSelectionInterval(0, 0);
            this.tblTabela.getTableHeader().setReorderingAllowed(false);
            this.tblTabela.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    String konsignacija = PreuzimanjeKolSaKons.this.tblTabela.getStringAt(PreuzimanjeKolSaKons.this.tblTabela.getSelectedRow(), 0);
                    if (PreuzimanjeKolSaKons.this.getParent() instanceof UnosPodataka) {
                        String selectedKolicina = PreuzimanjeKolSaKons.this.tblTabela.getStringAt(PreuzimanjeKolSaKons.this.tblTabela.getSelectedRow(), PreuzimanjeKolSaKons.this.tblTabela.getColumn((Object)"Raspolo\u017eiva koli\u010dina").getModelIndex());
                        ((UnosPodataka)((Object)PreuzimanjeKolSaKons.this.getParent())).setKonsignacijaValues(konsignacija, PreuzimanjeKolSaKons.this.dajStaDasKons ? Double.parseDouble(selectedKolicina) : -1.0);
                    } else {
                        kons = konsignacija;
                    }
                    PreuzimanjeKolSaKons.this.getSession().putParameter("dajStaDasKons", null);
                    PreuzimanjeKolSaKons.this.dispose();
                }
            });
            this.setMinimumSize(new Dimension(640, 430));
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    public static String preuzmiIzKonsignacije(String sfrProizvod, String ogranak, BigDecimal kolicina, EntityManager em) {
        String rez = null;
        Query q = em.createQuery("SELECT s FROM Stanjeartikal s where s.radnajedinica.ogranak.oznOgranak=:ogranak and s.id.sfrProizvod=:sfrP and s.radnajedinica.gTip=:tip and s.kolicina - s.alocKolicina>=:kol");
        q.setParameter("sfrP", (Object)sfrProizvod);
        q.setParameter("ogranak", (Object)ogranak);
        q.setParameter("tip", (Object)"T");
        q.setParameter("kol", (Object)kolicina);
        Vector data = (Vector)q.getResultList();
        if (data.size() > 1) {
            double ukAloc = 0.0;
            double ukKol = 0.0;
            for (PzEntity sa : data) {
                Stanjeartikal s = (Stanjeartikal)sa;
                ukAloc += s.getAlocKolicina();
                ukKol += s.getKolicina();
            }
            PreuzimanjeKolSaKons dlg = new PreuzimanjeKolSaKons(null, data, sfrProizvod, ukAloc, ukKol);
            dlg.restoreSize();
            dlg.setModal(true);
            dlg.setVisible(true);
            if (kons != null) {
                Stanje stanjeKons = (Stanje)em.find(Stanje.class, (Object)new StanjePK(sfrProizvod, ogranak, kons));
                stanjeKons.setAlocKolicina(stanjeKons.getAlocKolicina() + kolicina.doubleValue());
            }
            rez = kons;
            kons = null;
        } else if (data.size() == 1) {
            Stanjeartikal s = (Stanjeartikal)data.get(0);
            Stanje stanjeKons = (Stanje)em.find(Stanje.class, (Object)new StanjePK(sfrProizvod, s.getId().getOznOgranak(), s.getId().getOznRj()));
            stanjeKons.setAlocKolicina(stanjeKons.getAlocKolicina() + kolicina.doubleValue());
            rez = s.getId().getOznRj();
        } else {
            PzSwingUtility.showErrorMessage(null, (String)"Nema dovoljno raspolo\u017eive koli\u010dine ni u jednoj konsignaciji! Unos nije mogu\u0107!");
            return null;
        }
        return rez;
    }

    public static Object getGUIBuilderInstance() {
        return new PreuzimanjeKolSaKons(Boolean.FALSE);
    }

    public PreuzimanjeKolSaKons(Boolean initGUI) {
    }
}

