/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Rabat;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldIndikator;

public class PanelRabati
extends PzPanel {
    private List<Rabat> rabati;
    private HashMap<Rabat, PzDoubleField> mapaRabata;

    public PanelRabati() {
        EntityManager em = PzEntityManager.getEm();
        this.rabati = new ArrayList<Rabat>();
        this.rabati.add(new Rabat(Integer.valueOf(0), "Procenat rabata", 0.0));
        List rabatiU = em.createQuery("select r from Rabat r order by r.id").getResultList();
        em.close();
        if (rabatiU.size() != 0) {
            int i = 0;
            while (i < rabatiU.size()) {
                this.rabati.add((Rabat)rabatiU.get(i));
                ++i;
            }
        }
        this.setOpaque(false);
        this.initGUI();
    }

    public List<Rabat> getRabati() {
        return this.rabati;
    }

    public void setRabati(List<Rabat> rabati) {
        this.rabati = rabati;
    }

    public void setMapaRabata(HashMap<Rabat, PzDoubleField> mapaRabata) {
        this.mapaRabata = mapaRabata;
        this.repaint();
    }

    public HashMap<Rabat, PzDoubleField> getMapaRabata() {
        return this.mapaRabata;
    }

    private void initGUI() {
        GridBagLayout thisLayout = new GridBagLayout();
        thisLayout.rowWeights = this.getRowWeights();
        thisLayout.rowHeights = this.getRowHeights();
        thisLayout.columnWeights = new double[]{0.0, 0.0};
        thisLayout.columnWidths = new int[]{165, 85};
        this.setLayout(thisLayout);
        this.setBorder(BorderFactory.createTitledBorder(null, "Definisani rabati", 4, 0, new Font("Segoe UI", 1, 12), new Color(0, 0, 165)));
        this.createRabatFields(thisLayout);
    }

    private int[] getRowHeights() {
        int[] ret = new int[this.rabati.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = 25;
            ++i;
        }
        return ret;
    }

    private double[] getRowWeights() {
        double[] ret = new double[this.rabati.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = 0.0;
            ++i;
        }
        return ret;
    }

    private void createRabatFields(GridBagLayout thisLayout) {
        this.mapaRabata = new HashMap();
        int i = 0;
        while (i < this.rabati.size()) {
            Rabat rabat = this.rabati.get(i);
            PzDoubleField pzDbl = this.createPzDoubleField();
            PzFieldIndikator ind = new PzFieldIndikator();
            pzDbl.setStateIndikator(ind);
            this.mapaRabata.put(rabat, pzDbl);
            this.add(new JLabel(rabat.getNaziv()), new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 5, 1, 5), 0, 0));
            this.add((Component)pzDbl, new GridBagConstraints(1, i, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 20), 0, 0));
            this.add((Component)ind, new GridBagConstraints(1, i, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 1, 1, 0), 0, 0));
            ++i;
        }
    }

    private PzDoubleField createPzDoubleField() {
        final PzDoubleField dbl = new PzDoubleField();
        dbl.setPreferredSize(new Dimension(60, 24));
        dbl.setDecimalFormat(PzFormatFactory.getProcRabataFormat());
        dbl.setPreferredSize(new Dimension(60, 24));
        dbl.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent arg0) {
                if (dbl.getVal() < 0.0 || dbl.getVal() > 100.0) {
                    JOptionPane.showMessageDialog(null, "Procenat rabata mora biti izme\u0111u  0 i 100!", "Informacija", 1);
                    dbl.setState(PzFieldIndikator.STATE_INVALID);
                    dbl.requestFocus();
                    return false;
                }
                dbl.setState(PzFieldIndikator.STATE_VALID);
                return true;
            }
        });
        return dbl;
    }

    public BigDecimal getSumaRabata() {
        BigDecimal rez = new BigDecimal(0);
        for (PzDoubleField field : this.mapaRabata.values()) {
            rez = rez.add(field.getBigDecimal());
        }
        return rez;
    }

    public void setValueForRabatAtIndex(int index, String v) {
        Rabat r = this.rabati.get(index);
        this.setValueForRabat(r, v);
    }

    public BigDecimal getValueForRabat(Rabat r) {
        return this.mapaRabata.get(r).getBigDecimal();
    }

    public void setValueForRabat(Rabat r, String value) {
        this.mapaRabata.get(r).setVal((Object)new BigDecimal(value));
    }

    public void setEnabled(boolean enable) {
        for (PzDoubleField field : this.mapaRabata.values()) {
            field.setEnabled(enable);
        }
    }

    public HashMap<Integer, BigDecimal> getMapaIznosaRabata() {
        HashMap<Integer, BigDecimal> mapa = new HashMap<Integer, BigDecimal>();
        for (Rabat r : this.rabati) {
            mapa.put(r.getId(), this.getValueForRabat(r));
        }
        return mapa;
    }

    public void setIznosiRabata(HashMap<Integer, BigDecimal> mapaIznosa) {
        for (Rabat r : this.rabati) {
            this.setValueForRabat(r, mapaIznosa.get(r.getId()).toString());
        }
    }
}

