/*
 * Decompiled with CFR 0.152.
 */
package BI;

import BI.BB;
import BI.CC;
import BI.E;
import BI.FB;
import BI.IS;
import BI.KZ;
import BI.OJ;

public abstract class DB {
    public static final int[] s_supportedLanguages = new int[]{1247282, 366773, 169492, 561426, 249971, 284801, 942540, 1415342, 338100, 411849, 430290, 272517, 495788, 614661, 567573, 1090068, 631092, 688449, 758127, 831894, 827796, 948687, 1073676, 1210959, 1223253, 1682034, 226120, 1268331, 1264236, 366771, 1256054, 1327752, 1359688, 1348242};
    public static final int[] s_installedLanguages = new int[]{1073741969, 1073741971, 1073741973, 0x40000099, 1073741979, 1073741981, 1073741983, 1073741985, 1073741987, 1073741989, 1073741991, 1073741993, 1073741995, 1073741997, 1073741999, 1073742001, 1073742005, 1073742007, 1073742009, 0x400000BB, 1073742013, 1073742015, 1073742017, 1073742019, 1073742021, 1073742023, 1073742025, 1073742027, 1073742029, 1073742031, 1073742033, 1073742035, 1073742037, 1073742039};
    public static final int[] s_enabledLanguages = new int[]{1073741970, 0x40000094, 1073741974, 1073741978, 1073741980, 1073741982, 0x400000A0, 1073741986, 0x400000A4, 1073741990, 1073741992, 0x400000AA, 1073741996, 1073741998, 0x400000B0, 1073742002, 1073742006, 1073742008, 1073742010, 1073742012, 1073742014, 0x400000C0, 1073742018, 0x400000C4, 1073742022, 1073742024, 1073742026, 0x400000CC, 1073742030, 0x400000D0, 1073742034, 0x400000D4, 1073742038, 1073742040};
    public static BB s_localeInfoFactory = null;

    public static boolean isAvailableUILocale(int n) {
        if ((n & 0x7FF) == 174) {
            return true;
        }
        try {
            Class<?> clazz = Class.forName("com.jxcell.util.pvt.Resources_" + DB.getLanguage(n));
            if (clazz != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    protected static final int $assertionsDisabled(char c) {
        if (c <= 'z') {
            if (c >= 'a') {
                return c - 97 + 1;
            }
            if (c >= 'A' && c <= 'Z') {
                return c - 65 + 1;
            }
        }
        return 0;
    }

    public static int language2LocaleID(String string) {
        if (string.length() > 2) {
            if (string.equals("zhs")) {
                return 840;
            }
            if (string.equals("zht")) {
                return 1864;
            }
            if (string.equals("ptb")) {
                return 1556;
            }
            if (string.equals("pti")) {
                return 532;
            }
        }
        int n = DB.$assertionsDisabled(string.charAt(0)) << 5 | DB.$assertionsDisabled(string.charAt(1)) | (string.length() <= 2 ? 0 : 1024);
        switch (n) {
            case 311: {
                return 261;
            }
            case 302: {
                return 292;
            }
            case 329: {
                return 809;
            }
        }
        return n;
    }

    public static int country2LocaleID(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        return DB.$assertionsDisabled(string.charAt(0)) << 16 | DB.$assertionsDisabled(string.charAt(1)) << 11 | (string.length() <= 2 ? 0 : 0x200000);
    }

    public static int sortOrder2LocaleID(short s) {
        return s << 22;
    }

    public static int makeLocaleID(String string, String string2, short s) {
        int n = DB.language2LocaleID(string);
        int n2 = string2 == null || string2.length() <= 0 ? 0 : DB.country2LocaleID(string2);
        int n3 = DB.sortOrder2LocaleID(s);
        switch (n) {
            case 840: {
                switch (n2) {
                    case 546816: 
                    case 882688: 
                    case 1357824: {
                        n = 1864;
                    }
                }
                break;
            }
            case 532: {
                if (n2 != 167936) break;
                n = 1556;
            }
        }
        if (n2 == 0) {
            n2 = DB.getDefaultCountry(n);
        }
        return 0 | n | n2 | n3;
    }

    public static final short normalizeCodePage(short s) {
        if (s == 0) {
            return DB.getCodePage(DB.getDefault());
        }
        return s;
    }

    public static final int codePage2LocaleID(short s) {
        return 0x10000000 | DB.normalizeCodePage(s) & 0xFFFF;
    }

    public static final boolean isKnownRegionalLocale(int n) {
        return (n & 0xF0000000) == 0;
    }

    public static final boolean isKindOfFileLocale(int n) {
        return (n & 0xF0000000) == 0x40000000;
    }

    public static final boolean isFullyEncodedFileLocale(int n) {
        return (n & 0xF0010000) == 0x40000000;
    }

    public static final boolean isKindOfInitLocale(int n) {
        return (n & 0xF0000000) == 0x60000000;
    }

    public static boolean isAnyInternalLocale(int n) {
        int n2 = n & 0xF0000000;
        return n2 == 0x20000000 || n2 == 0x40000000 || n2 == 0x60000000;
    }

    public static boolean isKindOfRegionalLocale(int n) {
        return (n & Integer.MIN_VALUE) != 0 || (n & 0xF0000000) == 0;
    }

    public static boolean isCodePageLocale(int n) {
        return (n & 0xF0000000) == 0x10000000;
    }

    public static String getLanguage(int n) {
        switch (n & 0x7FF) {
            case 840: {
                return "zhs";
            }
            case 1864: {
                return "zht";
            }
            case 1556: {
                return "ptb";
            }
            case 532: {
                return "pti";
            }
            default: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append((char)(((n & 0x3E0) >> 5) + 97 - 1));
                stringBuffer.append((char)((n & 0x1F) + 97 - 1));
                if ((n & 0x400) != 0) {
                    stringBuffer.append("f1");
                }
                return stringBuffer.toString();
            }
            case 0: 
        }
        return null;
    }

    public static String getCountry(int n) {
        if ((n & 0x3FF800) == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)(((n & 0x1F0000) >> 16) + 65 - 1));
        stringBuffer.append((char)(((n & 0xF800) >> 11) + 65 - 1));
        if ((n & 0x200000) != 0) {
            stringBuffer.append("F1");
        }
        return stringBuffer.toString();
    }

    public static String getISOLanguage(int n) {
        if ((n & 0x7FF) == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)(((n & 0x3E0) >> 5) + 97 - 1));
        stringBuffer.append((char)((n & 0x1F) + 97 - 1));
        if ((n & 0x3FF800) == 0 || (n & 0x200000) != 0) {
            switch (n & 0x7FF) {
                case 840: {
                    stringBuffer.append("_CN");
                    break;
                }
                case 1864: {
                    stringBuffer.append("_TW");
                    break;
                }
                case 1556: {
                    stringBuffer.append("_BR");
                    break;
                }
                case 532: {
                    stringBuffer.append("_PT");
                }
            }
        } else {
            stringBuffer.append('_');
            stringBuffer.append((char)(((n & 0x1F0000) >> 16) + 65 - 1));
            stringBuffer.append((char)(((n & 0xF800) >> 11) + 65 - 1));
        }
        return stringBuffer.toString();
    }

    public static short getCodePage(int n) {
        if (DB.isCodePageLocale(n)) {
            return (short)(n & 0xFFFF);
        }
        assert (DB.isKnownRegionalLocale(n));
        assert ((n & 0x7FF) != 0);
        char c = (char)(n & 0x7FF);
        for (int i = 0; i < "&\u04e4\u0271\u04e22\u04e8\u00b5\u04e4E\u04e3G\u04e3a\u04e4\u0348\u03a8\u0748\u03b6\u0112\u04e2s\u04e2\u0081\u04e4\u01cc\u04e4\u00ae\u04e4\u00af\u04e2\u00b4\u04e9\u00cf\u04e2\u00c1\u04e8\u00c9\u04e4\u00d2\u04e4\u0085\u04e4\u00ac\u04e5\u0105\u04e7\u0137\u04e7\u0115\u04e2\u0133\u04e4\u0124\u04e4\u012e\u04e4\u0134\u04e4\u0141\u03a4\u016f\u03b5\u0196\u04e9\u0194\u04e9\u01cf\u04e4\u05cf\u04e4\u020c\u04e2\u0614\u04e4\u0214\u04e4\u024f\u04e2\u0255\u04e3\u0272\u04e3\u0268\u04e2\u026b\u04e2\u026c\u04e2\u00b3\u04e4\u04b3\u04e4\u0276\u04e4\u0288\u036a\u0292\u04e6\u02ab\u04e3\u02c9\u04ea".length(); i += 2) {
            if (c != "&\u04e4\u0271\u04e22\u04e8\u00b5\u04e4E\u04e3G\u04e3a\u04e4\u0348\u03a8\u0748\u03b6\u0112\u04e2s\u04e2\u0081\u04e4\u01cc\u04e4\u00ae\u04e4\u00af\u04e2\u00b4\u04e9\u00cf\u04e2\u00c1\u04e8\u00c9\u04e4\u00d2\u04e4\u0085\u04e4\u00ac\u04e5\u0105\u04e7\u0137\u04e7\u0115\u04e2\u0133\u04e4\u0124\u04e4\u012e\u04e4\u0134\u04e4\u0141\u03a4\u016f\u03b5\u0196\u04e9\u0194\u04e9\u01cf\u04e4\u05cf\u04e4\u020c\u04e2\u0614\u04e4\u0214\u04e4\u024f\u04e2\u0255\u04e3\u0272\u04e3\u0268\u04e2\u026b\u04e2\u026c\u04e2\u00b3\u04e4\u04b3\u04e4\u0276\u04e4\u0288\u036a\u0292\u04e6\u02ab\u04e3\u02c9\u04ea".charAt(i)) continue;
            return (short)"&\u04e4\u0271\u04e22\u04e8\u00b5\u04e4E\u04e3G\u04e3a\u04e4\u0348\u03a8\u0748\u03b6\u0112\u04e2s\u04e2\u0081\u04e4\u01cc\u04e4\u00ae\u04e4\u00af\u04e2\u00b4\u04e9\u00cf\u04e2\u00c1\u04e8\u00c9\u04e4\u00d2\u04e4\u0085\u04e4\u00ac\u04e5\u0105\u04e7\u0137\u04e7\u0115\u04e2\u0133\u04e4\u0124\u04e4\u012e\u04e4\u0134\u04e4\u0141\u03a4\u016f\u03b5\u0196\u04e9\u0194\u04e9\u01cf\u04e4\u05cf\u04e4\u020c\u04e2\u0614\u04e4\u0214\u04e4\u024f\u04e2\u0255\u04e3\u0272\u04e3\u0268\u04e2\u026b\u04e2\u026c\u04e2\u00b3\u04e4\u04b3\u04e4\u0276\u04e4\u0288\u036a\u0292\u04e6\u02ab\u04e3\u02c9\u04ea".charAt(i + 1);
        }
        return 1200;
    }

    public static int getDefaultCountry(int n) {
        if ((n & 0x3FF800) != 0) {
            return n & 0x3FF800;
        }
        assert (DB.isKnownRegionalLocale(n));
        assert ((n & 0x7FF) != 0);
        char c = (char)(n & 0x7FF);
        for (int i = 0; i < "&\u0341\u0271,2\u0261\u00b5\u00b3EYGGa\u00b3\u0348n\u0748\u0297\u0112\u0112sz\u0081\u008b\u01cc\u01cc\u00ae\u02b3\u00b4\u00a5\u00cf\u00cf\u00c1\u0132\u00c9\u00c9\u00d2\u00d2\u0085\u0085\u00ac\u00f2\u0105\u012c\u0137\u012c\u0115\u0115\u0133\u0133\u0124\u0124\u012e\u0124\u0134\u0134\u0141\u0150\u016f\u0172\u0196\u0196\u0194\u0194\u01cf\u01cf\u05cf\u01cf\u020c\u020c\u0214R\u0614\u0214\u024f\u024f\u0255\u0255\u0272\u0335\u0268\u0335\u026b\u026b\u026c\u0269\u00b3\u00b3\u04b3\u00b3\u0276\u0265\u0288\u0288\u0292\u0292\u02ab\u02a1\u02c9\u02ce".length(); i += 2) {
            if (c != "&\u0341\u0271,2\u0261\u00b5\u00b3EYGGa\u00b3\u0348n\u0748\u0297\u0112\u0112sz\u0081\u008b\u01cc\u01cc\u00ae\u02b3\u00b4\u00a5\u00cf\u00cf\u00c1\u0132\u00c9\u00c9\u00d2\u00d2\u0085\u0085\u00ac\u00f2\u0105\u012c\u0137\u012c\u0115\u0115\u0133\u0133\u0124\u0124\u012e\u0124\u0134\u0134\u0141\u0150\u016f\u0172\u0196\u0196\u0194\u0194\u01cf\u01cf\u05cf\u01cf\u020c\u020c\u0214R\u0614\u0214\u024f\u024f\u0255\u0255\u0272\u0335\u0268\u0335\u026b\u026b\u026c\u0269\u00b3\u00b3\u04b3\u00b3\u0276\u0265\u0288\u0288\u0292\u0292\u02ab\u02a1\u02c9\u02ce".charAt(i)) continue;
            return (short)"&\u0341\u0271,2\u0261\u00b5\u00b3EYGGa\u00b3\u0348n\u0748\u0297\u0112\u0112sz\u0081\u008b\u01cc\u01cc\u00ae\u02b3\u00b4\u00a5\u00cf\u00cf\u00c1\u0132\u00c9\u00c9\u00d2\u00d2\u0085\u0085\u00ac\u00f2\u0105\u012c\u0137\u012c\u0115\u0115\u0133\u0133\u0124\u0124\u012e\u0124\u0134\u0134\u0141\u0150\u016f\u0172\u0196\u0196\u0194\u0194\u01cf\u01cf\u05cf\u01cf\u020c\u020c\u0214R\u0614\u0214\u024f\u024f\u0255\u0255\u0272\u0335\u0268\u0335\u026b\u026b\u026c\u0269\u00b3\u00b3\u04b3\u00b3\u0276\u0265\u0288\u0288\u0292\u0292\u02ab\u02a1\u02c9\u02ce".charAt(i + 1) << 11;
        }
        return 1415168;
    }

    public static int getCodePageOptimizationRange(int n) {
        switch (!DB.isCodePageLocale(n) && !DB.isKnownRegionalLocale(n) ? 1252 : DB.getCodePage(n)) {
            case 1256: {
                return 0x60006FF;
            }
            case 1250: 
            case 1252: 
            case 1254: 
            case 1257: {
                return 16777807;
            }
            case 932: 
            case 936: 
            case 949: 
            case 950: 
            case 1361: {
                return -16711697;
            }
            case 1251: {
                return 0x40004FF;
            }
            case 1253: {
                return 57672703;
            }
            case 1255: {
                return 93324799;
            }
            case 874: {
                return 234884735;
            }
            case 1258: {
                return 16778095;
            }
        }
        return 0;
    }

    public static short getCharSet(short s) {
        s = DB.normalizeCodePage(s);
        for (int i = 1; i < "\u0000?\u0080\u03a4\u0081\u03b5\u0086\u03a8\u0082?\u00b1?\u00b2?\u00a1?\u00a2?\u00a3?\u00de?\u00ee?\u00cc?M?\u00ba?".length(); i += 2) {
            if (s != (short)"\u0000?\u0080\u03a4\u0081\u03b5\u0086\u03a8\u0082?\u00b1?\u00b2?\u00a1?\u00a2?\u00a3?\u00de?\u00ee?\u00cc?M?\u00ba?".charAt(i)) continue;
            return (short)"\u0000?\u0080\u03a4\u0081\u03b5\u0086\u03a8\u0082?\u00b1?\u00b2?\u00a1?\u00a2?\u00a3?\u00de?\u00ee?\u00cc?M?\u00ba?".charAt(i - 1);
        }
        return 0;
    }

    public static short getFamily(short s) {
        s = DB.normalizeCodePage(s);
        for (int i = 0; i < "?\u0006\u03a4\u0003\u03a8\u0003\u03b5\u0003\u03b6\u0003?\u0007?\u0007?\u0002?\u0002?\u0001?\u0002?\u0002?\u0004?\u0004?\u0002?\u0003?\u0007".length(); i += 2) {
            if (s != (short)"?\u0006\u03a4\u0003\u03a8\u0003\u03b5\u0003\u03b6\u0003?\u0007?\u0007?\u0002?\u0002?\u0001?\u0002?\u0002?\u0004?\u0004?\u0002?\u0003?\u0007".charAt(i)) continue;
            return (short)"?\u0006\u03a4\u0003\u03a8\u0003\u03b5\u0003\u03b6\u0003?\u0007?\u0007?\u0002?\u0002?\u0001?\u0002?\u0002?\u0004?\u0004?\u0002?\u0003?\u0007".charAt(i + 1);
        }
        return 0;
    }

    public static short getFamily(int n) {
        return DB.getFamily(DB.getCodePage(n));
    }

    public static int getCountryCode(int n) {
        if (!DB.isKindOfRegionalLocale(n)) {
            return 1;
        }
        if (DB.isKnownRegionalLocale(n)) {
            short s = (short)((n & 0x3FF800) >> 11);
            String string = "&],\u0163\u009a\u00d5$\u0178/\u00f4)\u03291\u02a0'\u010c26-\u01767\u01295=4+:\u03e2S\u00f2H\u03cdD\u0370B\u00f6Y\u0177E Z\u01f5J\u00e5M\u0329T\u03cfO\u024fA\u0183W\u010bR7\u02c7\u011cN\u02a1G\u0167F\u00e2I\u0101\u0283\u0289\u0168\u0357m\u00eda\u0002v\u00ee\u0462\u0001\u0179\u0159f\u00ec\u0284\u00ebl8nVx\u02a0c\u02a0o9\u016d\u010dg\u00f2d\u00f3\u0352\u00f3k\u02aar\u01fa\u0112\u0181u5y\u0165z\u01a4\u00ba\u01a4\u008b-\u008a\u00fd\u008d\u02ff\u008f\u0329\u00a3\u0251\u00a7\u0014\u0276\u01f7\u00f1\u00f0\u00b2\u0123\u00a5\u0174\u00b4\u00fb\u00cb\u01f4\u00cf\u012a\u00ca\u02a7\u00c9\u0166\u00d2!\u00e6\u0252\u0206\u02b1\u00e1\u00f1\u00ed\u00dc\u00e5\u03e3\u00851\u00e8\u00e9\u00e9\u015e\u00f2\u001e\u00ec\u012b\u00e4\u01d9\u00f0\u024e\u00f5\u029f\u00f4\u01f6\u00ee\u00e0\u00f7\u00f5\u00f9\u0250\u0114\u01fd\u02c1'\u010e\u01f8\u010b\u0354\u0115$\u0133\u0162\u012e[\u0124>\u0132b\u0131\u03c4\u0125\u0161\u012c\u03cc\u0134'\u014d\u036c\u0150Q\u014f\u03c2\u017a\u0007\u0165\u00fe\u0169\u02ae\u0177\u03c5\u0167\u03e4\u0181\u0358\u0196\u0173\u0182\u03c1\u0193\u010a\u0192\u00e7\u0199\u00da\u0189)\u0194\u0172\u0195\u0160\u01af\u0355\u01ab\u0185\u01a7\u0105\u01b7\u0109\u01b9<\u01b6\u03c0\u01ac\u00df\u01b4\u0164\u01a8\u02b4\u01b1\u0254\u01b2\u00de\u01b5\u00e6\u0334\u010d\u01b84\u00cd\u02b3\u01a4\u0175\u01a3\u0179\u01ae\u03d0\u01b3\u0298\u01a1\u00d4\u01ba\u0102\u01ad_\u01c1\u0108\u01d2\u02a2\u01d0\u03d1\u01cc\u001f.\u0257\u01c3\u02af\u01da@\u01c9\u01f9\u01c5\u00e3\u01c7\u00ea\u01d5\u02ab\u01c6\u02a0\u0170\u0352\u01cf/\u01ed\u03c8\u020b\\\u0217\u02a8\u0201\u01fb\u0207\u02a3\u0219\u0253\u02053\u0208?\u020c0\u0214\u015f\u0212\u0313\u0221\u03ce\u0245\u0106\u024f(\u0255\u0007\u0257\u00fa\u016e\u0365\u0183\u02f6\u020d\u01fc\u02c3\u03103\u02ac\u02f3\u02ad\u026d\u017a\u0274\u00ef\u0261\u03c6\u026e\u00dd\u0263\u00f8\u026c\u00e8\u0267A\u026b\u01a5\u0269\u0182\u0262\u02a5\u026f\u00fc\u0341\u001b\u0172R\u00b3\"\u018b^\u0264\u00f9\u0272\u0255\u027a\u010c\u0265.h)\u0279\u03c3\u0297\u0376\u028a\u0007\u029a\u00ff\u0281\u0007\u0288B\u0287\u00e4\u028b\u02b2\u028f\u02a4\u0294\u0364\u028e\u00d8\u0292Z\u028d\u03e1\u0296\u02b0\u02a7\u0100\u02a1\u017c%\u03cb\u00e2,\u02b3\u0001\u02b9\u0256\u02ad\u0001\u02c9\u0154\u02ba\u0007\u02d5\u02a6\u02c5:\u02ceT\u02e6\u02a9\u0325\u03c7\u0335\u017d\u034d\u0104\u0357\u0107";
            for (int i = 0; i < "&],\u0163\u009a\u00d5$\u0178/\u00f4)\u03291\u02a0'\u010c26-\u01767\u01295=4+:\u03e2S\u00f2H\u03cdD\u0370B\u00f6Y\u0177E Z\u01f5J\u00e5M\u0329T\u03cfO\u024fA\u0183W\u010bR7\u02c7\u011cN\u02a1G\u0167F\u00e2I\u0101\u0283\u0289\u0168\u0357m\u00eda\u0002v\u00ee\u0462\u0001\u0179\u0159f\u00ec\u0284\u00ebl8nVx\u02a0c\u02a0o9\u016d\u010dg\u00f2d\u00f3\u0352\u00f3k\u02aar\u01fa\u0112\u0181u5y\u0165z\u01a4\u00ba\u01a4\u008b-\u008a\u00fd\u008d\u02ff\u008f\u0329\u00a3\u0251\u00a7\u0014\u0276\u01f7\u00f1\u00f0\u00b2\u0123\u00a5\u0174\u00b4\u00fb\u00cb\u01f4\u00cf\u012a\u00ca\u02a7\u00c9\u0166\u00d2!\u00e6\u0252\u0206\u02b1\u00e1\u00f1\u00ed\u00dc\u00e5\u03e3\u00851\u00e8\u00e9\u00e9\u015e\u00f2\u001e\u00ec\u012b\u00e4\u01d9\u00f0\u024e\u00f5\u029f\u00f4\u01f6\u00ee\u00e0\u00f7\u00f5\u00f9\u0250\u0114\u01fd\u02c1'\u010e\u01f8\u010b\u0354\u0115$\u0133\u0162\u012e[\u0124>\u0132b\u0131\u03c4\u0125\u0161\u012c\u03cc\u0134'\u014d\u036c\u0150Q\u014f\u03c2\u017a\u0007\u0165\u00fe\u0169\u02ae\u0177\u03c5\u0167\u03e4\u0181\u0358\u0196\u0173\u0182\u03c1\u0193\u010a\u0192\u00e7\u0199\u00da\u0189)\u0194\u0172\u0195\u0160\u01af\u0355\u01ab\u0185\u01a7\u0105\u01b7\u0109\u01b9<\u01b6\u03c0\u01ac\u00df\u01b4\u0164\u01a8\u02b4\u01b1\u0254\u01b2\u00de\u01b5\u00e6\u0334\u010d\u01b84\u00cd\u02b3\u01a4\u0175\u01a3\u0179\u01ae\u03d0\u01b3\u0298\u01a1\u00d4\u01ba\u0102\u01ad_\u01c1\u0108\u01d2\u02a2\u01d0\u03d1\u01cc\u001f.\u0257\u01c3\u02af\u01da@\u01c9\u01f9\u01c5\u00e3\u01c7\u00ea\u01d5\u02ab\u01c6\u02a0\u0170\u0352\u01cf/\u01ed\u03c8\u020b\\\u0217\u02a8\u0201\u01fb\u0207\u02a3\u0219\u0253\u02053\u0208?\u020c0\u0214\u015f\u0212\u0313\u0221\u03ce\u0245\u0106\u024f(\u0255\u0007\u0257\u00fa\u016e\u0365\u0183\u02f6\u020d\u01fc\u02c3\u03103\u02ac\u02f3\u02ad\u026d\u017a\u0274\u00ef\u0261\u03c6\u026e\u00dd\u0263\u00f8\u026c\u00e8\u0267A\u026b\u01a5\u0269\u0182\u0262\u02a5\u026f\u00fc\u0341\u001b\u0172R\u00b3\"\u018b^\u0264\u00f9\u0272\u0255\u027a\u010c\u0265.h)\u0279\u03c3\u0297\u0376\u028a\u0007\u029a\u00ff\u0281\u0007\u0288B\u0287\u00e4\u028b\u02b2\u028f\u02a4\u0294\u0364\u028e\u00d8\u0292Z\u028d\u03e1\u0296\u02b0\u02a7\u0100\u02a1\u017c%\u03cb\u00e2,\u02b3\u0001\u02b9\u0256\u02ad\u0001\u02c9\u0154\u02ba\u0007\u02d5\u02a6\u02c5:\u02ceT\u02e6\u02a9\u0325\u03c7\u0335\u017d\u034d\u0104\u0357\u0107".length(); i += 2) {
                if (s != (short)"&],\u0163\u009a\u00d5$\u0178/\u00f4)\u03291\u02a0'\u010c26-\u01767\u01295=4+:\u03e2S\u00f2H\u03cdD\u0370B\u00f6Y\u0177E Z\u01f5J\u00e5M\u0329T\u03cfO\u024fA\u0183W\u010bR7\u02c7\u011cN\u02a1G\u0167F\u00e2I\u0101\u0283\u0289\u0168\u0357m\u00eda\u0002v\u00ee\u0462\u0001\u0179\u0159f\u00ec\u0284\u00ebl8nVx\u02a0c\u02a0o9\u016d\u010dg\u00f2d\u00f3\u0352\u00f3k\u02aar\u01fa\u0112\u0181u5y\u0165z\u01a4\u00ba\u01a4\u008b-\u008a\u00fd\u008d\u02ff\u008f\u0329\u00a3\u0251\u00a7\u0014\u0276\u01f7\u00f1\u00f0\u00b2\u0123\u00a5\u0174\u00b4\u00fb\u00cb\u01f4\u00cf\u012a\u00ca\u02a7\u00c9\u0166\u00d2!\u00e6\u0252\u0206\u02b1\u00e1\u00f1\u00ed\u00dc\u00e5\u03e3\u00851\u00e8\u00e9\u00e9\u015e\u00f2\u001e\u00ec\u012b\u00e4\u01d9\u00f0\u024e\u00f5\u029f\u00f4\u01f6\u00ee\u00e0\u00f7\u00f5\u00f9\u0250\u0114\u01fd\u02c1'\u010e\u01f8\u010b\u0354\u0115$\u0133\u0162\u012e[\u0124>\u0132b\u0131\u03c4\u0125\u0161\u012c\u03cc\u0134'\u014d\u036c\u0150Q\u014f\u03c2\u017a\u0007\u0165\u00fe\u0169\u02ae\u0177\u03c5\u0167\u03e4\u0181\u0358\u0196\u0173\u0182\u03c1\u0193\u010a\u0192\u00e7\u0199\u00da\u0189)\u0194\u0172\u0195\u0160\u01af\u0355\u01ab\u0185\u01a7\u0105\u01b7\u0109\u01b9<\u01b6\u03c0\u01ac\u00df\u01b4\u0164\u01a8\u02b4\u01b1\u0254\u01b2\u00de\u01b5\u00e6\u0334\u010d\u01b84\u00cd\u02b3\u01a4\u0175\u01a3\u0179\u01ae\u03d0\u01b3\u0298\u01a1\u00d4\u01ba\u0102\u01ad_\u01c1\u0108\u01d2\u02a2\u01d0\u03d1\u01cc\u001f.\u0257\u01c3\u02af\u01da@\u01c9\u01f9\u01c5\u00e3\u01c7\u00ea\u01d5\u02ab\u01c6\u02a0\u0170\u0352\u01cf/\u01ed\u03c8\u020b\\\u0217\u02a8\u0201\u01fb\u0207\u02a3\u0219\u0253\u02053\u0208?\u020c0\u0214\u015f\u0212\u0313\u0221\u03ce\u0245\u0106\u024f(\u0255\u0007\u0257\u00fa\u016e\u0365\u0183\u02f6\u020d\u01fc\u02c3\u03103\u02ac\u02f3\u02ad\u026d\u017a\u0274\u00ef\u0261\u03c6\u026e\u00dd\u0263\u00f8\u026c\u00e8\u0267A\u026b\u01a5\u0269\u0182\u0262\u02a5\u026f\u00fc\u0341\u001b\u0172R\u00b3\"\u018b^\u0264\u00f9\u0272\u0255\u027a\u010c\u0265.h)\u0279\u03c3\u0297\u0376\u028a\u0007\u029a\u00ff\u0281\u0007\u0288B\u0287\u00e4\u028b\u02b2\u028f\u02a4\u0294\u0364\u028e\u00d8\u0292Z\u028d\u03e1\u0296\u02b0\u02a7\u0100\u02a1\u017c%\u03cb\u00e2,\u02b3\u0001\u02b9\u0256\u02ad\u0001\u02c9\u0154\u02ba\u0007\u02d5\u02a6\u02c5:\u02ceT\u02e6\u02a9\u0325\u03c7\u0335\u017d\u034d\u0104\u0357\u0107".charAt(i)) continue;
                return "&],\u0163\u009a\u00d5$\u0178/\u00f4)\u03291\u02a0'\u010c26-\u01767\u01295=4+:\u03e2S\u00f2H\u03cdD\u0370B\u00f6Y\u0177E Z\u01f5J\u00e5M\u0329T\u03cfO\u024fA\u0183W\u010bR7\u02c7\u011cN\u02a1G\u0167F\u00e2I\u0101\u0283\u0289\u0168\u0357m\u00eda\u0002v\u00ee\u0462\u0001\u0179\u0159f\u00ec\u0284\u00ebl8nVx\u02a0c\u02a0o9\u016d\u010dg\u00f2d\u00f3\u0352\u00f3k\u02aar\u01fa\u0112\u0181u5y\u0165z\u01a4\u00ba\u01a4\u008b-\u008a\u00fd\u008d\u02ff\u008f\u0329\u00a3\u0251\u00a7\u0014\u0276\u01f7\u00f1\u00f0\u00b2\u0123\u00a5\u0174\u00b4\u00fb\u00cb\u01f4\u00cf\u012a\u00ca\u02a7\u00c9\u0166\u00d2!\u00e6\u0252\u0206\u02b1\u00e1\u00f1\u00ed\u00dc\u00e5\u03e3\u00851\u00e8\u00e9\u00e9\u015e\u00f2\u001e\u00ec\u012b\u00e4\u01d9\u00f0\u024e\u00f5\u029f\u00f4\u01f6\u00ee\u00e0\u00f7\u00f5\u00f9\u0250\u0114\u01fd\u02c1'\u010e\u01f8\u010b\u0354\u0115$\u0133\u0162\u012e[\u0124>\u0132b\u0131\u03c4\u0125\u0161\u012c\u03cc\u0134'\u014d\u036c\u0150Q\u014f\u03c2\u017a\u0007\u0165\u00fe\u0169\u02ae\u0177\u03c5\u0167\u03e4\u0181\u0358\u0196\u0173\u0182\u03c1\u0193\u010a\u0192\u00e7\u0199\u00da\u0189)\u0194\u0172\u0195\u0160\u01af\u0355\u01ab\u0185\u01a7\u0105\u01b7\u0109\u01b9<\u01b6\u03c0\u01ac\u00df\u01b4\u0164\u01a8\u02b4\u01b1\u0254\u01b2\u00de\u01b5\u00e6\u0334\u010d\u01b84\u00cd\u02b3\u01a4\u0175\u01a3\u0179\u01ae\u03d0\u01b3\u0298\u01a1\u00d4\u01ba\u0102\u01ad_\u01c1\u0108\u01d2\u02a2\u01d0\u03d1\u01cc\u001f.\u0257\u01c3\u02af\u01da@\u01c9\u01f9\u01c5\u00e3\u01c7\u00ea\u01d5\u02ab\u01c6\u02a0\u0170\u0352\u01cf/\u01ed\u03c8\u020b\\\u0217\u02a8\u0201\u01fb\u0207\u02a3\u0219\u0253\u02053\u0208?\u020c0\u0214\u015f\u0212\u0313\u0221\u03ce\u0245\u0106\u024f(\u0255\u0007\u0257\u00fa\u016e\u0365\u0183\u02f6\u020d\u01fc\u02c3\u03103\u02ac\u02f3\u02ad\u026d\u017a\u0274\u00ef\u0261\u03c6\u026e\u00dd\u0263\u00f8\u026c\u00e8\u0267A\u026b\u01a5\u0269\u0182\u0262\u02a5\u026f\u00fc\u0341\u001b\u0172R\u00b3\"\u018b^\u0264\u00f9\u0272\u0255\u027a\u010c\u0265.h)\u0279\u03c3\u0297\u0376\u028a\u0007\u029a\u00ff\u0281\u0007\u0288B\u0287\u00e4\u028b\u02b2\u028f\u02a4\u0294\u0364\u028e\u00d8\u0292Z\u028d\u03e1\u0296\u02b0\u02a7\u0100\u02a1\u017c%\u03cb\u00e2,\u02b3\u0001\u02b9\u0256\u02ad\u0001\u02c9\u0154\u02ba\u0007\u02d5\u02a6\u02c5:\u02ceT\u02e6\u02a9\u0325\u03c7\u0335\u017d\u034d\u0104\u0357\u0107".charAt(i + 1);
            }
        }
        return 0;
    }

    public static synchronized void setDefaultLocaleInfoFactory() {
        if (s_localeInfoFactory == null) {
            s_localeInfoFactory = new FB();
        }
    }

    public static double getFontScale(int n) {
        return s_localeInfoFactory.getFontScale(n);
    }

    public static String getUIFont(int n) {
        return s_localeInfoFactory.getUIFont(n);
    }

    public static String getDocFontSansSerif(int n) {
        return s_localeInfoFactory.getDocFontSansSerif(n);
    }

    public static String[] getDocFontListSerif(int n) {
        return s_localeInfoFactory.getDocFontListSerif(n);
    }

    public static String[] getDocFontListSansSerif(int n) {
        return s_localeInfoFactory.getDocFontListSansSerif(n);
    }

    public static E getBasicLocaleInfo(CC cC, int n, int n2) {
        return s_localeInfoFactory.getBasicLocaleInfo(cC, n, n2);
    }

    public static E getBasicLocaleInfo(CC cC, int n) {
        return DB.getBasicLocaleInfo(cC, n, n);
    }

    public static E getBasicLocaleInfo(CC cC) {
        return DB.getBasicLocaleInfo(cC, cC.getFormatLocale(), cC.getUILocale());
    }

    public static KZ getExtendedLocaleInfo(CC cC, int n, int n2) {
        return s_localeInfoFactory.getExtendedLocaleInfo(cC, n, n2);
    }

    public static OJ getStringComparator(CC cC, int n, int n2) {
        return s_localeInfoFactory.getStringComparator(cC, n, n2);
    }

    public static OJ getStringComparator(CC cC) {
        return DB.getStringComparator(cC, cC.getFormatLocale(), cC.getUILocale());
    }

    public static IS getTextConverter(short s) {
        return s_localeInfoFactory.getTextConverter(DB.normalizeCodePage(s));
    }

    public static IS getTextConverter(CC cC) {
        return s_localeInfoFactory.getTextConverter(DB.getCodePage(cC.getUILocale()));
    }

    public static short[] getSupportedCodePages() {
        short[] sArray = new short[]{1201, 1200, -535, 1250, 1251, 1252, 1253, 1254, 1255, 1256, 1257, 1258, 1361, 874, 932, 936, 949, 950};
        return sArray;
    }

    public static int getDefault() {
        return s_localeInfoFactory.getDefault();
    }

    public static E getDefaultBasicLocaleInfo() {
        return DB.getBasicLocaleInfo(null, 0, 0);
    }

    public static OJ getDefaultStringComparator() {
        return DB.getStringComparator(null, 0, 0);
    }
}

