/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.tools.processTools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ProcessUtils {
    private static final String TASKLIST = "tasklist";
    public static final Integer RETRY_NUMBER = 5;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isProcessRunging(String serviceName) {
        try {
            String line;
            Process p = Runtime.getRuntime().exec(TASKLIST);
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            do {
                if ((line = reader.readLine()) != null) continue;
                return false;
            } while (!line.toUpperCase().contains(serviceName.toUpperCase()));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void runProcess(String folder, String processName) throws IOException {
        int i = 0;
        i = 0;
        while (i < RETRY_NUMBER) {
            Runtime.getRuntime().exec(String.valueOf(folder) + processName);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (ProcessUtils.isProcessRunging(processName)) break;
            ++i;
        }
        if (i == RETRY_NUMBER) {
            throw new IOException("Nije Moguce pokrenuti aplikaciju.");
        }
    }

    public static void endProcess(String processName) throws IOException {
        int i = 0;
        i = 0;
        while (i < RETRY_NUMBER) {
            Runtime.getRuntime().exec("taskkill /IM " + processName);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (!ProcessUtils.isProcessRunging(processName)) break;
            ++i;
        }
        if (i == RETRY_NUMBER) {
            throw new IOException("Nije moguce ugasiti aplikaciju.");
        }
    }
}

