/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.widget.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import rs.pezar.db.entity.Radnomesto;
import rs.pezar.msg.PzExtensionLoader;
import rs.pezar.msg.msg.MsgProtocol;
import rs.pezar.msg.msg.control.OnlineUserData;
import rs.pezar.msg.widget.panel.PnlKorisnik;
import rs.pezar.msg.widget.panel.pnlDostupniKorisnici.PnlActionIcons;
import rs.pezar.swing.PzPanel;

public class PnlDostupniKorisnici
extends PzPanel {
    private static final Integer REFRESH_SECONDS = 10000;
    private Vector<PnlKorisnik> pnlPool = new Vector();
    PnlKorisnik header;
    private Timer timerRefresher;
    private TimerTask timerTask;
    private JList list;

    public PnlDostupniKorisnici() {
        this.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportBorder(new EmptyBorder(1, 1, 1, 1));
        this.add(scrollPane, "Center");
        this.list = new JList();
        scrollPane.setViewportView(this.list);
        this.list.setModel(new DefaultListModel());
        this.list.setCellRenderer(new FocusedTitleListCellRenderer());
        String user = String.valueOf(PzExtensionLoader.getInstance().getApplication().getSession().getLoggedUser().getPzusername()) + "(" + PzExtensionLoader.getInstance().getApplication().getSession().getLoggedUser().getIme() + PzExtensionLoader.getInstance().getApplication().getSession().getLoggedUser().getPrezime() + ")";
        Radnomesto radnoMesto = PzExtensionLoader.getInstance().getApplication().getSession().getLoggedUser().getRadnoMesto();
        String position = radnoMesto != null ? radnoMesto.getNaziv() : "";
        this.list.addMouseListener(new ActionJList());
        this.list.addKeyListener(new EnterJLlist());
        PnlKorisnik pnlKorisnik_1 = new PnlKorisnik(null, true);
        pnlKorisnik_1.setMinimumSize(new Dimension(10, 10));
        pnlKorisnik_1.setUserName(user);
        pnlKorisnik_1.setPosition(position);
        this.add((Component)((Object)pnlKorisnik_1), "North");
        this.header = pnlKorisnik_1;
        this.pnlPool.add(pnlKorisnik_1);
        PnlActionIcons pnlAlati = new PnlActionIcons();
        this.add((Component)((Object)pnlAlati), "South");
    }

    public void updateUser(PnlKorisnik pnlKorisnik) {
        int i = 0;
        while (i < this.pnlPool.size()) {
            if (this.pnlPool.get(i).getUserName().equals(pnlKorisnik.getUserName())) {
                this.pnlPool.get(i).setStatus(pnlKorisnik.getStatus());
                this.pnlPool.get(i).setUserQueue(pnlKorisnik.getUserQueue());
                this.pnlPool.get(i).setDevices(pnlKorisnik.getDevices());
                this.pnlPool.get(i).setActions(pnlKorisnik.getActions());
                this.pnlPool.get(i).setCompany(pnlKorisnik.getCompany());
                this.pnlPool.get(i).setRemoteId(pnlKorisnik.getRemoteId());
                return;
            }
            ++i;
        }
        this.pnlPool.add(pnlKorisnik);
        ((DefaultListModel)this.list.getModel()).addElement(pnlKorisnik);
    }

    public void init() {
        this.timerRefresher = new Timer();
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                PnlDostupniKorisnici.this.refresher();
            }
        };
        this.timerRefresher.schedule(this.timerTask, 0L, (long)REFRESH_SECONDS.intValue());
    }

    private void refresher() {
        Vector<Object> onlineUsers = new Vector();
        try {
            MsgProtocol msgProtocol = PzExtensionLoader.getInstance().getMsgProtocol();
            if (msgProtocol != null) {
                onlineUsers = msgProtocol.getControl().getOnlineUsers();
            } else {
                this.header.setStatus("O");
                int i = 0;
                while (i < this.pnlPool.size()) {
                    this.pnlPool.get(i).setStatus("O");
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
        int i = 0;
        while (i < onlineUsers.size()) {
            PnlKorisnik korisnik = new PnlKorisnik(this.pnlPool, false);
            korisnik.setUserName(((OnlineUserData)onlineUsers.get(i)).getName());
            korisnik.setPosition(((OnlineUserData)onlineUsers.get(i)).getPosition());
            korisnik.setStatus(((OnlineUserData)onlineUsers.get(i)).getState());
            korisnik.setUserQueue(((OnlineUserData)onlineUsers.get(i)).getQueue());
            korisnik.setActions(((OnlineUserData)onlineUsers.get(i)).getActions());
            korisnik.setDevices(((OnlineUserData)onlineUsers.get(i)).getDevices());
            korisnik.setCompany(((OnlineUserData)onlineUsers.get(i)).getCompany());
            korisnik.setRemoteId(((OnlineUserData)onlineUsers.get(i)).getRemoteID());
            this.updateUser(korisnik);
            ++i;
        }
        this.repaint();
    }

    class ActionJList
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            int index = PnlDostupniKorisnici.this.list.locationToIndex(e.getPoint());
            if (index == -1) {
                return;
            }
            ListModel dlm = PnlDostupniKorisnici.this.list.getModel();
            PnlKorisnik item = (PnlKorisnik)((Object)dlm.getElementAt(index));
            item.getClickAdapter().mouseClicked(e);
        }
    }

    class EnterJLlist
    extends KeyAdapter {
        @Override
        public void keyReleased(KeyEvent ke) {
            if (ke.getKeyCode() == 10) {
                ((PnlKorisnik)((Object)((JList)ke.getSource()).getSelectedValue())).onDoubleClicked();
            }
        }
    }

    class FocusedTitleListCellRenderer
    implements ListCellRenderer {
        FocusedTitleListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ((PnlKorisnik)((Object)value)).setSelected(cellHasFocus);
            JPanel temp = (JPanel)value;
            return temp;
        }
    }
}

