/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.engine.sifreKnjizenja;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import rs.pezar.db.PzDokument;
import rs.pezar.db.entity.Uplata;
import rs.pezar.finansije.engine.sifreKnjizenja.manager.UplataManager;

public class ManagerLoader {
    public static String getSfrByTip(String tip) throws ConfigurationException {
        XMLConfiguration conf = new XMLConfiguration(ManagerLoader.class.getClassLoader().getResource("rs/pezar/finansije/resource/akcije.xml"));
        conf.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        return (String)conf.getProperty("//akcija[@tip='" + tip + "']/@sfr");
    }

    public static UplataManager getManagerByTip(String tip) throws ConfigurationException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        UplataManager m = null;
        XMLConfiguration conf = new XMLConfiguration(ManagerLoader.class.getClassLoader().getResource("rs/pezar/finansije/resource/akcije.xml"));
        conf.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        String cname = (String)conf.getProperty("//akcija[@tip='" + tip + "']/@manager");
        if (cname == null) {
            return m;
        }
        m = (UplataManager)Class.forName(cname).getConstructor(PzDokument.class, Uplata.class).newInstance(null, null);
        return m;
    }

    public static UplataManager getManagerBySfr(String sfr) throws ConfigurationException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        UplataManager m = null;
        XMLConfiguration conf = new XMLConfiguration(ManagerLoader.class.getClassLoader().getResource("rs/pezar/finansije/resource/akcije.xml"));
        conf.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        String cname = (String)conf.getProperty("//akcija[@sfr='" + sfr + "']/@manager");
        if (cname == null) {
            return m;
        }
        m = (UplataManager)Class.forName(cname).getConstructor(PzDokument.class, Uplata.class).newInstance(null, null);
        return m;
    }

    public static void main(String[] args) throws ConfigurationException {
        System.out.println(ManagerLoader.getSfrByTip("UPLATA_KUPCA"));
    }
}

