/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.engine.sifreKnjizenja.manager;

import java.math.BigDecimal;
import javax.persistence.EntityManager;
import rs.pezar.db.PzDokument;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Stavkanzk;
import rs.pezar.db.entity.Uplata;
import rs.pezar.finansije.engine.sifreKnjizenja.manager.UplataManager;

public class StornoRacunaDobavljacaManager
extends UplataManager {
    public static final String STORNO_IZNOS = "STORNO_IZNOS";

    public StornoRacunaDobavljacaManager(PzDokument dokument, Uplata uplata) {
        super(dokument, uplata);
    }

    @Override
    public void doInTransaction(EntityManager em) {
        Kalkulacija r = (Kalkulacija)em.find(Kalkulacija.class, (Object)this.getDokument().getIdDok());
        r.setStornoIznos(r.getStornoIznos().add((BigDecimal)this.getValue(STORNO_IZNOS)));
    }

    @Override
    public void reverse(EntityManager em, Stavkanzk stavka) {
        Kalkulacija storno = (Kalkulacija)em.find(Kalkulacija.class, (Object)stavka.getDokument().getIdDok());
        Kalkulacija original = (Kalkulacija)em.find(Kalkulacija.class, (Object)storno.getOriginal().getIdDok());
        original.setStornoIznos(original.getStornoIznos().subtract(storno.getIznos()));
    }
}

