/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRException;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Nzk;
import rs.pezar.finansije.PzExtensionLoader;
import rs.pezar.finansije.gui.PzDialogVracanjeNalogaUPripremu;
import rs.pezar.finansije.gui.util.Tools;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogBrisanjeDokumentaSaNaloga
extends PzDialog {
    private static final long serialVersionUID = -3207000022957737605L;
    private PzPanel mainPanel;
    private PzButton btnOk;
    private PzNumericOnlyTextField idDokumenta;
    private JLabel jLabel1;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogVracanjeNalogaUPripremu inst = new PzDialogVracanjeNalogaUPripremu(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogBrisanjeDokumentaSaNaloga(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogBrisanjeDokumentaSaNaloga(PzDialog frame) {
        super(frame);
        this.initGUI();
    }

    protected void initGUI() {
        try {
            BorderLayout bLayout = new BorderLayout();
            this.setLayout(bLayout);
            this.setTitle("Uklanjanje dokumenta sa naloga");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            mainPanelLayout.columnWidths = new int[]{118, 123, 20};
            mainPanelLayout.rowHeights = new int[]{21, 25, 7, 20};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 1.0, 0.1};
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.btnOk = new PzButton();
            this.mainPanel.add((Component)this.btnOk, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOk.setText("OK");
            this.btnOk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/check.png")));
            this.btnOk.setActionCommand("OK");
            this.btnOk.addActionListener((ActionListener)((Object)this));
            this.jLabel1 = new JLabel();
            this.mainPanel.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel1.setText("Id dokumenta:");
            this.idDokumenta = new PzNumericOnlyTextField();
            this.mainPanel.add((Component)this.idDokumenta, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.idDokumenta.setPreferredSize(new Dimension(80, 25));
            this.idDokumenta.setFont(new Font("Tahoma", 0, 14));
            this.pack();
            this.setResizable(false);
            this.setRestorable(false);
            this.setSize(342, 152);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = ((PzButton)e.getSource()).getActionCommand();
        if (actionCommand.equals("OK")) {
            if (this.idDokumenta.getText().equals("")) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Uneseite identifikacioni broj dokumenta!");
                return;
            }
            Integer idDok = this.idDokumenta.getIntVal();
            EntityManager em = PzEntityManagerFactory.getInstance().createEm();
            Dokument dok = (Dokument)em.find(Dokument.class, (Object)idDok);
            if (dok == null) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Ne postoji dokumenta sa unetim id brojem!");
                return;
            }
            if (dok.getProknjizen() == 0) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Dokument nije proknji\u017een. Dalji rad nemogu\u0107!");
                return;
            }
            em.getTransaction().begin();
            Integer idNalog = (Integer)em.createQuery("Select DISTINCT(nzk.idNalog) From Nzk nzk, Stavkanzk stavka Where nzk.idNalog = stavka.id.idNalog and stavka.dokument.idDok='" + idDok + "'").getSingleResult();
            em.createQuery("Delete From Stavkanzk where dokument.idDok='" + idDok + "'").executeUpdate();
            dok.setProknjizen((short)0);
            dok.getKonkretanDokument().setProknjizen((short)0);
            dok.getKonkretanDokument().createLog(10, null, PzExtensionLoader.getLoggedUser(), em);
            Nzk nalog = (Nzk)em.find(Nzk.class, (Object)idNalog);
            BigDecimal duguje = nalog.getDugujeSum();
            BigDecimal potrazuje = nalog.getPotrazujeSum();
            if (nalog.getStavkanzks().size() == 0) {
                nalog.setArhiviran(Integer.valueOf(0));
                PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Nalog je vra\u0107en u pripremu");
            }
            if (duguje.compareTo(potrazuje) != 0) {
                if (nalog.getArhiviran() == 1) {
                    nalog.setArhiviran(Integer.valueOf(0));
                    PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Nalog nije u ravnote\u017ei. Nalog je vra\u0107en u pripremu");
                } else {
                    PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Nalog nije u ravnote\u017ei.");
                }
            }
            em.getTransaction().commit();
            try {
                if (nalog.getStavkanzks().size() != 0) {
                    Tools.prikaziIzvestaj(nalog, this, false);
                }
            }
            catch (JRException e1) {
                PzMysqlExceptionHandler.handle((Throwable)e1);
            }
            catch (Exception e1) {
                PzMysqlExceptionHandler.handle((Throwable)e1);
            }
            em.close();
            this.dispose();
        }
    }
}

