/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.entity.Dokument;
import rs.pezar.finansije.engine.DokumentCompilerException;
import rs.pezar.finansije.gui.PzDialogPotvrdiKnjizenje;
import rs.pezar.finansije.gui.izRobnogUFinansijsko.PzDialogFilter;
import rs.pezar.finansije.gui.util.DBManager;
import rs.pezar.finansije.gui.util.Tools;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class PzDialogIzRobnogUFinansijsko
extends PzDialog {
    private static final long serialVersionUID = -7745443644331406254L;
    private JPanel pnlTable;
    private PzToolBarIcon icnKnjizenje;
    private PzToolBarIcon icnTest;
    private PzTable table;
    private JScrollPane scp;
    private JPanel content;
    private JToolBar toolbar;
    private List<Dokument> dokumenti;
    private PzToolBarIcon icnFilter;
    private HashMap<String, Object> filter = null;
    private JPanel pnlSelect;
    private PzButton icnSelektuj;
    private PzButton icnSelektujSve;
    private PzButton icnDeselektujSve;
    private PzButton icnInverznaSelekcija;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel("");
    private PzToolBarIcon icnSlika;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogIzRobnogUFinansijsko inst = new PzDialogIzRobnogUFinansijsko(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogIzRobnogUFinansijsko(JFrame frame) {
        super(frame);
        this.initGUI();
        this.scp.setViewportView((Component)this.table);
    }

    public PzDialogIzRobnogUFinansijsko(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Izbor knji\u017eenja");
            this.content = new JPanel();
            BorderLayout jPanel4Layout = new BorderLayout();
            this.content.setLayout(jPanel4Layout);
            this.getContentPane().add((Component)this.content, "Center");
            this.toolbar = new JToolBar();
            this.content.add((Component)this.toolbar, "North");
            this.pnlTable = new JPanel();
            this.content.add((Component)this.pnlTable, "Center");
            GridBagLayout gbl_pnlTable = new GridBagLayout();
            gbl_pnlTable.rowWeights = new double[]{0.0, 1.0, 0.0};
            gbl_pnlTable.columnWeights = new double[]{1.0};
            gbl_pnlTable.rowHeights = new int[]{7, 308, 37};
            gbl_pnlTable.columnWidths = new int[]{433};
            this.pnlTable.setLayout(gbl_pnlTable);
            this.scp = new JScrollPane();
            GridBagConstraints gbc_scp = new GridBagConstraints();
            gbc_scp.insets = new Insets(0, 10, 10, 10);
            gbc_scp.fill = 1;
            gbc_scp.gridx = 0;
            gbc_scp.gridy = 1;
            this.table = new PzTable();
            this.table.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Dokument dok = (Dokument)entity;
                    return new Object[]{TipDokumentConfig.getNameByValue((String)dok.getTip(), null), dok.getOpis(), dok.getOznDokumenta(), dok.getRadnajedinica() != null ? dok.getRadnajedinica().getId().getOznRj() : "", dok.getKomitent() != null ? dok.getKomitent().getNaziv() : "", dok.getDatum(), dok.getDatPrometa(), dok.getIdDok()};
                }

                public String[] getColumnNames() {
                    return new String[]{"Vrsta dokumenta", "Opis", "Oznaka dokumenta", "RJ", "Komitent", "Datum dokumenta", "Datum prometa", "ID"};
                }
            });
            this.pnlTable.add((Component)this.scp, new GridBagConstraints(0, 1, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.icnKnjizenje = new PzToolBarIcon();
            this.icnKnjizenje.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzDialogIzRobnogUFinansijsko.this.akcijaKnjizenje();
                }
            });
            this.icnKnjizenje.setIcon((Icon)new ImageIcon(PzDialogIzRobnogUFinansijsko.class.getResource("/rs/pezar/finansije/gui/resources/img/magic-wand.png")));
            this.icnKnjizenje.setText("Knji\u017eenje|(ctrl+w)");
            this.toolbar.add((Component)this.icnKnjizenje);
            this.icnKnjizenje.setShortcut("CTRL+W");
            this.toolbar.add((Component)this.icnKnjizenje);
            this.icnTest = new PzToolBarIcon();
            this.icnTest.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    try {
                        PzDialogIzRobnogUFinansijsko.this.akcijaTest();
                    }
                    catch (DokumentCompilerException e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)PzDialogIzRobnogUFinansijsko.this), (Throwable)e);
                    }
                }
            });
            this.icnTest.setIcon((Icon)new ImageIcon(PzDialogIzRobnogUFinansijsko.class.getResource("/rs/pezar/finansije/gui/resources/img/magic-wand.png")));
            this.icnTest.setText("Probno|knji\u017eenje(alt+w)");
            this.icnTest.setShortcut("alt+w");
            this.toolbar.add((Component)this.icnTest);
            this.toolbar.add((Component)this.icnTest);
            this.icnSlika = new PzToolBarIcon();
            this.icnSlika.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    try {
                        PzDialogIzRobnogUFinansijsko.this.slikaDokumenta();
                    }
                    catch (DokumentCompilerException e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)PzDialogIzRobnogUFinansijsko.this), (Throwable)e);
                    }
                }
            });
            this.icnSlika.setIcon((Icon)new ImageIcon(PzDialogIzRobnogUFinansijsko.class.getResource("/rs/pezar/finansije/resource/img/presentation_chart.png")));
            this.icnSlika.setText("Slika|dokumenta(F3)");
            this.icnSlika.setShortcut("f3");
            this.toolbar.add((Component)this.icnSlika);
            this.toolbar.add((Component)this.icnSlika);
            this.icnFilter = new PzToolBarIcon();
            this.icnFilter.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    try {
                        PzDialogIzRobnogUFinansijsko.this.akcijaFilter();
                    }
                    catch (DokumentCompilerException e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)PzDialogIzRobnogUFinansijsko.this), (Throwable)e);
                    }
                }
            });
            this.icnFilter.setIcon((Icon)new ImageIcon(PzDialogIzRobnogUFinansijsko.class.getResource("/rs/pezar/finansije/gui/resources/img/funnel.png")));
            this.icnFilter.setText("Filter|(F4)");
            this.icnFilter.setShortcut("F4");
            this.toolbar.add((Component)this.icnFilter);
            this.toolbar.add((Component)this.icnFilter);
            this.pnlSelect = new JPanel();
            FlowLayout pnlSelectLayout = new FlowLayout();
            pnlSelectLayout.setAlignment(0);
            pnlSelectLayout.setVgap(2);
            this.pnlSelect.setLayout(pnlSelectLayout);
            this.toolbar.add(this.pnlSelect);
            this.pnlSelect.setPreferredSize(new Dimension(221, 113));
            this.pnlSelect.setOpaque(false);
            this.icnSelektuj = new PzButton();
            this.pnlSelect.add((Component)this.icnSelektuj);
            this.icnSelektuj.setText("Selektuj trenutni (f2)");
            this.icnSelektuj.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnSelektuj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/selektuj.png")));
            this.icnSelektuj.setPreferredSize(new Dimension(207, 24));
            this.icnSelektuj.setHorizontalAlignment(10);
            this.icnSelektuj.setFocusable(false);
            this.icnSelektuj.setOpaque(false);
            this.icnSelektuj.addActionListener((ActionListener)((Object)this));
            this.icnSelektujSve = new PzButton();
            this.pnlSelect.add((Component)this.icnSelektujSve);
            this.icnSelektujSve.setText("Selektuj sve (alt+f2)");
            this.icnSelektujSve.setOpaque(false);
            this.icnSelektujSve.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnSelektujSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/selection_sve.png")));
            this.icnSelektujSve.setPreferredSize(new Dimension(207, 24));
            this.icnSelektujSve.setHorizontalAlignment(10);
            this.icnSelektujSve.setFocusable(false);
            this.icnSelektujSve.addActionListener((ActionListener)((Object)this));
            this.icnDeselektujSve = new PzButton();
            this.pnlSelect.add((Component)this.icnDeselektujSve);
            this.icnDeselektujSve.setText("Deselektuj sve (ctrl+f2)");
            this.icnDeselektujSve.setOpaque(false);
            this.icnDeselektujSve.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnDeselektujSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/deselektuj_sve.png")));
            this.icnDeselektujSve.setPreferredSize(new Dimension(207, 24));
            this.icnDeselektujSve.setHorizontalAlignment(10);
            this.icnDeselektujSve.setFocusable(false);
            this.icnDeselektujSve.addActionListener((ActionListener)((Object)this));
            this.icnInverznaSelekcija = new PzButton();
            this.pnlSelect.add((Component)this.icnInverznaSelekcija);
            this.icnInverznaSelekcija.setText("Inverzna selekcija (ctrl+alt+f2)");
            this.icnInverznaSelekcija.setOpaque(false);
            this.icnInverznaSelekcija.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnInverznaSelekcija.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/selektuj inverzno.png")));
            this.icnInverznaSelekcija.setPreferredSize(new Dimension(208, 24));
            this.icnInverznaSelekcija.setHorizontalAlignment(10);
            this.icnInverznaSelekcija.setFocusable(false);
            this.icnInverznaSelekcija.addActionListener((ActionListener)((Object)this));
            this.statusBar = new PzStatusBar();
            this.content.add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("\tBroj dokumenata");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setSize(900, 600);
            this.setLocationRelativeTo(null);
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.icnSelektujSve) {
            this.table.checkAll();
        } else if (arg0.getSource() == this.icnDeselektujSve) {
            this.table.unCheckAll();
        } else if (arg0.getSource() == this.icnInverznaSelekcija) {
            this.table.inverseCheck();
        } else if (arg0.getSource() == this.icnSelektuj) {
            this.table.switchIt();
        }
    }

    public void instantiateTable() {
        try {
            this.dokumenti = DBManager.getDokumentiZaKnjizenjeImproved(this.filter);
            this.brDok.setText(String.valueOf(this.dokumenti.size()));
            this.table.setData(this.dokumenti, Dokument.class);
            this.table.setCheckboxColumn(0);
            this.table.setSelectionMode(1);
            if (this.table.getRowCount() != 0) {
                this.table.setRowSelectionInterval(0, 0);
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
    }

    public void akcijaKnjizenje() {
        this.knjizi(false);
    }

    public void akcijaOK() throws DokumentCompilerException {
    }

    public void slikaDokumenta() throws DokumentCompilerException {
        Dokument d;
        if ((double)this.table.getRowCount() != 0.0 && (d = (Dokument)this.table.getSelectedEntity()) != null) {
            PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)d);
        }
    }

    public void akcijaTest() throws DokumentCompilerException {
        this.knjizi(true);
    }

    public void akcijaFilter() throws DokumentCompilerException {
        this.filter = PzDialogFilter.getFilter(this);
        if (this.filter != null) {
            this.instantiateTable();
        }
    }

    private void knjizi(boolean test2) {
        if (this.table.getCheckedEntities().size() == 0) {
            return;
        }
        this.getSession().putParameter("dokumenti_za_knjizenje", (Object)this.table.getCheckedEntities());
        this.showDialog(PzDialogPotvrdiKnjizenje.class);
        if (PzDialogPotvrdiKnjizenje.DATUM != null) {
            PzWorkerDialog.showStatus((String)"Generisanje naloga za knjizenje je u toku. Molim sa\u010dekajte.", (PzDialog)this);
            Map props = (Map)this.getSession().getParameter("nzk_properties");
            this.getSession().putParameter("nzk_properties", null);
            Tools.generishiNaloge(this.table.getCheckedEntities(), PzDialogPotvrdiKnjizenje.DATUM, this, test2, props);
        }
        PzDialogPotvrdiKnjizenje.DATUM = null;
    }

    public boolean shouldBeShown() {
        this.filter = PzDialogFilter.getFilter(this);
        if (this.filter == null) {
            return false;
        }
        this.instantiateTable();
        return true;
    }
}

