/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import org.jdesktop.application.Application;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.reports.PzDataSource;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.util.PzDateUtility;

public class PzDialogPoslovniRezultat
extends PzDialog {
    private PzPanel mainPanel;
    private JLabel lblPocetni;
    private PzButton btnPotvrdi;
    private PzDateField dfKrajnji;
    private JLabel lblKrajnjiDatum;
    private PzDateField dfPocetni;
    private BigDecimal konto60;
    private BigDecimal konto61;
    private BigDecimal konto62;
    private BigDecimal konto63;
    private BigDecimal konto64;
    private BigDecimal konto65;
    private BigDecimal konto66;
    private BigDecimal konto67;
    private BigDecimal konto68;
    private BigDecimal konto50;
    private BigDecimal konto51;
    private BigDecimal konto52;
    private BigDecimal konto53;
    private BigDecimal konto54;
    private BigDecimal konto55;
    private BigDecimal konto56;
    private BigDecimal konto57;
    private BigDecimal konto58;
    private BigDecimal konto721;
    private BigDecimal konto722;

    public PzDialogPoslovniRezultat(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout bLayout = new BorderLayout();
            this.setLayout(bLayout);
            this.setTitle("Utvr\u0111ivanje poslovnog rezultata");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
            mainPanelLayout.rowHeights = new int[]{20, 7, 7, 7, 12};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{98, 135, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.lblPocetni = new JLabel();
            this.mainPanel.add((Component)this.lblPocetni, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 5), 0, 0));
            this.lblPocetni.setText("Po\u010detni datum");
            this.dfPocetni = new PzDateField();
            this.mainPanel.add((Component)this.dfPocetni, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.dfPocetni.setVal((Object)PzDateUtility.getFirstDayOfCurrentYear());
            this.lblKrajnjiDatum = new JLabel();
            this.mainPanel.add((Component)this.lblKrajnjiDatum, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 5), 0, 0));
            this.lblKrajnjiDatum.setText("Krajnji datum");
            this.dfKrajnji = new PzDateField();
            this.mainPanel.add((Component)this.dfKrajnji, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.btnPotvrdi = new PzButton();
            this.mainPanel.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/check.png")));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pack();
            this.setSize(341, 150);
            this.setResizable(false);
            this.setRestorable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    PzDialogPoslovniRezultat.this.konto60 = PzDialogPoslovniRezultat.this.getIznos("60", true, em);
                    PzDialogPoslovniRezultat.this.konto61 = PzDialogPoslovniRezultat.this.getIznos("61", true, em);
                    PzDialogPoslovniRezultat.this.konto62 = PzDialogPoslovniRezultat.this.getIznos("62", true, em);
                    PzDialogPoslovniRezultat.this.konto63 = PzDialogPoslovniRezultat.this.getIznos("63", true, em);
                    PzDialogPoslovniRezultat.this.konto64 = PzDialogPoslovniRezultat.this.getIznos("64", true, em);
                    PzDialogPoslovniRezultat.this.konto65 = PzDialogPoslovniRezultat.this.getIznos("65", true, em);
                    PzDialogPoslovniRezultat.this.konto66 = PzDialogPoslovniRezultat.this.getIznos("66", true, em);
                    PzDialogPoslovniRezultat.this.konto67 = PzDialogPoslovniRezultat.this.getIznos("67", true, em);
                    PzDialogPoslovniRezultat.this.konto68 = PzDialogPoslovniRezultat.this.getIznos("68", true, em);
                    PzDialogPoslovniRezultat.this.konto50 = PzDialogPoslovniRezultat.this.getIznos("50", false, em);
                    PzDialogPoslovniRezultat.this.konto51 = PzDialogPoslovniRezultat.this.getIznos("51", false, em);
                    PzDialogPoslovniRezultat.this.konto52 = PzDialogPoslovniRezultat.this.getIznos("52", false, em);
                    PzDialogPoslovniRezultat.this.konto53 = PzDialogPoslovniRezultat.this.getIznos("53", false, em);
                    PzDialogPoslovniRezultat.this.konto54 = PzDialogPoslovniRezultat.this.getIznos("54", false, em);
                    PzDialogPoslovniRezultat.this.konto55 = PzDialogPoslovniRezultat.this.getIznos("55", false, em);
                    PzDialogPoslovniRezultat.this.konto56 = PzDialogPoslovniRezultat.this.getIznos("56", false, em);
                    PzDialogPoslovniRezultat.this.konto57 = PzDialogPoslovniRezultat.this.getIznos("57", false, em);
                    PzDialogPoslovniRezultat.this.konto58 = PzDialogPoslovniRezultat.this.getIznos("58", false, em);
                    PzDialogPoslovniRezultat.this.konto721 = PzDialogPoslovniRezultat.this.getIznos("721", false, em);
                    PzDialogPoslovniRezultat.this.konto722 = PzDialogPoslovniRezultat.this.getIznos("721", false, em);
                    em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        try {
                            this.get();
                            PzDialogPoslovniRezultat.this.showReport();
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogPoslovniRezultat.this), (Throwable)e);
                            PzWorkerDialog.hideStatus();
                            em.close();
                        }
                    }
                    finally {
                        em.close();
                    }
                }
            };
            worker.execute();
        }
    }

    private BigDecimal getIznos(String konto, boolean prihod, EntityManager em) {
        BigDecimal iznos = new BigDecimal(0.0);
        Query q = null;
        String upit = "SELECT %iznos% FROM Stavkanzk s WHERE s.id.oznKonto LIKE '" + konto + "%'  " + "and s.datKnjizenja>='" + this.dfPocetni.getVal() + "'  and s.datKnjizenja<='" + this.dfKrajnji.getVal() + "'";
        upit = prihod ? upit.replace("%iznos%", "abs(sum(s.duguje-s.potrazuje))") : upit.replace("%iznos%", "sum(s.duguje-s.potrazuje)");
        q = em.createQuery(upit);
        List data = q.getResultList();
        if (data.size() != 0 && data.get(0) != null) {
            iznos = (BigDecimal)data.get(0);
        }
        return iznos;
    }

    private void showReport() throws Exception {
        Vector<Firma> data = new Vector<Firma>();
        Date today = PzDateUtility.getCurrentDate();
        data.add(PzFirma.getFirma());
        PzDataSource ds = new PzDataSource(data, null);
        String subtitle = "u periodu od " + PzDateUtility.formatDate((Date)this.dfPocetni.getVal()) + " do " + PzDateUtility.formatDate((Date)this.dfKrajnji.getVal());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("datum", PzFormatFactory.getDateFormat().format(today));
        params.put("title", "UTVR\u0110IVANJE FINANSIJSKOG REZULTATA");
        params.put("subtitle", subtitle);
        params.put("konto60", this.konto60);
        params.put("konto61", this.konto61);
        params.put("konto62", this.konto62);
        params.put("konto63", this.konto63);
        params.put("konto64", this.konto64);
        params.put("konto65", this.konto65);
        params.put("konto66", this.konto66);
        params.put("konto67", this.konto67);
        params.put("konto68", this.konto68);
        params.put("konto50", this.konto50);
        params.put("konto51", this.konto51);
        params.put("konto52", this.konto52);
        params.put("konto53", this.konto53);
        params.put("konto54", this.konto54);
        params.put("konto55", this.konto55);
        params.put("konto56", this.konto56);
        params.put("konto57", this.konto57);
        params.put("konto58", this.konto58);
        params.put("konto721", this.konto721);
        params.put("konto722", this.konto722);
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)"rs/pezar/reports/compiled/finansijski.rezultat.jasper", (String)"UTVR\u0110IVANJE FINANSIJSKOG REZULTATA", params);
    }
}

