/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui.export;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntityManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.util.PzDateUtility;

public class ExportGlavneKnjige
extends PzDialog {
    private PzPanel mainPanel;
    private JLabel lblPocetni;
    private PzDateField dfPocetni;
    private JLabel lblKrajnjiDatum;
    private PzDateField dfKrajnji;
    private PzButton btnPotvrdi;
    private ScrollableCursor cursor = null;

    public ExportGlavneKnjige(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout bLayout = new BorderLayout();
            this.setLayout(bLayout);
            this.setTitle("Vremenski interval");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
            mainPanelLayout.rowHeights = new int[]{20, 7, 7, 7, 12};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{98, 135, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.lblPocetni = new JLabel();
            this.mainPanel.add((Component)this.lblPocetni, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 5), 0, 0));
            this.lblPocetni.setText("Po\u010detni datum");
            this.dfPocetni = new PzDateField();
            this.mainPanel.add((Component)this.dfPocetni, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.dfPocetni.setVal((Object)PzDateUtility.getFirstDayOfCurrentYear());
            this.lblKrajnjiDatum = new JLabel();
            this.mainPanel.add((Component)this.lblKrajnjiDatum, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 5), 0, 0));
            this.lblKrajnjiDatum.setText("Krajnji datum");
            this.dfKrajnji = new PzDateField();
            this.mainPanel.add((Component)this.dfKrajnji, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.dfKrajnji.setVal((Object)PzDateUtility.getCurrentDate());
            this.btnPotvrdi = new PzButton();
            this.mainPanel.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/check.png")));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pack();
            this.setSize(341, 150);
            this.setResizable(false);
            this.setRestorable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        final String dirname = (String)this.getSession().getParameter("direktorijum");
        if (actionCommand.equals("potvrdi")) {
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    if (ExportGlavneKnjige.this.cursor != null) {
                        ExportGlavneKnjige.this.cursor.close();
                    }
                    Query q = null;
                    String upit = "SELECT stavka.oznKonto, stavka.nazivKonta, stavka.datKnjizenja, stavka.datDokumenta, stavka.brdokumenta, '', stavka.duguje, stavka.potrazuje, stavka.idNalog, stavka.analitika, stavka.sfrKomitent, stavka.opis FROM Stavkanzk stavka where stavka.datKnjizenja>='" + ExportGlavneKnjige.this.dfPocetni.getVal() + "' and stavka.datKnjizenja<='" + ExportGlavneKnjige.this.dfKrajnji.getVal() + "'";
                    q = em.createNativeQuery(upit);
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    ExportGlavneKnjige.this.cursor = (ScrollableCursor)q.getSingleResult();
                    System.out.println("Kursor je nasao faktura" + ExportGlavneKnjige.this.cursor.size());
                    return null;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                protected void done() {
                    try {
                        this.get();
                        if (ExportGlavneKnjige.this.cursor.size() == 0) {
                            JOptionPane.showMessageDialog(ExportGlavneKnjige.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                            PzWorkerDialog.hideStatus();
                            return;
                        }
                        try {
                            if (ExportGlavneKnjige.this.cursor.size() > 65534) {
                                JOptionPane.showMessageDialog(ExportGlavneKnjige.this.getParent(), "Previ\u0161e podataka za prikazivanje. Smanjite datumski interval", "Informacija", 1);
                                PzWorkerDialog.hideStatus();
                                return;
                            }
                            String filename = String.valueOf(dirname) + "\\glavna-knjiga-" + ExportGlavneKnjige.this.dfPocetni.getVal() + "-" + ExportGlavneKnjige.this.dfKrajnji.getVal() + ".xls";
                            File file = new File(filename);
                            HSSFWorkbook wb = new HSSFWorkbook();
                            HSSFSheet sheet = wb.createSheet("Sheet1");
                            HSSFRow rowhead = sheet.createRow(0);
                            rowhead.createCell(0).setCellValue("Konto");
                            rowhead.createCell(1).setCellValue("Naziv konta");
                            rowhead.createCell(2).setCellValue("Datum naloga za knjizenje");
                            rowhead.createCell(3).setCellValue("Datum dokumenta");
                            rowhead.createCell(4).setCellValue("Br. dokumenta");
                            rowhead.createCell(5).setCellValue("OTV / ZAK");
                            rowhead.createCell(6).setCellValue("Duguje");
                            rowhead.createCell(7).setCellValue("Potrazuje");
                            rowhead.createCell(8).setCellValue("Nalog za knjizenje");
                            rowhead.createCell(9).setCellValue("Analitika");
                            rowhead.createCell(10).setCellValue("Analitika poslovnog partnera");
                            rowhead.createCell(11).setCellValue("Opis promene");
                            int k = 1;
                            while (ExportGlavneKnjige.this.cursor.hasNext()) {
                                Object[] data = (Object[])ExportGlavneKnjige.this.cursor.next();
                                HSSFRow row = sheet.createRow(k);
                                int j = 0;
                                while (j < data.length) {
                                    if (data[j] == null) {
                                        row.createCell(j).setCellValue("");
                                    } else {
                                        row.createCell(j).setCellValue(data[j].toString());
                                    }
                                    ++j;
                                }
                                ++k;
                            }
                            FileOutputStream fileOut = new FileOutputStream(file);
                            wb.write((OutputStream)fileOut);
                            fileOut.flush();
                            fileOut.close();
                            ExportGlavneKnjige.this.dispose();
                            return;
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)ExportGlavneKnjige.this), (Throwable)e);
                        }
                        return;
                    }
                    finally {
                        em.close();
                        ExportGlavneKnjige.this.cursor.close();
                        PzWorkerDialog.hideStatus();
                    }
                }
            };
            worker.execute();
        }
    }
}

