/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui.izRobnogUFinansijsko;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.commons.configuration.XMLConfiguration;
import org.jdesktop.application.Application;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Shema;
import rs.pezar.finansije.engine.internal.PzShemaProvider;
import rs.pezar.finansije.gui.izRobnogUFinansijsko.PzCheckBoxList;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.globals.TipDokumentStructure;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzButtonPanel;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;

public class PzDialogFilter
extends PzDialog {
    private static final long serialVersionUID = 4011467257459098315L;
    private PzPanel mainPanel;
    private PzPanelHeader phFiltriranjePodataka;
    private PzPanel pnlSnimanje;
    private JScrollPane jScrollPane1;
    private JButton btnPotvrdi;
    private PzDateField dfKrajnjiDatum;
    private JLabel lblKrajnji;
    private PzDateField dfPocetni;
    private JLabel lblPocetniDatum;
    private JPanel pnlDatumDokumenta;
    private PzCheckBoxList listSnimanje;
    private PzButtonPanel btnPnlSnimanje;
    private PzButton snimanjeSelektuj;
    private PzButton snimanjeDeselektuj;
    private PzPanel pnlRj;
    private JScrollPane scrolPaneRj;
    private Container btnPnlSnimanjeRj;
    private PzButton snimanjeSelektujRJ;
    private PzButton snimanjeDeselektujRj;
    private final HashMap<String, String> dozvoleRjMap;
    private PzCheckBoxList listSnimanjeRJ;
    private final List<String> listaTip = new ArrayList<String>();
    private final List<String> listaRj = new ArrayList<String>();
    private HashMap<String, Object> filter = null;
    private static XMLConfiguration xml;
    private static TipDokumentConfig conf;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogFilter inst = new PzDialogFilter(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogFilter(JFrame frame) {
        super(frame);
        this.dozvoleRjMap = new LinkedHashMap<String, String>();
        this.getRJ();
        this.initGUI();
        this.postInit();
    }

    public PzDialogFilter(PzDialog dialog) {
        super(dialog);
        this.dozvoleRjMap = new LinkedHashMap<String, String>();
        this.getRJ();
        this.initGUI();
        this.postInit();
    }

    public void postInit() {
        try {
            HashMap filterPom = (HashMap)PzApplication.getApplication().getPropManager().loadObject("filter.sav");
            if (filterPom != null) {
                this.setTipoviDokumenata((List)filterPom.get("TIP"), this.listSnimanje);
                this.setRJ((List)filterPom.get("RJ"), this.listSnimanjeRJ);
                this.dfPocetni.setVal(filterPom.get("P_DATUM"));
                this.dfKrajnjiDatum.setVal(filterPom.get("K_DATUM"));
            }
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void initGUI() {
        try {
            BorderLayout bLayout = new BorderLayout();
            this.setLayout(bLayout);
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.0};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            mainPanelLayout.columnWidths = new int[]{310, 300, 10};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.mainPanel.setPreferredSize(new Dimension(626, 278));
            this.phFiltriranjePodataka = new PzPanelHeader();
            this.mainPanel.add((Component)this.phFiltriranjePodataka, (Object)new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.phFiltriranjePodataka.setTitle("Filtriranje dokumenata za knjizenje");
            this.phFiltriranjePodataka.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/funnel.png")));
            this.phFiltriranjePodataka.setPreferredSize(new Dimension(426, 77));
            this.phFiltriranjePodataka.setOpaque(false);
            this.pnlSnimanje = new PzPanel();
            BorderLayout pnlSnimanjeLayout = new BorderLayout();
            this.pnlSnimanje.setLayout((LayoutManager)pnlSnimanjeLayout);
            this.mainPanel.add((Component)this.pnlSnimanje, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 15, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.pnlSnimanje.setBorder((Border)BorderFactory.createTitledBorder("Izbor dokumenta"));
            this.jScrollPane1 = new JScrollPane();
            this.pnlSnimanje.add((Component)this.jScrollPane1, (Object)"Center");
            this.listSnimanje = new PzCheckBoxList();
            this.listSnimanje.setListData(this.setDocumentList());
            this.jScrollPane1.setViewportView(this.listSnimanje);
            this.btnPnlSnimanje = new PzButtonPanel();
            GridBagLayout btnPnlSnimanjeLayout = new GridBagLayout();
            this.pnlSnimanje.add((Component)this.btnPnlSnimanje, (Object)"South");
            btnPnlSnimanjeLayout.rowWeights = new double[]{0.1};
            btnPnlSnimanjeLayout.rowHeights = new int[]{7};
            btnPnlSnimanjeLayout.columnWeights = new double[]{0.1, 0.1};
            btnPnlSnimanjeLayout.columnWidths = new int[]{7, 7};
            this.btnPnlSnimanje.setLayout((LayoutManager)btnPnlSnimanjeLayout);
            this.btnPnlSnimanje.setPreferredSize(new Dimension(362, 34));
            this.snimanjeSelektuj = new PzButton();
            this.btnPnlSnimanje.add((Component)this.snimanjeSelektuj, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.snimanjeSelektuj.setText("Selektuj sve");
            this.snimanjeSelektuj.addActionListener((ActionListener)((Object)this));
            this.snimanjeSelektuj.setActionCommand("snimanjeSelektuj");
            this.snimanjeSelektuj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/selection_check.png")));
            this.snimanjeDeselektuj = new PzButton();
            this.btnPnlSnimanje.add((Component)this.snimanjeDeselektuj, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.snimanjeDeselektuj.setText("Deselektuj sve");
            this.snimanjeDeselektuj.addActionListener((ActionListener)((Object)this));
            this.snimanjeDeselektuj.setActionCommand("snimanjeDeselektuj");
            this.snimanjeDeselektuj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/selection_delete.png")));
            this.pnlRj = new PzPanel();
            pnlSnimanjeLayout = new BorderLayout();
            this.pnlRj.setLayout((LayoutManager)pnlSnimanjeLayout);
            this.mainPanel.add((Component)this.pnlRj, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlRj.setBorder((Border)BorderFactory.createTitledBorder("Izbor radnih jedinica"));
            this.scrolPaneRj = new JScrollPane();
            this.pnlRj.add((Component)this.scrolPaneRj, (Object)"Center");
            this.listSnimanjeRJ = new PzCheckBoxList();
            this.listSnimanjeRJ.setListData(this.setDozvoleRJList());
            this.scrolPaneRj.setViewportView(this.listSnimanjeRJ);
            this.btnPnlSnimanjeRj = new PzButtonPanel();
            btnPnlSnimanjeLayout = new GridBagLayout();
            this.pnlRj.add((Component)this.btnPnlSnimanjeRj, (Object)"South");
            btnPnlSnimanjeLayout.rowWeights = new double[]{0.1};
            btnPnlSnimanjeLayout.rowHeights = new int[]{7};
            btnPnlSnimanjeLayout.columnWeights = new double[]{0.1, 0.1};
            btnPnlSnimanjeLayout.columnWidths = new int[]{7, 7};
            this.btnPnlSnimanjeRj.setLayout(btnPnlSnimanjeLayout);
            this.btnPnlSnimanjeRj.setPreferredSize(new Dimension(362, 34));
            this.snimanjeSelektujRJ = new PzButton();
            this.btnPnlSnimanjeRj.add((Component)this.snimanjeSelektujRJ, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.snimanjeSelektujRJ.setText("Selektuj sve");
            this.snimanjeSelektujRJ.addActionListener((ActionListener)((Object)this));
            this.snimanjeSelektujRJ.setActionCommand("snimanjeSelektujRJ");
            this.snimanjeSelektujRJ.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/selection_check.png")));
            this.snimanjeDeselektujRj = new PzButton();
            this.btnPnlSnimanjeRj.add((Component)this.snimanjeDeselektujRj, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.snimanjeDeselektujRj.setText("Deselektuj sve");
            this.snimanjeDeselektujRj.addActionListener((ActionListener)((Object)this));
            this.snimanjeDeselektujRj.setActionCommand("snimanjeDeselektujRj");
            this.snimanjeDeselektujRj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/selection_delete.png")));
            this.pnlDatumDokumenta = new JPanel();
            GridBagLayout pnlDatumDokumentaLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlDatumDokumenta, (Object)new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.pnlDatumDokumenta.setBorder(BorderFactory.createTitledBorder("Datum dokumenata"));
            pnlDatumDokumentaLayout.rowWeights = new double[]{0.0};
            pnlDatumDokumentaLayout.rowHeights = new int[]{7};
            pnlDatumDokumentaLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlDatumDokumentaLayout.columnWidths = new int[]{90, 120, 90, 120, 20};
            this.pnlDatumDokumenta.setLayout(pnlDatumDokumentaLayout);
            this.lblPocetniDatum = new JLabel();
            this.pnlDatumDokumenta.add((Component)this.lblPocetniDatum, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblPocetniDatum.setText("Po\u010detni datum");
            this.dfPocetni = new PzDateField();
            this.pnlDatumDokumenta.add((Component)this.dfPocetni, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblKrajnji = new JLabel();
            this.pnlDatumDokumenta.add((Component)this.lblKrajnji, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblKrajnji.setText("Krajnji datum");
            this.dfKrajnjiDatum = new PzDateField();
            this.pnlDatumDokumenta.add((Component)this.dfKrajnjiDatum, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi = new PzButton();
            this.mainPanel.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 10, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(140, 32));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.pack();
            this.setSize(640, 700);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = ((PzButton)e.getSource()).getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            this.createListTip(this.listSnimanje, this.listaTip);
            this.createListRJ(this.listSnimanjeRJ, this.listaRj);
            this.filter = new HashMap();
            this.filter.put("TIP", this.listaTip);
            this.filter.put("RJ", this.listaRj);
            this.filter.put("P_DATUM", this.dfPocetni.getVal());
            this.filter.put("K_DATUM", this.dfKrajnjiDatum.getVal());
            this.saveFilterProperties();
            this.dispose();
        } else if (actionCommand.equalsIgnoreCase("snimanjeSelektuj")) {
            this.listSnimanje.setSelectedAll();
        } else if (actionCommand.equalsIgnoreCase("snimanjeDeselektuj")) {
            this.listSnimanje.setDeselectAll();
        } else if (actionCommand.equalsIgnoreCase("snimanjeDeselektujRJ")) {
            this.listSnimanjeRJ.setDeselectAll();
        } else if (actionCommand.equalsIgnoreCase("snimanjeSelektujRj")) {
            this.listSnimanjeRJ.setSelectedAll();
        }
    }

    public static HashMap<String, Object> getFilter(PzDialog parent) {
        PzDialogFilter d = new PzDialogFilter(parent);
        d.setLocationRelativeTo((Component)parent);
        d.setModal(true);
        d.setVisible(true);
        return d.getFilter();
    }

    private HashMap<String, Object> getFilter() {
        return this.filter;
    }

    private List<TipDokumentStructure.Tip> getShemaTip() {
        ArrayList<TipDokumentStructure.Tip> tipovi = new ArrayList<TipDokumentStructure.Tip>();
        List<Shema> sheme = new PzShemaProvider().loadShemas();
        for (Shema s : sheme) {
            if (s.getAbstrakt() != 0 || this.contains(tipovi, s.getId().getTipDok())) continue;
            tipovi.add(this.getNazivDokumenta(s.getId().getTipDok()));
        }
        return tipovi;
    }

    private boolean contains(List<TipDokumentStructure.Tip> tipovi, String tipStr) {
        boolean found = false;
        for (TipDokumentStructure.Tip tip : tipovi) {
            if (!tip.getTip().equals(tipStr)) continue;
            found = true;
            break;
        }
        return found;
    }

    private Vector<JCheckBox> setDocumentList() {
        Vector<JCheckBox> cbList = new Vector<JCheckBox>();
        List<TipDokumentStructure.Tip> tipovi = this.getShemaTip();
        for (TipDokumentStructure.Tip tip : tipovi) {
            JCheckBox cb = new JCheckBox();
            cb.setText(tip.getNaziv());
            cbList.add(cb);
        }
        return cbList;
    }

    private void setTipoviDokumenata(List<String> tipovi, PzCheckBoxList list) {
        int j = 0;
        while (j < tipovi.size()) {
            TipDokumentStructure.Tip tip = this.getNazivDokumenta(tipovi.get(j));
            int i = 0;
            while (i < list.getModel().getSize()) {
                if (((JCheckBox)list.getModel().getElementAt(i)).getText().equals(tip.getNaziv())) {
                    ((JCheckBox)list.getModel().getElementAt(i)).setSelected(true);
                }
                ++i;
            }
            ++j;
        }
    }

    private TipDokumentStructure.Tip getTip(String naziv) {
        List tipovi = TipDokumentStructure.loadStructure();
        TipDokumentStructure.Tip tipReturn = null;
        for (TipDokumentStructure.Tip tipPom : tipovi) {
            if (!tipPom.getNaziv().equals(naziv)) continue;
            tipReturn = tipPom;
            break;
        }
        return tipReturn;
    }

    private TipDokumentStructure.Tip getNazivDokumenta(String tip) {
        List tipovi = TipDokumentStructure.loadStructure();
        TipDokumentStructure.Tip tipReturn = null;
        for (TipDokumentStructure.Tip tipPom : tipovi) {
            if (!tipPom.getTip().equals(tip)) continue;
            tipReturn = tipPom;
            break;
        }
        return tipReturn;
    }

    private void createListTip(PzCheckBoxList list, List<String> tips) {
        int i = 0;
        while (i < list.getModel().getSize()) {
            if (((JCheckBox)list.getModel().getElementAt(i)).isSelected()) {
                tips.add(this.getTip(((JCheckBox)list.getModel().getElementAt(i)).getText()).getTip());
            }
            ++i;
        }
    }

    private void getRJ() {
        EntityManager emRJ = PzEntityManager.getEm();
        Query q = emRJ.createQuery("SELECT rj FROM Radnajedinica rj ORDER BY rj.id.oznRj");
        Vector rj = (Vector)q.getResultList();
        for (Radnajedinica temp : rj) {
            this.dozvoleRjMap.put(temp.getId().getOznRj(), temp.getNaziv());
        }
        emRJ.close();
    }

    private Vector<JCheckBox> setDozvoleRJList() {
        Vector<JCheckBox> cbList = new Vector<JCheckBox>();
        for (Map.Entry<String, String> temp : this.dozvoleRjMap.entrySet()) {
            JCheckBox cb = new JCheckBox();
            cb.setText(String.valueOf(temp.getKey()) + " " + temp.getValue());
            cbList.add(cb);
        }
        return cbList;
    }

    private Map.Entry<String, String> getEntry(String key) {
        for (Map.Entry<String, String> entry : this.dozvoleRjMap.entrySet()) {
            if (!entry.getKey().equals(key)) continue;
            return entry;
        }
        return null;
    }

    private void setRJ(List<String> rj, PzCheckBoxList list) {
        try {
            int j = 0;
            while (j < rj.size()) {
                String dozvola = rj.get(j);
                Map.Entry<String, String> entry = this.getEntry(dozvola);
                int i = 0;
                while (i < list.getModel().getSize()) {
                    if (((JCheckBox)list.getModel().getElementAt(i)).getText().equals(String.valueOf(entry.getKey()) + " " + entry.getValue())) {
                        ((JCheckBox)list.getModel().getElementAt(i)).setSelected(true);
                    }
                    ++i;
                }
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createListRJ(PzCheckBoxList list, List<String> rjs) {
        int i = 0;
        while (i < list.getModel().getSize()) {
            if (((JCheckBox)list.getModel().getElementAt(i)).isSelected()) {
                for (Map.Entry<String, String> temp : this.dozvoleRjMap.entrySet()) {
                    if (!((JCheckBox)list.getModel().getElementAt(i)).getText().equals(String.valueOf(temp.getKey()) + " " + temp.getValue())) continue;
                    rjs.add(temp.getKey());
                }
            }
            ++i;
        }
    }

    private void saveFilterProperties() {
        try {
            PzApplication.getApplication().getPropManager().saveObject(this.filter, "filter.sav");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

