/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui.nalogZaKnjizenje.akcije;

import java.awt.event.ActionEvent;
import java.sql.Date;
import java.util.List;
import javax.persistence.EntityManager;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Nzk;
import rs.pezar.db.entity.Stavkanzk;
import rs.pezar.finansije.engine.DokumentCompilerException;
import rs.pezar.finansije.engine.DokumentCompilerFactory;
import rs.pezar.finansije.engine.sifreKnjizenja.manager.UplataManager;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.util.PzDateUtility;

public abstract class PzDialogAkcija
extends PzDialog {
    private static final long serialVersionUID = 7492823894615987257L;
    protected PzTable tblStavke;
    protected Stavkanzk stavka;
    protected PzDokument dokument;
    protected Boolean update;
    private Nzk nzk;
    private EntityManager em;
    private int sfrKnjizenja;
    private boolean commited = false;
    private Integer brojac;

    public boolean isCommited() {
        return this.commited;
    }

    public void commit() {
        this.commited = true;
        this.dispose();
    }

    public PzDialogAkcija(PzDialog parent) {
        super(parent);
    }

    public PzDialogAkcija() {
    }

    public void actionPerformed(ActionEvent e) {
    }

    public PzTable getTblStavke() {
        return this.tblStavke;
    }

    public void setTblStavke(PzTable tblStavke) {
        this.tblStavke = tblStavke;
    }

    public Stavkanzk getStavka() {
        return this.stavka;
    }

    public void setStavka(Stavkanzk stavka) {
        this.stavka = stavka;
    }

    public PzDokument getDokument() {
        return this.dokument;
    }

    public void setDokument(PzDokument dokument) {
        this.dokument = dokument;
    }

    public Boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(Boolean update) {
        this.update = update;
    }

    public Integer getBrojac() {
        return this.brojac;
    }

    public void setBrojac(Integer brojac) {
        this.brojac = brojac;
    }

    public void initData(EntityManager em) {
    }

    public void setNzk(Nzk nzk) {
        this.nzk = nzk;
    }

    public Nzk getNzk() {
        return this.nzk;
    }

    public void setEm(EntityManager em) {
        this.em = em;
    }

    public EntityManager getEm() {
        return this.em;
    }

    public int getSfrKnjizenja() {
        return this.sfrKnjizenja;
    }

    public void setSfrKnjizenja(int sfrKnjizenja) {
        this.sfrKnjizenja = sfrKnjizenja;
    }

    protected void updateSftKnjizenja(List<Stavkanzk> stavke) {
        for (Stavkanzk stavka : stavke) {
            stavka.setSfrKnjizenja(Integer.valueOf(this.getSfrKnjizenja()));
        }
    }

    protected List<Stavkanzk> compileDokument(PzDokument dokument) throws DokumentCompilerException {
        Nzk nzk = DokumentCompilerFactory.getInstance().createSingleDokumentCompiler().compileDokument(dokument);
        this.updateSftKnjizenja(nzk.getStavkanzks());
        return nzk.getStavkanzks();
    }

    public void updateNzk(PzDokument dokument, Date datKnjizenja) throws DokumentCompilerException {
        boolean update = false;
        if (dokument.getDokument() != null && dokument.getDokument().getStavkanzks() != null && dokument.getDokument().getStavkanzks().size() > 0) {
            update = true;
        }
        List<Stavkanzk> stavke = this.compileDokument(dokument);
        for (Stavkanzk stavka : stavke) {
            stavka.getId().setIdNalog(this.nzk.getIdNalog());
            this.brojac = this.brojac + 1;
            stavka.getId().setrBroj(this.brojac);
            stavka.setDatKnjizenja(datKnjizenja);
            if (update) {
                for (Stavkanzk stavkaStara : dokument.getDokument().getStavkanzks()) {
                    if (!stavka.getId().getAnalitika().equals(stavkaStara.getId().getAnalitika()) || !stavka.getId().getOznKonto().equals(stavkaStara.getId().getOznKonto())) continue;
                    stavka.getId().setrBroj(stavkaStara.getId().getrBroj());
                    this.getTblStavke().update(Integer.valueOf(this.tblStavke.getAllEntities().indexOf(stavkaStara)), (PzEntity)stavka, true);
                }
                continue;
            }
            this.getTblStavke().insert((PzEntity)stavka, this.getEm());
        }
    }

    public abstract Date getDatKnjizenja();

    public abstract PzDokument getNewDokument() throws Exception;

    public List<PzDokument> getNewDokuments() throws Exception {
        return null;
    }

    public List<Stavkanzk> getStavke() {
        return null;
    }

    public UplataManager getUplataManager() {
        return null;
    }

    public boolean setEntity(PzEntity entity, PzFieldImpl field) {
        return true;
    }

    public Date getDatKnjizenjaTemp() {
        if (this.getSession().getParameter("dat_knjizenja") != null) {
            return (Date)this.getSession().getParameter("dat_knjizenja");
        }
        return PzDateUtility.getCurrentDate();
    }

    public void setDatKnjizenjaTemp(Date date) {
        this.getSession().putParameter("dat_knjizenja", (Object)date);
    }

    public Date getDatUplateTemp() {
        if (this.getSession().getParameter("dat_uplate") != null) {
            return (Date)this.getSession().getParameter("dat_uplate");
        }
        return PzDateUtility.getCurrentDate();
    }

    public void setDatUplateTemp(Date date) {
        this.getSession().putParameter("dat_uplate", (Object)date);
    }
}

