/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui.obracuni;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.core.PzApplication;
import rs.pezar.core.PzGenericService;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.OtpisPotrazivanja;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.finansije.util.FinansijeGradientUtil;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzScrollableTable;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.data.models.PzScrollableTableModel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.util.PzDateUtility;

public class PzDialogOtpisIzArhive
extends PzDialog {
    private static final long serialVersionUID = -9120569199511467681L;
    private PzPanel mainPanel;
    private PzButton btnTrazi;
    private PzDateField dfKrajnjuDatum;
    private JLabel lblKrajnjuDatum;
    private PzDateField dfPocetniDatum;
    private JLabel lblPocetniDatum;
    private PzPanel panelPretraga;
    private PzScrollableTable tabelaOtpis;
    private JToolBar toolbar;
    private PzToolBarIcon icnSlika;
    private PzToolBarIcon icnPriprema;
    private JScrollPane scpOtpisPotrazivanja;
    private Radnajedinica rj;
    private ScrollableCursor cursor = null;
    private int idDokColumnIndex = -1;
    private String izvestaj;
    private PzToolBarIcon icnStampa;
    private String paremetar;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    private PzToolBarIcon icnUpitNZK;

    public PzDialogOtpisIzArhive(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Otpis potra\u017eivanja iz arhive");
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1, 0.0, 0.0, 0.0};
            mainPanelLayout.rowHeights = new int[]{111, 73, 82, 102, 89, 47, 46};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.mainPanel.setPreferredSize(new Dimension(662, 424));
            this.scpOtpisPotrazivanja = new JScrollPane();
            this.mainPanel.add((Component)this.scpOtpisPotrazivanja, (Object)new GridBagConstraints(0, 2, 4, 5, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            this.tabelaOtpis = new PzScrollableTable();
            this.scpOtpisPotrazivanja.setViewportView((Component)this.tabelaOtpis);
            this.panelPretraga = new PzPanel();
            GridBagLayout panelPretragaLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.panelPretraga, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panelPretragaLayout.rowWeights = new double[]{0.0};
            panelPretragaLayout.rowHeights = new int[]{25};
            panelPretragaLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.1};
            panelPretragaLayout.columnWidths = new int[]{100, 110, 111, 110, 27, 90, 20, 7};
            this.panelPretraga.setLayout((LayoutManager)panelPretragaLayout);
            this.panelPretraga.setBorder((Border)BorderFactory.createTitledBorder("Pretraga"));
            this.panelPretraga.setOpaque(false);
            this.lblPocetniDatum = new JLabel();
            this.panelPretraga.add((Component)this.lblPocetniDatum, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 20, 0, 0), 0, 0));
            this.lblPocetniDatum.setText("Po\u010detni datum");
            this.dfPocetniDatum = new PzDateField();
            this.panelPretraga.add((Component)this.dfPocetniDatum, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfPocetniDatum.setVal((Object)PzDateUtility.getFirstDayOfCurrentYear());
            this.lblKrajnjuDatum = new JLabel();
            this.panelPretraga.add((Component)this.lblKrajnjuDatum, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 30, 0, 0), 0, 0));
            this.lblKrajnjuDatum.setText("Krajnji datum");
            this.dfKrajnjuDatum = new PzDateField();
            this.panelPretraga.add((Component)this.dfKrajnjuDatum, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnTrazi = new PzButton();
            this.panelPretraga.add((Component)this.btnTrazi, (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnTrazi.setText("Tra\u017ei");
            this.btnTrazi.setActionCommand("trazi");
            this.btnTrazi.addActionListener((ActionListener)((Object)this));
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setPreferredSize(new Dimension(662, 104));
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setOpaque(false);
            this.icnSlika = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSlika);
            this.icnSlika.setText("Slika|dokumenta (F2)");
            this.icnSlika.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/printer_preferences.png")));
            this.icnSlika.setActionCommand("slika");
            this.icnSlika.addActionListener((ActionListener)((Object)this));
            this.icnSlika.setShortcut("F2");
            this.icnPriprema = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnPriprema);
            this.icnPriprema.setText("Priprema za|\u0161tampu (ALT+S)");
            this.icnPriprema.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/printer_preferences.png")));
            this.icnPriprema.setActionCommand("priprema");
            this.icnPriprema.addActionListener((ActionListener)((Object)this));
            this.icnPriprema.setShortcut("ALT+S");
            this.icnUpitNZK = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnUpitNZK);
            this.icnUpitNZK.setText("Upit|u NZK|(F5)");
            this.icnUpitNZK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/img/nzk.png")));
            this.icnUpitNZK.setActionCommand("nzk");
            this.icnUpitNZK.setBounds(-30, 0, 58, 84);
            this.icnUpitNZK.addActionListener((ActionListener)((Object)this));
            this.icnUpitNZK.setShortcut("f5");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("Broj dokumenata");
            this.jlStatusBar.setPreferredSize(new Dimension(82, 14));
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(766, 740);
            this.setMinimumSize(new Dimension(766, 740));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            if (actionCommand.equals("trazi")) {
                if (this.cursor != null) {
                    this.cursor.close();
                }
                String upit = null;
                upit = "SELECT op.komitent.sfrKomitent, op.komitent.naziv, op.oznDokumenta, op.datum, op.iznosSaPorezom, op.idDok FROM OtpisPotrazivanja op WHERE op.arhiviran=1 and op.datum>=:datumOD and op.datum<=:datumDO ORDER BY op.datum";
                Query q = em.createQuery(upit);
                q = em.createQuery(upit);
                q.setParameter("datumOD", (Object)this.dfPocetniDatum.getVal());
                q.setParameter("datumDO", (Object)this.dfKrajnjuDatum.getVal());
                q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                q.setHint("eclipselink.read-only", (Object)"True");
                this.cursor = (ScrollableCursor)q.getSingleResult();
                this.brDok.setText(Integer.toString(this.cursor.size()));
                this.tabelaOtpis.read(this.cursor, this.getColumnNames());
                this.scpOtpisPotrazivanja.setViewportView((Component)this.tabelaOtpis);
                this.idDokColumnIndex = ((PzScrollableTableModel)this.tabelaOtpis.getModel()).getColumnIndexByName("iddok");
                if (this.tabelaOtpis.convertColumnIndexToView(this.idDokColumnIndex) != -1) {
                    this.tabelaOtpis.getColumnExt(this.idDokColumnIndex).setVisible(false);
                }
                if (this.cursor.size() > 0) {
                    this.tabelaOtpis.setRowSelectionInterval(0, 0);
                    this.tabelaOtpis.requestFocusInWindow();
                }
                return;
            }
            if (actionCommand.equals("slika")) {
                OtpisPotrazivanja otpis = (OtpisPotrazivanja)this.getSelectedEntity();
                PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)otpis);
                return;
            }
            if (actionCommand.equals("nzk")) {
                if (this.tabelaOtpis.getRowCount() == 0) {
                    return;
                }
                PzGenericService gs = PzApplication.getApplication().getGenericServiceRegistry().getService("NZK_SERVICE");
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("NZK_DOKUMENT", this.getSelectedEntity());
                params.put("NZK_PARENT_DIALOG", (Object)this);
                gs.run(params);
                return;
            }
            if (actionCommand.equals("priprema")) {
                this.showReports();
                return;
            }
        }
        catch (Exception e1) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
        finally {
            em.close();
        }
    }

    public boolean shouldBeShown() {
        this.mainPanel.setPaintGradient(true);
        this.mainPanel.setGradient(FinansijeGradientUtil.OBRACUN_GRADIENT);
        this.getSession().putParameter("gradient", (Object)FinansijeGradientUtil.OBRACUN_GRADIENT);
        this.setVisible(false);
        return true;
    }

    public String[] getColumnNames() {
        return new String[]{"<html>\u0160ifra<br>komitenta</html>", "<html>Naziv<br>komitenta</html>", "Broj racuna", "Datum", "Iznos", "iddok"};
    }

    private PzEntity getSelectedEntity() {
        int sifra = (Integer)this.tabelaOtpis.getModel().getValueAt(this.tabelaOtpis.getRealSelectedRowIndex(), this.idDokColumnIndex);
        EntityManager em = PzEntityManager.getEm();
        OtpisPotrazivanja op = (OtpisPotrazivanja)em.createQuery("select op from OtpisPotrazivanja op where op.idDok=" + sifra).getSingleResult();
        return op;
    }

    public void showReports() {
        try {
            String title = "";
            String fname = "";
            Vector<Firma> data = new Vector<Firma>();
            data.add(PzFirma.getFirma());
            PzTableDataSource ds = new PzTableDataSource((PzAbstractTable)this.tabelaOtpis, data);
            fname = "rs/pezar/finansije/resource/reports/compiled/otpis.potrazivanja.stampa.jasper";
            HashMap<String, Object> params = new HashMap<String, Object>();
            title = "Pregled otpisa potra\u017eivanja";
            params.put("datum", PzDateUtility.getCurrentDate());
            params.put("datumOd", this.dfPocetniDatum.getVal());
            params.put("datumDo", this.dfKrajnjuDatum.getVal());
            params.put("reklama", "");
            params.put("title", title);
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource(fname), params, (String)title);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }
}

