/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.util;

import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentFinalizer;
import rs.pezar.globals.TipDokumentConfig;

public class PzFinansijeFinalizer
implements PzDokumentFinalizer {
    List<String> tipoviUplKup = new Vector<String>();
    List<String> tipoviUplKupStorno = new Vector<String>();
    List<String> tipoviUplDob = new Vector<String>();
    List<String> tipoviUplDobStorno = new Vector<String>();
    List<String> tipovi = new Vector<String>();

    public PzFinansijeFinalizer() {
        this.tipoviUplKup.add(TipDokumentConfig.get().UPLATA_KUPCA);
        this.tipoviUplKupStorno.add(TipDokumentConfig.get().UPLATA_KUPCA_POVRACAJ);
        this.tipoviUplDob.add(TipDokumentConfig.get().UPLATA_DOBAVLJACU);
        this.tipoviUplDobStorno.add(TipDokumentConfig.get().UPLATA_DOBAVLJACU_POVRACAJ);
        this.tipovi.addAll(this.tipoviUplDob);
        this.tipovi.addAll(this.tipoviUplDobStorno);
        this.tipovi.addAll(this.tipoviUplKup);
        this.tipovi.addAll(this.tipoviUplKupStorno);
    }

    public boolean appliesTo(PzDokument d) {
        return this.tipovi.contains(d.getTip());
    }

    public void finalize(PzDokument d, EntityManager em) {
        if (this.tipoviUplKup.contains(d.getTip())) {
            d.getDokument().setVrstaDuga("UK");
        } else if (this.tipoviUplKupStorno.contains(d.getTip())) {
            d.getDokument().setVrstaDuga("UKS");
        } else if (this.tipoviUplDob.contains(d.getTip())) {
            d.getDokument().setVrstaDuga("UD");
        } else if (this.tipoviUplDobStorno.contains(d.getTip())) {
            d.getDokument().setVrstaDuga("UDS");
        }
    }
}

