/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.zahtevi.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import org.apache.commons.codec.binary.Base64;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.swingx.JXTitledPanel;
import rs.pezar.core.PzApplication;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.zahtevi.RedmineController;

public class PzDialogNoviZahtev
extends PzDialog {
    private static final long serialVersionUID = -2137807663487880134L;
    private final JXTitledPanel pnlBug = new JXTitledPanel("Podaci o problemu");
    private JScrollPane scp;
    private JComboBox cbVrsta;
    private JLabel lblVrsta;
    private JTextField txtEmail;
    private JTextField txtTelefon;
    private JTextField txtIme;
    private JLabel lblIme;
    private JLabel lblEmail;
    private JLabel lblTelefon;
    private JPanel pnlUserDataContent;
    private JXTitledPanel pnlUserData;
    private JPanel pnlContent;
    private JComboBox cbPrioritet;
    private JLabel lblPrioritet;
    private JLabel lblOpis;
    private JLabel lblNaslov;
    private JEditorPane txtOpis;
    private JTextField txtNaslov;
    private PzPanelHeader header;
    private JPanel pnlBugContent;
    private JXLayer<JComponent> layer;
    private Object userCode;
    private String userCodeString;

    public static void main(String[] args) {
        try {
            PzDialogNoviZahtev dialog = new PzDialogNoviZahtev();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PzDialogNoviZahtev(JFrame frame) {
        super(frame);
        this.initGui();
        this.getContentPane().remove(this.pnlContent);
        this.layer = PzSwingUtility.createLayer((JComponent)this.pnlContent);
        this.getContentPane().add((Component)this.layer, "Center");
        this.fillData();
    }

    public PzDialogNoviZahtev() {
        this.initGui();
    }

    private void initGui() {
        this.setBounds(0, 0, 730, 524);
        this.getContentPane().setLayout(new BorderLayout());
        this.pnlContent = new JPanel();
        GridBagLayout jPanel1Layout = new GridBagLayout();
        jPanel1Layout.rowWeights = new double[]{0.1, 0.0};
        jPanel1Layout.rowHeights = new int[]{7, 7};
        jPanel1Layout.columnWeights = new double[]{0.1};
        jPanel1Layout.columnWidths = new int[]{7};
        this.pnlContent.setLayout(jPanel1Layout);
        this.getContentPane().add((Component)this.pnlContent, "Center");
        this.pnlContent.setPreferredSize(new Dimension(718, 350));
        this.pnlContent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagLayout pnlBugContentLayout = new GridBagLayout();
        this.pnlBugContent = new JPanel();
        this.pnlBugContent.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.pnlBugContent.setLayout(pnlBugContentLayout);
        pnlBugContentLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.0};
        pnlBugContentLayout.rowHeights = new int[]{20, 7, 7, 7};
        pnlBugContentLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.1};
        pnlBugContentLayout.columnWidths = new int[]{7, 204, 7, 7};
        this.scp = new JScrollPane();
        this.pnlBugContent.add((Component)this.scp, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.txtOpis = new JEditorPane();
        this.scp.setViewportView(this.txtOpis);
        this.txtNaslov = new JTextField();
        this.pnlBugContent.add((Component)this.txtNaslov, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.lblNaslov = new JLabel("Naslov:");
        this.pnlBugContent.add((Component)this.lblNaslov, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.lblOpis = new JLabel("Opis:");
        this.pnlBugContent.add((Component)this.lblOpis, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.lblPrioritet = new JLabel("Prioritet:");
        this.pnlBugContent.add((Component)this.lblPrioritet, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.cbPrioritet = new JComboBox();
        this.pnlBugContent.add((Component)this.cbPrioritet, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.cbPrioritet.setModel(new RedmineController.PriorityCBModel());
        this.lblVrsta = new JLabel("Vrsta:");
        this.pnlBugContent.add((Component)this.lblVrsta, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.cbVrsta = new JComboBox();
        this.pnlBugContent.add((Component)this.cbVrsta, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.cbVrsta.setModel(new RedmineController.TrackerCBModel());
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("Po\u0161alji");
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        okButton.setName("okButton");
        okButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/zahtevi/resource/img/check.png")));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PzDialogNoviZahtev.this.okButtonActionPerformed(evt);
            }
        });
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Odustani");
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        cancelButton.setName("cancelButton");
        cancelButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/zahtevi/resource/img/forbidden.png")));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PzDialogNoviZahtev.this.cancelButtonActionPerformed(evt);
            }
        });
        this.pnlBug.setContentContainer((Container)this.pnlBugContent);
        this.pnlContent.add((Component)this.pnlBug, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.pnlUserData = new JXTitledPanel("Podaci putem kojih je mogu\u0107e kontaktirati korisnika");
        this.pnlContent.add((Component)this.pnlUserData, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlUserDataContent = new JPanel();
        this.pnlUserDataContent.setBorder(new EmptyBorder(10, 10, 10, 10));
        new GridBagLayout();
        this.pnlUserData.setContentContainer((Container)this.pnlUserDataContent);
        this.pnlContent.add((Component)this.pnlUserData, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        GridBagLayout pnlUserDataContentLayout = new GridBagLayout();
        pnlUserDataContentLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
        pnlUserDataContentLayout.rowHeights = new int[]{20, 7, 7};
        pnlUserDataContentLayout.columnWeights = new double[]{0.0, 0.1};
        pnlUserDataContentLayout.columnWidths = new int[]{7, 7};
        this.pnlUserDataContent.setLayout(pnlUserDataContentLayout);
        this.lblTelefon = new JLabel("Telefon:");
        this.pnlUserDataContent.add((Component)this.lblTelefon, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.lblEmail = new JLabel("Email:");
        this.pnlUserDataContent.add((Component)this.lblEmail, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.lblIme = new JLabel("Ime i prezime:");
        this.pnlUserDataContent.add((Component)this.lblIme, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.txtIme = new JTextField();
        this.pnlUserDataContent.add((Component)this.txtIme, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.txtTelefon = new JTextField();
        this.pnlUserDataContent.add((Component)this.txtTelefon, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.txtEmail = new JTextField();
        this.pnlUserDataContent.add((Component)this.txtEmail, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.header = new PzPanelHeader();
        this.header.setTitle("Prijavljivanje problema");
        this.header.setText("Unesite podatke o problemu, odnosno zahtevu");
        this.header.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/zahtevi/resource/img/bug_red.png")));
        this.getContentPane().add((Component)this.header, "North");
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.txtNaslov.getText().equals("")) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Naslov ne sme ostati prazan");
            return;
        }
        if (this.txtOpis.getText().equals("")) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Opis ne sme ostati prazan");
            return;
        }
        ((PzBusyPainterUI)this.layer.getUI()).setLocked(true);
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                RedmineController rc = new RedmineController();
                rc.sendTask(((RedmineController.Choice)PzDialogNoviZahtev.this.cbVrsta.getSelectedItem()).getId(), PzDialogNoviZahtev.this.txtNaslov.getText(), PzDialogNoviZahtev.this.txtOpis.getText(), ((RedmineController.Choice)PzDialogNoviZahtev.this.cbPrioritet.getSelectedItem()).getId(), PzDialogNoviZahtev.this.txtIme.getText(), String.valueOf(PzDialogNoviZahtev.this.txtTelefon.getText()) + "; " + PzDialogNoviZahtev.this.txtEmail.getText(), PzFirma.getFirma().getNaziv(), PzDialogNoviZahtev.this.userCodeString);
                return null;
            }

            @Override
            protected void done() {
                super.done();
                try {
                    try {
                        this.get();
                        PzSwingUtility.showInformationMessage((Component)((Object)PzDialogNoviZahtev.this), (String)"Problem uspesno poslat");
                        PzDialogNoviZahtev.this.dispose();
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)PzDialogNoviZahtev.this), (Throwable)e);
                        ((PzBusyPainterUI)PzDialogNoviZahtev.this.layer.getUI()).setLocked(false);
                    }
                }
                finally {
                    ((PzBusyPainterUI)PzDialogNoviZahtev.this.layer.getUI()).setLocked(false);
                }
            }
        };
        worker.execute();
    }

    public void actionPerformed(ActionEvent e) {
    }

    private void fillData() {
        try {
            Pzuser u = PzApplication.getApplication().getSession().getLoggedUser();
            Firma f = PzFirma.getFirma();
            this.txtIme.setText(String.valueOf(u.getIme()) + " " + u.getPrezime() + " [ " + u.getPzusername() + " ]");
            this.txtEmail.setText(u.getEmail(Integer.valueOf(1)) != null ? u.getEmail(Integer.valueOf(1)).getAdresa() : "");
            this.txtTelefon.setText(u.getTelefon(Integer.valueOf(1)) != null ? u.getTelefon(Integer.valueOf(1)).getBrojTelefona() : "");
            Base64 b64 = new Base64();
            this.userCode = b64.encode((String.valueOf(f.getPib()) + f.getMatBroj() + u.getPzusername()).getBytes());
            byte[] aa = (byte[])this.userCode;
            this.userCodeString = new String(aa, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

