/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.korisnici.gui;

import it.cnr.imaa.essi.lablib.gui.checkboxtree.CheckboxTree;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.CheckboxTreeCellRenderer;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.QuadristateButtonModel;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.QuadristateCheckbox;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import rs.pezar.core.gui.defaultWidgets.mainView.TreeElement;

public class PzCheckBoxTreeCellRenderer
extends JPanel
implements CheckboxTreeCellRenderer {
    private Font font;
    private Color treeSelectionForeground;
    private Color treeNoSelectionForeground;
    private Color treeSelectionBackground;
    private Color treeNoSelectionBackground;
    protected QuadristateCheckbox checkBox = new QuadristateCheckbox();
    protected DefaultTreeCellRenderer label = new DefaultTreeCellRenderer();

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
        DefaultTreeCellRenderer treeCellRenderer = new DefaultTreeCellRenderer();
        treeCellRenderer.setFont(this.font);
        TreePath path = tree.getPathForRow(row);
        TreeCheckingModel checkingModel = ((CheckboxTree)tree).getCheckingModel();
        this.checkBox.setEnabled(checkingModel.isPathEnabled(path) && tree.isEnabled());
        boolean checked = checkingModel.isPathChecked(path);
        boolean greyed = checkingModel.isPathGreyed(path);
        if (checked && !greyed) {
            this.checkBox.setState(QuadristateButtonModel.State.CHECKED);
            this.setOpaque(true);
            this.setBackground(this.treeSelectionBackground);
            this.setForeground(this.treeSelectionForeground);
        }
        if (!checked && greyed) {
            this.checkBox.setState(QuadristateButtonModel.State.GREY_UNCHECKED);
        }
        if (checked && greyed) {
            this.checkBox.setState(QuadristateButtonModel.State.GREY_CHECKED);
        }
        if (!checked && !greyed) {
            this.checkBox.setState(QuadristateButtonModel.State.UNCHECKED);
            this.setOpaque(false);
            this.setBackground(this.treeNoSelectionBackground);
            this.setForeground(this.treeNoSelectionForeground);
        }
        this.setEnabled(tree.isEnabled());
        String label = null;
        if (value instanceof Vector) {
            label = "PEZAR";
        } else {
            TreeElement element = (TreeElement)value;
            label = element.getLabel();
            if (element.getActionClass() == null && !element.hasChildren()) {
                this.setEnabled(false);
            }
        }
        this.label.setText(label);
        return this;
    }

    public boolean isOnHotspot(int x, int y) {
        return this.checkBox.contains(x, y);
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(this.treeNoSelectionBackground);
    }

    public PzCheckBoxTreeCellRenderer() {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setOpaque(false);
        this.add((Component)this.checkBox);
        this.add(this.label);
        this.font = new Font("Sans", 1, 14);
        this.treeSelectionForeground = Color.WHITE;
        this.treeNoSelectionForeground = UIManager.getColor("Tree.textForeground");
        this.treeSelectionBackground = Color.BLUE;
        this.treeNoSelectionBackground = UIManager.getColor("Tree.textBackground");
        UIDefaults metalDefaults = new MetalLookAndFeel().getDefaults();
        metalDefaults.getIcon("FileView.directoryIcon");
        metalDefaults.getIcon("FileView.hardDriveIcon");
        metalDefaults.getIcon("FileView.fileIcon");
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d_check = this.checkBox.getPreferredSize();
        Dimension d_label = this.label.getPreferredSize();
        return new Dimension(d_check.width + d_label.width, d_check.height < d_label.height ? d_label.height : d_check.height);
    }

    public void setClosedIcon(Icon newIcon) {
        this.label.setClosedIcon(newIcon);
    }

    public void setLeafIcon(Icon newIcon) {
        this.label.setLeafIcon(newIcon);
    }

    public void setOpenIcon(Icon newIcon) {
        this.label.setOpenIcon(newIcon);
    }
}

