/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.indexes;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import org.xBaseJ.DBF;
import org.xBaseJ.fields.Field;
import org.xBaseJ.indexes.BinaryTree;
import org.xBaseJ.indexes.Index;
import org.xBaseJ.indexes.MDXFile;
import org.xBaseJ.indexes.MNode;
import org.xBaseJ.indexes.Node;
import org.xBaseJ.indexes.NodeKey;
import org.xBaseJ.indexes.TagDescriptor;
import org.xBaseJ.indexes.TagHeader;
import org.xBaseJ.xBaseJException;

public class MDX
extends Index {
    short tag_pos;
    private MDXFile mfile;
    TagDescriptor tagDesc;
    TagHeader tagHead;

    public MDX(MDXFile ifile, DBF iDBF, short ipos) throws xBaseJException, IOException {
        int Index_record;
        MNode lNode = null;
        Field field = null;
        this.database = iDBF;
        this.mfile = ifile;
        this.tagDesc = this.mfile.getTagDescriptor(ipos);
        this.dosname = this.tagDesc.getName();
        this.tagHead = new TagHeader(ifile, (short)this.tagDesc.indheaderpage);
        this.key_per_Node = this.tagHead.key_per_Node;
        this.key_length = this.tagHead.key_length;
        this.nfile = ifile.raFile;
        this.keyType = (char)this.tagHead.keyType;
        if (this.keyType == 'N' && this.key_length == 12) {
            this.keyType = (char)70;
        }
        if (this.keyType == 'D') {
            this.keyType = (char)78;
        }
        int reading = Index_record = this.tagHead.top_Node;
        this.stringKey = new String(this.tagHead.NDXString);
        StringTokenizer strtok = new StringTokenizer(this.stringKey, "+");
        while (strtok.hasMoreElements()) {
            String wb = (String)strtok.nextElement();
            wb = wb.trim();
            field = this.database.getField(wb);
            this.keyControl.addElement(field);
        }
        while (reading > 0) {
            if (this.topNode == null) {
                lNode = new MNode(this.mfile, (int)this.key_per_Node, (int)this.key_length, this.keyType, Index_record, false);
            } else {
                MNode llNode = new MNode(this.mfile, (int)this.key_per_Node, (int)this.key_length, this.keyType, Index_record, false);
                lNode.set_prev(llNode);
                lNode = llNode;
            }
            this.workNode = lNode;
            lNode.set_pos(0);
            lNode.read();
            if (reading > 0 && (Index_record = lNode.get_lower_level()) == 0) {
                Index_record = lNode.get_key_record_number();
                reading = 0;
                lNode.set_pos(0);
            }
            if (this.topNode != null) continue;
            this.topNode = (MNode)lNode.clone();
        }
        try {
            this.dosname = new String(this.tagDesc.tagname, DBF.encodedType);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.dosname = new String(this.tagDesc.tagname);
        }
    }

    public MDX(String iname, String NDXString, DBF iDBF, MDXFile ifile, TagDescriptor inTagDesc, short pos, boolean unique) throws xBaseJException, IOException {
        byte[] kd;
        int len;
        this.dosname = iname;
        this.database = iDBF;
        this.mfile = ifile;
        this.nfile = ifile.raFile;
        int i = iname.length();
        this.unique_key = (byte)(unique ? 64 : 0);
        if (i < 1 || i > 10) {
            throw new xBaseJException("Invalid tag name " + iname + " name length incorrect");
        }
        if (!Character.isLetter(iname.charAt(0))) {
            throw new xBaseJException("Invalid tag name " + iname + " first character not alphabetic");
        }
        iname = iname.toUpperCase();
        int j = 1;
        while (j < i) {
            if (!Character.isLetter(iname.charAt(j)) && !Character.isDigit(iname.charAt(j)) && iname.charAt(j) != '_') {
                throw new xBaseJException("Invalid tag name " + iname + " invalid character at position " + (j + 1));
            }
            ++j;
        }
        StringTokenizer strtok = new StringTokenizer(NDXString, "+");
        int keylen = 0;
        this.keyType = (char)32;
        do {
            String fname;
            Field ffld;
            char type;
            if ((type = (ffld = iDBF.getField(fname = (String)strtok.nextElement())).getType()) == 'M') {
                throw new xBaseJException("Can't make memo field part of a key");
            }
            if (type == 'L') {
                throw new xBaseJException("Can't make logical field part of a key");
            }
            if (type == 'F') {
                throw new xBaseJException("Can't make float field part of a key");
            }
            if (this.keyType == ' ') {
                this.keyType = type;
            } else if (this.keyType != type) {
                this.keyType = (char)67;
            }
            keylen += ffld.getLength();
            this.keyControl.addElement(ffld);
        } while (strtok.hasMoreElements());
        if (this.keyType == 'D') {
            keylen = 8;
        }
        if (this.keyType == 'N') {
            keylen = 12;
        }
        if ((len = ((keylen - 1) / 4 + 1) * 4) < 1) {
            throw new xBaseJException("Key length too short");
        }
        if (len > 100) {
            throw new xBaseJException("Key length too long");
        }
        this.tagDesc = inTagDesc;
        this.tagDesc.setKeyType(this.keyType);
        this.tagHead = new TagHeader(this.mfile, (short)this.tagDesc.indheaderpage, (short)len, this.keyType, unique);
        if (this.keyType == 'N') {
            this.keyType = (char)70;
        }
        if (this.keyType == 'D') {
            this.keyType = (char)78;
        }
        this.key_length = this.tagHead.key_length;
        this.key_per_Node = this.tagHead.key_per_Node;
        try {
            kd = NDXString.toUpperCase().substring(0, NDXString.length()).getBytes(DBF.encodedType);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            kd = NDXString.toUpperCase().substring(0, NDXString.length()).getBytes();
        }
        int x = 0;
        while (x < kd.length) {
            this.tagHead.key_definition[x] = kd[x];
            ++x;
        }
        if (this.database.getRecordCount() > 0) {
            this.reIndex();
        } else {
            this.tagDesc.write();
            this.tagHead.write();
        }
    }

    @Override
    public void reIndex() throws xBaseJException, IOException {
        int reccount = this.database.getRecordCount();
        BinaryTree topTree = null;
        if (this.database.getRecordCount() > 0) {
            this.database.gotoRecord(1);
            this.top_Node = 0;
            int i = 1;
            while (i <= reccount) {
                NodeKey lastkey = this.build_key();
                if (topTree == null) {
                    topTree = new BinaryTree(lastkey, i, topTree);
                } else {
                    new BinaryTree(lastkey, i, topTree);
                }
                if (i < reccount) {
                    this.database.read();
                }
                ++i;
            }
        }
        this.topNode = null;
        if (this.database.getRecordCount() > 0) {
            this.reIndexWork(topTree.getLeast(), 0, topTree);
        }
        this.tagHead.top_Node = this.top_Node;
        this.tagHead.write();
        this.tagDesc.write();
        this.anchor_write();
    }

    private int reIndexWork(BinaryTree bt, int level, BinaryTree topTree) throws IOException, xBaseJException {
        int prev_page = 0;
        BinaryTree tree2 = null;
        int pos = 0;
        if (level > 0) {
            prev_page = this.top_Node;
        }
        this.top_Node = (short)this.mfile.anchor.get_nextavailable();
        this.workNode = new MNode(this.mfile, (int)this.key_per_Node, (int)this.key_length, this.keyType, this.top_Node, level > 0);
        this.workNode.set_prev_page(prev_page);
        this.mfile.anchor.update_nextavailable();
        this.tagHead.pagesused += this.mfile.anchor.get_blocksize();
        this.workNode.set_pos(0);
        NodeKey lastKey = null;
        while (true) {
            if (pos == this.key_per_Node || bt == null) {
                int i;
                if (tree2 == null && level > 0 && pos == 1 || pos == 0) {
                    --this.top_Node;
                    this.mfile.anchor.reset_nextavailable();
                    this.topNode = this.workNode;
                    i = pos;
                    while (i < this.key_per_Node) {
                        this.workNode.set_pos(i);
                        this.workNode.set_key_value(lastKey);
                        ++i;
                    }
                    this.workNode.write();
                    break;
                }
                if (bt != null || tree2 != null) {
                    if (tree2 == null) {
                        this.topNode = this.workNode;
                        tree2 = new BinaryTree(lastKey, this.workNode.get_record_number(), tree2);
                    } else {
                        new BinaryTree(lastKey, this.workNode.get_record_number(), tree2);
                    }
                }
                if (level == 0) {
                    this.workNode.set_keys_in_this_Node(pos);
                } else {
                    this.workNode.set_keys_in_this_Node(pos - 1);
                }
                i = pos;
                while (i < this.key_per_Node) {
                    this.workNode.set_pos(i);
                    this.workNode.set_key_value(lastKey);
                    ++i;
                }
                this.workNode.write();
                if (bt == null) {
                    this.topNode = this.workNode;
                    break;
                }
                this.top_Node = (short)this.mfile.anchor.get_nextavailable();
                this.workNode = new MNode(this.mfile, (int)this.key_per_Node, (int)this.key_length, this.keyType, this.top_Node, level > 0);
                this.mfile.anchor.update_nextavailable();
                this.tagHead.pagesused += this.mfile.anchor.get_blocksize();
                pos = 0;
                this.workNode.set_pos(0);
            }
            ++pos;
            lastKey = bt.getKey();
            this.workNode.set_key_value(lastKey);
            if (level == 0) {
                this.workNode.set_key_record_number(bt.getWhere());
            } else {
                this.workNode.set_lower_level(bt.getWhere());
            }
            this.workNode.pos_up();
            bt = bt.getNext();
        }
        if (tree2 == null) {
            return 0;
        }
        topTree = null;
        System.gc();
        return this.reIndexWork(tree2.getLeast(), ++level, tree2);
    }

    @Override
    public int find_entry(NodeKey findKey) throws xBaseJException, IOException {
        return this.find_entry(findKey, -2);
    }

    @Override
    public int find_entry(NodeKey findKey, int rec) throws xBaseJException, IOException {
        if (this.topNode == null) {
            throw new xBaseJException("No keys built");
        }
        this.topNode.set_pos(0);
        this.record = this.find_entry(findKey, (MNode)this.topNode, rec);
        return this.record;
    }

    public int find_entry(NodeKey findKey, MNode aNode, int findrec) throws xBaseJException, IOException {
        int stat = 0;
        this.foundExact = false;
        this.workNode = aNode;
        if (aNode == null) {
            throw new xBaseJException("No keys built");
        }
        int leaf = aNode.get_lower_level();
        int until = leaf != 0 ? aNode.get_keys_in_this_Node() + 1 : aNode.get_keys_in_this_Node();
        aNode.set_pos(0);
        while (aNode.get_pos() < until) {
            leaf = aNode.get_lower_level();
            int rec = aNode.get_key_record_number();
            if (aNode.get_pos() >= aNode.get_keys_in_this_Node() || (stat = findKey.compareKey(aNode.get_key_value())) <= 0) {
                if (leaf > 0) {
                    MNode Node_2;
                    if (aNode.get_next() == null) {
                        Node_2 = new MNode(this.mfile, (int)this.key_per_Node, (int)this.key_length, this.keyType, leaf, true);
                        aNode.set_next(Node_2);
                        Node_2.set_prev(aNode);
                    } else {
                        Node_2 = (MNode)aNode.get_next();
                    }
                    Node_2.set_record_number(leaf);
                    Node_2.read();
                    Node_2.set_pos(0);
                    this.workNode = Node_2;
                    rec = this.find_entry(findKey, Node_2, findrec);
                    return rec;
                }
                if (stat < 0) {
                    if (findrec > 0) {
                        return -3;
                    }
                    if (findrec == -1) {
                        return -3;
                    }
                    return rec;
                }
                this.foundExact = true;
                if (findrec > 0 && rec == findrec) {
                    return rec;
                }
                if (findrec == -1) {
                    return rec;
                }
                if (findrec == -2) {
                    return rec;
                }
            }
            aNode.pos_up();
        }
        return -4;
    }

    @Override
    public int get_next_key() throws xBaseJException, IOException {
        return this.get_next_key((MNode)this.workNode);
    }

    private int get_next_key(MNode aNode) throws xBaseJException, IOException {
        if (aNode == null) {
            return -1;
        }
        int leaf = aNode.get_lower_level();
        int until = aNode.branch ? aNode.get_keys_in_this_Node() + 1 : aNode.get_keys_in_this_Node();
        aNode.pos_up();
        if (aNode.get_pos() >= until) {
            MNode rNode = (MNode)aNode.get_prev();
            int rec = this.get_next_key(rNode);
            if (rec == -1) {
                aNode.set_pos(until);
                return -1;
            }
            this.workNode = aNode;
            aNode.set_record_number(rec);
            aNode.read();
            aNode.set_pos(0);
        }
        leaf = aNode.get_lower_level();
        this.workNode = aNode;
        if (leaf > 0) {
            return leaf;
        }
        return aNode.get_key_record_number();
    }

    @Override
    public int get_prev_key() throws xBaseJException, IOException {
        return this.get_prev_key((MNode)this.workNode);
    }

    private int get_prev_key(MNode aNode) throws xBaseJException, IOException {
        if (aNode == null) {
            return -1;
        }
        if (aNode.get_pos() < 0) {
            return -1;
        }
        int leaf = aNode.get_lower_level();
        int until = 0;
        if (aNode.get_pos() > -1) {
            aNode.pos_down();
        }
        if (aNode.get_pos() < 0) {
            int rec = this.get_prev_key((MNode)aNode.get_prev());
            if (rec == -1) {
                return -1;
            }
            aNode.set_record_number(rec);
            aNode.read();
            aNode.set_pos(aNode.get_keys_in_this_Node() + until);
            aNode.pos_down();
        }
        leaf = aNode.get_lower_level();
        this.workNode = aNode;
        if (leaf > 0) {
            return leaf;
        }
        return aNode.get_key_record_number();
    }

    private void anchor_write() throws IOException {
        this.mfile.anchor.write();
    }

    @Override
    public int add_entry(NodeKey NDXkey, int recno) throws xBaseJException, IOException {
        if (this.topNode != null) {
            this.find_entry(NDXkey, -2);
        }
        this.set_active_key(NDXkey);
        return this.update_entry((MNode)this.workNode, NDXkey, recno, 0);
    }

    private int update_entry(MNode aNode, NodeKey NDXkey, int recno, int oldrecno) throws IOException, xBaseJException {
        if (this.topNode == null || this.topNode.get_record_number() == 0) {
            if (this.topNode == null) {
                this.topNode = new MNode(this.mfile, (int)this.key_per_Node, (int)this.key_length, this.keyType, this.mfile.anchor.get_nextavailable(), false);
            }
            this.workNode = this.topNode;
            this.topNode.set_next(null);
            this.topNode.set_prev(null);
            this.topNode.set_pos(0);
            this.topNode.set_key_record_number(recno);
            this.topNode.set_key_value(NDXkey);
            this.topNode.set_keys_in_this_Node(1);
            this.tagHead.top_Node = this.mfile.anchor.get_nextavailable();
            this.topNode.set_record_number(this.tagHead.top_Node);
            this.topNode.set_lower_level(0);
            this.topNode.write();
            this.tagHead.top_Node = this.mfile.anchor.get_nextavailable();
            this.tagHead.pagesused += this.mfile.anchor.get_blocksize();
            this.tagHead.write();
            this.mfile.anchor.update_nextavailable();
            return 0;
        }
        if (aNode == null) {
            MNode newNode = new MNode(this.mfile, (int)this.key_per_Node, (int)this.key_length, this.keyType, this.mfile.anchor.get_nextavailable(), true);
            newNode.set_next(null);
            newNode.set_prev(null);
            this.topNode = newNode;
            newNode.set_pos(0);
            newNode.set_key_record_number(recno);
            newNode.set_key_value(NDXkey);
            newNode.set_pos(1);
            newNode.set_key_record_number(oldrecno);
            newNode.set_pos(0);
            newNode.set_keys_in_this_Node(1);
            this.tagHead.top_Node = this.mfile.anchor.get_nextavailable();
            newNode.set_record_number(this.tagHead.top_Node);
            newNode.write();
            this.tagHead.pagesused += this.mfile.anchor.get_blocksize();
            this.tagHead.write();
            this.mfile.anchor.update_nextavailable();
            return 0;
        }
        int savepos = aNode.get_pos();
        if (savepos < aNode.get_keys_in_this_Node()) {
            int i = aNode.get_keys_in_this_Node();
            aNode.set_pos(i);
            int ptr = aNode.get_lower_level();
            aNode.pos_up();
            aNode.set_lower_level(ptr);
            aNode.set_pos(i);
            while (i > -1 && i >= savepos) {
                ptr = aNode.get_lower_level();
                int recn = aNode.get_key_record_number();
                NodeKey buf = aNode.get_key_value();
                aNode.pos_up();
                aNode.set_lower_level(ptr);
                aNode.set_key_record_number(recn);
                aNode.set_key_value(buf);
                aNode.set_pos(i - 1);
                --i;
            }
            aNode.set_pos(savepos);
            aNode.set_lower_level(recno);
            aNode.set_key_record_number(recno);
            aNode.set_key_value(NDXkey);
            if (oldrecno > 0) {
                aNode.pos_up();
                aNode.set_lower_level(oldrecno);
                aNode.pos_down();
            }
        } else {
            aNode.set_pos(aNode.get_keys_in_this_Node());
            aNode.set_lower_level(recno);
            aNode.set_key_record_number(recno);
            aNode.set_key_value(NDXkey);
            if (oldrecno > 0) {
                aNode.pos_up();
                aNode.set_lower_level(oldrecno);
                aNode.pos_down();
            }
        }
        aNode.set_keys_in_this_Node(aNode.get_keys_in_this_Node() + 1);
        aNode.write();
        if (aNode.get_keys_in_this_Node() > this.key_per_Node) {
            this.splitNode(aNode, savepos);
        }
        return 0;
    }

    private void splitNode(MNode aNode, int savepos) throws xBaseJException, IOException {
        MNode bNode = new MNode(this.mfile, (int)this.key_per_Node, (int)this.key_length, this.keyType, 0, aNode.isBranch());
        bNode.set_pos(0);
        aNode.set_pos(0);
        int k = 0;
        while (k < aNode.get_keys_in_this_Node()) {
            bNode.set_lower_level(aNode.get_lower_level());
            bNode.set_key_record_number(aNode.get_key_record_number());
            bNode.set_key_value(aNode.get_key_value());
            bNode.pos_up();
            aNode.pos_up();
            ++k;
        }
        bNode.set_lower_level(aNode.get_lower_level());
        bNode.set_key_value("");
        int i = aNode.get_keys_in_this_Node() / 2;
        int j = aNode.get_keys_in_this_Node() - i;
        if (savepos > i) {
            bNode.set_keys_in_this_Node(i);
            if (aNode.get_next() != null) {
                aNode.set_keys_in_this_Node(i - 1);
            } else {
                aNode.set_keys_in_this_Node(i);
            }
            int left = aNode.get_record_number();
            aNode.write();
            int right = this.mfile.anchor.get_nextavailable();
            this.mfile.anchor.update_nextavailable();
            if (aNode.get_prev() != null) {
                bNode.set_pos(i - 1);
                this.update_entry((MNode)aNode.get_prev(), bNode.get_key_value(), left, right);
            }
            aNode.set_pos(0);
            bNode.set_pos(i);
            k = 0;
            while (k <= j) {
                aNode.set_lower_level(bNode.get_lower_level());
                aNode.set_key_record_number(bNode.get_key_record_number());
                aNode.set_key_value(bNode.get_key_value());
                aNode.pos_up();
                bNode.pos_up();
                ++k;
            }
            aNode.set_keys_in_this_Node(j);
            aNode.set_pos(savepos - i);
            aNode.set_record_number(right);
            aNode.write();
            if (aNode.get_prev() == null) {
                bNode.set_pos(i - 1);
                this.update_entry(null, bNode.get_key_value(), left, right);
                aNode.set_prev(this.topNode);
                this.topNode.set_next(aNode);
            }
        } else {
            int right = aNode.get_record_number();
            aNode.set_pos(0);
            bNode.set_pos(j);
            k = 0;
            while (k <= i) {
                aNode.set_lower_level(bNode.get_lower_level());
                aNode.set_key_record_number(bNode.get_key_record_number());
                aNode.set_key_value(bNode.get_key_value());
                aNode.pos_up();
                bNode.pos_up();
                ++k;
            }
            aNode.set_keys_in_this_Node(i);
            aNode.write();
            bNode.set_keys_in_this_Node(i);
            aNode.set_pos(0);
            bNode.set_pos(0);
            k = 0;
            while (k < this.key_per_Node) {
                aNode.set_lower_level(bNode.get_lower_level());
                aNode.set_key_record_number(bNode.get_key_record_number());
                aNode.set_key_value(bNode.get_key_value());
                aNode.pos_up();
                bNode.pos_up();
                ++k;
            }
            aNode.set_record_number(this.mfile.anchor.get_nextavailable());
            this.mfile.anchor.update_nextavailable();
            if (aNode.get_next() != null) {
                aNode.set_keys_in_this_Node(j - 1);
            } else {
                aNode.set_keys_in_this_Node(j);
            }
            aNode.set_pos(j - 1);
            aNode.write();
            int left = aNode.get_record_number();
            this.update_entry((MNode)aNode.get_prev(), aNode.get_key_value(), left, right);
            if (aNode.get_prev() == null) {
                aNode.set_prev(this.topNode);
                this.topNode.set_next(aNode);
            }
        }
        bNode = null;
    }

    @Override
    public void del_entry(Node inNode) throws IOException, xBaseJException {
        int pos;
        MNode aNode = (MNode)inNode;
        int k = pos = aNode.get_pos();
        aNode.set_keys_in_this_Node(aNode.get_keys_in_this_Node() - 1);
        if (aNode.get_lower_level() != 0 && pos <= aNode.get_keys_in_this_Node()) {
            k = pos - 1;
            while (k < aNode.get_keys_in_this_Node()) {
                aNode.pos_up();
                int level = aNode.get_lower_level();
                int rec = aNode.get_key_record_number();
                NodeKey key = aNode.get_key_value();
                aNode.pos_down();
                aNode.set_lower_level(level);
                aNode.set_key_record_number(rec);
                aNode.set_key_value(key);
                aNode.pos_up();
                ++k;
            }
        } else if (pos < aNode.get_keys_in_this_Node()) {
            k = pos;
            while (k < aNode.get_keys_in_this_Node()) {
                aNode.pos_up();
                int level = aNode.get_lower_level();
                int rec = aNode.get_key_record_number();
                NodeKey key = aNode.get_key_value();
                aNode.pos_down();
                aNode.set_lower_level(level);
                aNode.set_key_record_number(rec);
                aNode.set_key_value(key);
                aNode.pos_up();
                ++k;
            }
        }
        if (aNode.get_prev() != null) {
            if (aNode.get_keys_in_this_Node() == 0) {
                if (aNode.get_lower_level() == 0) {
                    this.del_entry(aNode.get_prev());
                }
            } else if (aNode.get_keys_in_this_Node() == -1) {
                this.del_entry(aNode.get_prev());
            }
        }
        aNode.set_pos(pos);
        aNode.write();
    }
}

