/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.swing;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.xBaseJ.fields.Field;
import org.xBaseJ.fields.MemoField;
import org.xBaseJ.swing.dbfTableModel;
import org.xBaseJ.swing.dbfTableRecordMemoDialog;
import org.xBaseJ.swing.dbfViewer;

class dbfViewerRecordPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    dbfViewer parent;
    JPanel p;
    JScrollPane sp = new JScrollPane(this);
    JPanel viewPane;
    GridBagLayout gb;
    GridBagConstraints gbc;
    JLabel crl;
    JLabel trl;
    JCheckBox delCB;
    JButton Prev;
    JButton Next;
    JButton Add;
    JButton Update;
    JButton Clear;
    Vector fldObjects;
    JLabel l;
    JTextField t;
    Field f;
    JButton b;
    JCheckBox c;
    int currentRow;
    dbfTableModel tableModel;

    public dbfViewerRecordPanel(dbfViewer inParent, dbfTableModel indbfTableModel) throws Exception {
        this.parent = inParent;
        this.tableModel = indbfTableModel;
        this.setupDBFields();
    }

    public void setupDBFields() throws Exception {
        this.setLayout(null);
        Dimension dimView = this.sp.getSize();
        int height = 0;
        int width = 50;
        this.removeAll();
        this.gb = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.setLayout(this.gb);
        if (this.tableModel.getColumnCount() > 0) {
            this.fldObjects = new Vector(this.tableModel.getColumnCount() - 1);
            int i = 0;
            while (i < this.tableModel.getColumnCount() - 1) {
                Field f = this.tableModel.getColumnField(i);
                if (f.getType() == 'M' || f.getType() == 'P') {
                    this.b = new JButton(f.getName());
                    this.b.setActionCommand("M" + i);
                    this.b.addActionListener(this);
                    dbfViewerRecordPanel.addComponent(this, this.b, 1, i, 1, 1, 2, 13);
                    this.fldObjects.addElement(this.b);
                } else if (f.getType() == 'L') {
                    this.c = new JCheckBox(f.getName(), true);
                    this.c.setActionCommand("L" + i);
                    this.c.addActionListener(this);
                    dbfViewerRecordPanel.addComponent(this, this.c, 1, i, 1, 1, 2, 13);
                    this.fldObjects.addElement(this.c);
                } else {
                    this.l = new JLabel(f.getName(), 2);
                    dbfViewerRecordPanel.addComponent(this, this.l, 0, i, 1, 1, 2, 13);
                    int ln = f.getLength();
                    if (ln > 100) {
                        ln = 100;
                    }
                    this.t = new JTextField(f.getName(), ln);
                    this.t.setName(f.getName());
                    this.t.setActionCommand("T" + i);
                    this.t.getDocument().addDocumentListener(this.parent);
                    this.t.getDocument().putProperty("name", "" + i);
                    this.t.setEditable(true);
                    if (width < ln * 10) {
                        width = ln * 10;
                    }
                    dbfViewerRecordPanel.addComponent(this, this.t, 1, i, ln, 1, 2, 13);
                    this.fldObjects.addElement(this.t);
                }
                height += 10;
                ++i;
            }
            this.c = new JCheckBox("Deleted");
            this.c.setActionCommand("L" + i);
            this.c.addActionListener(this);
            dbfViewerRecordPanel.addComponent(this, this.c, 1, i, 1, 1, 2, 13);
            this.fldObjects.addElement(this.c);
            height += 10;
        }
        dimView.setSize(width + 150, height + 150);
        this.sp.setSize(dimView);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int col = Integer.parseInt(e.getActionCommand().substring(1));
        switch (e.getActionCommand().charAt(0)) {
            case 'M': {
                this.parent.setCursor(new Cursor(3));
                this.setCursor(new Cursor(3));
                new dbfTableRecordMemoDialog(this.parent, this, this.tableModel, this.parent.editingRow, col).setVisible(true);
                break;
            }
            case 'L': {
                this.c = (JCheckBox)this.fldObjects.elementAt(col);
                this.tableModel.setValueAt(this.c.isSelected(), this.parent.editingRow, col);
                this.tableModel.fireTableCellUpdated(this.parent.editingRow, col);
            }
        }
    }

    public void goTo(int where) {
        this.parent.editingRow = where - 1;
        try {
            Boolean bln;
            JCheckBox c;
            if (where < 1) {
                return;
            }
            if (where > this.tableModel.getRowCount()) {
                return;
            }
            int i = 0;
            while (i < this.tableModel.getColumnCount() - 1) {
                Field f = this.tableModel.getColumnField(i);
                if (!(f instanceof MemoField)) {
                    if (f.getType() == 'L') {
                        c = (JCheckBox)this.fldObjects.elementAt(i);
                        bln = (Boolean)this.tableModel.getValueAt(where - 1, i);
                        c.setSelected(bln);
                    } else {
                        JTextField t = (JTextField)this.fldObjects.elementAt(i);
                        t.setText((String)this.tableModel.getValueAt(where - 1, i));
                    }
                }
                ++i;
            }
            c = (JCheckBox)this.fldObjects.elementAt(i);
            bln = (Boolean)this.tableModel.getValueAt(where - 1, i);
            c.setSelected(bln);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            System.exit(2);
        }
    }

    public static void addComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, int fill, int anchor) throws AWTException {
        LayoutManager lm = container.getLayout();
        if (!(lm instanceof GridBagLayout)) {
            throw new AWTException("Invalid layout" + lm);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        gbc.fill = fill;
        gbc.anchor = anchor;
        ((GridBagLayout)lm).setConstraints(component, gbc);
        container.add(component);
    }
}

