/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.ActionManager;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.LocalStorage;
import org.jdesktop.application.ResourceManager;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SessionStorage;
import org.jdesktop.application.TaskMonitor;
import org.jdesktop.application.TaskService;

public class ApplicationContext
extends AbstractBean {
    private static final Logger logger = Logger.getLogger(ApplicationContext.class.getName());
    private final List<TaskService> taskServices;
    private final List<TaskService> taskServicesReadOnly;
    private ResourceManager resourceManager = new ResourceManager(this);
    private ActionManager actionManager = new ActionManager(this);
    private LocalStorage localStorage = new LocalStorage(this);
    private SessionStorage sessionStorage = new SessionStorage(this);
    private Application application = null;
    private Class applicationClass = null;
    private JComponent focusOwner = null;
    private Clipboard clipboard = null;
    private TaskMonitor taskMonitor = null;

    protected ApplicationContext() {
        this.taskServices = new CopyOnWriteArrayList<TaskService>();
        this.taskServices.add(new TaskService("default"));
        this.taskServicesReadOnly = Collections.unmodifiableList(this.taskServices);
    }

    public final synchronized Class getApplicationClass() {
        return this.applicationClass;
    }

    public final synchronized void setApplicationClass(Class applicationClass) {
        if (this.application != null) {
            throw new IllegalStateException("application has been launched");
        }
        this.applicationClass = applicationClass;
    }

    public final synchronized Application getApplication() {
        return this.application;
    }

    synchronized void setApplication(Application application) {
        if (this.application != null) {
            throw new IllegalStateException("application has already been launched");
        }
        this.application = application;
    }

    public final ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    protected void setResourceManager(ResourceManager resourceManager) {
        if (resourceManager == null) {
            throw new IllegalArgumentException("null resourceManager");
        }
        ResourceManager oldValue = this.resourceManager;
        this.resourceManager = resourceManager;
        this.firePropertyChange("resourceManager", oldValue, this.resourceManager);
    }

    public final ResourceMap getResourceMap(Class cls) {
        return this.getResourceManager().getResourceMap(cls, cls);
    }

    public final ResourceMap getResourceMap(Class startClass, Class stopClass) {
        return this.getResourceManager().getResourceMap(startClass, stopClass);
    }

    public final ResourceMap getResourceMap() {
        return this.getResourceManager().getResourceMap();
    }

    public final ActionManager getActionManager() {
        return this.actionManager;
    }

    protected void setActionManager(ActionManager actionManager) {
        if (actionManager == null) {
            throw new IllegalArgumentException("null actionManager");
        }
        ActionManager oldValue = this.actionManager;
        this.actionManager = actionManager;
        this.firePropertyChange("actionManager", oldValue, this.actionManager);
    }

    public final ApplicationActionMap getActionMap() {
        return this.getActionManager().getActionMap();
    }

    public final ApplicationActionMap getActionMap(Class actionsClass, Object actionsObject) {
        return this.getActionManager().getActionMap(actionsClass, actionsObject);
    }

    public final ApplicationActionMap getActionMap(Object actionsObject) {
        if (actionsObject == null) {
            throw new IllegalArgumentException("null actionsObject");
        }
        return this.getActionManager().getActionMap(actionsObject.getClass(), actionsObject);
    }

    public final LocalStorage getLocalStorage() {
        return this.localStorage;
    }

    protected void setLocalStorage(LocalStorage localStorage) {
        if (localStorage == null) {
            throw new IllegalArgumentException("null localStorage");
        }
        LocalStorage oldValue = this.localStorage;
        this.localStorage = localStorage;
        this.firePropertyChange("localStorage", oldValue, this.localStorage);
    }

    public final SessionStorage getSessionStorage() {
        return this.sessionStorage;
    }

    protected void setSessionStorage(SessionStorage sessionStorage) {
        if (sessionStorage == null) {
            throw new IllegalArgumentException("null sessionStorage");
        }
        SessionStorage oldValue = this.sessionStorage;
        this.sessionStorage = sessionStorage;
        this.firePropertyChange("sessionStorage", oldValue, this.sessionStorage);
    }

    public Clipboard getClipboard() {
        if (this.clipboard == null) {
            try {
                this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (SecurityException securityException) {
                this.clipboard = new Clipboard("sandbox");
            }
        }
        return this.clipboard;
    }

    public JComponent getFocusOwner() {
        return this.focusOwner;
    }

    void setFocusOwner(JComponent focusOwner) {
        JComponent oldValue = this.focusOwner;
        this.focusOwner = focusOwner;
        this.firePropertyChange("focusOwner", oldValue, this.focusOwner);
    }

    private List<TaskService> copyTaskServices() {
        return new ArrayList<TaskService>(this.taskServices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskService(TaskService taskService) {
        if (taskService == null) {
            throw new IllegalArgumentException("null taskService");
        }
        List<TaskService> oldValue = null;
        List<TaskService> newValue = null;
        boolean changed = false;
        List<TaskService> list = this.taskServices;
        synchronized (list) {
            if (!this.taskServices.contains(taskService)) {
                oldValue = this.copyTaskServices();
                this.taskServices.add(taskService);
                newValue = this.copyTaskServices();
                changed = true;
            }
        }
        if (changed) {
            this.firePropertyChange("taskServices", oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskService(TaskService taskService) {
        if (taskService == null) {
            throw new IllegalArgumentException("null taskService");
        }
        List<TaskService> oldValue = null;
        List<TaskService> newValue = null;
        boolean changed = false;
        List<TaskService> list = this.taskServices;
        synchronized (list) {
            if (this.taskServices.contains(taskService)) {
                oldValue = this.copyTaskServices();
                this.taskServices.remove(taskService);
                newValue = this.copyTaskServices();
                changed = true;
            }
        }
        if (changed) {
            this.firePropertyChange("taskServices", oldValue, newValue);
        }
    }

    public TaskService getTaskService(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        for (TaskService taskService : this.taskServices) {
            if (!name.equals(taskService.getName())) continue;
            return taskService;
        }
        return null;
    }

    public final TaskService getTaskService() {
        return this.getTaskService("default");
    }

    public List<TaskService> getTaskServices() {
        return this.taskServicesReadOnly;
    }

    public final TaskMonitor getTaskMonitor() {
        if (this.taskMonitor == null) {
            this.taskMonitor = new TaskMonitor(this);
        }
        return this.taskMonitor;
    }
}

