/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.text.StringCharacterIterator;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JLabel;

class MnemonicText {
    private static final String DISPLAYED_MNEMONIC_INDEX_KEY = "SwingDisplayedMnemonicIndexKey";

    private MnemonicText() {
    }

    public static void configure(Object target, String markedText) {
        String text = markedText;
        int mnemonicIndex = -1;
        int mnemonicKey = 0;
        int markerIndex = MnemonicText.mnemonicMarkerIndex(markedText, '&');
        if (markerIndex == -1) {
            markerIndex = MnemonicText.mnemonicMarkerIndex(markedText, '_');
        }
        if (markerIndex != -1) {
            text = String.valueOf(text.substring(0, markerIndex)) + text.substring(markerIndex + 1);
            mnemonicIndex = markerIndex;
            StringCharacterIterator sci = new StringCharacterIterator(markedText, markerIndex);
            mnemonicKey = MnemonicText.mnemonicKey(sci.next());
        }
        if (target instanceof Action) {
            MnemonicText.configureAction((Action)target, text, mnemonicKey, mnemonicIndex);
        } else if (target instanceof AbstractButton) {
            MnemonicText.configureButton((AbstractButton)target, text, mnemonicKey, mnemonicIndex);
        } else if (target instanceof JLabel) {
            MnemonicText.configureLabel((JLabel)target, text, mnemonicKey, mnemonicIndex);
        } else {
            throw new IllegalArgumentException("unrecognized target type " + target);
        }
    }

    private static int mnemonicMarkerIndex(String s, char marker) {
        if (s == null || s.length() < 2) {
            return -1;
        }
        StringCharacterIterator sci = new StringCharacterIterator(s);
        int i = 0;
        while (i != -1) {
            if ((i = s.indexOf(marker, i)) != -1) {
                sci.setIndex(i);
                char c1 = sci.previous();
                sci.setIndex(i);
                char c2 = sci.next();
                boolean isQuote = c1 == '\'' && c2 == '\'';
                boolean isSpace = Character.isWhitespace(c2);
                if (!isQuote && !isSpace && c2 != '\uffff') {
                    return i;
                }
            }
            if (i == -1) continue;
            ++i;
        }
        return -1;
    }

    private static int mnemonicKey(char c) {
        int vk = c;
        if (vk >= 97 && vk <= 122) {
            vk -= 32;
        }
        return vk;
    }

    private static void configureAction(Action target, String text, int key, int index) {
        target.putValue("Name", text);
        if (key != 0) {
            target.putValue("MnemonicKey", key);
        }
        if (index != -1) {
            target.putValue(DISPLAYED_MNEMONIC_INDEX_KEY, index);
        }
    }

    private static void configureButton(AbstractButton target, String text, int key, int index) {
        target.setText(text);
        if (key != 0) {
            target.setMnemonic(key);
        }
        if (index != -1) {
            target.setDisplayedMnemonicIndex(index);
        }
    }

    private static void configureLabel(JLabel target, String text, int key, int index) {
        target.setText(text);
        if (key != 0) {
            target.setDisplayedMnemonic(key);
        }
        if (index != -1) {
            target.setDisplayedMnemonicIndex(index);
        }
    }
}

