/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.analize.komitenti;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Valuta;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.reports.engine.standard.PzResultSetDataSourceAdapter;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.util.PzDateUtility;

public class PzDialogSpecifikacija
extends PzDialog {
    private static final String KUPAC = "Kupci";
    private static final String DOBAVLJAC = "Dobavlja\u010di";
    private static final String DOMACI = "Doma\u0107i";
    private static final String INOSTRANI = "Inostrani";
    private static final String PO_SIFRI = "Po \u0161ifri";
    private static final String PO_VREDNOSTI = "Po vrednosti";
    private static final String SA_FAKTURAMA_IZ_M = "Sa fakturama iz maloprodaje";
    private static final String BEZ_FAKTURA_IZ_M = "Bez faktura iz maloprodaje";
    private PzPanel mainPanel;
    private PzRadioGroup<String> panelRBs1;
    private PzRadioGroup<String> panelRBs2;
    private PzRadioGroup<String> panelRBs3;
    private PzRadioGroup<String> panelRBs4;
    private PzButton btnPotvrdi;
    private ScrollableCursor cursor = null;
    private JPanel pnlValuta;
    private PzComboBox cbValuta;

    public PzDialogSpecifikacija(JFrame frame) {
        super(frame);
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        Query q = PzEntityManager.getEm().createQuery("Select v from Valuta v");
        Iterator i = q.getResultList().iterator();
        this.cbValuta.addItem((Object)new PzChoice("", (Object)""));
        while (i.hasNext()) {
            Valuta v = (Valuta)i.next();
            this.cbValuta.addItem((Object)new PzChoice(v.getNaziv(), (Object)v.getOznValuta()));
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Specifikacija kupca - dobavlja\u010da");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.rowHeights = new int[]{15, 74, 9, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.columnWidths = new int[]{103, 98, 93, 178, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.panelRBs1 = new PzRadioGroup((Object[])new String[]{KUPAC, DOBAVLJAC});
            BoxLayout panelRBsLayout = new BoxLayout((Container)this.panelRBs1, 1);
            this.panelRBs1.setLayout((LayoutManager)panelRBsLayout);
            this.mainPanel.add(this.panelRBs1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.panelRBs1.setBorder((Border)BorderFactory.createTitledBorder("Grupa"));
            this.panelRBs1.setSelectedValue((Object)KUPAC);
            this.panelRBs1.setOpaque(false);
            this.panelRBs1.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getValue().equals(PzDialogSpecifikacija.DOBAVLJAC)) {
                        PzDialogSpecifikacija.this.panelRBs4.setEnabled(false);
                    } else {
                        PzDialogSpecifikacija.this.panelRBs4.setEnabled(true);
                    }
                }
            });
            this.panelRBs2 = new PzRadioGroup((Object[])new String[]{DOMACI, INOSTRANI});
            panelRBsLayout = new BoxLayout((Container)this.panelRBs2, 1);
            this.panelRBs2.setLayout((LayoutManager)panelRBsLayout);
            this.mainPanel.add(this.panelRBs2, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRBs2.setBorder((Border)BorderFactory.createTitledBorder("Poreklo"));
            this.panelRBs2.setSelectedValue((Object)DOMACI);
            this.panelRBs2.setOpaque(false);
            this.panelRBs3 = new PzRadioGroup((Object[])new String[]{PO_SIFRI, PO_VREDNOSTI});
            panelRBsLayout = new BoxLayout((Container)this.panelRBs3, 1);
            this.panelRBs3.setLayout((LayoutManager)panelRBsLayout);
            this.mainPanel.add(this.panelRBs3, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRBs3.setBorder((Border)BorderFactory.createTitledBorder("Sort"));
            this.panelRBs3.setSelectedValue((Object)PO_SIFRI);
            this.panelRBs3.setOpaque(false);
            this.panelRBs4 = new PzRadioGroup((Object[])new String[]{SA_FAKTURAMA_IZ_M, BEZ_FAKTURA_IZ_M});
            panelRBsLayout = new BoxLayout((Container)this.panelRBs4, 1);
            this.panelRBs4.setLayout((LayoutManager)panelRBsLayout);
            this.mainPanel.add(this.panelRBs4, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRBs4.setBorder((Border)BorderFactory.createTitledBorder("Opcije"));
            this.panelRBs4.setSelectedValue((Object)SA_FAKTURAMA_IZ_M);
            this.panelRBs4.setOpaque(false);
            this.btnPotvrdi = new PzButton();
            this.mainPanel.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(0, 3, 5, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(115, 33));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pnlValuta = new PzPanel();
            this.pnlValuta.setLayout(null);
            this.mainPanel.add((Component)this.pnlValuta, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
            this.pnlValuta.setBorder(BorderFactory.createTitledBorder("Izbor strane valute"));
            this.pnlValuta.setOpaque(false);
            this.cbValuta = new PzComboBox();
            this.pnlValuta.add((Component)this.cbValuta, "Center");
            this.cbValuta.setBounds(10, 31, 107, 27);
            this.pack();
            this.setSize(627, 197);
            this.setPreferredSize(new Dimension(627, 197));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    if (PzDialogSpecifikacija.this.cursor != null) {
                        PzDialogSpecifikacija.this.cursor.close();
                    }
                    String upit = "";
                    Query q = null;
                    String valuta = PzDialogSpecifikacija.this.cbValuta.getSelectedChoice().getValue().toString();
                    if (((String)PzDialogSpecifikacija.this.panelRBs1.getSelectedValue()).equals(PzDialogSpecifikacija.KUPAC)) {
                        upit = "SELECT k.sfrKomitent, k.naziv, SUM((f.iznos-f.stornoIznos)%valuta%), SUM(f.uplata%valuta%), SUM((f.iznos-f.stornoIznos-f.uplata)%valuta%)FROM Komitent k, Radnajedinica rj, Faktura f %valutaF% WHERE %valutaW% f.sfrKomitent=k.sfrKomitent and f.oznRj=rj.oznRj AND f.oznOgranak=rj.oznOgranak %tipRj% and k.domaciKomitent=':kom' and rj.oznRj IN (%listaRj%) and f.arhiviran=1 and f.storno=0 and (f.tip='FAKTURA' or f.tip='FAKTURA_IZ_SERVISA' or f.tip='FAKTURA_USLUGA')";
                        upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = f.datPrometa");
                    } else {
                        upit = "SELECT k.sfrKomitent, k.naziv, SUM((f.iznos-f.stornoIznos)%valuta%), SUM(f.uplata %valuta%), SUM((f.iznos-f.stornoIznos-f.uplata)%valuta%)FROM Komitent k, Kalkulacija f %valutaF% WHERE %valutaW% f.sfrKomitent=k.sfrKomitent and k.domaciKomitent=':kom' and f.arhiviran=1 and f.storno= 0  and ((f.tip='KALKULACIJA' and (f.podtip='FAKTURA' or f.podtip='POCETNO')) or f.tip='TROSAK' or f.tip='RACUN_DOBAVLJACA' or f.tip='ZAPISNIK_OTPREMNICE')";
                        upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = f.datum");
                    }
                    upit = ((String)PzDialogSpecifikacija.this.panelRBs3.getSelectedValue()).equals(PzDialogSpecifikacija.PO_SIFRI) ? String.valueOf(upit) + "GROUP BY k.sfrKomitent, k.naziv ORDER BY CAST(k.sfrKomitent AS NUMERIC) " : String.valueOf(upit) + "GROUP BY k.sfrKomitent, k.naziv ORDER BY 5 ";
                    upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/kurs.srednji/kurs.jedinica");
                    upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " kurs.oznValuta='" + valuta + "' and");
                    if (PzDialogRJ.getAvaliableRjString().equals("")) {
                        throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                    }
                    upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                    upit = upit.replace(":kom", ((String)PzDialogSpecifikacija.this.panelRBs2.getSelectedValue()).equals(PzDialogSpecifikacija.DOMACI) ? "1" : "0");
                    if (((String)PzDialogSpecifikacija.this.panelRBs1.getSelectedValue()).equals(PzDialogSpecifikacija.KUPAC)) {
                        upit = upit.replace("%tipRj%", ((String)PzDialogSpecifikacija.this.panelRBs4.getSelectedValue()).equals(PzDialogSpecifikacija.BEZ_FAKTURA_IZ_M) ? " and rj.gTip != 'E'" : " ");
                    }
                    q = em.createNativeQuery(upit);
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    PzDialogSpecifikacija.this.cursor = (ScrollableCursor)q.getSingleResult();
                    System.out.println("Kursor je nasao faktura" + PzDialogSpecifikacija.this.cursor.size());
                    em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                        if (PzDialogSpecifikacija.this.cursor.size() == 0) {
                            JOptionPane.showMessageDialog(PzDialogSpecifikacija.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                            PzWorkerDialog.hideStatus();
                            return;
                        }
                        try {
                            PzDialogSpecifikacija.this.showReport();
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogSpecifikacija.this), (Throwable)e);
                            PzWorkerDialog.hideStatus();
                        }
                    }
                    finally {
                        em.close();
                    }
                }
            };
            worker.execute();
        }
    }

    private void showReport() throws Exception {
        Vector<Firma> data = new Vector<Firma>();
        Date today = PzDateUtility.getCurrentDate();
        PzDataSourceExtended ds = new PzDataSourceExtended(data, this.cursor);
        ds.setAdapter((PzDataSourceAdapter)new PzResultSetDataSourceAdapter());
        String title = "";
        String fname = "";
        if (((String)this.panelRBs1.getSelectedValue()).equals(KUPAC)) {
            title = "SPECIFIKACIJA KUPCA";
            fname = "rs/pezar/analitike/resource/reports/compiled/specifikacija.kupca.dobavljaca.jasper";
        } else {
            title = "SPECIFIKACIJA DOBAVLJA\u010cA";
            fname = "rs/pezar/analitike/resource/reports/compiled/specifikacija.kupca.dobavljaca.jasper";
        }
        String valuta = "Vrednosti su izra\u017eene u valuti: " + (this.cbValuta.getSelectedChoice().getValue().equals("") ? "Dinar" : this.cbValuta.getSelectedChoice().getText());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", title);
        params.put("datum", today);
        params.put("reklama", "");
        params.put("valuta", valuta);
        data.add(PzFirma.getFirma());
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource(fname), params, (String)title);
    }
}

