/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.garniture.Demontaza;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.eclipse.persistence.indirection.IndirectList;
import org.jdesktop.application.Application;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Artikalgarnitura;
import rs.pezar.db.entity.Artikalnivelacija;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Garnitura;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class UtvrdjivanjePrncKomponenti
extends PzDialog {
    private PzPanel pnlGlavni;
    private PzPanel pnlFields;
    private JLabel lblKoeficient;
    private PzTextField tfNaziv;
    private JLabel lblNabavnaCena;
    private PzDoubleField dfNabavnaCena;
    private PzDoubleField dfKoeficijent;
    private JLabel lblNaziv;
    private PzTextField tfSifra;
    private JLabel lblSifra;
    private PzDoubleField dfZbir;
    private JLabel lblZbir;
    private PzDoubleField dfSklop;
    private JLabel lblSklop;
    private PzButton btnPotvrdi;
    private Artikal garnitura;
    private Radnajedinica rj;
    private Date datum;
    private Double kolicina;
    private EntityManager em;
    private Stanje stanjeGarnitura;
    private int index;
    private Garnitura zapisnik;
    private Nivelacija nivelacija;

    public UtvrdjivanjePrncKomponenti(PzDialog dialog) {
        super(dialog);
        this.initGUI();
        this.garnitura = (Artikal)this.getSession().getParameter("garnitura");
        this.rj = (Radnajedinica)this.getSession().getParameter("rj");
        this.datum = (Date)this.getSession().getParameter("datum");
        this.kolicina = (Double)this.getSession().getParameter("kolicina");
        this.em = (EntityManager)this.getSession().getParameter("em");
        this.postInit();
    }

    private void postInit() {
        Artikalgarnitura artGar = (Artikalgarnitura)this.garnitura.getDeloviGarniture().get(0);
        this.stanjeGarnitura = (Stanje)this.em.find(Stanje.class, (Object)new StanjePK(this.garnitura.getSfrProizvod(), this.rj));
        this.dfSklop.setVal((Object)this.stanjeGarnitura.getProsNabCena());
        Stanje stanjeArtikal = (Stanje)this.em.find(Stanje.class, (Object)new StanjePK(artGar.getId().getDeo(), this.rj));
        this.dfZbir.setVal((Object)(stanjeArtikal.getProsNabCena().doubleValue() * artGar.getKolicina()));
        this.tfSifra.setVal((Object)artGar.getId().getDeo());
        this.tfNaziv.setVal((Object)artGar.getDeo().getNaziv());
        this.dfKoeficijent.setVal((Object)artGar.getKolicina());
        this.dfNabavnaCena.setVal((Object)stanjeArtikal.getProsNabCena());
        this.index = 1;
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Utvr\u0111ivanje prose\u010dne nabavne cene komponenti");
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout1 = new GridBagLayout();
            new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout1.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout1.rowHeights = new int[]{54, 65, 73, 7};
            pnlGlavniLayout1.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout1.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout1);
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlFields, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlFieldsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.rowHeights = new int[]{22, 25, 25, 25, 25, 25, 25, 7};
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.columnWidths = new int[]{15, 136, 115, 108, 7};
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.pnlFields.setOpaque(false);
            this.lblSklop = new JLabel();
            this.pnlFields.add((Component)this.lblSklop, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 20, 0, 0), 0, 0));
            this.lblSklop.setName("lblSklop");
            this.dfSklop = new PzDoubleField();
            this.pnlFields.add((Component)this.dfSklop, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfSklop.setForeground(new Color(255, 0, 0));
            this.dfSklop.setFocusable(false);
            this.lblZbir = new JLabel();
            this.pnlFields.add((Component)this.lblZbir, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 20, 0, 0), 0, 0));
            this.lblZbir.setName("lblZbir");
            this.dfZbir = new PzDoubleField();
            this.pnlFields.add((Component)this.dfZbir, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfZbir.setForeground(new Color(255, 0, 0));
            this.dfZbir.setFocusable(false);
            this.lblSifra = new JLabel();
            this.pnlFields.add((Component)this.lblSifra, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 20, 0, 0), 0, 0));
            this.lblSifra.setName("lblSifra");
            this.tfSifra = new PzTextField();
            this.pnlFields.add((Component)this.tfSifra, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfSifra.setForeground(new Color(0, 0, 255));
            this.tfSifra.setFocusable(false);
            this.lblNaziv = new JLabel();
            this.pnlFields.add((Component)this.lblNaziv, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 20, 0, 0), 0, 0));
            this.lblNaziv.setName("lblNaziv");
            this.tfNaziv = new PzTextField();
            this.pnlFields.add((Component)this.tfNaziv, (Object)new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfNaziv.setForeground(new Color(0, 0, 255));
            this.tfNaziv.setFocusable(false);
            this.lblKoeficient = new JLabel();
            this.pnlFields.add((Component)this.lblKoeficient, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 20, 0, 0), 0, 0));
            this.lblKoeficient.setName("lblKoeficient");
            this.dfKoeficijent = new PzDoubleField();
            this.pnlFields.add((Component)this.dfKoeficijent, (Object)new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfKoeficijent.setForeground(new Color(0, 0, 255));
            this.dfKoeficijent.setFocusable(false);
            this.lblNabavnaCena = new JLabel();
            this.pnlFields.add((Component)this.lblNabavnaCena, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 20, 0, 0), 0, 0));
            this.lblNabavnaCena.setText("Nabavna cene");
            this.dfNabavnaCena = new PzDoubleField();
            this.pnlFields.add((Component)this.dfNabavnaCena, (Object)new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi = new PzButton();
            this.pnlFields.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Dalje");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(115, 33));
            this.btnPotvrdi.setActionCommand("dalje");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setShortcut("enter");
            this.pack();
            this.setSize(415, 341);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        try {
            if (actionCommand.equals("dalje")) {
                if (this.index < this.garnitura.getDeloviGarniture().size()) {
                    if (this.dfZbir.getVal() > this.dfSklop.getVal()) {
                        PzSwingUtility.showErrorMessage((Component)((Object)this), (String)(" Prose\u010dna nabavna cena sklopa: " + this.dfSklop.getVal() + "\n Prose\u010dna nabavna cena zbira komponenti: " + this.dfZbir.getVal() + "\n DALJI RADI NEMOGU\u0106!!!"));
                    } else {
                        Artikalgarnitura artGar = (Artikalgarnitura)this.garnitura.getDeloviGarniture().get(this.index);
                        this.stanjeGarnitura = (Stanje)this.em.find(Stanje.class, (Object)new StanjePK(this.garnitura.getSfrProizvod(), this.rj));
                        this.dfSklop.setVal((Object)this.stanjeGarnitura.getProsNabCena());
                        Stanje stanjeArtikal = (Stanje)this.em.find(Stanje.class, (Object)new StanjePK(artGar.getId().getDeo(), this.rj));
                        this.dfZbir.setVal((Object)(this.dfZbir.getVal() + stanjeArtikal.getProsNabCena().doubleValue() * artGar.getKolicina()));
                        this.tfSifra.setVal((Object)artGar.getId().getDeo());
                        this.tfNaziv.setVal((Object)artGar.getDeo().getNaziv());
                        this.dfKoeficijent.setVal((Object)artGar.getKolicina());
                        this.dfNabavnaCena.setVal((Object)stanjeArtikal.getProsNabCena());
                        ++this.index;
                        if (this.index == this.garnitura.getDeloviGarniture().size()) {
                            this.btnPotvrdi.setText("Potvrdi");
                            this.btnPotvrdi.setActionCommand("potvrdi");
                        }
                    }
                }
            } else if (actionCommand.equals("potvrdi")) {
                System.out.println(this.dfSklop.getVal());
                System.out.println(this.dfZbir.getVal());
                if (!this.dfZbir.getVal().equals(this.dfSklop.getVal())) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)(" Prose\u010dna nabavna cena sklopa: " + this.dfSklop.getVal() + "\n Prose\u010dna nabavna cena zbira komponenti: " + this.dfZbir.getVal() + "\n DALJI RADI NEMOGU\u0106!!!"));
                } else {
                    this.em.getTransaction().begin();
                    this.createGarnitura(this.em);
                    int br = 1;
                    double prodCena = 0.0;
                    double prncCena = 0.0;
                    for (Artikalgarnitura artGar : this.garnitura.getDeloviGarniture()) {
                        Stanje stanje = (Stanje)this.em.find(Stanje.class, (Object)new StanjePK(artGar.getId().getDeo(), this.rj));
                        Artikalopstidokument artOp = new Artikalopstidokument();
                        artOp.setId(this.zapisnik.getIdDok(), artGar.getId().getDeo(), br);
                        artOp.setNaziv(artGar.getDeo().getNaziv());
                        artOp.setJm(artGar.getDeo().getJedMere());
                        artOp.setOpstidokument((Opstidokument)this.zapisnik);
                        artOp.setKolicina(artGar.getKolicina());
                        artOp.setKolicinaBaza(artGar.getKolicina() * this.kolicina);
                        artOp.setProsNabCena(stanje.getProsNabCena());
                        artOp.setProdCena(new BigDecimal(stanje.getProdCena()));
                        this.em.persist((Object)artOp);
                        stanje.setDatZadIzlaza(this.datum);
                        stanje.setKolicina(stanje.getKolicina() + artGar.getKolicina() * this.kolicina);
                        stanje.setKumIzlaza(stanje.getKumIzlaza() + artGar.getKolicina());
                        this.em.merge((Object)stanje);
                        this.zapisnik.getArtikalopstidokuments().add(artOp);
                        prodCena += stanje.getProdCena() * artGar.getKolicina();
                        prncCena += stanje.getProsNabCena().doubleValue() * artGar.getKolicina();
                        ++br;
                    }
                    this.zapisnik.setPrncCena(prncCena);
                    this.zapisnik.setProdCena(prodCena);
                    this.zapisnik.setIznos(this.rj.getNacinVodjenja().equals("PRODAJNA") ? new BigDecimal(prodCena) : new BigDecimal(prncCena));
                    PzDokumentManager.getInstance().arhivirajDokument((PzDokument)this.zapisnik, true, null, this.em);
                    Stanje stanjeGar = (Stanje)this.em.find(Stanje.class, (Object)new StanjePK(this.garnitura.getSfrProizvod(), this.rj));
                    if (stanjeGar == null) {
                        stanjeGar = new Stanje();
                        stanjeGar.setId(new StanjePK(this.garnitura.getSfrProizvod(), this.rj));
                        stanjeGar.setArtikal(this.garnitura);
                        stanjeGar.setProdCena(BDConverter.getProdCena((double)prodCena).doubleValue());
                        stanjeGar.setProsNabCena(BDConverter.getPrnc((double)prncCena));
                    }
                    stanjeGar.setDatZadIzlaza(this.datum);
                    stanjeGar.setKolicina(stanjeGar.getKolicina() - this.kolicina);
                    stanjeGar.setKumIzlaza(stanjeGar.getKumIzlaza() + this.kolicina);
                    this.em.merge((Object)stanjeGar);
                    if (prodCena != stanjeGar.getProdCena()) {
                        Faktura f = this.getFaktura(stanjeGar, prodCena, this.em);
                        this.nivelacija = PzEntityUtil.createNivelacija((PzDokument)f, (boolean)true, (boolean)true, (EntityManager)this.em);
                        this.arhiviraj(this.nivelacija, this.em);
                    }
                    this.em.getTransaction().commit();
                    PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.zapisnik);
                    if (this.nivelacija != null) {
                        PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.nivelacija);
                    }
                }
                this.dispose();
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    public Faktura getFaktura(Stanje stanje, double prodCena, EntityManager em) {
        Faktura f = null;
        f = new Faktura();
        f.setTip("FAKTURA");
        f.setArtikalfakturas((List)new IndirectList());
        f.setRadnajedinica(this.rj);
        Artikalfaktura af = new Artikalfaktura();
        Artikal a = (Artikal)em.find(Artikal.class, (Object)stanje.getId().getSfrProizvod());
        af.setArtikal(a);
        af.setId(1, stanje.getId().getSfrProizvod(), 1);
        af.setKolicina(stanje.getKolicina());
        af.setCena(prodCena);
        af.setNaziv(a.getNaziv());
        af.setJm(a.getJedMere());
        f.getArtikalfakturas().add(af);
        return f;
    }

    private void arhiviraj(Nivelacija nivel, EntityManager em) throws Exception {
        if (nivel == null) {
            return;
        }
        for (Artikalnivelacija arniv : nivel.getArtikalnivelacijas()) {
            StanjePK stanjePk = new StanjePK(arniv.getId().getSfrProizvod(), nivel.getRadnajedinica());
            Stanje s = (Stanje)em.find(Stanje.class, (Object)stanjePk);
            s.setProdCena(arniv.getCenaNova());
            em.merge((Object)s);
        }
        PzDokumentManager.getInstance().arhivirajDokument((PzDokument)nivel, true, null, em);
    }

    private void createGarnitura(EntityManager em) throws Exception {
        this.zapisnik = new Garnitura();
        Integer broj = (Integer)em.createQuery("SELECT MAX(g.brojGarniture) FROM Garnitura g where g.storno=1").getSingleResult();
        broj = broj == null ? Integer.valueOf(1) : Integer.valueOf(broj + 1);
        this.zapisnik.setBrojGarniture(broj.intValue());
        this.zapisnik.setTip("GARNITURA");
        this.zapisnik.setUserPoc(PzApplication.getApplication().getSession().getLoggedUser());
        this.zapisnik.setUserKraj(PzApplication.getApplication().getSession().getLoggedUser());
        this.zapisnik.setSifra(this.garnitura.getSfrProizvod());
        this.zapisnik.setNaziv(this.garnitura.getNaziv());
        this.zapisnik.setRadnajedinica(this.rj);
        this.zapisnik.setDatum(this.datum);
        this.zapisnik.setArhiviran((short)0);
        this.zapisnik.setStorno(1);
        this.zapisnik.setKolicina(this.kolicina.doubleValue());
        this.zapisnik.setArtikalopstidokuments((List)new IndirectList());
        PzDokumentManager.getInstance().snimiDokument((PzDokument)this.zapisnik, true, null, em);
    }

    public static Object getGUIBuilderInstance() {
        return new UtvrdjivanjePrncKomponenti(Boolean.FALSE);
    }

    public UtvrdjivanjePrncKomponenti(Boolean initGUI) {
    }
}

