/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.lagerLista;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.analitike.gui.artikli.lagerLista.PzDialogFilter;
import rs.pezar.analitike.gui.artikli.lagerLista.PzDialogKriterijum;
import rs.pezar.analitike.util.AnalitikaUtil;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.reports.rf.LagerListaRF;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzScrollableTable;
import rs.pezar.swing.PzStatusDialog;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;

public class PzDialogLagerLista
extends PzDialog {
    private static final long serialVersionUID = 1824157487300032779L;
    private PzPanel plLabeleDugmici;
    private JToolBar toolbar;
    private PzToolBarIcon btnNadjiArtikal;
    private PzTextField tfRj;
    private PzTextField tfCena;
    private PzTextField tfKolicina;
    private JLabel jLabel1;
    private JLabel lblOpKolicina;
    private PzScrollableTable tblLagerLista;
    private JScrollPane scPane;
    private PzPanel plTabela;
    private JLabel lblOpRJ;
    private PzNumericOnlyTextField nfBrojSifara;
    private JLabel lblBrojSifara;
    private JLabel lblCena;
    private JLabel lblOpCena;
    private JLabel lblKolicina;
    private PzDoubleField dfUkupnaVrednost;
    private JLabel lblUkupnaVrednost;
    private PzToolBarIcon btnStampanje;
    private PzToolBarIcon btnFilter;
    private PzToolBarIcon btnUpitURJ;
    private PzToolBarIcon btnKartica;
    private Radnajedinica rj;
    private ScrollableCursor cursor;
    private EntityManager em;
    private String qFilter = "";
    private String kriterijum;
    private Firma firma;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogLagerLista inst = new PzDialogLagerLista(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogLagerLista(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogLagerLista() {
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("Lager lista");
            this.toolbar = new JToolBar();
            this.getContentPane().add((Component)this.toolbar, "North");
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(20);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setPreferredSize(new Dimension(892, 104));
            this.btnKartica = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnKartica);
            this.btnKartica.setText("Kartica|(F2)");
            this.btnKartica.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document_header.png")));
            this.btnKartica.addActionListener((ActionListener)((Object)this));
            this.btnKartica.setShortcut("f2");
            this.btnUpitURJ = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnUpitURJ);
            this.btnUpitURJ.setText("Upit u RJ|(F3)");
            this.btnUpitURJ.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/message.png")));
            this.btnFilter = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnFilter);
            this.btnFilter.setText("Filter|(F4)");
            this.btnFilter.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/funnel.png")));
            this.btnFilter.addActionListener((ActionListener)((Object)this));
            this.btnFilter.setShortcut("f4");
            this.btnNadjiArtikal = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnNadjiArtikal);
            this.btnNadjiArtikal.setText("Na\u0111i artikal|(F8)");
            this.btnNadjiArtikal.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/find_text.png")));
            this.btnStampanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnStampanje);
            this.btnStampanje.setText("\u0160tampanje|(Alt+S)");
            this.btnStampanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.btnStampanje.addActionListener((ActionListener)((Object)this));
            this.btnStampanje.setShortcut("alt+s");
            this.plLabeleDugmici = new PzPanel();
            AnchorLayout plLabeleDugmiciLayout = new AnchorLayout();
            this.getContentPane().add((Component)this.plLabeleDugmici, "Center");
            this.plLabeleDugmici.setLayout((LayoutManager)plLabeleDugmiciLayout);
            this.plLabeleDugmici.setPreferredSize(new Dimension(892, 111));
            this.plLabeleDugmici.setBorder((Border)BorderFactory.createTitledBorder(null, "LAGER LISTA", 2, 0, new Font("Tahoma", 1, 18)));
            this.tfRj = new PzTextField();
            this.plLabeleDugmici.add((Component)this.tfRj, (Object)new AnchorConstraint(353, 963, 580, 453, 1, 1, 1, 1));
            this.tfRj.setPreferredSize(new Dimension(455, 24));
            this.tfRj.setEditable(false);
            this.tfRj.setFocusable(false);
            this.tfRj.setFont(new Font("Tahoma", 1, 14));
            this.tfCena = new PzTextField();
            this.plLabeleDugmici.add((Component)this.tfCena, (Object)new AnchorConstraint(617, 262, 844, 116, 1, 1, 1, 1));
            this.tfCena.setPreferredSize(new Dimension(131, 24));
            this.tfCena.setFont(new Font("Tahoma", 1, 14));
            this.tfCena.setEditable(false);
            this.tfCena.setFocusable(false);
            this.tfKolicina = new PzTextField();
            this.plLabeleDugmici.add((Component)this.tfKolicina, (Object)new AnchorConstraint(344, 262, 570, 116, 1, 1, 1, 1));
            this.tfKolicina.setPreferredSize(new Dimension(131, 24));
            this.tfKolicina.setFocusable(false);
            this.tfKolicina.setEditable(false);
            this.tfKolicina.setFont(new Font("Tahoma", 1, 14));
            this.jLabel1 = new JLabel();
            this.plLabeleDugmici.add((Component)this.jLabel1, (Object)new AnchorConstraint(387, 444, 520, 277, 1, 1, 1, 1));
            this.jLabel1.setText("Radna jedinica:");
            this.jLabel1.setPreferredSize(new Dimension(149, 16));
            this.jLabel1.setFont(new Font("Tahoma", 1, 14));
            this.jLabel1.setForeground(new Color(0, 0, 255));
            this.lblUkupnaVrednost = new JLabel();
            this.plLabeleDugmici.add((Component)this.lblUkupnaVrednost, (Object)new AnchorConstraint(655, 440, 797, 272, 1, 1, 1, 1));
            this.lblUkupnaVrednost.setText("Ukupna vrednost:");
            this.lblUkupnaVrednost.setFont(new Font("Tahoma", 1, 14));
            this.lblUkupnaVrednost.setPreferredSize(new Dimension(149, 15));
            this.lblUkupnaVrednost.setForeground(new Color(0, 0, 255));
            this.dfUkupnaVrednost = new PzDoubleField();
            this.plLabeleDugmici.add((Component)this.dfUkupnaVrednost, (Object)new AnchorConstraint(617, 616, 844, 453, 1, 1, 1, 1));
            this.dfUkupnaVrednost.setFont(new Font("Tahoma", 1, 14));
            this.dfUkupnaVrednost.setPreferredSize(new Dimension(145, 24));
            this.dfUkupnaVrednost.setEditable(false);
            this.dfUkupnaVrednost.setFocusable(false);
            this.lblKolicina = new JLabel();
            this.plLabeleDugmici.add((Component)this.lblKolicina, (Object)new AnchorConstraint(379, 110, 520, 18, 1, 1, 1, 1));
            this.lblKolicina.setText("Koli\u010dina:");
            this.lblKolicina.setFont(new Font("Tahoma", 1, 14));
            this.lblKolicina.setPreferredSize(new Dimension(82, 17));
            this.lblKolicina.setForeground(new Color(0, 0, 255));
            this.lblOpCena = new JLabel();
            this.plLabeleDugmici.add((Component)this.lblOpCena, (Object)new AnchorConstraint(-79, 0, 4, -10, 1, 1, 1, 1));
            this.lblOpCena.setText("Opis cene");
            this.lblOpCena.setFont(new Font("Tahoma", 0, 14));
            this.lblOpCena.setVisible(false);
            this.lblOpCena.setPreferredSize(new Dimension(10, 10));
            this.lblOpKolicina = new JLabel();
            this.plLabeleDugmici.add((Component)this.lblOpKolicina, (Object)new AnchorConstraint(-79, 0, 4, -10, 1, 1, 1, 1));
            this.lblOpKolicina.setText("Opis kolicine");
            this.lblOpKolicina.setFont(new Font("Tahoma", 0, 14));
            this.lblOpKolicina.setVisible(false);
            this.lblOpKolicina.setPreferredSize(new Dimension(10, 10));
            this.lblCena = new JLabel();
            this.plLabeleDugmici.add((Component)this.lblCena, (Object)new AnchorConstraint(655, 110, 797, 18, 1, 1, 1, 1));
            this.lblCena.setText("Cena:");
            this.lblCena.setFont(new Font("Tahoma", 1, 14));
            this.lblCena.setPreferredSize(new Dimension(82, 15));
            this.lblCena.setForeground(new Color(0, 0, 255));
            this.lblBrojSifara = new JLabel();
            this.plLabeleDugmici.add((Component)this.lblBrojSifara, (Object)new AnchorConstraint(646, 759, 787, 653, 1, 1, 1, 1));
            this.lblBrojSifara.setText("Broj \u0161ifara:");
            this.lblBrojSifara.setFont(new Font("Tahoma", 1, 14));
            this.lblBrojSifara.setPreferredSize(new Dimension(95, 15));
            this.lblBrojSifara.setForeground(new Color(0, 0, 255));
            this.nfBrojSifara = new PzNumericOnlyTextField();
            this.plLabeleDugmici.add((Component)this.nfBrojSifara, (Object)new AnchorConstraint(617, 963, 844, 787, 1, 1, 1, 1));
            this.nfBrojSifara.setFont(new Font("Tahoma", 1, 14));
            this.nfBrojSifara.setPreferredSize(new Dimension(157, 24));
            this.nfBrojSifara.setEditable(false);
            this.nfBrojSifara.setFocusable(false);
            this.lblOpRJ = new JLabel();
            this.plLabeleDugmici.add((Component)this.lblOpRJ, (Object)new AnchorConstraint(-79, 0, 4, -10, 1, 1, 1, 1));
            this.lblOpRJ.setText("Opis radne jedinice");
            this.lblOpRJ.setFont(new Font("Tahoma", 0, 14));
            this.lblOpRJ.setVisible(false);
            this.lblOpRJ.setPreferredSize(new Dimension(10, 10));
            this.plTabela = new PzPanel();
            AnchorLayout plTabelaLayout = new AnchorLayout();
            this.getContentPane().add((Component)this.plTabela, "South");
            this.plTabela.setLayout((LayoutManager)plTabelaLayout);
            this.plTabela.setPreferredSize(new Dimension(892, 510));
            this.scPane = new JScrollPane();
            this.plTabela.add((Component)this.scPane, (Object)new AnchorConstraint(37, 987, 976, 14, 1, 1, 1, 1));
            this.scPane.setPreferredSize(new Dimension(868, 466));
            this.setSize(900, 740);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.btnFilter) {
                this.tblLagerLista = new PzScrollableTable();
                this.qFilter = PzDialogFilter.getQuery(this);
                if (this.qFilter == null) {
                    return;
                }
                final PzDialogLagerLista instance = this;
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        PzStatusDialog.showStatus((String)"Filtriranje lager liste je u toku. Molim, sa\u010dekajte.", (PzDialog)instance);
                        PzDialogLagerLista.this.query(PzDialogLagerLista.this.createQuery(PzDialogLagerLista.this.kriterijum), PzDialogLagerLista.this.getVrednostQuery(PzDialogLagerLista.this.kriterijum));
                        PzStatusDialog.hideStatus();
                    }
                });
                t.start();
            } else if (e.getSource() == this.btnStampanje) {
                Vector<Object> eData = new Vector<Object>();
                eData.add(this.rj);
                eData.add(this.firma);
                LagerListaRF.showReport((PzScrollableTable)this.tblLagerLista, eData, (String)((TitledBorder)this.plLabeleDugmici.getBorder()).getTitle(), (PzDialog)this);
            } else if (e.getSource() == this.btnKartica) {
                int selectedRow = this.tblLagerLista.convertRowIndexToModel(this.tblLagerLista.getSelectedRow());
                if (selectedRow == -1) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Morate obele\u017eiti artikal u tabeli.");
                } else {
                    String a = this.tblLagerLista.getModel().getValueAt(selectedRow, 0).toString();
                    Artikal artikal = (Artikal)PzEntityManager.find(Artikal.class, (Object)a);
                    AnalitikaUtil.karticaArtikla((PzDialog)this, artikal, this.rj, null);
                }
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    public boolean shouldBeShown() {
        try {
            this.rj = PzDialogRJ.getRJ((PzDialog)this);
            if (this.rj != null) {
                this.kriterijum = PzDialogKriterijum.getKriterijum(this);
                if (this.kriterijum != null) {
                    this.firma = PzFirma.getFirma();
                    PzStatusDialog.showStatus((String)"Sastavljanje lager liste u toku. Ova operacija mo\u017ee da potraje. Molim, sa\u010dekajte", (PzDialog)this);
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            PzDialogLagerLista.this.query(PzDialogLagerLista.this.createQuery(PzDialogLagerLista.this.kriterijum), PzDialogLagerLista.this.getVrednostQuery(PzDialogLagerLista.this.kriterijum));
                            PzStatusDialog.hideStatus();
                        }
                    });
                    t.start();
                    String[] krit = this.kriterijum.split("\\|");
                    if (krit[1].equals("po_prnc")) {
                        this.tfCena.setVal((Object)"PROS. NABAVNA");
                    } else {
                        this.tfCena.setVal((Object)"PRODAJNA");
                    }
                    if (krit[2].equals("raspoloziva")) {
                        this.tfKolicina.setVal((Object)"RASPOLO\u017dIVA");
                    } else if (krit[2].equals("ukupna")) {
                        this.tfKolicina.setVal((Object)"UKUPNA");
                    } else {
                        this.tfKolicina.setVal((Object)"ALOCIRANA");
                    }
                    this.tfRj.setVal((Object)("[" + this.rj.getId().getOznRj() + "] " + this.rj.getNaziv()));
                    return true;
                }
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            PzStatusDialog.hideStatus();
        }
        return false;
    }

    private String createQuery(String kriterijum) {
        String[] krit = kriterijum.split("\\|");
        String query = "SELECT a.sfrProizvod, a.naziv, a.bliziOpis, a.jedMere, %kolicina%, %cena%, %kolicina%*%cena%, a.oznRobGr, a.oznModel, a.proizvodjac FROM StanjeArtikal a WHERE %kolicina%<>0 AND %kolicina% IS NOT NULL %filter% ";
        query = query.replaceAll("%filter%", this.qFilter);
        if (krit[0].equals("trenutna")) {
            query = query.replaceAll("%kolicina%", krit[2].equals("raspoloziva") ? "(a.kolicina - a.alocKolicina)" : (krit[2].equals("ukupna") ? "a.kolicina" : "a.alocKolicina"));
            query = query.replaceAll("%cena%", krit[1].equals("po_prnc") ? "a.prosNabCena" : "a.prodCena");
        } else {
            query = query.replaceAll("%kolicina%", "a.kolPop").replaceAll("%cena%", "a.cenaNaPs");
        }
        query = String.valueOf(query) + " AND a.oznRj = %oznRj% AND a.oznOgranak = %oznOgranak% ORDER BY " + (krit[3].equals("sifra") ? "a.sfrProizvod" : "a.naziv");
        query = query.replaceAll("%oznRj%", "'" + this.rj.getId().getOznRj() + "'").replaceAll("%oznOgranak%", "'" + this.rj.getId().getOznOgranak() + "'");
        return query;
    }

    private String getVrednostQuery(String kriterijum) {
        String[] krit = kriterijum.split("\\|");
        String query = "SELECT SUM(ROUND(CAST(%kolicina%*%cena% AS NUMERIC), 2)) FROM StanjeArtikal a WHERE %kolicina%<>0 AND %kolicina% IS NOT NULL %filter% AND a.oznRj = %oznRj% AND a.oznOgranak = %oznOgranak%";
        query = query.replaceAll("%filter%", this.qFilter);
        if (krit[0].equals("trenutna")) {
            query = query.replaceAll("%kolicina%", krit[2].equals("raspoloziva") ? "(a.kolicina - a.alocKolicina)" : (krit[2].equals("ukupna") ? "a.kolicina" : "a.alocKolicina"));
            query = query.replaceAll("%cena%", krit[1].equals("po_prnc") ? "a.prosNabCena" : "a.prodCena");
        } else {
            query = query.replaceAll("%kolicina%", "a.kolPop").replaceAll("%cena%", "a.cenaNaPs");
        }
        query = query.replaceAll("%oznRj%", "'" + this.rj.getId().getOznRj() + "'").replaceAll("%oznOgranak%", "'" + this.rj.getId().getOznOgranak() + "'");
        return query;
    }

    private void query(String queryGlavni, String queryVrednost) {
        if ((this.em != null && this.em.isOpen()) & (this.cursor != null && !this.cursor.isClosed())) {
            this.cursor.close();
            this.em.close();
        }
        this.em = PzEntityManager.getEm();
        Query q = this.em.createNativeQuery(queryVrednost);
        this.dfUkupnaVrednost.setVal(q.getSingleResult());
        q = this.em.createNativeQuery(queryGlavni);
        q.setHint("eclipselink.cursor.scrollable", (Object)true);
        this.cursor = (ScrollableCursor)q.getSingleResult();
        this.nfBrojSifara.setVal((Object)this.cursor.size());
        String[] columnNames = new String[]{"\u0160ifra", "Naziv", "Bli\u017ei opis", "JM", "Koli\u010dina", "Cena", "Vrednost", "Robna grupa", "Model", "Proizvo\u0111a\u010d"};
        if (this.tblLagerLista == null) {
            this.tblLagerLista = new PzScrollableTable(this.cursor, columnNames);
        } else {
            this.tblLagerLista.read(this.cursor, columnNames);
        }
        this.scPane.setViewportView((Component)this.tblLagerLista);
    }

    protected void thisWindowClosing(WindowEvent evt) {
        this.cursor.close();
        this.em.close();
        super.thisWindowClosing(evt);
    }
}

