/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.lagerLista;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Robnagrupa;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.reports.engine.standard.PzResultSetDataSourceAdapter;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRobneGrupe;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.util.PzDateUtility;

public class PzDialogLagerListaPoRj
extends PzDialog {
    public static final String KLASICNA = "Klasi\u010dna";
    public static final String RB_GRUPA = "Izabrana robna grupa";
    public static final String PROIZVODJAC = "Izabrani proizvo\u0111a\u010d";
    public static final String DOBAVLJAC = "Izabrani dobavlja\u010d";
    private PzTextField tfNazivRg;
    private PzFieldIndikator indRobnaGrupa;
    private PzTextField tfNazivDobavljaca;
    private PzTextField tfDobavljac;
    private JLabel lblDobavljac;
    private PzFieldIndikator indDobavljac;
    private PzFieldIndikator indProizvodjac;
    private PzTextField tfNazivProizvodjaca;
    private PzTextField tfProizvodjac;
    private JLabel lblProizvodjac;
    private JButton btnPotvrdi;
    private PzTextField tfRobnaGrupa;
    private JLabel lblRobnaGrupa;
    private ScrollableCursor cursor;
    private PzPanel mainPanel;
    private PzRadioGroup<String> panelRbs;
    private Robnagrupa entRobnaGrupa;
    private Komitent entProizvodjac;
    private Komitent entDobavljac;

    public PzDialogLagerListaPoRj(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Lager lista po radnoj jedinici");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.rowHeights = new int[]{35, 20, 20, 20, 20, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.columnWidths = new int[]{161, 83, 100, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.panelRbs = new PzRadioGroup((Object[])new String[]{KLASICNA, RB_GRUPA, PROIZVODJAC, DOBAVLJAC});
            BoxLayout panelRBsLayout = new BoxLayout((Container)this.panelRbs, 1);
            this.panelRbs.setLayout((LayoutManager)panelRBsLayout);
            this.mainPanel.add(this.panelRbs, (Object)new GridBagConstraints(0, 0, 1, 5, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRbs.setBorder((Border)BorderFactory.createTitledBorder("Izbor pregleda"));
            this.panelRbs.setSelectedValue((Object)KLASICNA);
            this.panelRbs.setOpaque(false);
            this.panelRbs.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getStateChange() == 1) {
                        if (evt.getValue().equals(PzDialogLagerListaPoRj.KLASICNA)) {
                            PzDialogLagerListaPoRj.this.setEnabledDob(false);
                            PzDialogLagerListaPoRj.this.setEnabledPro(false);
                            PzDialogLagerListaPoRj.this.setEnabledRg(false);
                        } else if (evt.getValue().equals(PzDialogLagerListaPoRj.RB_GRUPA)) {
                            PzDialogLagerListaPoRj.this.setEnabledDob(false);
                            PzDialogLagerListaPoRj.this.setEnabledPro(false);
                            PzDialogLagerListaPoRj.this.setEnabledRg(true);
                        } else if (evt.getValue().equals(PzDialogLagerListaPoRj.PROIZVODJAC)) {
                            PzDialogLagerListaPoRj.this.setEnabledDob(false);
                            PzDialogLagerListaPoRj.this.setEnabledPro(true);
                            PzDialogLagerListaPoRj.this.setEnabledRg(false);
                        } else if (evt.getValue().equals(PzDialogLagerListaPoRj.DOBAVLJAC)) {
                            PzDialogLagerListaPoRj.this.setEnabledDob(true);
                            PzDialogLagerListaPoRj.this.setEnabledPro(false);
                            PzDialogLagerListaPoRj.this.setEnabledRg(false);
                        }
                    }
                }
            });
            this.lblRobnaGrupa = new JLabel();
            this.mainPanel.add((Component)this.lblRobnaGrupa, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblRobnaGrupa.setText("Robna grupa");
            this.lblRobnaGrupa.setEnabled(false);
            this.tfRobnaGrupa = new PzTextField();
            this.mainPanel.add((Component)this.tfRobnaGrupa, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.tfRobnaGrupa.setName("tfRobnaGrupa");
            this.tfRobnaGrupa.setFKField(Robnagrupa.class, PzDialogRobneGrupe.class, true, null);
            this.tfRobnaGrupa.setEnabled(false);
            this.tfNazivRg = new PzTextField();
            this.mainPanel.add((Component)this.tfNazivRg, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 25, 3, 10), 0, 0));
            this.tfNazivRg.setFocusable(false);
            this.tfNazivRg.setEnabled(false);
            this.indRobnaGrupa = new PzFieldIndikator();
            this.mainPanel.add((Component)this.indRobnaGrupa, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indRobnaGrupa.setName("indRobnaGrupa");
            this.indRobnaGrupa.setEnabled(false);
            this.btnPotvrdi = new PzButton();
            this.mainPanel.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.lblProizvodjac = new JLabel();
            this.mainPanel.add((Component)this.lblProizvodjac, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblProizvodjac.setText("Proizvo\u0111a\u010d");
            this.lblProizvodjac.setEnabled(false);
            this.tfProizvodjac = new PzTextField();
            this.mainPanel.add((Component)this.tfProizvodjac, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.tfProizvodjac.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.tfProizvodjac.setFocusable(false);
            this.tfProizvodjac.setEnabled(false);
            this.tfNazivProizvodjaca = new PzTextField();
            this.mainPanel.add((Component)this.tfNazivProizvodjaca, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 25, 3, 10), 0, 0));
            this.tfNazivProizvodjaca.setEnabled(false);
            this.tfNazivProizvodjaca.setFocusable(false);
            this.indProizvodjac = new PzFieldIndikator();
            this.mainPanel.add((Component)this.indProizvodjac, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indProizvodjac.setEnabled(false);
            this.indDobavljac = new PzFieldIndikator();
            this.mainPanel.add((Component)this.indDobavljac, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indDobavljac.setEnabled(false);
            this.lblDobavljac = new JLabel();
            this.mainPanel.add((Component)this.lblDobavljac, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblDobavljac.setText("Dobavlja\u010d");
            this.lblDobavljac.setEnabled(false);
            this.tfDobavljac = new PzTextField();
            this.mainPanel.add((Component)this.tfDobavljac, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.tfDobavljac.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.tfDobavljac.setFocusable(false);
            this.tfDobavljac.setEnabled(false);
            this.tfNazivDobavljaca = new PzTextField();
            this.mainPanel.add((Component)this.tfNazivDobavljaca, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 25, 3, 10), 0, 0));
            this.tfNazivDobavljaca.setEnabled(false);
            this.tfNazivDobavljaca.setFocusable(false);
            this.tfRobnaGrupa.setStateIndikator(this.indRobnaGrupa);
            this.tfProizvodjac.setStateIndikator(this.indProizvodjac);
            this.tfDobavljac.setStateIndikator(this.indDobavljac);
            this.pack();
            this.setSize(717, 223);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (!((String)this.panelRbs.getSelectedValue()).equals(KLASICNA) && !this.mainPanel.validateForm(true)) {
            return;
        }
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    if (PzDialogLagerListaPoRj.this.cursor != null) {
                        PzDialogLagerListaPoRj.this.cursor.close();
                    }
                    Query q = null;
                    String query = "SELECT a.sfrProizvod, a.naziv, s.oznRj, s.kolicina, s.prodCena, s.kolicina*s.prodCena, a.sfrSort FROM Artikal a INNER JOIN Stanje s ON a.sfrProizvod=s.sfrProizvod %krit% GROUP BY a.sfrProizvod, a.naziv, s.oznRj, s.kolicina, s.prodCena, a.bliziOpis, a.sfrSort, a.oznRobGr ORDER BY a.sfrSort";
                    if (((String)PzDialogLagerListaPoRj.this.panelRbs.getSelectedValue()).equals(PzDialogLagerListaPoRj.KLASICNA)) {
                        query = query.replace("%krit%", " ");
                    } else if (((String)PzDialogLagerListaPoRj.this.panelRbs.getSelectedValue()).equals(PzDialogLagerListaPoRj.RB_GRUPA)) {
                        query = query.replace("%krit%", "WHERE  a.oznRobGr ='" + PzDialogLagerListaPoRj.this.entRobnaGrupa.getOznRobGr() + "'");
                    } else if (((String)PzDialogLagerListaPoRj.this.panelRbs.getSelectedValue()).equals(PzDialogLagerListaPoRj.PROIZVODJAC)) {
                        query = query.replace("%krit%", "WHERE  a.proizvodjac ='" + PzDialogLagerListaPoRj.this.entProizvodjac.getSfrKomitent() + "'");
                    } else if (((String)PzDialogLagerListaPoRj.this.panelRbs.getSelectedValue()).equals(PzDialogLagerListaPoRj.DOBAVLJAC)) {
                        query = query.replace("%krit%", "WHERE  a.dobavljac ='" + PzDialogLagerListaPoRj.this.entDobavljac.getSfrKomitent() + "'");
                    }
                    q = em.createNativeQuery(query);
                    q.setHint("eclipselink.cursor.scrollable", (Object)true);
                    PzDialogLagerListaPoRj.this.cursor = (ScrollableCursor)q.getSingleResult();
                    System.out.println("Kursor ima:" + PzDialogLagerListaPoRj.this.cursor.size());
                    em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                        if (PzDialogLagerListaPoRj.this.cursor.size() == 0) {
                            JOptionPane.showMessageDialog(PzDialogLagerListaPoRj.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                            PzWorkerDialog.hideStatus();
                            return;
                        }
                        try {
                            PzDialogLagerListaPoRj.this.showReports();
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogLagerListaPoRj.this), (Throwable)e);
                            PzWorkerDialog.hideStatus();
                        }
                    }
                    finally {
                        em.close();
                    }
                }
            };
            worker.execute();
        }
    }

    private void showReports() throws Exception {
        Vector<Firma> data = new Vector<Firma>();
        String today = PzDateUtility.formatDate((Date)PzDateUtility.getCurrentDate());
        PzDataSourceExtended ds = new PzDataSourceExtended(data, this.cursor);
        ds.setAdapter((PzDataSourceAdapter)new PzResultSetDataSourceAdapter());
        String subtitle = "";
        if (((String)this.panelRbs.getSelectedValue()).equals(RB_GRUPA)) {
            subtitle = "Robna grupa: [ " + this.entRobnaGrupa.getOznRobGr() + " ] " + this.entRobnaGrupa.getNaziv();
        }
        if (((String)this.panelRbs.getSelectedValue()).equals(PROIZVODJAC)) {
            subtitle = "Proizvo\u0111a\u010d: [ " + this.entProizvodjac.getSfrKomitent() + " ] " + this.entProizvodjac.getNaziv();
        }
        if (((String)this.panelRbs.getSelectedValue()).equals(DOBAVLJAC)) {
            subtitle = "Dobavlja\u010d: [ " + this.entDobavljac.getSfrKomitent() + " ] " + this.entDobavljac.getNaziv();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("title", "Lager lista po svim radnim jedinicama");
        params.put("datum", today);
        params.put("reklama", "");
        params.put("subtitle", subtitle);
        data.add(PzFirma.getFirma());
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)"rs/pezar/reports/compiled/lager.lista.po.rj.jasper", params, (String)"Lager lista po svim radnim jedinicama");
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Robnagrupa) {
            this.entRobnaGrupa = (Robnagrupa)entity;
            this.tfRobnaGrupa.setVal((Object)this.entRobnaGrupa.getOznRobGr());
            this.tfNazivRg.setVal((Object)this.entRobnaGrupa.getNaziv());
        } else if (entity instanceof Komitent) {
            if (((String)this.panelRbs.getSelectedValue()).equals(PROIZVODJAC)) {
                this.entProizvodjac = (Komitent)entity;
                this.tfProizvodjac.setVal((Object)this.entProizvodjac.getSfrKomitent());
                this.tfNazivProizvodjaca.setVal((Object)this.entProizvodjac.getNaziv());
            } else if (((String)this.panelRbs.getSelectedValue()).equals(DOBAVLJAC)) {
                this.entDobavljac = (Komitent)entity;
                this.tfDobavljac.setVal((Object)this.entDobavljac.getSfrKomitent());
                this.tfNazivDobavljaca.setVal((Object)this.entDobavljac.getNaziv());
            }
        }
    }

    private void setEnabledRg(boolean enabled) {
        this.lblRobnaGrupa.setEnabled(enabled);
        this.indRobnaGrupa.setEnabled(enabled);
        this.tfRobnaGrupa.setEnabled(enabled);
        this.tfRobnaGrupa.setFocusable(enabled);
        this.tfRobnaGrupa.setText("");
        this.tfNazivRg.setText("");
    }

    private void setEnabledPro(boolean enabled) {
        this.lblProizvodjac.setEnabled(enabled);
        this.indProizvodjac.setEnabled(enabled);
        this.tfProizvodjac.setEnabled(enabled);
        this.tfProizvodjac.setFocusable(enabled);
        this.indProizvodjac.setEnabled(enabled);
        this.tfProizvodjac.setText("");
        this.tfDobavljac.setText("");
    }

    private void setEnabledDob(boolean enabled) {
        this.lblDobavljac.setEnabled(enabled);
        this.indDobavljac.setEnabled(enabled);
        this.tfDobavljac.setEnabled(enabled);
        this.tfDobavljac.setFocusable(enabled);
        this.indDobavljac.setEnabled(enabled);
        this.tfDobavljac.setText("");
        this.tfNazivDobavljaca.setText("");
    }
}

