/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.popis;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.analitike.PzExtensionLoader;
import rs.pezar.analitike.gui.artikli.popis.DBF;
import rs.pezar.analitike.gui.artikli.popis.PzDialogPopisMaloprodaja;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Popis;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogDokumentiMaloprodaja
extends PzDialog {
    private static final long serialVersionUID = 1L;
    protected static Popis selected;
    private JToolBar toolbar;
    private PzToolBarIcon icnBrisanjeKalkulacije;
    private PzToolBarIcon icnIzmenaKalk;
    private PzToolBarIcon icnDodKalk;
    private JScrollPane scrollPane;
    private PzTable table;
    private PzPanel mainPanel;
    private PzComponentGroup kIcnGroup;
    private Popis popisBrisanje;
    private String parameter;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogDokumentiMaloprodaja inst = new PzDialogDokumentiMaloprodaja(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogDokumentiMaloprodaja(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogDokumentiMaloprodaja(JFrame frame, String parameter) {
        super(frame);
        this.parameter = parameter;
        this.initGUI();
        this.postInit();
    }

    public PzDialogDokumentiMaloprodaja(PzDialog dialog, String parameter) {
        super(dialog);
        this.parameter = parameter;
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        this.table = new PzTable(DBF.getPopisMaloprodaja(PzExtensionLoader.getLoggedUser(), this.parameter, 0, 0, "POPIS"), Popis.class);
        this.table.setEnterAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PzDialogDokumentiMaloprodaja.this.showDialog(PzDialogPopisMaloprodaja.class, true, PzDialogDokumentiMaloprodaja.this.table, PzDialogDokumentiMaloprodaja.this.table.getSelectedEntity());
            }
        });
        this.scrollPane.setViewportView((Component)this.table);
        this.brDok.setText(String.valueOf(this.table.getRowCount()));
    }

    private void initGUI() {
        try {
            this.setTitle("Popisi u pripremi za korisnika " + PzExtensionLoader.getLoggedUser().getPzusername() + " (" + PzExtensionLoader.getLoggedUser().getIme() + " " + PzExtensionLoader.getLoggedUser().getPrezime() + ")");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{106, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.kIcnGroup = new PzComponentGroup();
            this.toolbar.setOpaque(false);
            this.icnDodKalk = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnDodKalk);
            this.toolbar.add((Component)this.icnDodKalk);
            this.icnDodKalk.setText("Novi popis|(ins)");
            this.icnDodKalk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document_add.png")));
            this.icnDodKalk.addActionListener((ActionListener)((Object)this));
            this.icnDodKalk.setActionCommand("insert_popis");
            this.icnDodKalk.setShortcut("insert");
            this.icnIzmenaKalk = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnIzmenaKalk);
            this.toolbar.add((Component)this.icnIzmenaKalk);
            this.icnIzmenaKalk.setText("Izmena popisa|(f3)");
            this.icnIzmenaKalk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document_edit.png")));
            this.icnIzmenaKalk.setActionCommand("update_popis");
            this.icnIzmenaKalk.addActionListener((ActionListener)((Object)this));
            this.icnIzmenaKalk.setShortcut("f3");
            this.icnBrisanjeKalkulacije = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnBrisanjeKalkulacije);
            this.toolbar.add((Component)this.icnBrisanjeKalkulacije);
            this.icnBrisanjeKalkulacije.setText("Brisanje popisa |(del)");
            this.icnBrisanjeKalkulacije.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document_delete.png")));
            this.icnBrisanjeKalkulacije.addActionListener((ActionListener)((Object)this));
            this.icnBrisanjeKalkulacije.setActionCommand("delete_popis");
            this.icnBrisanjeKalkulacije.setShortcut("delete");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj dokumenata: ");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(989, 666);
            this.setMinimumSize(new Dimension(989, 666));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = ((PzToolBarIcon)e.getSource()).getActionCommand();
        boolean izmena = false;
        if (!actionCommand.equals("insert_popis")) {
            if (actionCommand.equals("update_popis")) {
                izmena = true;
            } else if (actionCommand.equals("delete_popis")) {
                EntityManager em = PzEntityManager.getEm();
                this.popisBrisanje = (Popis)this.table.getSelectedEntity();
                if (this.popisBrisanje == null) {
                    JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Niste odabrali popis za brisanje.", "Obave\u0161tenje", 1);
                    return;
                }
                int rez = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Da li ste sigurni?", (String)"Brisanje", null, (boolean)true);
                if (rez != 0) {
                    return;
                }
                try {
                    em.getTransaction().begin();
                    em.remove(em.find(Opstidokument.class, (Object)this.popisBrisanje.getIdDok()));
                    em.getTransaction().commit();
                    this.table.removeSelectedEntity(false, false);
                    return;
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                }
                finally {
                    em.close();
                }
            }
        }
        this.showDialog(PzDialogPopisMaloprodaja.class, izmena, this.table, null);
        this.table.refreshData();
    }

    public void finish() {
        this.table.removeSelectedEntity(false, false);
    }

    public static Popis getPopisUVProdavnicama(PzDialog parent, String parameter) {
        PzDialogDokumentiMaloprodaja dlg = new PzDialogDokumentiMaloprodaja(parent, parameter);
        if (!dlg.shouldBeShown()) {
            return null;
        }
        dlg.table.setEnterAction(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                selected = (Popis)PzDialogDokumentiMaloprodaja.this.table.getSelectedEntity();
                PzDialogDokumentiMaloprodaja.this.dispose();
            }
        });
        dlg.restoreSize();
        dlg.setModal(true);
        dlg.setVisible(true);
        Popis res = selected;
        selected = null;
        return res;
    }
}

