/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.izborDokumenta;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.analitike.gui.Settings;
import rs.pezar.analitike.gui.komitenti.obracunKamate.PzDialogKamatneStope;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Komitent;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class PzDialogIzborDokumenta
extends PzDialog {
    private static final long serialVersionUID = 1L;
    private PzPanel pzPanel1;
    private JToolBar toolbar;
    private PzToolBarIcon icnNadjiDokument;
    private JScrollPane jScrollPane1;
    private PzTable table;
    private PzPanel pzPanel2;
    private Komitent komitent;
    Vector<PzDokument> result;

    public void actionPerformed(ActionEvent e) {
        try {
            String actionCommand = ((AbstractButton)e.getSource()).getActionCommand();
            if (actionCommand.equals("nadjidokument")) {
                this.onNadjiDokumentPressed();
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogKamatneStope(Boolean.FALSE);
    }

    public PzDialogIzborDokumenta(Boolean initGUI) {
    }

    public PzDialogIzborDokumenta(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogIzborDokumenta(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    public PzDialogIzborDokumenta(PzDialog dialog, boolean izmena, Object data1, Object data2) {
        super(dialog);
        this.komitent = (Komitent)data1;
        this.initGUI();
    }

    protected void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setPreferredSize(new Dimension(754, 597));
            this.setTitle("Izbor dokumenta za komitenta");
            this.pzPanel1 = new PzPanel();
            BorderLayout pzPanel1Layout = new BorderLayout();
            this.pzPanel1.setLayout((LayoutManager)pzPanel1Layout);
            this.getContentPane().add((Component)this.pzPanel1, "Center");
            this.pzPanel1.setPreferredSize(new Dimension(573, 500));
            this.toolbar = new JToolBar();
            this.pzPanel1.add((Component)this.toolbar, (Object)"North");
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setAlignmentY(0.5f);
            this.toolbar.setBounds(0, -1, 850, 104);
            this.toolbar.setPreferredSize(new Dimension(723, 104));
            this.icnNadjiDokument = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnNadjiDokument);
            this.icnNadjiDokument.setText("Prika\u017ei samo |nepla\u0107ene(F2)");
            this.icnNadjiDokument.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/table_view.png")));
            this.icnNadjiDokument.setActionCommand("nadjidokument");
            this.icnNadjiDokument.setToolTipText("Prikazuje samo dokumente koji nemaju pokriven ceo iznos uplatom");
            this.icnNadjiDokument.setPreferredSize(new Dimension(91, 84));
            this.icnNadjiDokument.setSize(91, 84);
            this.icnNadjiDokument.addActionListener((ActionListener)((Object)this));
            this.icnNadjiDokument.setActionCommand("nadjidokument");
            this.icnNadjiDokument.setShortcut("F2");
            this.pzPanel2 = new PzPanel();
            GridBagLayout pzPanel2Layout = new GridBagLayout();
            this.pzPanel1.add((Component)this.pzPanel2, (Object)"Center");
            pzPanel2Layout.rowWeights = new double[]{0.0, 0.1, 0.0};
            pzPanel2Layout.rowHeights = new int[]{7, 7, 7};
            pzPanel2Layout.columnWeights = new double[]{0.0, 0.1, 0.0};
            pzPanel2Layout.columnWidths = new int[]{7, 7, 7};
            this.pzPanel2.setLayout((LayoutManager)pzPanel2Layout);
            this.jScrollPane1 = new JScrollPane();
            this.pzPanel2.add((Component)this.jScrollPane1, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pack();
            this.fillInTheInfo();
            this.setSize(754, 597);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fillInTheInfo() {
        Query q = null;
        this.createSelectionList(Settings.obracunKamateDokumenta);
        new ScrollableCursor();
        EntityManager em = PzEntityManager.getEm();
        String query = "Select a from Dokument a where a.komitent.sfrKomitent = :sifra and a.arhiviran = 1 and a.storno = 0 and a.tip in (%s)";
        query = String.format(query, this.createSelectionList(Settings.obracunKamateDokumenta));
        q = em.createQuery(query);
        q.setParameter("sifra", (Object)this.komitent.getSfrKomitent());
        this.result = (Vector)q.getResultList();
        PzEntityFilter filter = new PzEntityFilter(){

            public Object[] getValues(PzEntity entity) {
                String oznakaDokumenta = ((Dokument)entity).getOznDokumenta();
                BigDecimal uplata = new BigDecimal(0.0);
                uplata = ((Dokument)entity).getFaktura() != null ? ((Dokument)entity).getFaktura().getUplata() : uplata;
                uplata = ((Dokument)entity).getFakturausluga() != null ? ((Dokument)entity).getFakturausluga().getUplata() : uplata;
                BigDecimal iznos = ((Dokument)entity).getIznos() == null ? new BigDecimal(0.0) : ((Dokument)entity).getIznos();
                BigDecimal stornoIznos = ((Dokument)entity).getStornoIznos() == null ? new BigDecimal(0.0) : ((Dokument)entity).getStornoIznos();
                Date datum = ((Dokument)entity).getDatum();
                Date datumValute = ((Dokument)entity).getDatValute();
                return new Object[]{oznakaDokumenta, iznos, iznos.subtract(stornoIznos).subtract(uplata), datum, datumValute};
            }

            public String[] getColumnNames() {
                return new String[]{"Oznaka dokumenta", "Iznos", "Dug po dokumentu", "Datum dokumenta", "Datum valute"};
            }
        };
        this.table = new PzTable();
        this.table.setFilter(filter);
        this.table.setData(this.result, PzDokument.class);
        this.jScrollPane1.setViewportView((Component)this.table);
    }

    private String createSelectionList(String[] selectionList) {
        String list = new String();
        int i = 0;
        while (i < selectionList.length) {
            list = String.valueOf(list) + "'" + selectionList[i] + "', ";
            ++i;
        }
        list = list.substring(0, list.length() - 2);
        return list;
    }

    private String createSelectionList(Vector<String> selectionList) {
        String list = new String();
        int i = 0;
        while (i < selectionList.size()) {
            list = String.valueOf(list) + "'" + selectionList.get(i) + "', ";
            ++i;
        }
        list = list.substring(0, list.length() - 2);
        return list;
    }

    public static PzDokument getDokumentInstance(JFrame frame) {
        new PzDialogIzborDokumenta(frame);
        return null;
    }

    private void onNadjiDokumentPressed() {
        int i = 0;
        while (i < this.result.size()) {
            BigDecimal stornoIznos;
            PzDokument entity = this.result.get(i);
            BigDecimal uplata = new BigDecimal(0.0);
            uplata = ((Dokument)entity).getFaktura() != null ? ((Dokument)entity).getFaktura().getUplata() : uplata;
            uplata = ((Dokument)entity).getFakturausluga() != null ? ((Dokument)entity).getFakturausluga().getUplata() : uplata;
            BigDecimal iznos = ((Dokument)entity).getIznos() == null ? new BigDecimal(0.0) : ((Dokument)entity).getIznos();
            BigDecimal temp = iznos.subtract(stornoIznos = ((Dokument)entity).getStornoIznos() == null ? new BigDecimal(0.0) : ((Dokument)entity).getStornoIznos()).subtract(uplata);
            if (temp.doubleValue() <= 0.0) {
                this.result.remove(entity);
            }
            this.table.setData(this.result, PzDokument.class);
            ++i;
        }
    }
}

