/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.knjigaPausalnihObveznika;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import rs.pezar.analitike.gui.knjigaPausalnihObveznika.DodavanjeKPO;
import rs.pezar.analitike.tableModels.PzTableModelKPO;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Knjigapausalnihobveznika;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzScrollableTable;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzCalculatedField;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogKnjigaPausalnihObveznika
extends PzDialog {
    private static final String BEZ_OGRANICENJE = "Bez ograni\u010denje";
    private static final String U_PERIODU = "U periodu";
    private PzPanel mainPanel;
    private JToolBar toolbar;
    private PzToolBarIcon icnDodavanje;
    private PzDoubleField dfPrenetoStanje;
    private JLabel lblPrenetiSaldo;
    private PzPanel pnlDatum;
    private PzButton btnPotvrdi;
    private PzPanel pnlScrollPane;
    private PzCalculatedField dfSaldo;
    private PzPanel pnlSaldo;
    private JLabel lblSaldo;
    private PzScrollableTable tblTable;
    private JScrollPane scrollPane;
    private PzToolBarIcon icnIzmena;
    private PzToolBarIcon icnBrisanje;
    private PzDateField dfKrajnjiDatum;
    private JLabel lblKrajnjiDatum;
    private JLabel lblPocetniDatum;
    private PzDateField dfPocetniDatum;
    private PzRadioGroup panelRbs;
    private PzPanel pnlOgranicenje;
    private PzToolBarIcon icnStampa;
    private PzTableModelKPO model;
    private PzDoubleField dfUkupno;
    private JLabel lblUkupno;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    private PzBusyPainterUI layerUI;
    private JXLayer<PzPanel> layer;
    private EntityManager em;
    private SwingWorker<ScrollableCursor, Object> worker;
    private ScrollableCursor cursor;
    private PzToolBarIcon icnSlika;
    private BigDecimal prenetoStanje = BigDecimal.ZERO;
    public static PzDialogKnjigaPausalnihObveznika instance;

    public PzDialogKnjigaPausalnihObveznika(JFrame frame) {
        super(frame);
        this.initGUI();
        this.setEnableDatum(false);
    }

    private void initGUI() {
        try {
            BorderLayout bLayout = new BorderLayout();
            this.setLayout(bLayout);
            this.setTitle("Knjiga pau\u0161alnih obveznika: Obrazac KPO");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.0};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Dodavanje|(INS)");
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/book_blue_add.png")));
            this.icnDodavanje.setActionCommand("dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("INSERT");
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/book_blue_edit.png")));
            this.icnIzmena.setActionCommand("izmena");
            this.icnIzmena.setShortcut("F3");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnSlika = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSlika);
            this.icnSlika.setText("Slika dokumenta|(F2)");
            this.icnSlika.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/book_blue_view.png")));
            this.icnSlika.setActionCommand("slika");
            this.icnSlika.setShortcut("F2");
            this.icnSlika.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|(DEl)");
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/book_blue_delete.png")));
            this.icnBrisanje.setActionCommand("brisanje");
            this.icnBrisanje.setShortcut("DELETE");
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnStampa = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnStampa);
            this.icnStampa.setText("\u0160tampa|(Alt+S)");
            this.icnStampa.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.icnStampa.setActionCommand("stampa");
            this.icnStampa.setShortcut("Alt+S");
            this.icnStampa.addActionListener((ActionListener)((Object)this));
            this.pnlOgranicenje = new PzPanel();
            GridBagLayout pnlOgranicenjeLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlOgranicenje, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlOgranicenjeLayout.rowWeights = new double[]{0.1, 0.0, 0.0, 0.1};
            pnlOgranicenjeLayout.rowHeights = new int[]{7, 7, 7, 7};
            pnlOgranicenjeLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlOgranicenjeLayout.columnWidths = new int[]{124, 247, 20, 7};
            this.pnlOgranicenje.setLayout((LayoutManager)pnlOgranicenjeLayout);
            this.pnlOgranicenje.setOpaque(false);
            this.panelRbs = new PzRadioGroup((Object[])new String[]{BEZ_OGRANICENJE, U_PERIODU});
            BoxLayout panelRBsLayout = new BoxLayout((Container)this.panelRbs, 1);
            this.panelRbs.setLayout((LayoutManager)panelRBsLayout);
            this.pnlOgranicenje.add((Component)this.panelRbs, (Object)new GridBagConstraints(0, 0, 1, 4, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
            this.panelRbs.setBorder((Border)BorderFactory.createTitledBorder("Pregled"));
            this.panelRbs.setSelectedValue((Object)BEZ_OGRANICENJE);
            this.panelRbs.setOpaque(false);
            this.panelRbs.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getStateChange() == 1) {
                        if (evt.getValue().equals(PzDialogKnjigaPausalnihObveznika.BEZ_OGRANICENJE)) {
                            PzDialogKnjigaPausalnihObveznika.this.setEnableDatum(false);
                        } else if (evt.getValue().equals(PzDialogKnjigaPausalnihObveznika.U_PERIODU)) {
                            PzDialogKnjigaPausalnihObveznika.this.setEnableDatum(true);
                        }
                    }
                }
            });
            this.btnPotvrdi = new PzButton();
            this.pnlOgranicenje.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(2, 1, 1, 2, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.setShortcut("Ctrl+W");
            this.pnlDatum = new PzPanel();
            GridBagLayout pnlDatumLayout = new GridBagLayout();
            this.pnlOgranicenje.add((Component)this.pnlDatum, (Object)new GridBagConstraints(1, 0, 1, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlDatumLayout.rowWeights = new double[]{0.1, 0.0, 0.0, 0.1};
            pnlDatumLayout.rowHeights = new int[]{7, 7, 7, 7};
            pnlDatumLayout.columnWeights = new double[]{0.0, 0.0};
            pnlDatumLayout.columnWidths = new int[]{88, 150};
            this.pnlDatum.setLayout((LayoutManager)pnlDatumLayout);
            this.pnlDatum.setOpaque(false);
            this.lblPocetniDatum = new JLabel();
            this.pnlDatum.add((Component)this.lblPocetniDatum, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.lblPocetniDatum.setText("Po\u010detni datum:");
            this.lblKrajnjiDatum = new JLabel();
            this.pnlDatum.add((Component)this.lblKrajnjiDatum, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.lblKrajnjiDatum.setText("Krajnji datum:");
            this.dfPocetniDatum = new PzDateField();
            this.pnlDatum.add((Component)this.dfPocetniDatum, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfKrajnjiDatum = new PzDateField();
            this.pnlDatum.add((Component)this.dfKrajnjiDatum, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlScrollPane = new PzPanel();
            GridBagLayout pnlScrollPaneLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlScrollPane, (Object)new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 7, 7, 7), 0, 0));
            pnlScrollPaneLayout.rowWeights = new double[]{0.1};
            pnlScrollPaneLayout.rowHeights = new int[]{7};
            pnlScrollPaneLayout.columnWeights = new double[]{0.1};
            pnlScrollPaneLayout.columnWidths = new int[]{7};
            this.pnlScrollPane.setLayout((LayoutManager)pnlScrollPaneLayout);
            this.scrollPane = new JScrollPane();
            this.pnlScrollPane.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tblTable = new PzScrollableTable();
            this.scrollPane.setViewportView((Component)this.tblTable);
            this.pnlSaldo = new PzPanel();
            GridBagLayout pnlSaldoLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlSaldo, (Object)new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlSaldo.setLayout((LayoutManager)pnlSaldoLayout);
            pnlSaldoLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
            pnlSaldoLayout.rowHeights = new int[]{20, 7, 20};
            pnlSaldoLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlSaldoLayout.columnWidths = new int[]{101, 150, 7, 7};
            this.pnlSaldo.setOpaque(false);
            this.lblSaldo = new JLabel();
            this.pnlSaldo.add((Component)this.lblSaldo, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 7, 3, 0), 0, 0));
            this.lblSaldo.setText("Saldo u periodu:");
            this.lblSaldo.setForeground(new Color(0, 0, 255));
            this.lblSaldo.setFont(new Font("Tahoma", 2, 12));
            this.lblPrenetiSaldo = new JLabel();
            this.pnlSaldo.add((Component)this.lblPrenetiSaldo, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 7, 3, 0), 0, 0));
            this.lblPrenetiSaldo.setText("Preneto stanje:");
            this.lblPrenetiSaldo.setForeground(new Color(0, 0, 255));
            this.lblPrenetiSaldo.setFont(new Font("Tahoma", 2, 12));
            this.dfPrenetoStanje = new PzDoubleField();
            this.pnlSaldo.add((Component)this.dfPrenetoStanje, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.dfPrenetoStanje.setFocusable(false);
            this.dfPrenetoStanje.setEditable(false);
            this.dfPrenetoStanje.setBackground(new Color(157, 226, 250));
            this.lblUkupno = new JLabel();
            this.pnlSaldo.add((Component)this.lblUkupno, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 7, 5, 0), 0, 0));
            this.lblUkupno.setText("Ukupno:");
            this.lblUkupno.setForeground(new Color(0, 0, 255));
            this.lblUkupno.setFont(new Font("Tahoma", 2, 12));
            this.dfUkupno = new PzDoubleField();
            this.pnlSaldo.add((Component)this.dfUkupno, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.dfUkupno.setFocusable(false);
            this.dfUkupno.setEditable(false);
            this.dfUkupno.setBackground(new Color(157, 226, 250));
            this.dfSaldo = this.tblTable.createExpresionField("$7$");
            this.pnlSaldo.add((Component)this.dfSaldo, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.dfSaldo.setBackground(new Color(157, 226, 250));
            this.dfSaldo.setFocusable(false);
            this.dfSaldo.setEditable(false);
            this.layerUI = new PzBusyPainterUI();
            this.layer = new JXLayer((Component)this.pnlScrollPane, (LayerUI)this.layerUI);
            this.mainPanel.add(this.layer, (Object)new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 7, 7, 7), 0, 0));
            instance = this;
            this.layerUI.setLocked(false);
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText(" Broj dokumentara:");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(916, 665);
            this.setMinimumSize(new Dimension(916, 665));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void setEnableDatum(boolean enable) {
        this.lblPocetniDatum.setEnabled(enable);
        this.lblKrajnjiDatum.setEnabled(enable);
        this.dfPocetniDatum.setEnabled(enable);
        this.dfPocetniDatum.setFocusable(enable);
        this.dfKrajnjiDatum.setEnabled(enable);
        this.dfKrajnjiDatum.setFocusable(enable);
    }

    ScrollableCursor fillInTheInfo() {
        this.em = PzEntityManager.getEm();
        if (this.cursor != null) {
            this.cursor.close();
        }
        this.prenetoStanje = null;
        this.layerUI.setLocked(true);
        this.worker = new SwingWorker<ScrollableCursor, Object>(){

            @Override
            protected ScrollableCursor doInBackground() throws Exception {
                Query q;
                String queV = "SELECT SUM(CASE WHEN (a.storno = 1) THEN -(a.vrednostRobe + a.vrednostUsluga) ELSE a.vrednostRobe + a.vrednostUsluga END) FROM Dokument a WHERE a.tip IN ('" + TipDokumentConfig.get().FAKTURA + "', '" + TipDokumentConfig.get().FISKALNI_IZVESTAJ + "', '" + TipDokumentConfig.get().FAKTURA_SERVISA + "', '" + TipDokumentConfig.get().FAKTURA_USLUGA + "', '" + TipDokumentConfig.get().KPO_DOKUMENT + "') " + "AND a.arhiviran = 1 AND NOT a.rbrdok = -1 AND a.datprometa >= '" + PzDateUtility.getFirstDayOfCurrentYear() + "' AND a.datprometa <= '" + PzDialogKnjigaPausalnihObveznika.this.dfPocetniDatum.getVal() + "' ";
                String que = "SELECT \ta.iddok, \ta.datum,    kom.sfrkomitent, \ta.ozndokumenta, \ta.vrednostRobe, \ta.vrednostUsluga, \ta.storno, \ta.tip FROM Dokument a left join Komitent kom on kom.sfrKomitent = a.sfrKomitent WHERE a.tip IN ('" + TipDokumentConfig.get().FAKTURA + "', '" + TipDokumentConfig.get().FISKALNI_IZVESTAJ + "', '" + TipDokumentConfig.get().FAKTURA_SERVISA + "', '" + TipDokumentConfig.get().FAKTURA_USLUGA + "', '" + TipDokumentConfig.get().KPO_DOKUMENT + "') " + "AND a.arhiviran = 1 AND NOT a.rbrdok = -1 %period% Order by a.iddok ";
                if (PzDialogKnjigaPausalnihObveznika.this.panelRbs.getSelectedValue().equals(PzDialogKnjigaPausalnihObveznika.U_PERIODU)) {
                    que = que.replace("%period%", "AND a.datprometa >= '" + PzDialogKnjigaPausalnihObveznika.this.dfPocetniDatum.getVal() + "' AND a.datprometa <= '" + PzDialogKnjigaPausalnihObveznika.this.dfKrajnjiDatum.getVal() + "' ");
                    q = PzDialogKnjigaPausalnihObveznika.this.em.createNativeQuery(queV);
                    PzDialogKnjigaPausalnihObveznika.this.prenetoStanje = (BigDecimal)q.getSingleResult();
                } else {
                    que = que.replace("%period%", "");
                }
                q = PzDialogKnjigaPausalnihObveznika.this.em.createNativeQuery(que);
                q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                ScrollableCursor c = (ScrollableCursor)q.getSingleResult();
                c.size();
                return c;
            }

            @Override
            protected void done() {
                PzDialogKnjigaPausalnihObveznika.this.layerUI.setLocked(false);
                try {
                    PzDialogKnjigaPausalnihObveznika.this.cursor = (ScrollableCursor)this.get();
                    System.out.println(PzDialogKnjigaPausalnihObveznika.this.cursor.size());
                    PzDialogKnjigaPausalnihObveznika.this.brDok.setText(String.valueOf(PzDialogKnjigaPausalnihObveznika.this.cursor.size()));
                    try {
                        if (PzDialogKnjigaPausalnihObveznika.this.prenetoStanje == null) {
                            PzDialogKnjigaPausalnihObveznika.this.prenetoStanje = BigDecimal.ZERO;
                        }
                        PzDialogKnjigaPausalnihObveznika.this.model = new PzTableModelKPO(PzDialogKnjigaPausalnihObveznika.this.cursor, PzDialogKnjigaPausalnihObveznika.this.prenetoStanje, PzDialogKnjigaPausalnihObveznika.this);
                        PzDialogKnjigaPausalnihObveznika.this.tblTable.setModel((TableModel)((Object)PzDialogKnjigaPausalnihObveznika.this.model));
                        PzDialogKnjigaPausalnihObveznika.this.dfPrenetoStanje.setVal((Object)PzDialogKnjigaPausalnihObveznika.this.prenetoStanje);
                        if (PzDialogKnjigaPausalnihObveznika.this.tblTable.getRowCount() != 0) {
                            PzDialogKnjigaPausalnihObveznika.this.tblTable.setRowSelectionInterval(0, 0);
                        }
                        PzDialogKnjigaPausalnihObveznika.this.tblTable.calculateFields();
                        PzDialogKnjigaPausalnihObveznika.this.setUkupno();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        PzMysqlExceptionHandler.handle((Component)((Object)instance), (Throwable)e);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        };
        this.worker.execute();
        return this.cursor;
    }

    public void setUkupno() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.out.println(PzDialogKnjigaPausalnihObveznika.this.prenetoStanje);
                System.out.println(PzDialogKnjigaPausalnihObveznika.this.dfSaldo.getText());
                PzDialogKnjigaPausalnihObveznika.this.dfUkupno.setVal((Object)PzDialogKnjigaPausalnihObveznika.this.prenetoStanje.add(PzDialogKnjigaPausalnihObveznika.this.dfSaldo.getBigDecimal()));
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            this.fillInTheInfo();
            return;
        }
        if (actionCommand.equals("slika")) {
            this.onSlikaDokumentaPressed();
            return;
        }
        if (actionCommand.equals("brisanje")) {
            this.onBrisanjeDokumentaPressed();
            return;
        }
        if (actionCommand.equals("izmena")) {
            this.onIzmenaDokumentaPressed();
            return;
        }
        if (actionCommand.equals("dodavanje")) {
            this.onDodavanjeDokumentaPressed();
            return;
        }
        if (actionCommand.equals("stampa")) {
            this.showReport();
            return;
        }
    }

    private void onSlikaDokumentaPressed() {
        if (this.tblTable.getSelectedRow() == -1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Morate selektovati dokument iz tabele.", "Info", 1);
            return;
        }
        Integer iddok = (Integer)this.tblTable.getModel().getValueAt(this.tblTable.convertRowIndexToModel(this.tblTable.getSelectedRow()), 0);
        PzDokument d = null;
        try {
            d = (PzDokument)PzEntityManager.find(Dokument.class, (Object)iddok);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)d);
    }

    private void onBrisanjeDokumentaPressed() {
        if (this.tblTable.getSelectedRow() == -1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Morate selektovati dokument iz tabele.", "Info", 1);
            return;
        }
        Integer iddok = (Integer)this.tblTable.getModel().getValueAt(this.tblTable.convertRowIndexToModel(this.tblTable.getSelectedRow()), 0);
        PzDokument d = null;
        try {
            d = (PzDokument)PzEntityManager.find(Dokument.class, (Object)iddok);
            if (!d.getTip().equals(TipDokumentConfig.get().KPO_DOKUMENT)) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Zabranjeno brisanje dokumenta.");
            } else {
                PzEntityManager.delete(Dokument.class, (Object)iddok);
                PzEntityManager.delete(Opstidokument.class, (Object)iddok);
                this.fillInTheInfo();
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void onDodavanjeDokumentaPressed() {
        this.getSession().putParameter("update", (Object)false);
        this.showDialog(DodavanjeKPO.class);
    }

    private void onIzmenaDokumentaPressed() {
        if (this.tblTable.getSelectedRow() == -1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Morate selektovati dokument iz tabele.", "Info", 1);
            return;
        }
        Integer iddok = (Integer)this.tblTable.getModel().getValueAt(this.tblTable.convertRowIndexToModel(this.tblTable.getSelectedRow()), 0);
        PzDokument d = null;
        try {
            d = (PzDokument)PzEntityManager.find(Dokument.class, (Object)iddok);
            if (!d.getTip().equals(TipDokumentConfig.get().KPO_DOKUMENT)) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Izmena dokumenta nije dozvoljena.");
            } else {
                Knjigapausalnihobveznika kpo = (Knjigapausalnihobveznika)PzEntityManager.find(Knjigapausalnihobveznika.class, (Object)iddok);
                this.getSession().putParameter("update", (Object)true);
                this.getSession().putParameter("kpo", (Object)kpo);
                this.showDialog(DodavanjeKPO.class);
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void showReport() {
        try {
            Firma firma = null;
            firma = PzFirma.getFirma();
            Vector<Firma> data = new Vector<Firma>();
            data.add(firma);
            String subtitle = "";
            subtitle = this.panelRbs.getSelectedValue().equals(BEZ_OGRANICENJE) ? "u periodu od " + PzDateUtility.formatDate((Date)PzDateUtility.getFirstDayOfCurrentYear()) + " do " + PzDateUtility.formatDate((Date)PzDateUtility.getCurrentDate()) : "u periodu od " + PzDateUtility.formatDate((Date)this.dfPocetniDatum.getVal()) + " do " + PzDateUtility.formatDate((Date)this.dfKrajnjiDatum.getVal());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("title", "Knjiga o ostvarenom prometu pau\u0161alno oporezivanih obveznika");
            params.put("subtitle", subtitle);
            params.put("datum", PzDateUtility.getCurrentDate());
            PzTableDataSource ds = new PzTableDataSource((PzAbstractTable)this.tblTable, data);
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/reports/compiled/knjigapausalnihobveznika.jasper"), params, (String)"Knjiga o ostvarenom prometu pau\u0161alno oporezivanih obveznika", (int)PzReportManager.REPORT_TYPE_JASPER);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

