/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.komitenti;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.analitike.gui.Settings;
import rs.pezar.analitike.gui.komitenti.predlogKompenzacije.IspravkaIznosa;
import rs.pezar.analitike.gui.komitenti.predlogKompenzacije.PredlogKompenzacijeEntity;
import rs.pezar.core.gui.menu.PzDialogTekuciRacuni;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Tekuciracun;
import rs.pezar.db.management.PzPorukeManager;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzDataSource;
import rs.pezar.reports.PzReportManager;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.event.PzTableCheckboxListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzTextField;

public class PzDialogPredlogKompenzacije
extends PzDialog {
    private static final long serialVersionUID = -7508393225648537427L;
    public static final String KUPAC = "Kupac";
    public static final String DOBAVLJAC = "Dobavlja\u010d";
    BigDecimal kupac = new BigDecimal(0);
    BigDecimal dobavljac = new BigDecimal(0);
    BigDecimal razlika = new BigDecimal(0);
    private PzPanel pzPanel1;
    private JToolBar jToolBar1;
    private PzToolBarIcon pzToolBarIcon2;
    private JScrollPane jScrollPane1;
    private PzButton btnOk;
    private JLabel jLabel4;
    private PzDoubleField pzDoubleRazlika;
    private PzDoubleField pzDoubleDobavljac;
    private PzDoubleField pzDoubleKupac;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel lblNazivKupca;
    private PzTextField pzTextField1;
    private JLabel jLabel1;
    private PzPanel pzPanel3;
    private PzTable table;
    private PzPanel pzPanel2;
    private PzToolBarIcon pzToolBarIcon3;
    private PzToolBarIcon pzToolBarIcon1;
    private Komitent komitent;
    private ScrollableCursor cursor;
    private Vector<PredlogKompenzacijeEntity> temp;

    public PzDialogPredlogKompenzacije(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String actionCommand = ((PzButton)e.getSource()).getActionCommand();
            if (actionCommand.equals("selektuj")) {
                this.onbtnSelektujPressed();
            } else if (actionCommand.equals("izmeni")) {
                this.onbtnIzmeniPressed();
            } else if (actionCommand.equals("kraj")) {
                this.onbtnKrajPressed();
            } else if (actionCommand.equals("OK")) {
                this.onbtnOkPressed();
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Predlog kompenzacije");
            this.setPreferredSize(new Dimension(626, 760));
            this.pzPanel1 = new PzPanel();
            this.pzPanel1.setPaintGradient(true);
            this.getContentPane().add((Component)this.pzPanel1, "Center");
            AnchorLayout pzPanel1Layout = new AnchorLayout();
            this.pzPanel1.setLayout((LayoutManager)pzPanel1Layout);
            this.jToolBar1 = new JToolBar();
            this.jToolBar1 = new JToolBar();
            this.pzPanel1.add((Component)this.jToolBar1, (Object)new AnchorConstraint(0, 989, 134, 0, 1, 1, 1, 1));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            this.jToolBar1.setLayout(toolbarLayout);
            this.jToolBar1.setPreferredSize(new Dimension(611, 97));
            this.jToolBar1.setOpaque(false);
            this.pzToolBarIcon1 = new PzToolBarIcon();
            this.jToolBar1.add((Component)this.pzToolBarIcon1);
            this.pzToolBarIcon1.setText("Selektuj | (F2) / (Space)");
            this.pzToolBarIcon1.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/row_preferences.png")));
            this.pzToolBarIcon1.setActionCommand("slikadokumenta");
            this.pzToolBarIcon1.setToolTipText("Selektuje dokument u tabeli");
            this.pzToolBarIcon1.setPreferredSize(new Dimension(75, 84));
            this.pzToolBarIcon1.setSize(86, 93);
            this.pzToolBarIcon1.addActionListener((ActionListener)((Object)this));
            this.pzToolBarIcon1.setActionCommand("selektuj");
            this.pzToolBarIcon1.setShortcut("F2");
            this.pzToolBarIcon2 = new PzToolBarIcon();
            this.jToolBar1.add((Component)this.pzToolBarIcon2);
            this.pzToolBarIcon2.setText("Izmeni | (F3)");
            this.pzToolBarIcon2.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/row_edit.png")));
            this.pzToolBarIcon2.setActionCommand("slikadokumenta");
            this.pzToolBarIcon2.setPreferredSize(new Dimension(74, 80));
            this.pzToolBarIcon2.setSize(86, 93);
            this.pzToolBarIcon2.setToolTipText("Izmeni iznos na ozna\u010denoj fakturi");
            this.pzToolBarIcon2.addActionListener((ActionListener)((Object)this));
            this.pzToolBarIcon2.setActionCommand("izmeni");
            this.pzToolBarIcon2.setShortcut("F3");
            this.pzToolBarIcon3 = new PzToolBarIcon();
            this.jToolBar1.add((Component)this.pzToolBarIcon3);
            this.pzToolBarIcon3.setText("Kraj | (CTRL+W)");
            this.pzToolBarIcon3.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.pzToolBarIcon3.setActionCommand("slikadokumenta");
            this.pzToolBarIcon3.setPreferredSize(new Dimension(72, 80));
            this.pzToolBarIcon3.setSize(86, 93);
            this.pzToolBarIcon3.setToolTipText("\u0160tampanje predloga kompenzacije (CTRL+W)");
            this.pzToolBarIcon3.addActionListener((ActionListener)((Object)this));
            this.pzToolBarIcon3.setActionCommand("kraj");
            this.pzToolBarIcon3.setShortcut("CTRL+W");
            this.pzPanel2 = new PzPanel();
            GridBagLayout pzPanel2Layout = new GridBagLayout();
            this.pzPanel1.add((Component)this.pzPanel2, (Object)new AnchorConstraint(142, 337, 305, 12, 1, 1, 1, 1));
            pzPanel2Layout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            pzPanel2Layout.rowHeights = new int[]{-8, -11, 23, 7};
            pzPanel2Layout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.0};
            pzPanel2Layout.columnWidths = new int[]{7, 65, 7, 7};
            this.pzPanel2.setLayout((LayoutManager)pzPanel2Layout);
            this.pzPanel2.setBorder((Border)BorderFactory.createTitledBorder("Komitent"));
            this.pzPanel2.setPreferredSize(new Dimension(201, 118));
            this.jLabel1 = new JLabel();
            this.pzPanel2.add((Component)this.jLabel1, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel1.setText("\u0160ifra:");
            this.pzTextField1 = new PzTextField();
            this.pzPanel2.add((Component)this.pzTextField1, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pzTextField1.setHorizontalAlignment(4);
            this.pzTextField1.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.lblNazivKupca = new JLabel();
            this.pzPanel2.add((Component)this.lblNazivKupca, (Object)new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOk = new PzButton();
            this.pzPanel2.add((Component)this.btnOk, (Object)new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOk.setText("Prika\u017ei");
            this.btnOk.addActionListener((ActionListener)((Object)this));
            this.btnOk.setActionCommand("OK");
            this.jScrollPane1 = new JScrollPane();
            this.pzPanel1.add((Component)this.jScrollPane1, (Object)new AnchorConstraint(313, 1000, 1003, 12, 1, 1, 1, 1));
            this.jScrollPane1.setPreferredSize(new Dimension(611, 501));
            this.pzPanel3 = new PzPanel();
            this.pzPanel1.add((Component)this.pzPanel3, (Object)new AnchorConstraint(142, 989, 305, 382, 1, 1, 1, 1));
            GridBagLayout pzPanel3Layout = new GridBagLayout();
            pzPanel3Layout.columnWidths = new int[]{7, 107, 45, 7, 7};
            pzPanel3Layout.rowHeights = new int[]{7, 19, 18, 20, 7};
            pzPanel3Layout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1, 0.0};
            pzPanel3Layout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
            this.pzPanel3.setLayout((LayoutManager)pzPanel3Layout);
            this.pzPanel3.setBorder((Border)BorderFactory.createTitledBorder("Selektovani iznos"));
            this.pzPanel3.setPreferredSize(new Dimension(375, 118));
            this.jLabel2 = new JLabel();
            this.pzPanel3.add((Component)this.jLabel2, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel2.setText("Kupac:");
            this.jLabel3 = new JLabel();
            this.pzPanel3.add((Component)this.jLabel3, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel3.setText("Dobavlja\u010d:");
            this.jLabel4 = new JLabel();
            this.pzPanel3.add((Component)this.jLabel4, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel4.setText("Razlika:");
            this.pzDoubleKupac = new PzDoubleField();
            this.pzPanel3.add((Component)this.pzDoubleKupac, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pzDoubleKupac.setEditable(false);
            this.pzDoubleKupac.setBackground(new Color(157, 226, 150));
            this.pzDoubleDobavljac = new PzDoubleField();
            this.pzPanel3.add((Component)this.pzDoubleDobavljac, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pzDoubleDobavljac.setEditable(false);
            this.pzDoubleDobavljac.setBackground(new Color(157, 226, 150));
            this.pzDoubleRazlika = new PzDoubleField();
            this.pzPanel3.add((Component)this.pzDoubleRazlika, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pzDoubleRazlika.setEditable(false);
            this.pzDoubleRazlika.setBackground(new Color(255, 108, 108));
            this.pack();
            this.setSize(626, 760);
            this.instantiateTable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fillInTheInfo() {
        BigDecimal kupac = new BigDecimal(0.0);
        BigDecimal dobavljac = new BigDecimal(0.0);
        String query = "Select a  from Dokument a where ((%s) and a.komitent.sfrKomitent = :sifra and a.arhiviran = 1 and (not a.storno = 1)\tand (not (a.podTip = '" + TipDokumentConfig.get().OTPREMNICA + "') AND NOT (a.podTip = 'PRENOSNICA')  )) and (a.iznos - a.stornoIznos - a.uplata > 1) order by a.datValute ";
        String dokumenta = "";
        int i = 0;
        while (i < Settings.predlogkompenzacije.length) {
            dokumenta = String.valueOf(dokumenta) + "a.tip = '" + Settings.predlogkompenzacije[i][0] + "' OR ";
            ++i;
        }
        dokumenta = dokumenta.substring(0, dokumenta.length() - 3);
        query = String.format(query, dokumenta);
        EntityManager em = PzEntityManager.getEm();
        Query q = em.createQuery(query);
        q.setParameter("sifra", (Object)this.komitent.getSfrKomitent());
        Vector result = (Vector)q.getResultList();
        this.temp = new Vector();
        int i2 = 0;
        while (i2 < result.size()) {
            BigDecimal iznos = ((Dokument)result.get(i2)).getIznos() == null ? new BigDecimal(0.0) : ((Dokument)result.get(i2)).getIznos();
            BigDecimal stornoIznos = ((Dokument)result.get(i2)).getStornoIznos() == null ? new BigDecimal(0.0) : ((Dokument)result.get(i2)).getStornoIznos();
            BigDecimal uplata = ((Dokument)result.get(i2)).getStornoIznos() == null ? new BigDecimal(0.0) : ((Dokument)result.get(i2)).getUplata();
            iznos = iznos.subtract(stornoIznos).subtract(uplata);
            PredlogKompenzacijeEntity kompenzacijaEntity = new PredlogKompenzacijeEntity();
            kompenzacijaEntity.setOznDokumenta(((Dokument)result.get(i2)).getOznDokumenta());
            kompenzacijaEntity.setIznosPredlog(iznos);
            kompenzacijaEntity.setKupacDobavljac(this.isKupacDobavljac((PzEntity)result.get(i2)));
            kompenzacijaEntity.setDatum(((Dokument)result.get(i2)).getDatum());
            kompenzacijaEntity.setDatumValute(((Dokument)result.get(i2)).getDatValute());
            this.temp.add(kompenzacijaEntity);
            if (this.isKupacDobavljac((PzEntity)result.get(i2)).equals(KUPAC)) {
                kupac = kupac.add(iznos);
            } else {
                dobavljac = dobavljac.add(iznos);
            }
            ++i2;
        }
        this.table.setData(this.temp, Dokument.class);
        this.table.requestFocusInWindow();
        this.refreshSum();
        if (kupac.doubleValue() == 0.0 || dobavljac.doubleValue() == 0.0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Ne postoje uslovi za izradu predloga kompenzacije!", "Ne postoje uslovi", 1);
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        this.komitent = (Komitent)entity;
        if (this.komitent != null) {
            ((PzField)component).setVal((Object)this.komitent.getSfrKomitent());
            this.lblNazivKupca.setText(this.komitent.getNaziv());
        }
    }

    private String isKupacDobavljac(PzEntity entity) {
        int i = 0;
        while (i < Settings.predlogkompenzacije.length) {
            if (Settings.predlogkompenzacije[i][0].equals(((Dokument)entity).getTip()) && Settings.predlogkompenzacije[i][1].equals("DUGUJE")) {
                return KUPAC;
            }
            if (Settings.predlogkompenzacije[i][0].equals(((Dokument)entity).getTip()) && Settings.predlogkompenzacije[i][1].equals("POTRAZUJE")) {
                return DOBAVLJAC;
            }
            ++i;
        }
        return "";
    }

    private void instantiateTable() {
        PzEntityFilter filter = new PzEntityFilter(){

            public Object[] getValues(PzEntity entity) {
                return new Object[]{((PredlogKompenzacijeEntity)entity).getKupacDobavljac(), ((PredlogKompenzacijeEntity)entity).getDatum(), ((PredlogKompenzacijeEntity)entity).getDatumValute(), ((PredlogKompenzacijeEntity)entity).getOznDokumenta(), ((PredlogKompenzacijeEntity)entity).getIznosPredlog()};
            }

            public String[] getColumnNames() {
                return new String[]{"Kupac / Dobavlja\u010d", "Datum", "Datum Valute", "Broj Dokumenta", "Iznos"};
            }
        };
        PzTableCheckboxListener cbListener = new PzTableCheckboxListener(){

            public void valueChanged(int rowIndex, PzEntity entity, boolean newValue) {
                PzDialogPredlogKompenzacije.this.refreshSum();
                PzDialogPredlogKompenzacije.this.repaint();
            }
        };
        this.table = new PzTable();
        this.table.addCheckboxListener(cbListener);
        this.table.setFilter(filter);
        this.table.setCheckboxColumn(0, KeyStroke.getKeyStroke("F2"));
        this.jScrollPane1.setViewportView((Component)this.table);
    }

    public void refreshSum() {
        List l = this.table.getCheckedEntities();
        if (l == null) {
            return;
        }
        this.kupac = new BigDecimal(0);
        this.dobavljac = new BigDecimal(0);
        BigDecimal iznos = BigDecimal.ZERO;
        int i = 0;
        while (i < l.size()) {
            iznos = ((PredlogKompenzacijeEntity)l.get(i)).getIznosPredlog();
            if (((PredlogKompenzacijeEntity)l.get(i)).getKupacDobavljac().equals(KUPAC)) {
                this.kupac = this.kupac.add(iznos);
            } else {
                this.dobavljac = this.dobavljac.add(iznos);
            }
            ++i;
        }
        this.pzDoubleKupac.setVal((Object)this.kupac);
        this.pzDoubleDobavljac.setVal((Object)this.dobavljac);
        this.pzDoubleRazlika.setVal((Object)this.kupac.subtract(this.dobavljac));
    }

    private void onbtnSelektujPressed() {
        this.refreshSum();
        this.repaint();
    }

    private void onbtnKrajPressed() {
        if (this.kupac.equals(new BigDecimal(0)) || this.dobavljac.equals(new BigDecimal(0))) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Nema uslova za izradu kompenzacije", "Greska", 0);
            return;
        }
        Vector<Object> data = new Vector<Object>();
        Vector<List> ll = new Vector<List>();
        Vector<String> dokZaKupca = new Vector<String>();
        int i = 0;
        while (i < Settings.predlogkompenzacije.length) {
            if (Settings.predlogkompenzacije[i][1].equals("DUGUJE")) {
                dokZaKupca.add(Settings.predlogkompenzacije[i][0]);
            }
            ++i;
        }
        Tekuciracun tekuciRacun = PzDialogTekuciRacuni.getTekuciRacun((PzDialog)this, (String)"Izberite tekuci racun");
        if (tekuciRacun == null) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.komitent.getTekuciracuns().size() > 0) {
            params.put("komitenttekuci", ((Tekuciracun)this.komitent.getTekuciracuns().get(0)).getBrRacuna());
        }
        params.put("dokZaKupca", dokZaKupca);
        List lista1 = PzPorukeManager.getPoruke((String)"KOMPENZACIJA1");
        List lista2 = PzPorukeManager.getPoruke((String)"KOMPENZACIJA2");
        String poruka1 = lista1 != null && lista1.size() > 0 ? (String)lista1.get(0) : "";
        String poruka2 = lista2 != null && lista2.size() > 0 ? (String)lista2.get(0) : "";
        if (poruka1 == null) {
            poruka1 = "";
        }
        if (poruka2 == null) {
            poruka2 = "";
        }
        params.put("poruka1", poruka1);
        params.put("poruka2", poruka2);
        try {
            data.add(tekuciRacun);
            data.add(this.komitent);
            data.add(PzFirma.getFirma());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        ll.add(this.table.getCheckedEntities());
        PzDataSource ds = new PzDataSource(data, ll);
        try {
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)"rs/pezar/reports/compiled/izjava.o.prebijanju.jasper", params, (String)"PredlogKompenzacije", (int)PzReportManager.REPORT_TYPE_JASPER);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onbtnIzmeniPressed() {
        this.table.getSelectedRow();
        if (this.table.getSelectedRow() != -1 && this.table.getSelectedRow() < this.table.getRowCount()) {
            PredlogKompenzacijeEntity predlogEntity = (PredlogKompenzacijeEntity)this.table.getSelectedEntity();
            BigDecimal iznos = predlogEntity.getIznosPredlog();
            BigDecimal abc = IspravkaIznosa.getIznos(this, iznos);
            predlogEntity.setIznosPredlog(abc);
            this.repaint();
            this.refreshSum();
        }
    }

    private void onbtnOkPressed() {
        this.fillInTheInfo();
    }

    protected void thisWindowClosing(WindowEvent evt) {
        if (this.cursor != null) {
            this.cursor.close();
        }
        super.thisWindowClosing(evt);
    }
}

