/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.porez.popdv.form;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rs.pezar.analitike.gui.porez.popdv.form.Vrednost;

public class Red {
    private String id;
    private String naziv;
    private List<Vrednost> vrednosti;
    private boolean sumarni;

    public Red(String id) {
        this.id = id;
        this.vrednosti = new ArrayList<Vrednost>();
    }

    public Red(String id, Vrednost ... vrednosti) {
        this(id);
        int i = 0;
        while (i < vrednosti.length) {
            if (vrednosti[i].getId() == null) {
                vrednosti[i].setId(String.valueOf(i + 1));
            }
            this.addVrednost(vrednosti[i]);
            ++i;
        }
    }

    public Red(String id, BigDecimal ... vrednosti) {
        this(id);
        int i = 0;
        while (i < vrednosti.length) {
            this.addVrednost(new Vrednost(String.valueOf(i + 1), vrednosti[i]));
            ++i;
        }
    }

    public Red(int id, BigDecimal ... vrednosti) {
        this(String.valueOf(id), vrednosti);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNaziv() {
        return this.naziv;
    }

    public void setNaziv(String naziv) {
        this.naziv = naziv;
    }

    public List<Vrednost> getVrednosti() {
        return this.vrednosti;
    }

    public void setVrednosti(List<Vrednost> vrednosti) {
        this.vrednosti = vrednosti;
    }

    public void addVrednost(Vrednost v) {
        this.vrednosti.add(v);
    }

    public void setSumarni(boolean sumarni) {
        this.sumarni = sumarni;
    }

    public boolean isSumarni() {
        return this.sumarni;
    }

    public Vrednost getVrednost(String id) {
        Vrednost v = null;
        Iterator<Vrednost> iterator = this.getVrednosti().iterator();
        while (iterator.hasNext() && v == null) {
            Vrednost tmp = iterator.next();
            if (!id.equals(tmp.getId())) continue;
            v = tmp;
        }
        return v;
    }

    public void setSumarneVrednosti(List<Vrednost> add) {
        int i = 0;
        while (i < this.getVrednosti().size()) {
            this.getVrednosti().get(i).addAndBind(add.get(i));
            ++i;
        }
    }

    public Red kol(int ... kol) {
        Red red = new Red(this.getId());
        int i = 0;
        while (i < kol.length) {
            red.addVrednost(this.getVrednosti().get(kol[i] - 1));
            ++i;
        }
        return red;
    }

    public Red abs() {
        Red red = new Red(this.getId());
        for (final Vrednost v1 : this.getVrednosti()) {
            final Vrednost v2 = new Vrednost(v1.getId(), v1.getIznos().abs());
            v1.addListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    v2.setIznos(v1.getIznos().abs());
                }
            });
            red.addVrednost(v2);
        }
        return red;
    }

    public Red absIfNeg() {
        Red red = new Red(this.getId());
        red.setSumarni(this.isSumarni());
        for (final Vrednost v1 : this.getVrednosti()) {
            final Vrednost v2 = new Vrednost(v1.getId(), v1.getIznos().compareTo(BigDecimal.ZERO) < 0 ? v1.getIznos().abs() : BigDecimal.ZERO);
            v1.addListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    BigDecimal iznos = v1.getIznos().compareTo(BigDecimal.ZERO) < 0 ? v1.getIznos().abs() : BigDecimal.ZERO;
                    v2.setIznos(iznos);
                }
            });
            red.addVrednost(v2);
        }
        return red;
    }

    public Red zeroIfNeg() {
        Red red = new Red(this.getId());
        red.setSumarni(this.isSumarni());
        for (final Vrednost v1 : this.getVrednosti()) {
            final Vrednost v2 = new Vrednost(v1.getId(), v1.getIznos().compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : v1.getIznos());
            v1.addListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    BigDecimal iznos = v1.getIznos().compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : v1.getIznos();
                    v2.setIznos(iznos);
                }
            });
            red.addVrednost(v2);
        }
        return red;
    }

    public Red add(Red drugiRed) {
        Red noviRed = new Red(String.valueOf(this.getId()) + drugiRed.getId());
        for (Vrednost v : this.getVrednosti()) {
            Vrednost vNova = new Vrednost(v.getId(), BigDecimal.ZERO);
            vNova.addAndBind(v);
            Vrednost vDruga = drugiRed.getVrednost(v.getId());
            if (vDruga != null) {
                vNova.addAndBind(vDruga);
            }
            noviRed.addVrednost(vNova);
        }
        return noviRed;
    }

    public Red negate() {
        Red red = new Red(this.getId());
        for (final Vrednost v : this.getVrednosti()) {
            final Vrednost vNova = new Vrednost(v.getId(), v.getIznos().negate());
            v.addListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    vNova.setIznos(v.getIznos().negate());
                }
            });
            red.addVrednost(vNova);
        }
        return red;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Red: " + this.id + "\r\n");
        for (Vrednost element : this.vrednosti) {
            sb.append("\t" + element.toString());
            sb.append("\r\n");
        }
        return sb.toString();
    }
}

