/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.pregledi.analizaNabavkeProdajeArtikala;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Valuta;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.reports.engine.standard.PzResultSetDataSourceAdapter;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.util.PzDateUtility;

public class PzDialogPregledKupovine
extends PzDialog {
    public static final String DETALJAN_PREGLED = "Detaljan pregled";
    public static final String ZBIRNI_PREGLED = "Zbirni pregled";
    private PzPanel pnlGlavni;
    private JPanel pnlButton;
    private PzPanel pnlFields;
    private JLabel lblPocetniDatum;
    private PzRadioGroup<String> panelRbs;
    private JPanel panelDatum;
    private PzTextField tfNaziv;
    private PzDateField dfKrajnjiDatum;
    private JLabel lblKrajnjiDatum;
    private PzDateField dfPocetniDatum;
    private PzFieldIndikator indSifra;
    private PzTextField tfSifra;
    private JLabel lblSifra;
    private PzButton btnPotvrdi;
    private Komitent entKomitent;
    private ScrollableCursor cursor = null;
    private PzComboBox cbValuta;
    private PzPanel pnlValuta;

    public PzDialogPregledKupovine(JFrame frame) {
        super(frame);
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        Query q = PzEntityManager.getEm().createQuery("Select v from Valuta v");
        Iterator i = q.getResultList().iterator();
        this.cbValuta.addItem((Object)new PzChoice("", (Object)""));
        while (i.hasNext()) {
            Valuta v = (Valuta)i.next();
            this.cbValuta.addItem((Object)new PzChoice(v.getNaziv(), (Object)v.getOznValuta()));
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Pregled kupovine od proizvo\u0111a\u010da");
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{48, 48, 75, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlGlavni.setPreferredSize(new Dimension(442, 197));
            this.pnlButton = new JPanel();
            this.pnlGlavni.add((Component)this.pnlButton, (Object)new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlButton.setOpaque(false);
            this.btnPotvrdi = new PzButton();
            this.pnlButton.add((Component)this.btnPotvrdi, new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 25, 0, 25), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(130, 35));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlFields, (Object)new GridBagConstraints(0, 0, 4, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlFieldsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.rowHeights = new int[]{21, 25, 14, 45, 38, 7};
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.columnWidths = new int[]{32, 93, 114, 138, 125, 20};
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.pnlFields.setOpaque(false);
            this.lblSifra = new JLabel();
            this.pnlFields.add((Component)this.lblSifra, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblSifra.setText("\u0160ifra proizvo\u0111a\u010da");
            this.tfSifra = new PzTextField();
            this.pnlFields.add((Component)this.tfSifra, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            this.tfSifra.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.indSifra = new PzFieldIndikator();
            this.pnlFields.add((Component)this.indSifra, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.tfNaziv = new PzTextField();
            this.pnlFields.add((Component)this.tfNaziv, (Object)new GridBagConstraints(3, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 0, 0), 0, 0));
            this.tfNaziv.setEditable(false);
            this.tfNaziv.setFocusable(false);
            this.panelDatum = new JPanel();
            GridBagLayout panelDatumLayout = new GridBagLayout();
            this.pnlFields.add((Component)this.panelDatum, (Object)new GridBagConstraints(1, 3, 2, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelDatum.setBorder(BorderFactory.createTitledBorder("Period pregleda"));
            panelDatumLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            panelDatumLayout.rowHeights = new int[]{5, 25, 25, 7};
            panelDatumLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            panelDatumLayout.columnWidths = new int[]{54, 21, 90, 7};
            this.panelDatum.setLayout(panelDatumLayout);
            this.panelDatum.setOpaque(false);
            this.lblPocetniDatum = new JLabel();
            this.panelDatum.add((Component)this.lblPocetniDatum, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblPocetniDatum.setText("Po\u010detni datum");
            this.dfPocetniDatum = new PzDateField();
            this.panelDatum.add((Component)this.dfPocetniDatum, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblKrajnjiDatum = new JLabel();
            this.panelDatum.add((Component)this.lblKrajnjiDatum, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblKrajnjiDatum.setText("Krajnji datum");
            this.dfKrajnjiDatum = new PzDateField();
            this.panelDatum.add((Component)this.dfKrajnjiDatum, new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRbs = new PzRadioGroup((Object[])new String[]{DETALJAN_PREGLED, ZBIRNI_PREGLED});
            BoxLayout panelRBsLayout = new BoxLayout((Container)this.panelRbs, 1);
            this.panelRbs.setLayout((LayoutManager)panelRBsLayout);
            this.pnlFields.add(this.panelRbs, (Object)new GridBagConstraints(3, 3, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRbs.setBorder((Border)BorderFactory.createTitledBorder("Pregled"));
            this.panelRbs.setSelectedValue((Object)DETALJAN_PREGLED);
            this.panelRbs.setOpaque(false);
            this.pnlValuta = new PzPanel();
            GridBagLayout pnlValutaLayout = new GridBagLayout();
            this.pnlFields.add((Component)this.pnlValuta, (Object)new GridBagConstraints(4, 3, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlValutaLayout.rowWeights = new double[]{0.1, 0.0, 0.1};
            pnlValutaLayout.rowHeights = new int[]{7, 25, 7};
            pnlValutaLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            pnlValutaLayout.columnWidths = new int[]{14, 90, 7};
            this.pnlValuta.setLayout((LayoutManager)pnlValutaLayout);
            this.pnlValuta.setBorder((Border)BorderFactory.createTitledBorder("Izbor strane valute"));
            this.pnlValuta.setOpaque(false);
            this.cbValuta = new PzComboBox();
            this.pnlValuta.add((Component)this.cbValuta, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfSifra.setStateIndikator(this.indSifra);
            this.pack();
            this.setSize(620, 282);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    if (PzDialogPregledKupovine.this.cursor != null) {
                        PzDialogPregledKupovine.this.cursor.close();
                    }
                    String upit = "";
                    Query q = null;
                    String valuta = PzDialogPregledKupovine.this.cbValuta.getSelectedChoice().getValue().toString();
                    if (((String)PzDialogPregledKupovine.this.panelRbs.getSelectedValue()).equals(PzDialogPregledKupovine.DETALJAN_PREGLED)) {
                        upit = "SELECT ad1.sfrProizvod, ad1.naziv, sum(ad1.kolicina), sum(ad2.kolicina),ad1.prodCena%valuta%, ad1.procRabata, d1.datum, d1.oznDokumenta, d1.oznRj, k.sfrKomitent, k.naziv FROM Komitent pro, Artikal a, Radnajedinica rj,  (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok LEFT JOIN Komitent k ON d1.sfrKomitent = k.sfrKomitent%valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena WHERE %valutaW% rj.oznRj = d1.oznRj and rj.oznOgranak = d1.oznOgranak and rj.oznRj IN (%listaRj%) and d1.tip IN ('%tipF%', '%tipFI%', '%tipFS%', '%tipFR%') AND d1.storno = 0 and d1.arhiviran = 1 AND d1.datum >= ':datumOd' AND d1.datum <= ':datumDo' AND ad1.sfrProizvod = a.sfrProizvod AND a.proizvodjac = pro.sfrKomitent AND pro.sfrKomitent = ':komitent' GROUP BY ad1.sfrProizvod, ad1.naziv, ad1.kolicina, ad1.prodCena, ad1.procRabata, d1.datum, d1.oznDokumenta, d1.oznRj, k.sfrKomitent, k.naziv %valutaG% ORDER BY k.sfrKomitent ";
                        upit = upit.replace(":komitent", PzDialogPregledKupovine.this.entKomitent.getSfrKomitent());
                        upit = upit.replace(":datumOd", PzDialogPregledKupovine.this.dfPocetniDatum.getVal().toString());
                        upit = upit.replace(":datumDo", PzDialogPregledKupovine.this.dfKrajnjiDatum.getVal().toString());
                    } else if (((String)PzDialogPregledKupovine.this.panelRbs.getSelectedValue()).equals(PzDialogPregledKupovine.ZBIRNI_PREGLED)) {
                        upit = "SELECT k.sfrKomitent, k.naziv, sum(CASE WHEN (d1.tip = '%tipF%' or d1.tip = '%tipFR%') THEN ((ad1.prodCena*ad1.procRabata/100)*ad1.kolicina)%valuta% ELSE 0 END), sum(CASE WHEN (d2.tip = '%tipF%' or d2.tip = '%tipFR%') THEN ((ad2.prodCena*ad2.procRabata/100)*ad2.kolicina)%valuta% ELSE 0 END), sum((ad1.prodCena*ad1.kolicina)%valuta%), sum((ad1.prodCena*ad2.kolicina)%valuta%) FROM Komitent pro, Artikal a, Radnajedinica rj, (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok LEFT JOIN Komitent k ON d1.sfrKomitent = k.sfrKomitent%valutaF% ) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena WHERE %valutaW% d1.datum >= ':datumOd' AND d1.datum <= ':datumDo' and rj.oznRj = d1.oznRj and rj.oznOgranak = d1.oznOgranak and rj.oznRj IN (%listaRj%) and d1.tip IN ('%tipF%', '%tipFI%', '%tipFS%', '%tipFR%') AND d1.storno = 0 and d1.arhiviran = 1 AND ad1.sfrProizvod = a.sfrProizvod AND a.proizvodjac = pro.sfrKomitent AND pro.sfrKomitent = ':komitent' GROUP BY k.sfrKomitent, k.naziv ORDER BY k.sfrKomitent";
                        upit = upit.replace(":komitent", PzDialogPregledKupovine.this.entKomitent.getSfrKomitent());
                        upit = upit.replace(":datumOd", PzDialogPregledKupovine.this.dfPocetniDatum.getVal().toString());
                        upit = upit.replace(":datumDo", PzDialogPregledKupovine.this.dfKrajnjiDatum.getVal().toString());
                    }
                    upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/kurs.srednji/kurs.jedinica");
                    upit = upit.replace("%valutaG%", valuta.equals("") ? " " : ", kurs.srednji, kurs.jedinica ");
                    upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = d1.datPrometa");
                    upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " kurs.oznValuta='" + valuta + "' and");
                    if (PzDialogRJ.getAvaliableRjString().equals("")) {
                        throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                    }
                    upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                    upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
                    upit = upit.replace("%tipFI%", TipDokumentConfig.get().FISKALNI_IZVESTAJ);
                    upit = upit.replace("%tipFR%", TipDokumentConfig.get().FISKALNI_RACUN);
                    upit = upit.replace("%tipFS%", TipDokumentConfig.get().FAKTURA_SERVISA);
                    q = em.createNativeQuery(upit);
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    PzDialogPregledKupovine.this.cursor = (ScrollableCursor)q.getSingleResult();
                    System.out.println("Kursor je nasao faktura" + PzDialogPregledKupovine.this.cursor.size());
                    em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                        if (PzDialogPregledKupovine.this.cursor.size() == 0) {
                            JOptionPane.showMessageDialog(PzDialogPregledKupovine.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                            PzWorkerDialog.hideStatus();
                            return;
                        }
                        try {
                            PzDialogPregledKupovine.this.showReports();
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogPregledKupovine.this), (Throwable)e);
                            PzWorkerDialog.hideStatus();
                        }
                    }
                    finally {
                        em.close();
                    }
                }
            };
            worker.execute();
        }
    }

    private void showReports() throws Exception {
        Vector<Firma> data = new Vector<Firma>();
        Date today = PzDateUtility.getCurrentDate();
        PzDataSourceExtended ds = new PzDataSourceExtended(data, this.cursor);
        ds.setAdapter((PzDataSourceAdapter)new PzResultSetDataSourceAdapter());
        String title = "PREGLED PRODAJE OD PROIZVO\u0110A\u010cA: [ " + this.entKomitent.getSfrKomitent() + " ] " + this.entKomitent.getNaziv();
        String subtitle = "Period: " + PzDateUtility.formatDate((Date)this.dfPocetniDatum.getVal()) + " do " + PzDateUtility.formatDate((Date)this.dfKrajnjiDatum.getVal());
        String fname = "";
        String valuta = "Vrednosti su izra\u017eene u valuti: " + (this.cbValuta.getSelectedChoice().getValue().equals("") ? "Dinar" : this.cbValuta.getSelectedChoice().getText());
        fname = ((String)this.panelRbs.getSelectedValue()).equals(DETALJAN_PREGLED) ? "rs/pezar/analitike/resource/reports/compiled/pregled.prodaje.kupcu.jasper" : "rs/pezar/analitike/resource/reports/compiled/pregled.prodaje.kupcu.zbirno.jasper";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", title);
        params.put("subtitle", subtitle);
        params.put("datum", today);
        params.put("reklama", "");
        params.put("pretraga", "Kupac");
        params.put("valuta", valuta);
        data.add(PzFirma.getFirma());
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource(fname), params, (String)title);
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.entKomitent = (Komitent)entity;
            if (this.entKomitent != null) {
                this.tfSifra.setVal((Object)this.entKomitent.getSfrKomitent());
                this.tfNaziv.setVal((Object)this.entKomitent.getNaziv());
            }
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogPregledKupovine(Boolean.FALSE);
    }

    public PzDialogPregledKupovine(Boolean initGUI) {
    }
}

