/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.reports;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRSaver;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.BDConverter;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.core.log.PzLogger;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Fakturaparameter;
import rs.pezar.db.entity.Fakturausluga;
import rs.pezar.db.entity.Kurs;
import rs.pezar.db.entity.KursPK;
import rs.pezar.db.management.PzPorukeManager;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzHashMapDataSource;
import rs.pezar.reports.PzReportViewer;
import rs.pezar.reports.PzSingleListDataSource;
import rs.pezar.reports.engine.dokument.DokumentDS;
import rs.pezar.reports.engine.dokument.PzDokumentResolver;
import rs.pezar.reports.excel.PzXlsViewer;
import rs.pezar.reports.rf.PzDokumentRF;
import rs.pezar.reports.util.Porezi;
import rs.pezar.reports.util.PzPorez;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.util.PzCacheUtility;
import rs.pezar.util.PzDateUtility;
import rs.pezar.util.PzFileUtility;

public class PzReportManager
extends SwingWorker<JasperPrint, Integer> {
    public static int REPORT_TYPE_JASPER = 1;
    public static int REPORT_TYPE_XLS = 2;
    public static boolean GENERATE_ONLY = false;
    private PzDialog parent;
    private JRDataSource ds;
    private Map<String, Object> params;
    private String exportFilename;
    private InputStream is;
    private int reportType;
    private PzDokumentRF dokumentRf;

    static {
        JRProperties.setProperty((String)"net.sf.jasperreports.default.pdf.encoding", (String)"UTF-8");
    }

    public PzReportManager() {
    }

    public PzReportManager(PzDialog parent, JRDataSource ds, String compiledFile, Map<String, Object> params, String exportFilename, PzDokumentRF rf, int reportType) throws IOException, JRException {
        this.parent = parent;
        this.ds = ds;
        this.is = PzFileUtility.getReportFileAsInputStream((String)compiledFile, (ClassLoader)new PzReportManager().getClass().getClassLoader());
        this.params = new HashMap<String, Object>();
        if (params != null) {
            this.params.putAll(params);
        }
        this.exportFilename = exportFilename;
        this.dokumentRf = rf;
        this.reportType = reportType;
        this.params.put("sencenje", Boolean.valueOf(PzParameter.getParameterValue((String)"SENCENJE_REDOVA", (String)"true")));
        this.params.put("godina", PzDateUtility.getCurrentYear());
    }

    public PzReportManager(PzDialog parent, JRDataSource ds, URL compiledFile, Map<String, Object> params, String exportFilename, PzDokumentRF rf, int reportType) throws IOException {
        this.parent = parent;
        this.ds = ds;
        this.is = PzFileUtility.getReportFileAsInputStreamURL((URL)compiledFile, (ClassLoader)new PzReportManager().getClass().getClassLoader());
        this.params = new HashMap<String, Object>();
        if (params != null) {
            this.params.putAll(params);
        }
        this.exportFilename = exportFilename;
        this.dokumentRf = rf;
        this.reportType = reportType;
        this.params.put("sencenje", Boolean.valueOf(PzParameter.getParameterValue((String)"SENCENJE_REDOVA", (String)"true")));
        this.params.put("godina", PzDateUtility.getCurrentYear());
    }

    public static void createAndShowReport(PzDialog parent, JRDataSource ds, String compiledFile, Map<String, Object> params, String exportFilename) throws JRException, IOException {
        PzWorkerDialog.showStatus((String)"Procesiranje podataka je u toku. Molim, sa\u010dekajte.", (PzDialog)parent);
        PzReportManager worker = new PzReportManager(parent, ds, compiledFile, params, exportFilename, null, REPORT_TYPE_XLS);
        worker.execute();
    }

    public static void createAndShowReport(PzDialog parent, JRDataSource ds, String compiledFile, Map<String, Object> params, String exportFilename, int reportType) throws JRException, IOException {
        PzWorkerDialog.showStatus((String)"Procesiranje podataka je u toku. Molim, sa\u010dekajte.", (PzDialog)parent);
        PzReportManager worker = new PzReportManager(parent, ds, compiledFile, params, exportFilename, null, reportType);
        worker.execute();
    }

    public static void createAndShowReport(PzDialog parent, JRDataSource ds, URL compiledFile, Map<String, Object> params, String exportFilename) throws JRException, IOException {
        PzWorkerDialog.showStatus((String)"Procesiranje podataka je u toku. Molim, sa\u010dekajte.", (PzDialog)parent);
        PzReportManager worker = new PzReportManager(parent, ds, compiledFile, params, exportFilename, null, REPORT_TYPE_XLS);
        worker.execute();
    }

    public static void createAndShowReport(PzDialog parent, JRDataSource ds, URL compiledFile, Map<String, Object> params, String exportFilename, int reportType) throws JRException, IOException {
        PzWorkerDialog.showStatus((String)"Procesiranje podataka je u toku. Molim, sa\u010dekajte.", (PzDialog)parent);
        PzReportManager worker = new PzReportManager(parent, ds, compiledFile, params, exportFilename, null, reportType);
        worker.execute();
    }

    public static void createAndShowReport(PzDialog parent, JRDataSource ds, URL compiledFile, Map<String, Object> params, String exportFilename, PzDokumentRF rf) throws JRException, IOException {
        PzWorkerDialog.showStatus((String)"Procesiranje podataka je u toku. Molim, sa\u010dekajte.", (PzDialog)parent);
        PzReportManager worker = new PzReportManager(parent, ds, compiledFile, params, exportFilename, rf, REPORT_TYPE_XLS);
        worker.execute();
    }

    public static void createAndShowReport(PzDialog parent, JRDataSource ds, String compiledFile, Map<String, Object> params, String exportFilename, PzDokumentRF rf) throws JRException, IOException {
        PzWorkerDialog.showStatus((String)"Procesiranje podataka je u toku. Molim, sa\u010dekajte.", (PzDialog)parent);
        PzReportManager worker = new PzReportManager(parent, ds, compiledFile, params, exportFilename, rf, REPORT_TYPE_XLS);
        worker.execute();
    }

    public static void createAndShowReport(PzDialog parent, JRDataSource ds, URL compiledFile, Map<String, Object> params, String exportFilename, PzDokumentRF rf, int reportType) throws JRException, IOException {
        PzWorkerDialog.showStatus((String)"Procesiranje podataka je u toku. Molim, sa\u010dekajte.", (PzDialog)parent);
        PzReportManager worker = new PzReportManager(parent, ds, compiledFile, params, exportFilename, rf, reportType);
        worker.execute();
    }

    public static void createAndShowReport(PzDialog parent, PzDokument dokument) {
        try {
            PzDokument dok = dokument instanceof Dokument ? PzDokumentManager.getInstance().getPzDokument((Dokument)dokument) : dokument;
            Properties props = new Properties();
            props.load(PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/resource/reports.properties", (ClassLoader)new PzReportManager().getClass().getClassLoader()));
            String className = props.getProperty(dokument.getTip());
            if (className != null) {
                ((PzDokumentRF)Class.forName(className).newInstance()).showReport(parent, dok);
                PzApplication.getApplication().getLocalMachineUserSettings().setProperty("POSL.DOK", (Object)String.valueOf(dokument.getIdDok()));
            } else {
                JOptionPane.showConfirmDialog((Component)parent, "Za dokument tipa \" " + TipDokumentConfig.getNameByValue((String)dokument.getTip(), null) + " \" ne postoji definicija izve\u0161taja.", "Obave\u0161tenje", -1, 1);
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
        }
    }

    public static void createAndShowReport(final PzDialog parent, final JRDataSource ds, final String compiledFile, final String title, final Map<String, Object> params) throws Exception {
        PzWorkerDialog.showStatus((String)"Pribavljanje dokumenta je u toku. Molim, sa\u010dekajte.", (PzDialog)parent);
        SwingWorker<JasperPrint, Integer> worker = new SwingWorker<JasperPrint, Integer>(){

            @Override
            protected JasperPrint doInBackground() throws Exception {
                return PzReportManager.createJasperPrint(compiledFile, ds, title, params);
            }

            @Override
            protected void done() {
                try {
                    try {
                        PzReportViewer.viewReport(parent, (JasperPrint)this.get(), title);
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        worker.execute();
    }

    public static JasperPrint createJasperPrint(String compiledFile, JRDataSource ds, String title, Map<String, Object> params) throws Exception {
        HashMap<String, Object> params1 = new HashMap<String, Object>();
        if (params != null) {
            params1.putAll(params);
        }
        String[] paths = compiledFile.split(",");
        JasperReport[] jrArray = new JasperReport[paths.length];
        int j = 0;
        while (j < paths.length) {
            JasperReport jr;
            InputStream is = PzFileUtility.getReportFileAsInputStream((String)paths[j].trim(), (ClassLoader)new PzReportManager().getClass().getClassLoader());
            jrArray[j] = jr = (JasperReport)JRLoader.loadObject((InputStream)is);
            is.close();
            ++j;
        }
        JasperReport firstReport = jrArray[0];
        JasperPrint jp = JasperFillManager.fillReport((JasperReport)firstReport, params1, (JRDataSource)ds);
        int j2 = 1;
        while (j2 < jrArray.length) {
            ((PzHashMapDataSource)ds).reset();
            JasperPrint jp1 = JasperFillManager.fillReport((JasperReport)jrArray[j2], params1, (JRDataSource)ds);
            List pages = jp1.getPages();
            for (JRPrintPage page : pages) {
                jp.addPage(page);
            }
            ++j2;
        }
        return jp;
    }

    public static void createAndShowReport(final PzDialog parent, final PzDokument dokument, final String title, final Map<String, Object> params) throws Exception {
        if (GENERATE_ONLY) {
            GENERATE_ONLY = false;
            PzReportManager.createJasperPrint(dokument, title, params);
        } else {
            PzWorkerDialog.showStatus((String)"Pribavljanje dokumenta je u toku. Molim, sa\u010dekajte.", (PzDialog)parent);
            SwingWorker<JasperPrint, Integer> worker = new SwingWorker<JasperPrint, Integer>(){

                @Override
                protected JasperPrint doInBackground() throws Exception {
                    return PzReportManager.createJasperPrint(dokument, title, params);
                }

                @Override
                protected void done() {
                    try {
                        try {
                            PzReportViewer.viewReport(parent, (JasperPrint)this.get(), title);
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
                            PzWorkerDialog.hideStatus();
                        }
                    }
                    finally {
                        PzWorkerDialog.hideStatus();
                    }
                }
            };
            worker.execute();
        }
    }

    public static void createAndShowReports(final PzDialog parent, final List<? extends PzDokument> dokumenti, final ReportDescriptor descriptor, final Map<String, Object> params) throws Exception {
        PzWorkerDialog.showStatus((String)"Pribavljanje dokumenta je u toku. Molim, sa\u010dekajte.", (PzDialog)parent);
        SwingWorker<JasperPrint, Integer> worker = new SwingWorker<JasperPrint, Integer>(){

            @Override
            protected JasperPrint doInBackground() throws Exception {
                JasperPrint jp = null;
                for (PzDokument dokument : dokumenti) {
                    JasperPrint jp1 = PzReportManager.createJasperPrint(dokument, descriptor != null ? descriptor.getTitle(dokument) : "", params);
                    if (jp == null) {
                        jp = jp1;
                    } else {
                        List pages = jp1.getPages();
                        for (JRPrintPage page : pages) {
                            jp.addPage(page);
                        }
                    }
                    this.publish(1);
                }
                return jp;
            }

            @Override
            protected void process(List<Integer> arg0) {
                PzWorkerDialog.getDialogInstance().incProgress(arg0.size());
            }

            @Override
            protected void done() {
                try {
                    try {
                        PzReportViewer.viewReport(parent, (JasperPrint)this.get(), "Dokumenti");
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        worker.execute();
    }

    public static void createAndShowReports(final PzDialog parent, final List<? extends PzDokument> dokumenti, final List<JasperPrint> jasperPrints, final ReportDescriptor descriptor, final Map<String, Object> params) throws Exception {
        PzWorkerDialog.showStatus((String)"Pribavljanje dokumenta je u toku. Molim, sa\u010dekajte.", (PzDialog)parent);
        SwingWorker<JasperPrint, Integer> worker = new SwingWorker<JasperPrint, Integer>(){

            @Override
            protected JasperPrint doInBackground() throws Exception {
                JasperPrint jp = null;
                for (PzDokument dokument : dokumenti) {
                    JasperPrint jp1 = PzReportManager.createJasperPrint(dokument, descriptor != null ? descriptor.getTitle(dokument) : "", params);
                    if (jp == null) {
                        jp = jp1;
                    } else {
                        List pages = jp1.getPages();
                        for (JRPrintPage page : pages) {
                            jp.addPage(page);
                        }
                    }
                    this.publish(1);
                }
                for (JasperPrint jp1 : jasperPrints) {
                    if (jp == null) {
                        jp = jp1;
                    } else {
                        List pages = jp1.getPages();
                        for (JRPrintPage page : pages) {
                            jp.addPage(page);
                        }
                    }
                    this.publish(1);
                }
                return jp;
            }

            @Override
            protected void process(List<Integer> arg0) {
                PzWorkerDialog.getDialogInstance().incProgress(arg0.size());
            }

            @Override
            protected void done() {
                try {
                    try {
                        PzReportViewer.viewReport(parent, (JasperPrint)this.get(), "Dokumenti");
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)parent, (Throwable)e);
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        worker.execute();
    }

    private static JasperPrint createJasperPrint(PzDokument dokument, String title, Map<String, Object> params) throws Exception {
        Object ds;
        JasperPrint jpl;
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        JasperPrint jasperPrint = jpl = dokument.getArhiviran() == 1 ? PzReportManager.loadReportFromCache(dokument, PzCacheUtility.getReportCacheDir((EntityManager)em, (PzDokument)dokument)) : null;
        if (jpl != null) {
            return jpl;
        }
        HashMap<String, Object> params1 = new HashMap<String, Object>();
        if (params != null) {
            params1.putAll(params);
        }
        params1.put("REPORTS_DIR", PzParameter.getParameterValue((String)"REPORTS_DIR"));
        if (dokument instanceof Fakturausluga) {
            ds = new PzSingleListDataSource(((Fakturausluga)dokument).getTaksafakturas());
            PzSingleListDataSource dsPT = new PzSingleListDataSource(((Fakturausluga)dokument).getPutnitrosaks());
            params1.put("ulPorez", ds);
            params1.put("putniTrosak", dsPT);
            if (((Fakturausluga)dokument).getFakturaparameter(dokument.getIdDok(), "VALUTA") == null) {
                if (((Fakturausluga)dokument).getFakturaparameters().size() == 0) {
                    ((Fakturausluga)dokument).setFakturaparameters(new ArrayList());
                }
                Fakturaparameter fp = new Fakturaparameter(((Fakturausluga)dokument).getIdDok(), "VALUTA", "RSD", "");
                ((Fakturausluga)dokument).addFakturaparameter(fp);
            }
        }
        params1.put("title", title);
        params1.put("reklama", "");
        ds = new DokumentDS(dokument);
        Porezi ups = new Porezi();
        Iterator i = dokument.getArtikalDocuments().iterator();
        while (i.hasNext()) {
            ups.addPorez((PzArtikalDokument)i.next());
        }
        String oznVal = null;
        if (dokument.getKomitent() != null && dokument.getKomitent().getKomitentparameter("FAKVAL") != null) {
            oznVal = dokument.getKomitent().getKomitentparameter("FAKVAL").getValue();
            if (oznVal == null || oznVal.equals("")) {
                oznVal = PzParameter.getParameterValue((String)"DEF_VALUTA", (String)"EUR", (EntityManager)em);
            }
            params1.put("valuta", oznVal);
        } else {
            oznVal = PzParameter.getParameterValue((String)"DEF_VALUTA", (String)"EUR", (EntityManager)em);
        }
        Kurs k = (Kurs)em.find(Kurs.class, (Object)new KursPK(oznVal, dokument.getDatPrometa()));
        if (k != null && dokument.getIznos() != null) {
            double kd = BDConverter.getKurs((double)(k.getSrednji().doubleValue() / (double)k.getJedinica())).doubleValue();
            BigDecimal izn = BDConverter.getIznos((double)(dokument.getIznos().doubleValue() / kd));
            String kursStr = "Prema srednjem kursu Narodne banke Srbije, na dan " + PzFormatFactory.getDateFormat().format(k.getId().getDatum()) + ", koji glasi " + PzFormatFactory.getKursFormat().format(k.getSrednji()) + " RSD za " + k.getJedinica() + " " + k.getId().getOznValuta() + ", iznos dokumenta je " + PzFormatFactory.getIznosFormat().format(izn) + " " + k.getId().getOznValuta();
            params1.put("kurs", kursStr);
            params1.put("valuta", oznVal);
        }
        for (PzPorez up : ups.getPorezi()) {
            params1.put(String.valueOf(up.getTip()) + up.getVrsta(), up.getDS());
        }
        params1.put("porezTblSubreport", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/subreport.porez.tbl.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
        params1.put("porezTblSubreportBigDecimal", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/subreport.porez.tbl.bigdecimal.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
        params1.put("porezTblSubreportKons", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/subreport.porez.tbl.kons.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
        params1.put("porezSubreport", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/subreport.porez.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
        params1.put("porezSubreportIno", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/subreport.porez.ino.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
        params1.put("porezServisaSubreport", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/subreport.porez.servisa.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
        params1.put("porezAvRacunSubreport", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/subreport.porez.avansni.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
        params1.put("porezAvRacunSubreportIno", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/subreport.porez.avansni.ino.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
        params1.put("headerRacunSubreport", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/header.racun.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
        params1.put("headerRacunLevoSubreport", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/header.racun.levo.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
        params1.put("headerStandardSubreport", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/header.standard.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
        params1.put("fakturaServisaArtikliSubreport", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/subreport.servisa.artikal.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
        params1.put("fakturaServisaUslugeSubreport", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/subreport.servisa.usluga.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
        params1.put("putniTrosakSubreport", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/subreport.putnitrosak.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
        params1.put("putniTrosakSubreportIno", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/subreport.putnitrosak.ino.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
        params1.put("avansiSubreportIno", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/subreport.zatvaranje.avansom.ino.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
        params1.put("porezMPSubreport", JRLoader.loadObject((InputStream)PzFileUtility.getReportFileAsInputStream((String)"rs/pezar/reports/compiled/subreport.porez.m.jasper", (ClassLoader)new PzReportManager().getClass().getClassLoader())));
        params1.put("headerData", new DokumentDS(dokument));
        params1.put("godina", PzDateUtility.getCurrentYear());
        params1.put("sencenje", Boolean.valueOf(PzParameter.getParameterValue((String)"SENCENJE_REDOVA", (String)"true", (EntityManager)em)));
        params1.put("nazivArtikla", PzParameter.getParameterValue((String)"NAZIV_ARTIKLA", (String)"jedan_red", (EntityManager)em));
        params1.put("zaglavljeIzvestaja", PzParameter.getParameterValue((String)"ZAGLAVLJE_IZVESTAJA", (String)"desno", (EntityManager)em));
        String logoStr = PzParameter.getParameterValue((String)"LOGOTIP", (EntityManager)em);
        if (logoStr != null && !logoStr.equals("")) {
            params1.put("logo", new URL(logoStr));
        }
        JasperReport[] jrArray = (JasperReport[])PzReportManager.getReportData(dokument).get("reports");
        JasperReport firstReport = jrArray[0];
        JasperPrint jp = JasperFillManager.fillReport((JasperReport)firstReport, params1, (JRDataSource)ds);
        int j = 1;
        while (j < jrArray.length) {
            ((DokumentDS)ds).reset();
            JasperPrint jp1 = JasperFillManager.fillReport((JasperReport)jrArray[j], params1, (JRDataSource)ds);
            List pages = jp1.getPages();
            for (JRPrintPage page : pages) {
                jp.addPage(page);
            }
            ++j;
        }
        if (dokument.getArhiviran() == 1) {
            PzReportManager.saveReportToCache(jp, String.valueOf(dokument.getIdDok()) + ".jrprint", PzCacheUtility.getReportCacheDir((EntityManager)em, (PzDokument)dokument));
        }
        em.close();
        return jp;
    }

    private static void saveReportToCache(JasperPrint jp, String reportName, File reportCacheDir) {
        block3: {
            if (reportCacheDir != null) {
                try {
                    JRSaver.saveObject((Object)jp, (String)(String.valueOf(reportCacheDir.getPath()) + File.separator + reportName));
                }
                catch (JRException e) {
                    if (e.getCause() instanceof FileNotFoundException) break block3;
                    PzLogger.getInstance().logException((Throwable)e);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JasperPrint loadReportFromCache(PzDokument dokument, File reportCacheDir) {
        InputStream is = null;
        OutputStream os = null;
        if (reportCacheDir == null) {
            return null;
        }
        if (dokument.getDokument() == null) {
            return null;
        }
        try {
            File hashFile = new File(String.valueOf(reportCacheDir.getAbsolutePath()) + File.separator + ".hash");
            if (!hashFile.exists()) {
                hashFile.createNewFile();
            }
            Properties props = new Properties();
            is = new FileInputStream(hashFile);
            props.load(is);
            String hashCode = (String)props.get(String.valueOf(dokument.getIdDok()));
            if (hashCode != null) {
                if (hashCode.equals(String.valueOf(dokument.getDokument().hashCode()))) {
                    JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject((String)(String.valueOf(reportCacheDir.getPath()) + File.separator + dokument.getIdDok() + ".jrprint"));
                    return jasperPrint;
                }
                os = new FileOutputStream(hashFile);
                props.put(String.valueOf(dokument.getIdDok()), String.valueOf(dokument.getDokument().hashCode()));
                props.store(os, "");
                return null;
            }
            try {
                os = new FileOutputStream(hashFile);
                props.put(String.valueOf(dokument.getIdDok()), String.valueOf(dokument.getDokument().hashCode()));
                props.store(os, "");
                return null;
            }
            catch (JRException e) {
                if (e.getCause() instanceof FileNotFoundException) return null;
                PzLogger.getInstance().logException((Throwable)e);
                return null;
            }
            catch (IOException e) {
                PzLogger.getInstance().logException((Throwable)e);
                return null;
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static HashMap<String, Object> getReportData(PzDokument dok) throws Exception {
        Document doc = PzFileUtility.loadXML((String)"rs/pezar/reports/resource/reports.xml", (ClassLoader)new PzReportManager().getClass().getClassLoader());
        NodeList reports = doc.getElementsByTagName("report");
        HashMap<String, Object> result = null;
        String tiprj1 = dok.getRadnajedinica() != null ? dok.getRadnajedinica().getgTip() : "";
        String tipdok1 = dok.getTip();
        String prnc1 = dok.getRadnajedinica() == null ? "false" : (dok.getRadnajedinica().getNacinVodjenja().equals("PRODAJNA") ? "false" : "true");
        String podTip1 = dok.getPodTip();
        int i = 0;
        while (i < reports.getLength()) {
            String uslov;
            String tiprj2 = reports.item(i).getAttributes().getNamedItem("rj") != null ? reports.item(i).getAttributes().getNamedItem("rj").getNodeValue() : "";
            String tipdok2 = reports.item(i).getAttributes().getNamedItem("tip").getNodeValue();
            String prnc2 = reports.item(i).getAttributes().getNamedItem("prnc") != null ? reports.item(i).getAttributes().getNamedItem("prnc").getNodeValue() : null;
            String podTip2 = reports.item(i).getAttributes().getNamedItem("podtip") != null ? reports.item(i).getAttributes().getNamedItem("podtip").getNodeValue() : null;
            String string = uslov = reports.item(i).getAttributes().getNamedItem("uslov") != null ? reports.item(i).getAttributes().getNamedItem("uslov").getNodeValue() : null;
            boolean cond = podTip1 != null ? (podTip2 != null ? podTip1.equals(podTip2) : true) : true;
            try {
                cond = uslov == null ? cond : cond && PzPorukeManager.parseBooleanExpression((String)uslov, (PzDokument)dok) != false;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (tiprj1 != null && tiprj1.equalsIgnoreCase(tiprj2) && tipdok1.equalsIgnoreCase(tipdok2) && prnc1.equalsIgnoreCase(prnc2) && cond || tiprj1.equalsIgnoreCase(tiprj2) && tipdok1.equalsIgnoreCase(tipdok2) && prnc2 == null && cond) {
                String path = reports.item(i).getAttributes().getNamedItem("path").getNodeValue();
                String resolverStr = reports.item(i).getAttributes().getNamedItem("resolver").getNodeValue();
                result = new HashMap<String, Object>();
                String[] paths = path.split(",");
                JasperReport[] jrArray = new JasperReport[paths.length];
                int j = 0;
                while (j < paths.length) {
                    JasperReport jr;
                    InputStream is = PzFileUtility.getReportFileAsInputStream((String)paths[j].trim(), (ClassLoader)new PzReportManager().getClass().getClassLoader());
                    jrArray[j] = jr = (JasperReport)JRLoader.loadObject((InputStream)is);
                    is.close();
                    ++j;
                }
                PzDokumentResolver resolver = (PzDokumentResolver)Class.forName(resolverStr).newInstance();
                result.put("reports", jrArray);
                result.put("resolver", resolver);
                break;
            }
            ++i;
        }
        return result;
    }

    @Override
    protected JasperPrint doInBackground() throws Exception {
        JasperPrint jp = JasperFillManager.fillReport((InputStream)this.is, this.params, (JRDataSource)this.ds);
        return jp;
    }

    @Override
    protected void done() {
        try {
            try {
                JasperPrint jp = (JasperPrint)this.get();
                if (this.reportType == REPORT_TYPE_XLS) {
                    PzXlsViewer.viewReport(this.parent, jp, this.exportFilename);
                } else if (this.reportType == REPORT_TYPE_JASPER) {
                    PzReportViewer.viewReport(this.parent, jp, this.exportFilename);
                }
                if (this.is != null) {
                    this.is.close();
                }
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Component)this.parent, (Throwable)e);
                if (this.dokumentRf != null) {
                    this.dokumentRf.finish();
                }
                PzWorkerDialog.hideStatus();
            }
        }
        finally {
            if (this.dokumentRf != null) {
                this.dokumentRf.finish();
            }
            PzWorkerDialog.hideStatus();
        }
    }

    public static interface ReportDescriptor {
        public String getTitle(PzDokument var1);
    }
}

