/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.reports;

import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import rs.pezar.reports.util.PzReportUtil;

public class PzSingleDataSource
implements JRDataSource {
    private final List<Object> list;
    private Iterator<Object> iterator;
    private Object[] current;
    private final int size;
    private int i = 0;

    public PzSingleDataSource(List<Object> list) {
        this.list = list;
        this.iterator = list.iterator();
        this.size = list.size();
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object result = null;
        try {
            if (field.getName().indexOf("_") != -1) {
                String className = field.getName().split("_")[0];
                result = this.getClassFieldValue(this.list, field.getName().split("_")[1], className);
            } else {
                int colNum = Integer.parseInt(field.getName().substring(1));
                result = this.current[colNum];
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Naziv polja nije dobar. Polje: [" + field.getName() + "]. Naziv pocinje znakom f i ima uz sebe numericku oznaku kolone (pr. f1, f2, f3 ...)");
        }
        return result;
    }

    public boolean next() throws JRException {
        boolean hasnext = false;
        if (this.i < this.size) {
            this.current = (Object[])this.list.get(this.i);
            ++this.i;
            if (this.i <= this.size) {
                hasnext = true;
            }
        }
        return hasnext;
    }

    public void moveFirst() throws JRException {
        this.iterator = this.list.iterator();
    }

    private Object getClassFieldValue(List<Object> entities, String fieldName, String className) {
        Object res = null;
        for (Object entity : entities) {
            res = PzReportUtil.getClassFieldValue(entity, fieldName, className);
            if (res != null) break;
        }
        return res;
    }
}

