/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prostoKnjigovodstvo.gui.knjizenje.akcije;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Konto;
import rs.pezar.db.entity.KontoPK;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Slobodnaanalitika;
import rs.pezar.db.entity.Taksakalkulacija;
import rs.pezar.db.entity.Taksaopstidokument;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.globals.TipAnalitika;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.prostoKnjigovodstvo.gui.knjizenje.akcije.PzDialogAkcija;
import rs.pezar.prostoKnjigovodstvo.gui.util.FakturaKomitent;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogKontniPlan;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.sifarnici.gui.PzDialogStopePoreza;
import rs.pezar.sifarnici.gui.kontniPlan.PzDialogAnalitikaKonta;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzGenericTableDialog;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.custom.PzDialogPorezIznos;
import rs.pezar.swing.custom.PzTablePorez;
import rs.pezar.swing.event.PzEntityChecker;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public final class PzComponentFactory {
    public static final Color COLOR_BLUE_LIGHT = Color.LIGHT_GRAY;
    public static final int OPT_FAKTURE_KUPCA = 1;
    public static final int OPT_FAKTURE_DOBAVLJACA = 2;

    public static PzTablePorez createPzTablePorez() {
        PzTablePorez pzTablePorez = new PzTablePorez(Taksaopstidokument.class, PzDialogPorezIznos.class, true);
        pzTablePorez.setColumnControlVisible(false);
        pzTablePorez.setAutoResizeMode(4);
        return pzTablePorez;
    }

    public static PzTablePorez createPzTablePorezFakturaDobavljaca() {
        PzTablePorez pzTablePorez = new PzTablePorez(Taksakalkulacija.class, PzDialogPorezIznos.class, true);
        pzTablePorez.setColumnControlVisible(false);
        pzTablePorez.setAutoResizeMode(4);
        return pzTablePorez;
    }

    public static PzRadioGroup<PzChoice> createRadioGroup() {
        PzRadioGroup group = PzRadioGroup.create((Object[])new PzChoice[]{new PzChoice("Sa pravom na odbitak PDV-a", (Object)"SA_PRAVOM"), new PzChoice("Bez prava na odbitak PDV-a", (Object)"BEZ_PRAVA"), new PzChoice("Oslobo\u0111eno PDV-a", (Object)"OSLOBODJENO")});
        group.setLayoutAxis(1);
        group.setSelectedIndex(0);
        group.setOpaque(false);
        return group;
    }

    public static PzRadioGroup<PzChoice> createGroupTipUplate() throws Exception {
        PzRadioGroup group = PzRadioGroup.create((Object[])new PzChoice[]{new PzChoice("Virman", (Object)TipDokumentConfig.get().PODTIP_UPLATA_VIRMAN), new PzChoice("Gotovina", (Object)TipDokumentConfig.get().PODTIP_UPLATA_GOTOVINA), new PzChoice("\u010cek", (Object)TipDokumentConfig.get().PODTIP_UPLATA_CEK), new PzChoice("Kompenzacija", (Object)TipDokumentConfig.get().PODTIP_UPLATA_KOMPENZACIJA), new PzChoice("Multi-kompenzacija", (Object)TipDokumentConfig.get().PODTIP_UPLATA_MULTIKOMPENZACIJA), new PzChoice("Cesija", (Object)TipDokumentConfig.get().PODTIP_UPLATA_CESIJA), new PzChoice("Menica", (Object)TipDokumentConfig.get().PODTIP_UPLATA_MENICA)});
        group.setSelectedIndex(0);
        group.setLayoutAxis(1);
        group.setOpaque(false);
        return group;
    }

    public static PzRadioGroup<PzChoice> createGroupUplataPazara() throws Exception {
        PzRadioGroup group = PzRadioGroup.create((Object[])new PzChoice[]{new PzChoice("Gotovina/Cekovi/Pl. kartice", (Object)TipDokumentConfig.get().PODTIP_UPLATA_PAZARA_GOTOVINA), new PzChoice("Virman", (Object)TipDokumentConfig.get().PODTIP_UPLATA_PAZARA_VIRMAN)});
        group.setSelectedIndex(0);
        group.setLayoutAxis(0);
        group.setOpaque(false);
        return group;
    }

    public static PzRadioGroup<PzChoice> createGroupPdvSaBez() {
        PzRadioGroup group = PzRadioGroup.create((Object[])new PzChoice[]{new PzChoice("Sa PDV-om", (Object)"SA_PDV"), new PzChoice("Bez PDV-a", (Object)"BEZ_PDV")});
        group.setSelectedIndex(0);
        group.setLayoutAxis(0);
        group.setOpaque(false);
        return group;
    }

    public static PzRadioGroup<PzChoice> createGroupPdvOdbitak() {
        PzRadioGroup group = PzRadioGroup.create((Object[])new PzChoice[]{new PzChoice("Sa pravom na odbitak", (Object)"SA_PRAVOM"), new PzChoice("Bezprava na odbitak", (Object)"BEZ_PRAVA")});
        group.setSelectedIndex(0);
        group.setLayoutAxis(0);
        group.setOpaque(false);
        return group;
    }

    public static PzNumericOnlyTextField createKomitentField() {
        PzNumericOnlyTextField tf = new PzNumericOnlyTextField();
        tf.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
        return tf;
    }

    public static PzNumericOnlyTextField createKontoField() {
        PzNumericOnlyTextField tf = new PzNumericOnlyTextField();
        tf.setFKField(Konto.class, PzDialogKontniPlan.class, false, null);
        tf.setMaxLength(6);
        final PzNumericOnlyTextField inst = tf;
        tf.setEntityChecker(new PzEntityChecker(){

            public PzEntity getEntity() {
                try {
                    return PzEntityManager.find(Konto.class, (Object)new KontoPK(inst.getVal(), ""));
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle((Component)inst, (Throwable)e);
                    return null;
                }
            }
        });
        return tf;
    }

    public static PzNumericOnlyTextField createKontoField(final PzTextField txtAnalitika) {
        PzNumericOnlyTextField tf = new PzNumericOnlyTextField();
        tf.setFKField(Konto.class, PzDialogKontniPlan.class, true, null);
        tf.setMaxLength(6);
        final PzNumericOnlyTextField inst = tf;
        tf.setEntityChecker(new PzEntityChecker(){

            public PzEntity getEntity() {
                try {
                    return PzEntityManager.find(Konto.class, (Object)new KontoPK(inst.getText(), txtAnalitika.getText()));
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle((Component)inst, (Throwable)e);
                    return null;
                }
            }
        });
        return tf;
    }

    public static PzTextField createOznDokumentaField(final PzNumericOnlyTextField numSifraKomitenta, final Class<? extends PzDokument> dokumentClass, final List<String> tipovi, final String podTipDok, final PzDialogAkcija parent, final PzEntityFilter filter, final Radnajedinica rj, final String tipRj) {
        PzTextField tf = new PzTextField();
        tf.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent arg0) {
                PzTextField tf = (PzTextField)arg0;
                EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                String query = "SELECT f FROM " + dokumentClass.getSimpleName() + " f WHERE f.tip in :tipovi AND f.komitent.sfrKomitent = " + numSifraKomitenta.getVal() + " AND f.storno = 0";
                if (rj != null) {
                    query = String.valueOf(query) + " AND f.radnajedinica=:rj";
                }
                if (tipRj != null) {
                    query = String.valueOf(query) + " AND f.radnajedinica.gTip = '" + tipRj + "'";
                }
                if (podTipDok != null) {
                    query = String.valueOf(query) + " AND f.podTip = '" + podTipDok + "'";
                }
                query = String.valueOf(query) + " ORDER BY f.idDok";
                Query q = em.createQuery(query);
                if (rj != null) {
                    q.setParameter("rj", (Object)rj);
                }
                q.setParameter("tipovi", (Object)tipovi);
                List dokumenti = q.getResultList();
                if (em.isOpen()) {
                    em.close();
                }
                if (tf.getText().equals("")) {
                    PzDokument dok = (PzDokument)PzGenericTableDialog.showDialog((PzDialog)parent, (Class)dokumentClass, (List)dokumenti, (String)"Izbor dokumenta", (String)"", (PzEntityFilter)filter);
                    if (dok != null) {
                        tf.setVal((Object)dok.getOznDokumenta());
                        parent.setEntity((PzEntity)dok, (Component)tf);
                        return parent.setEntity((PzEntity)dok, (PzFieldImpl)tf);
                    }
                    return false;
                }
                boolean found = false;
                for (PzDokument dok : dokumenti) {
                    if (!dok.getOznDokumenta().equals(tf.getVal())) continue;
                    parent.setEntity((PzEntity)dok, (Component)tf);
                    found = parent.setEntity((PzEntity)dok, (PzFieldImpl)tf);
                    break;
                }
                if (!found) {
                    PzSwingUtility.showErrorMessage((Component)tf, (String)"Dokument sa unetom oznakom ne postoji za izabranog komitenta!");
                }
                return found;
            }
        });
        return tf;
    }

    public static PzTextField createOznDokumentaField(final PzNumericOnlyTextField numSifraKomitenta, final PzDialog parent, final String queryString, final Class<?> dokumentClass, final PzEntityFilter filter) {
        PzTextField tf = new PzTextField();
        tf.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent arg0) {
                PzTextField tf = (PzTextField)arg0;
                EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                String query = String.valueOf(queryString) + " AND d.komitent.sfrKomitent = :sfrKomitent ORDER BY d.idDok";
                Query q = em.createQuery(query);
                q.setParameter("sfrKomitent", numSifraKomitenta.getValue());
                List dokumenti = q.getResultList();
                if (em.isOpen()) {
                    em.close();
                }
                if (tf.getText().equals("")) {
                    PzDokument dok = (PzDokument)PzGenericTableDialog.showDialog((PzDialog)parent, (Class)dokumentClass, (List)dokumenti, (String)"Izbor dokumenta", (String)"", (PzEntityFilter)filter);
                    if (dok != null) {
                        tf.setVal((Object)dok.getOznDokumenta());
                        parent.setEntity((PzEntity)dok, (Component)tf);
                        return true;
                    }
                    return false;
                }
                boolean found = false;
                for (PzDokument dok : dokumenti) {
                    if (!dok.getOznDokumenta().equals(tf.getVal())) continue;
                    found = true;
                    parent.setEntity((PzEntity)dok, (Component)tf);
                    break;
                }
                if (!found) {
                    PzSwingUtility.showErrorMessage((Component)tf, (String)"Dokument sa unetom oznakom ne postoji za izabranog komitenta!");
                }
                return found;
            }
        });
        return tf;
    }

    public static PzTextField createOznDokumentaField(final PzNumericOnlyTextField numSifraKomitenta, final int fakturaOpcija, String tipDokumenta, final String podTipDok, final PzDialogAkcija parent, final Radnajedinica rj, final String tipRj) {
        PzTextField tf = new PzTextField();
        tf.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent arg0) {
                List dokumenti;
                Query q;
                PzTextField tf = (PzTextField)arg0;
                EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                if (fakturaOpcija == 2) {
                    ArrayList<String> podTipovi = new ArrayList<String>();
                    podTipovi.add(TipDokumentConfig.get().PODTIP_KALKULACIJA_OTPREMNICA);
                    podTipovi.add(TipDokumentConfig.get().PODTIP_KALKULACIJA_PRENOSNICA);
                    String query = "SELECT f.oznDokumenta, f.iznos, f.iznos-f.uplata-f.stornoIznos, f.datum, f.datValute, f.idDok, 'RACUN_DOBAVLJACA' FROM Kalkulacija f WHERE (f.podTip NOT IN :podTipovi OR f.podTip IS NULL ) AND f.komitent.sfrKomitent = " + numSifraKomitenta.getVal() + " AND f.storno = 0 AND f.arhiviran=1";
                    if (rj != null) {
                        query = String.valueOf(query) + " AND f.radnajedinica=:rj";
                    }
                    if (tipRj != null) {
                        query = String.valueOf(query) + " AND f.radnajedinica.gTip = '" + tipRj + "'";
                    }
                    if (podTipDok != null) {
                        query = String.valueOf(query) + " AND f.podTip = '" + podTipDok + "'";
                    }
                    query = String.valueOf(query) + " ORDER BY f.datum";
                    q = em.createQuery(query);
                    q.setParameter("podTipovi", podTipovi);
                    if (rj != null) {
                        q.setParameter("rj", (Object)rj);
                    }
                    dokumenti = q.getResultList();
                } else {
                    ArrayList<String> tipovi = new ArrayList<String>();
                    tipovi.add(TipDokumentConfig.get().FAKTURA);
                    tipovi.add(TipDokumentConfig.get().FAKTURA_SERVISA);
                    tipovi.add(TipDokumentConfig.get().FAKTURA_USLUGA);
                    String query = "SELECT f.oznDokumenta, f.iznos, f.iznos-f.uplata-f.stornoIznos, f.datum, f.datValute, f.idDok, 'FAKTURA' FROM Faktura f WHERE f.tip IN :tipovi AND f.komitent.sfrKomitent = " + numSifraKomitenta.getVal() + " AND f.storno = 0 AND f.arhiviran=1";
                    if (rj != null) {
                        query = String.valueOf(query) + " AND f.radnajedinica=:rj";
                    }
                    if (tipRj != null) {
                        query = String.valueOf(query) + " AND f.radnajedinica.gTip = '" + tipRj + "'";
                    }
                    if (podTipDok != null) {
                        query = String.valueOf(query) + " AND f.podTip = '" + podTipDok + "'";
                    }
                    query = String.valueOf(query) + " ORDER BY f.datum";
                    q = em.createQuery(query);
                    q.setParameter("tipovi", tipovi);
                    if (rj != null) {
                        q.setParameter("rj", (Object)rj);
                    }
                    dokumenti = q.getResultList();
                }
                if (em.isOpen()) {
                    em.close();
                }
                if (tf.getText().equals("")) {
                    PzDokument dok = (PzDokument)FakturaKomitent.showDialog(parent, dokumenti, "Izbor dokumenta", "", 2, new String[]{"Oznaka dok.", "Iznos dok.", "Dug po dok.", "Datum dok.", "Dat. valute", "ID", "TIP"});
                    if (dok != null) {
                        tf.setVal((Object)dok.getOznDokumenta());
                        parent.setEntity((PzEntity)dok, (Component)tf);
                        boolean ret = parent.setEntity((PzEntity)dok, (PzFieldImpl)tf);
                        if (ret) {
                            tf.setState(PzFieldIndikator.STATE_VALID);
                        }
                        return ret;
                    }
                    return false;
                }
                boolean found = false;
                if (!found) {
                    tf.setState(PzFieldIndikator.STATE_INVALID);
                }
                return found;
            }
        });
        tf.setState(PzFieldIndikator.STATE_INVALID);
        return tf;
    }

    public static void installOznKontoField(final PzNumericOnlyTextField fieldKonto, final PzTextField fieldAnalitika, final PzDialog dlg, boolean showDialog) {
        fieldKonto.setFKField(Konto.class, PzDialogKontniPlan.class, showDialog, null);
        fieldKonto.setMaxLength(6);
        fieldKonto.setCustomInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent arg0) {
                try {
                    fieldAnalitika.setVal((Object)"");
                    return PzComponentFactory.validateKonto((Konto)PzEntityManager.findEntity(Konto.class, (Object)new KontoPK(fieldKonto.getText(), fieldAnalitika.getText())), fieldKonto, fieldAnalitika, dlg);
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle((Component)dlg, (Throwable)e);
                    return false;
                }
            }
        });
        fieldKonto.setEntityChecker(new PzEntityChecker(){

            public PzEntity getEntity() {
                return PzEntityManager.findEntity(Konto.class, (Object)new KontoPK(fieldKonto.getText(), fieldAnalitika.getText()));
            }
        });
        fieldKonto.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                fieldAnalitika.setText("");
            }
        });
    }

    private static boolean validateKonto(Konto konto, PzNumericOnlyTextField fieldKonto, PzTextField fieldAnalitika, PzDialog dlg) throws Exception {
        if (fieldKonto.getText().equals("")) {
            fieldAnalitika.setVal((Object)"");
            return true;
        }
        boolean ok = false;
        if (konto.getTipAnalitike() != null && !konto.getTipAnalitike().equals("")) {
            if (konto.getTipAnalitike().equals(TipAnalitika.ANALITIKA_RJ)) {
                Radnajedinica rj = PzDialogRJ.getRJ((PzDialog)dlg);
                if (rj != null) {
                    ok = true;
                    fieldAnalitika.setVal((Object)(String.valueOf(PzEntityUtil.strZero((String)rj.getId().getOznRj(), (int)3)) + rj.getgTip()));
                } else {
                    fieldKonto.requestFocusInWindow();
                }
            } else if (konto.getTipAnalitike().equals(TipAnalitika.ANALITIKA_KOMINTENTI)) {
                Komitent komitent = (Komitent)PzComponentFactory.launchSifarnik((PzDialog)new PzDialogKomintenti(dlg), dlg);
                if (komitent != null) {
                    ok = true;
                    fieldAnalitika.setVal((Object)komitent.getSfrKomitent());
                    PzComponentFactory.checkAnalitikaKonta(konto, komitent.getSfrKomitent());
                } else {
                    fieldKonto.requestFocusInWindow();
                }
            } else if (konto.getTipAnalitike().equals(TipAnalitika.ANALITIKA_POREZ)) {
                Tarifnagrupa tg = (Tarifnagrupa)PzComponentFactory.launchSifarnik((PzDialog)new PzDialogStopePoreza(dlg), dlg);
                if (tg != null) {
                    ok = true;
                    fieldAnalitika.setVal((Object)tg.getOznTarGr());
                    PzComponentFactory.checkAnalitikaKonta(konto, tg.getOznTarGr());
                } else {
                    fieldKonto.requestFocusInWindow();
                }
            } else if (konto.getTipAnalitike().equals(TipAnalitika.ANALITIKA_SLOBODNA)) {
                Slobodnaanalitika analitika = (Slobodnaanalitika)PzComponentFactory.launchSifarnik((PzDialog)new PzDialogAnalitikaKonta(dlg), dlg);
                if (analitika != null) {
                    ok = true;
                    fieldAnalitika.setVal((Object)analitika.getOznAnalitika());
                    PzComponentFactory.checkAnalitikaKonta(konto, analitika.getOznAnalitika());
                } else {
                    fieldKonto.requestFocusInWindow();
                }
            }
            if (ok) {
                fieldKonto.setVal((Object)konto.getId().getOznKonto());
            }
        } else {
            fieldKonto.setVal((Object)konto.getId().getOznKonto());
            fieldAnalitika.setVal((Object)konto.getId().getAnalitika());
            ok = true;
        }
        return ok;
    }

    private static void checkAnalitikaKonta(Konto konto, String oznAnalitika) throws Exception {
        Konto ks = (Konto)PzEntityManager.find(Konto.class, (Object)new KontoPK(konto.getId().getOznKonto(), oznAnalitika));
        if (ks == null) {
            ks = new Konto();
            ks.setId(new KontoPK(konto.getId().getOznKonto(), oznAnalitika));
            ks.setNaziv(konto.getNaziv());
            ks.setTipAnalitike("");
            PzEntityManager.insert((Object)ks);
        }
    }

    private static PzEntity launchSifarnik(PzDialog dlg, PzDialog parent) {
        dlg.setLocationRelativeTo((Component)parent);
        dlg.setModal(true);
        dlg.setCloseOnEnter(true);
        dlg.restoreSize();
        dlg.setVisible(true);
        PzEntity entity = PzTable.selectedEntity;
        PzTable.selectedEntity = null;
        return entity;
    }
}

